#define DBG  print*, pid ,__FILE__, __LINE__
#define DBG0  if(pid==0)print*, __FILE__, __LINE__
!!#define DOGFSForecast
#define OUTRSTEACHMONTH
!-------------------------------------------------------------------------------------------------
  module wammdl_mod
!-------------------------------------------------------------------------------------------------
  use time_mod
  use mwmvar_mod
  use mwmcor_mod
  use mwmpgt_mod
  use wamint_mod
  use wamcpl_mod
  use wamfio_mod
  use partctl_mod,only : pid,partctl_final,plist
#ifdef WDAWDA
  use wamasm_mod
#endif
  use propagat_mod,only : propagat_old=>propagat
  use propagat_mod,only : init_propagat_old=>init_propagat
  use propagat_mod,only: propagat_preinf_old=>propagat_preinf
  implicit none
!-------------------------------------------------------------------------------------------------
  public :: wave_model_init,wave_model_final,readwi
  private
!-------------------------------------------------------------------------------------------------
  contains
!-------------------------------------------------------------------------------------------------
  subroutine readwi
    integer :: it,idx
    real :: time_loop

    call timer_reset;call timer_start(1)
    ! --- Input restart file or set for cool restart.
    call inprst(rstfile,key)
    call update_ee
    !if(maxval(ee)<=small)then
    !  key=0;number=max(number,1)
    !endif

    dtime0=datenum(istime)
    dtimeend=datenum(ietime)
    number=(1-key)*cools_days*1440.d0/delttm
    itend=number+(datenum(ietime)-dtime0+1.d0)*1440.d0/delttm
    dtime=dtime0

    if(pid==0)then
      write(*,*)'Start time:',datestr(istime)
      write(*,*)'  End time:',datestr(ietime)
    endif

#ifdef TEST2022
    itime=datevec(dtime);ctime=datestr(itime);dtime=datenum(itime)
    call set_wind

    ee=0;e=0
    do idx=1,np;call setspec(1,idx);enddo;e=ee
    do idx=1,npc;if(nsp(idx)==1)call propagat(idx);enddo ! --- For wave propagation.
    do idx=1,npc;call implsch(idx); enddo
    call outrst('restart_new.nc')

    call init_propagat_old
    do idx=1,npc;if(nsp(idx)==1)call propagat_preinf_old(idx);enddo ! --- For wave propagation.

    ee=0;e=0
    do idx=1,np;call setspec(1,idx);enddo;e=ee
    do idx=1,npc;if(nsp(idx)==1)call propagat_old(idx);enddo ! --- For wave propagation.
    do idx=1,npc;call implsch_old(idx); enddo
    call outrst('restart_old.nc')

    return
#endif

    call timer_end(1)
    time_loop=Gettimer(1)

    do it=0,itend

      ! --- Set time & key for cool start.
      if(it>0)dtime=dtime+key*delttm/1440.d0;
      itime=datevec(dtime);ctime=datestr(itime);dtime=datenum(itime)
      DBG0,'READWI: ',ctime(1:8),' ',ctime(9:12),it-number,itend
      if(pid==0 .and. mod(it,10)==0)then
        write(*,*)'READWI: ',ctime(1:8),' ',ctime(9:12),it-number,itend,time_loop
        call timer_reset
        call timer_start(1)
      endif

      !if(pid==0)write(*,*)itime,dtime
      ! --- Read in wind data: wx,wy,w is the wind used in model.
      if(key/=0 .or. it==0)call set_wind
      if(key==0.and.it==0)then
        do idx=1,np;call setspec(1,idx);enddo
      endif
      call set_ice(1)
      !e=small;ee(:,:,0)=small;e=ee ! required when test without prgt
      do idx=1,npc;if(nsp(idx)==1)call propagat(idx);enddo ! --- For wave propagation.
      
      if(opt_imp==0)then
        do idx=1,npc;call implsch(idx);enddo
      elseif(opt_imp==1)then
        do idx=1,npc
          call implsch_old(idx)
          call setspec(2,idx)
          call mean1(idx)
        enddo
      endif

      call update_ee
      call smoth_ee
      call update_ee

      if(it>=number)key=1

      call timer_end(1)

      time_loop=Gettimer(1)

      if(key==0)cycle
#ifdef WDAWDA
      ! --- Wave data assimilation based on EAKF.
      call wave_data_assim
#endif
      call output(key,it,itime)
      call outmixingbv
      if(dtime>=dtimeend)exit
    enddo
    !DBG0;call outrst('restart_'//ctime//'.nc')
    DBG0,"SUCCESSFULLY COMPLETED"
  end subroutine readwi
!-------------------------------------------------------------------------------------------------
  subroutine wave_model_final
    call final_propagat
    call partctl_final
  end subroutine wave_model_final
!-------------------------------------------------------------------------------------------------
  end module wammdl_mod
!-------------------------------------------------------------------------------------------------
 !ChangeLog:
 !TEST2022: compared the sub-implsch and propagat in different version. The new version was
 !changed for mwmcom in which a lot of change without conform.
 !As the result, one change in the source function of propagat is not correct.
 !That is reported by Jiangxj. He thought the dddx and dddyBut it is already changed in waminit_mod
 !
