#define DBG  print*, pid ,__FILE__, __LINE__
#define IAIC_IDX idx
#define SMALLEXG
!-------------------------------------------------------------------------------------------------
module wamint_mod
  use irrp_smpi_mod;use irrp_package_mod
  use time_mod;use netcdf_mod
  use mwmvar_mod
  use mwmcor_mod,only: setwave,nlweight
  use mwmpgt_mod
  
  use wamcpl_mod
  use wamfio_mod
  use partctl_mod,only: mpi_comm,pid,root,nb8,plist,lon,lat,partctl_init,partctl_final
  use partctl_mod,only: np_=>np,npc_=>npc,im_=>im,jm_=>jm

  implicit none
!-------------------------------------------------------------------------------------------------
  public :: cnb_type,cnb,alon,alat
  public :: wave_model_init,update_ee,update_e
  private
!-------------------------------------------------------------------------------------------------
  integer :: delttmflag
  real(spdp),allocatable :: tempv2(:,:)
!-------------------------------------------------------------------------------------------------
  contains
!-------------------------------------------------------------------------------------------------
  subroutine wave_model_init
    integer :: idx
    call partctl_init
    call wamvar_mod_init(np_,npc_,im_,jm_)
    !wamvar_mod_init(npin,npcin,imin,jmin,klin,jlin,wkmin_in,wkmax_in)
    !call wamvar_mod_init(np_,npc_,im_,jm_,25,24,0.0071_spdp,0.688822359872592_spdp)
    !call wamvar_mod_init(np_,npc_,im_,jm_,30,24,0.0071,pi)
    allocate(pnb(0:np))
    do idx=0,np
      pnb(idx)%i =plist(idx)%i   ! Index of the first dimension
      pnb(idx)%j =plist(idx)%j   ! Index of the second dimension
      pnb(idx)%r =nb8(idx)%r     ! Right neighbor point.
      pnb(idx)%ur=nb8(idx)%ur    ! Up-right neighbor point.
      pnb(idx)%u =nb8(idx)%u     ! Up neighbor point.
      pnb(idx)%ul=nb8(idx)%ul    ! Up-left neighbor point.
      pnb(idx)%l =nb8(idx)%l     ! Left neighbor point.
      pnb(idx)%dl=nb8(idx)%dl    ! Down-left neighbor point.
      pnb(idx)%d =nb8(idx)%d     ! Down neighbor point.
      pnb(idx)%dr=nb8(idx)%dr    ! Down-right neighbor point.
    enddo
    call precom
    if(grdflag==0)then
      call settopo
    elseif(grdflag==1)then
      call settopo  !yinxq
      call set_geoinf
    endif
    call setwave
    if(pid==0)then
      write(*,*)'pwk1',pwk,10**(log10(wkmax/wkmin)/dble(kl-1))
      write(*,*)'pwk2',pwk,10**(log10(wk(kl)/wkmin)/dble(kl-1))
      write(*,*)'pwk3',wkmin,wkmax,wk(kl)
    endif
    call nlweight
    if(grdflag==0)then
      call reset_time_step
    elseif(grdflag==1)then
      call reset_time_step_dist
    endif
    call init_propagat
    call pntio_itp_init
  end subroutine wave_model_init
  
!!#define plist pnb
!!#define nb8 pnb
!-------------------------------------------------------------------------------------------------
  subroutine precom
    integer :: lsize
    type(mpipacket) :: pk
    integer :: itime(6),cldtype,ierr
    character(len=14) :: tmref
    !namelist/ctlparams/data_path,wind_path,out_path,mix_path,title,cistime,cietime,cools_days,&
    !                   delttm,wndfreq,wndtype,outflag,wiofreq,ciofreq,rstfreq,cpdays,cpflag
    !namelist/ioflags/ioflag_wx,ioflag_wy,ioflag_tp,ioflag_tz,ioflag_hs,ioflag_th
    namelist/ctlparams/title,cistime,cietime,cools_days,delttm,cpdays,grdflag,tmref,cldtype
    namelist/ioflags/outpath,outflag,wiofreq,rstfreq,ioflag_wx,ioflag_wy,ioflag_tp,ioflag_tz,ioflag_hs,ioflag_th
    namelist/optnml/opt_cd,opt_swl,windzone,opt_imp
    ! --- Input the parameters used in this model.
    if(pid == root)then
      open(11,file='ctlparams',delim='quote');read(11,nml=ctlparams);read(11,nml=ioflags);close(11)
      call packbcastdata(0)
    endif
    call packbcastdata(1)
    istime=0;read(tmref,'(i4.4,i2.2,i2.2)')istime(1:3)
    call init_time_mod(istime,cldtype) 
    timeunits='Days since '//tmref(1:4)//'-'//tmref(5:6)//'-'//tmref(7:8)//' 00:00:0.0.'
    ! --- Common parameters for wind data & module init.
    istime = 0; ietime = 0; 
    read(cistime,'(i4,i2,i2,i2)')istime(1:4)
    if(cpdays==0)then
      read(cietime,'(i4,i2,i2,i2)')ietime(1:4)
    else
      ietime=datevec(datenum(istime)+cpdays)
    endif
    delttmflag=0;if(delttm<=0)delttmflag=1
    if(pid==root)write(*,nml=ctlparams)
    ! set options
    if(pid == root)then
      open(11,file='ctlparams',delim='quote')
      read(11,nml=optnml,iostat=ierr)
      close(11)
      if(ierr/=0)then
        opt_cd=0;opt_swl=0;windzone=15
      endif
      call packbcastdata_opt(0)
    endif
    call packbcastdata_opt(1)
    contains
    subroutine packbcastdata_opt(act)
      integer,intent(in) :: act
      if(act==0)then
        lsize=(im*jm*8*2+200)
        call InitMpiPacket(pk,lsize)
      else
        call bcast_packet(pk,root,pid,mpi_comm)
      endif
      call irrp_pget_mpipacket(pk,opt_cd,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,opt_swl,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,windzone,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,opt_imp,1,mpi_comm,act)
      if(act>0)then
        call FinalMpiPacket(pk)
      endif
    end subroutine packbcastdata_opt

    subroutine packbcastdata(act)
      integer,intent(in) :: act
      if(act==0)then
        lsize=(im*jm*8*2+200)
        call InitMpiPacket(pk,lsize)
      else
        call bcast_packet(pk,root,pid,mpi_comm)
      endif
      call irrp_pget_mpipacket(pk,title,14,mpi_comm,act)
      call irrp_pget_mpipacket(pk,cistime,14,mpi_comm,act)
      call irrp_pget_mpipacket(pk,cietime,14,mpi_comm,act)
      call irrp_pget_mpipacket(pk,cools_days,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,delttm,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,cpdays,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,grdflag,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,tmref,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,cldtype,1,mpi_comm,act)
      !----------------------------------------------------------------
      call irrp_pget_mpipacket(pk,outpath,200,mpi_comm,act)
      call irrp_pget_mpipacket(pk,outflag,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,wiofreq,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,rstfreq,1,mpi_comm,act)
      !----------------------------------------------------------------
      call irrp_pget_mpipacket(pk,ioflag_wx,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,ioflag_wy,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,ioflag_hs,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,ioflag_th,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,ioflag_tp,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,ioflag_tz,1,mpi_comm,act)
      !----------------------------------------------------------------
      if(act>0)then
        call FinalMpiPacket(pk)
      endif
    end subroutine packbcastdata
  end subroutine precom
!-------------------------------------------------------------------------------------------------
  subroutine settopo
    integer :: idx,ncid
    integer,allocatable :: iv2(:,:)
    real(4),allocatable :: v2(:,:),sv2(:)
    real(spdp) :: dddx,dddy,rslat,deltx,delty
    
    if(.not. allocated(d))allocate(d(0:np))
    if(.not. allocated(nsp))allocate(nsp(0:np))
    if(.not. allocated(cnb))allocate(cnb(0:np))
!    if(.not. allocated(dddx))allocate(dddx(0:np))
!    if(.not. allocated(dddy))allocate(dddy(0:np))
!    if(.not. allocated(rslat))allocate(rslat(0:np))
    if(.not. allocated(alon))allocate(alon(0:np))  !yinxq 20221110
    if(.not. allocated(alat))allocate(alat(0:np))  !yinxq 20221110

    allocate(v2(im,jm),iv2(im,jm),sv2(0:np))
    if(pid==root)then
      call open_nc(ncid,'wamyyz.nc','r')
      call readnc(ncid,'depyyz',v2)
      call readnc(ncid,'nspyyz',iv2)
      call close_nc(ncid)
    endif
    call irrp_scatter_ext(v2,sv2,root);d=sv2
!    call irrp_scatter_ext(iv2,nsp,root);nsp(0)=0
    v2=iv2;call irrp_scatter_ext(v2,sv2,root);nsp=sv2;nsp(0)=0
    deallocate(v2,iv2,sv2)
    do idx=1,np
      !rslat(idx)=rs*cosd(lat(pnb(idx)%j)) ! yinxq 2017-10-16 13:19:52
      rslat=rs*cos(lat(pnb(idx)%j)*pi/180.d0) ! yinxq 2017-10-16 13:19:52
      ! deltx(ia) = (x(ia+1) - x(ia-1)) * 0.5
      ! dddx(ia,ic)=(d(ia+1,ic)-d(ia-1,ic))/(2.*deltx(ia))
      !-------------------------------------------------------------------------
      if(pnb(idx)%i==im)then
        deltx=(lon(im)-lon(im-1))
      elseif(pnb(idx)%i==1)then
        deltx=(lon(2)-lon(1))
      else
        deltx=(lon(pnb(idx)%i+1)-lon(pnb(idx)%i-1))/2.
      endif
      if(pnb(idx)%j==jm)then
        !delty(idx)=(lat(jm)-lat(jm-1))
        delty=(lat(jm)-lat(jm-1))
      elseif(pnb(idx)%j==1)then
        !delty(idx)=(lat(2)-lat(1))
        delty=(lat(2)-lat(1))
      else
        !delty(idx)=(lat(pnb(idx)%j+1)-lat(pnb(idx)%j-1))/2.
        delty=(lat(pnb(idx)%j+1)-lat(pnb(idx)%j-1))/2.
      endif
      !-------------------------------------------------------------------------
      if(pnb(idx)%r==0.and. pnb(idx)%l/=0)then
        !deltx(idx)=(lon(pnb(idx)%i)-lon(pnb(pnb(idx)%l)%i))
        !dddx(idx)=(d(idx)-d(pnb(idx)%l))/deltx(idx)
        dddx=(d(idx)-d(pnb(idx)%l))/deltx !(idx)
      elseif(pnb(idx)%r/=0.and. pnb(idx)%l==0)then
        !deltx(idx)=(lon(pnb(pnb(idx)%r)%i)-lon(pnb(idx)%i))
        !dddx(idx)=(d(pnb(pnb(idx)%r)%i)-d(pnb(idx)%i))/deltx(idx) 
        !dddx(idx)=(d(pnb(idx)%r)-d(idx))/deltx(idx) 
        dddx=(d(pnb(idx)%r)-d(idx))/deltx !(idx) 
      elseif(pnb(idx)%r==0 .and. pnb(idx)%l==0)then
        !if(pnb(idx)%i==im)then
        !  deltx(idx)=(lon(im)-lon(im-1))
        !elseif(pnb(idx)%i==1)then
        !  deltx(idx)=(lon(2)-lon(1))
        !else
        !  deltx(idx)=(lon(pnb(idx)%i+1)-lon(pnb(idx)%i-1))/2.
        !endif
        !dddx(idx)=0
        dddx=0
      else
        ! If pnb(idx)%i==1, right will be near 0 and left will be near 360.
        ! The deltx will be minus and near -360. Need to check this point.
        !deltx(idx)=(lon(pnb(pnb(idx)%r)%i)-lon(pnb(pnb(idx)%l)%i))
        !dddx(idx)=(d(pnb(idx)%r)-d(pnb(idx)%l))/deltx(idx)
        !deltx(idx)=deltx(idx)/2.0
        !if(pnb(idx)%i==1)then
        ! write(*,*)'deltx(idx)=',deltx(idx),lon(pnb(pnb(idx)%r)%i),lon(pnb(pnb(idx)%l)%i)
        !endif
        !dddx(idx)=(d(pnb(idx)%r)-d(pnb(idx)%l))/(deltx(idx)*2.d0)
        dddx=(d(pnb(idx)%r)-d(pnb(idx)%l))/(deltx*2.d0)
      endif
      ! delty(ic) = (y(ic+1) - y(ic-1)) * 0.5
      ! dddy(ia,ic)=(d(ia,ic+1)-d(ia,ic-1))/(2. * delty(ic))
      if(pnb(idx)%u==0 .and. pnb(idx)%d/=0)then
        !delty(idx)=(lat(pnb(idx)%j)-lat(pnb(pnb(idx)%d)%j))
        !dddy(idx)=(d(idx)-d(pnb(idx)%d))/delty(idx)
        dddy=(d(idx)-d(pnb(idx)%d))/delty
      elseif(pnb(idx)%u/=0 .and. pnb(idx)%d==0)then
        !delty(idx)=(lat(pnb(pnb(idx)%u)%j)-lat(pnb(idx)%j))
        !dddy(idx)=(d(pnb(idx)%u)-d(idx))/delty(idx)
        dddy=(d(pnb(idx)%u)-d(idx))/delty
      elseif(pnb(idx)%u==0 .and. pnb(idx)%d==0)then
        !if(pnb(idx)%j==jm)then
        !  delty(idx)=(lat(jm)-lat(jm-1))
        !elseif(pnb(idx)%j==1)then
        !  delty(idx)=(lat(2)-lat(1))
        !else
        !  delty(idx)=(lat(pnb(idx)%j+1)-lat(pnb(idx)%j-1))/2.
        !endif
        !dddy(idx)=0
        dddy=0
      else
        !delty(idx)=(lat(pnb(pnb(idx)%u)%j)-lat(pnb(pnb(idx)%d)%j))
        !dddy(idx)=(d(pnb(idx)%u)-d(pnb(idx)%d))/delty(idx)
        !delty(idx)=delty(idx)/2.0
        !dddy(idx)=(d(pnb(idx)%u)-d(pnb(idx)%d))/(delty(idx)*2.d0)
        dddy=(d(pnb(idx)%u)-d(pnb(idx)%d))/(delty*2.d0)
      endif
      !dddx(idx)=dddx(idx)*(180.d0/pi)/rslat(IAIC_IDX) ! dddx / (rs*cos(lat)*pi/180) m/deg --> m/m
      !dddy(idx)=dddy(idx)*(180.d0/pi)/rs ! dddy / (rs*pi/180) m/deg --> m/m
      !dddx=dddx*(180.d0/pi)/rslat(IAIC_IDX) ! dddx / (rs*cos(lat)*pi/180) m/deg --> m/m
      dddx=dddx*(180.d0/pi)/rslat  ! dddx / (rs*cos(lat)*pi/180) m/deg --> m/m
      dddy=dddy*(180.d0/pi)/rs ! dddy / (rs*pi/180) m/deg --> m/m
      
      cnb(idx)%tanlatrs=tan(lat(pnb(IAIC_IDX)%j)*pi/180.d0)/rs
      cnb(idx)%dddx=dddx !(idx)
      cnb(idx)%dddy=dddy !(idx)
      cnb(idx)%deltx=deltx !(idx)
      cnb(idx)%delty=delty !(idx)
      cnb(idx)%rslat=rslat !(idx)
      cnb(idx)%angle=0.d0     
      !dddx,dddy,deltx,delty,tanlatrs,
      cnb(idx)%n=4
      allocate(cnb(idx)%nbs(cnb(idx)%n))
      allocate(cnb(idx)%rot(cnb(idx)%n))
      allocate(cnb(idx)%dst(cnb(idx)%n))
      cnb(idx)%nbs(:)=[pnb(idx)%r,pnb(idx)%u,pnb(idx)%l,pnb(idx)%d]
      cnb(idx)%rot(:)=[0,90,180,270]
      allocate(cnb(idx)%nbsc(cnb(idx)%n))
      allocate(cnb(idx)%rotc(cnb(idx)%n))
      allocate(cnb(idx)%dstc(cnb(idx)%n))
      cnb(idx)%nbsc(:)=[pnb(idx)%ur,pnb(idx)%ul,pnb(idx)%dl,pnb(idx)%dr]
      cnb(idx)%rot(:)=[45,135,225,315]
    enddo
    !dddx(0)=dddx(1);deltx(0)=deltx(1);dddy(0)=dddy(1);delty(0)=delty(1)
    cnb(0)%dddx=cnb(1)%dddx;cnb(0)%dddy=cnb(1)%dddy
    cnb(0)%deltx=cnb(1)%deltx;cnb(0)%delty=cnb(1)%delty
    !write(*,*)'minval/minval(dddx)',minval(dddx),maxval(dddx),pid
    !write(*,*)'minval/minval(dddy)',minval(dddy),maxval(dddy),pid
    !write(*,*)'minval(delty),maxval(deltx)',minval(deltx),maxval(deltx)
    do idx=1,np
      alon(idx)=lon(pnb(idx)%i)
      alat(idx)=lat(pnb(idx)%j)
    enddo
    return
  end subroutine settopo
!-------------------------------------------------------------------------------------------------
  subroutine set_geoinf
    integer :: idx,ncid
    real(spdp) :: ang,grdx,grdy,rslat
    integer,allocatable :: iv2(:,:)
    real(spdp),allocatable :: v2(:,:),sv2(:)
    real(spdp),allocatable :: mlon(:,:),mlat(:,:)
    integer :: n,nn,nnn,i,j,i0,j0
    type(mpipacket) :: pk
    integer :: lsize
    
    allocate(v2(im,jm),iv2(im,jm),sv2(0:np),mlon(im,jm),mlat(im,jm))
    if(.not. allocated(d))allocate(d(0:np))
    if(.not. allocated(nsp))allocate(nsp(0:np))
    if(.not. allocated(alon))allocate(alon(0:np))
    if(.not. allocated(alat))allocate(alat(0:np))
    if(.not. allocated(cnb))allocate(cnb(0:np))
    !if(.not. allocated(dddx))allocate(dddx(0:np))
    !if(.not. allocated(dddy))allocate(dddy(0:np))
    !if(.not. allocated(rslat))allocate(rslat(0:np))
    if(pid==root)then
      call open_nc(ncid,'wamyyz.nc','r')
      call readnc(ncid,'depyyz',v2)
      call readnc(ncid,'nspyyz',iv2)
      call readnc(ncid,'alon',mlon)
      call readnc(ncid,'alat',mlat)
      call close_nc(ncid)
      call packbcastdata(0)
    endif
    call packbcastdata(1)
    call irrp_scatter_ext(mlon,sv2,root);alon=sv2
    call irrp_scatter_ext(mlat,sv2,root);alat=sv2
    call irrp_scatter_ext(v2,sv2,root);d=sv2
    v2=iv2;call irrp_scatter_ext(v2,sv2,root);nsp=sv2;nsp(0)=0
              
    call setgeoinf(mlon,mlat)
    return
    do idx=1,npc
      rslat=rs*cos(alat(idx)*pi/180.d0)
      !rslat(idx)=rs*cos(alat(idx)*pi/180.d0)
      !fox(idx)=alon(idx)
      !foy(idx)=alat(idx)
      cnb(idx)%n=4
      allocate(cnb(idx)%nbs(cnb(idx)%n))
      allocate(cnb(idx)%rot(cnb(idx)%n))
      allocate(cnb(idx)%dst(cnb(idx)%n))
      cnb(idx)%nbs(:)=[pnb(idx)%r,pnb(idx)%u,pnb(idx)%l,pnb(idx)%d]
      allocate(cnb(idx)%nbsc(cnb(idx)%n))
      allocate(cnb(idx)%rotc(cnb(idx)%n))
      allocate(cnb(idx)%dstc(cnb(idx)%n))
      cnb(idx)%nbsc(:)=[pnb(idx)%ur,pnb(idx)%ul,pnb(idx)%dl,pnb(idx)%dr]
      
      allocate(cnb(idx)%xm(cnb(idx)%n))
      allocate(cnb(idx)%ym(cnb(idx)%n))
      allocate(cnb(idx)%xmc(cnb(idx)%n))
      allocate(cnb(idx)%ymc(cnb(idx)%n))
      i0=pnb(idx)%i;j0=pnb(idx)%j
      do n=1,4
        if(n==1)then
          nn=pnb(idx)%r;i=i0+1;j=j0
        elseif(n==2)then
          nn=pnb(idx)%u;i=i0;j=j0+1
        elseif(n==3)then
          nn=pnb(idx)%l;i=i0-1;j=j0
        elseif(n==4)then
          nn=pnb(idx)%d;i=i0;j=j0-1
        endif
        if(j<1)j=1
        if(j>jm)j=jm
        if(nn/=0)then
          cnb(idx)%xm(n)=alon(nn)-alon(idx)
          cnb(idx)%ym(n)=alat(nn)-alat(idx)
        else
          if(i>im)then
            cnb(idx)%xm(n)=mlon(i0,j0)-mlon(im-1,j)
            cnb(idx)%ym(n)=mlat(i0,j0)-mlat(im-1,j)
          elseif(i<1)then
            cnb(idx)%xm(n)=mlon(i0,j0)-mlon(2,j)
            cnb(idx)%ym(n)=mlat(i0,j0)-mlat(2,j)
          else
            cnb(idx)%xm(n)=mlon(i,j)-mlon(i0,j0)
            cnb(idx)%ym(n)=mlat(i,j)-mlat(i0,j0)
          endif
        endif
        if(cnb(idx)%xm(n)>90.d0)cnb(idx)%xm(n)=cnb(idx)%xm(n)-360.d0
        if(cnb(idx)%xm(n)<-90.d0)cnb(idx)%xm(n)=cnb(idx)%xm(n)+360.d0
        !cnb(idx)%nbsc(:)=[pnb(idx)%ur,pnb(idx)%ul,pnb(idx)%dl,pnb(idx)%dr]
        if(n==1)then
          nn=pnb(idx)%ur;i=i0+1;j=j0+1
        elseif(n==2)then
          nn=pnb(idx)%ul;i=i0-1;j=j0+1
        elseif(n==3)then
          nn=pnb(idx)%dl;i=i0-1;j=j0-1
        elseif(n==4)then
          nn=pnb(idx)%dr;i=i0+1;j=j0-1
        endif
        if(j<1)j=1
        if(j>jm)j=jm
        if(nn/=0)then
          cnb(idx)%xmc(n)=alon(nn)-alon(idx)
          cnb(idx)%ymc(n)=alat(nn)-alat(idx)
        else
          if(i>im)then
            cnb(idx)%xmc(n)=alon(idx)-mlon(im-1,j)
            cnb(idx)%ymc(n)=-(alat(idx)-mlat(im-1,j))
          elseif(i<1)then
            cnb(idx)%xmc(n)=alon(idx)-mlon(2,j)
            cnb(idx)%ymc(n)=-(alat(idx)-mlat(2,j))
          else
            cnb(idx)%xmc(n)=mlon(i,j)-alon(idx)
            cnb(idx)%ymc(n)=mlat(i,j)-alat(idx)
          endif
        endif
        if(cnb(idx)%xmc(n)>90.d0)cnb(idx)%xmc(n)=cnb(idx)%xmc(n)-360.d0
        if(cnb(idx)%xmc(n)<-90.d0)cnb(idx)%xmc(n)=cnb(idx)%xmc(n)+360.d0
      enddo
      !  c2----n2----c1   
      !  |      |     |   
      !  n3-----o----n1   N1-4: right,up,left,down
      !  |      |     |   C1-4: ur,ul,dl,dr
      !  c3----n4----c4
      do n=1,cnb(idx)%n
        if(cnb(idx)%nbs(n)/=0)call cal_geo_distangl(alon(idx),alat(idx),                         &
                                                    alon(cnb(idx)%nbs(n)),alat(cnb(idx)%nbs(n)), &
                                                   cnb(idx)%dst(n),cnb(idx)%rot(n))
        if(cnb(idx)%nbsc(n)/=0)call cal_geo_distangl(alon(idx),alat(idx),                          &
                                                     alon(cnb(idx)%nbsc(n)),alat(cnb(idx)%nbsc(n)),&
                                                    cnb(idx)%dstc(n),cnb(idx)%rotc(n))
      enddo
      do n=1,cnb(idx)%n
        if(cnb(idx)%nbs(n)==0)then
          do nn=1,cnb(idx)%n-1
            nnn=n+nn;if(nnn>cnb(idx)%n)nnn=nnn-cnb(idx)%n
            if(cnb(idx)%nbs(nnn)/=0)then
              cnb(idx)%dst(n)=cnb(idx)%dst(nnn)
              cnb(idx)%rot(n)=cnb(idx)%rot(nnn)-nn*90.d0
              if(cnb(idx)%rot(n)<0)cnb(idx)%rot(n)=cnb(idx)%rot(n)+360.d0
              exit
            endif
          enddo
        endif
        if(cnb(idx)%nbsc(n)==0)then
          do nn=1,cnb(idx)%n-1
            nnn=n+nn;if(nnn>cnb(idx)%n)nnn=nnn-cnb(idx)%n
            if(cnb(idx)%nbsc(nnn)/=0)then
              cnb(idx)%dstc(n)=cnb(idx)%dstc(nnn)
              cnb(idx)%rotc(n)=cnb(idx)%rotc(nnn)-nn*90.d0
              if(cnb(idx)%rotc(n)<0)cnb(idx)%rotc(n)=cnb(idx)%rotc(n)+360.d0
              exit
            endif
          enddo
        endif
      enddo
            
      if(pnb(idx)%r/=0 .and. pnb(idx)%l/=0)then
        grdx=0.5d0*((d(pnb(idx)%r)-d(idx))/cnb(idx)%dst(1)+(d(idx)-d(pnb(idx)%l))/cnb(idx)%dst(3))
        ang=deg2rad*(cnb(idx)%rot(1)+cnb(idx)%rot(3)-180.d0)/2.d0
      elseif(pnb(idx)%r/=0)then
        grdx=(d(pnb(idx)%r)-d(idx))/cnb(idx)%dst(1)
        ang=deg2rad*cnb(idx)%rot(1)
      elseif(pnb(idx)%l/=0)then
        grdx=(d(idx)-d(pnb(idx)%l))/cnb(idx)%dst(3)
        ang=deg2rad*(cnb(idx)%rot(3)-180.d0)
      else
        grdx=0.d0
        ang=deg2rad*cnb(idx)%rot(1)
      endif
      if(pnb(idx)%u/=0 .and. pnb(idx)%d/=0)then
        grdy=0.5d0*((d(pnb(idx)%u)-d(idx))/cnb(idx)%dst(2)+(d(idx)-d(pnb(idx)%d))/cnb(idx)%dst(4))
      elseif(pnb(idx)%u/=0)then
        grdy=(d(pnb(idx)%u)-d(idx))/cnb(idx)%dst(2)
      elseif(pnb(idx)%d/=0)then
        grdy=(d(idx)-d(pnb(idx)%d))/cnb(idx)%dst(4)
      else
        grdy=0.d0
      endif
      ! x1=x*cos(a)-y*sin(a);y1=y*cos(a)+x*sin(a)
      !ang=(cnb(idx)%rot(1)+cnb(idx)%rot(3)-180.d0)/2.d0
      cnb(idx)%dddx=grdx*cos(ang)-grdy*sin(ang)
      cnb(idx)%dddy=grdy*cos(ang)+grdx*sin(ang)
      cnb(idx)%tanlatrs=tan(alat(IAIC_IDX)*pi/180.d0)/rs
      cnb(idx)%rslat=rslat !(idx)     
      cnb(idx)%angle=ang      
    enddo
    deallocate(v2,iv2,mlon,mlat,sv2)
    contains
    subroutine packbcastdata(act)
      integer,intent(in) :: act
      if(act==0)then
        lsize=(im*jm*8*2)
        call InitMpiPacket(pk,lsize)
      else
        call bcast_packet(pk,root,pid,mpi_comm)
      endif
      call irrp_pget_mpipacket(pk,mlon,im*jm,mpi_comm,act)
      call irrp_pget_mpipacket(pk,mlat,im*jm,mpi_comm,act)
      if(act>0)then
        call FinalMpiPacket(pk)
      endif
    end subroutine packbcastdata
  end subroutine set_geoinf
!-------------------------------------------------------------------------------------------------
  subroutine reset_time_step_dist
    real(spdp),allocatable :: tim(:)
    real(spdp) :: maxtimestep,prop_time_step,iii
    integer :: idx,ierr,ii,jj
    if(delttmflag==1)then
      allocate(tim(0:np))
      tim=1.e10
      do idx=1,npc
        if(nsp(idx)/=1)cycle
        !tim(idx)=minval(cnb(idx)%dst)/max(ccg(1,idx)+ux(idx),ccg(1,idx)+uy(idx))
        tim(idx)=minval(cnb(idx)%dst)/maxval(ccg(:,idx)) !+ux(idx),ccg(1,idx)+uy(idx))
      enddo
      tim=tim/60.d0 ! in minus
      maxtimestep=minval(tim,mask=tim>0.);deallocate(tim)
      if(spdp==4)then
        call MPI_ALLREDUCE(maxtimestep,delttm,1,MPI_REAL,MPI_MIN,mpi_comm,ierr)
      else
        call MPI_ALLREDUCE(maxtimestep,delttm,1,MPI_DOUBLE_PRECISION,MPI_MIN,mpi_comm,ierr)
      endif
      maxtimestep=delttm
      if(maxtimestep>1)then
        ii=int(maxtimestep)
        if(mod(60,ii)==0)then
          maxtimestep=ii
        else
          jj=int(60.d0/maxtimestep)+1
          maxtimestep=60.d0/dble(jj)
        endif
      else
        ii=int(maxtimestep*60)  ! in seconds
        if(mod(60,ii)==0)then
          maxtimestep=dble(ii)/60.d0
        else
          jj=int(1.d0/maxtimestep)+1
          maxtimestep=1.d0/dble(jj)
        endif
      endif
      delttm=maxtimestep
    endif
    deltt    = delttm  * 60.  ! yinxq
    !yinxq 20190119: deltt5   = delttm  * 30.  ! yinxq
    iwiofreq = wiofreq * 60. / delttm
!    iciofreq = ciofreq * 60. / delttm
    irstfreq = rstfreq * 60. / delttm
    number = (1-key) * cools_days * 1440. / delttm
    !cgro=0.0000091*p*deltts
    if(pid==0)write(*,*)'delttm=',delttm
    do k=1,kl
      !grolim(k)=0.0000091*p*deltt/wk(k)**4
      grolim(k)=0.0000091*p/wk(k)**4
    enddo
  end subroutine reset_time_step_dist
!-------------------------------------------------------------------------------------------------
  subroutine reset_time_step
    real(spdp),allocatable :: tim(:)
    real(spdp) :: maxtimestep,prop_time_step,iii
    integer :: idx,ierr,ii,jj
    if(delttmflag==1)then
      allocate(tim(0:np))
      tim=1.e10
      do idx=1,np
        if(nsp(idx)/=1)cycle
        !tim(idx)=min(deltx(idx)*rslat(idx)/(ccg(1,idx)+ux(idx)),&
        tim(idx)=min(cnb(idx)%deltx*cnb(idx)%rslat/(ccg(1,idx)+ux(idx)),&
                     cnb(idx)%delty*rs/(ccg(1,idx)+uy(idx)))
      enddo
      tim=tim*pi/1.08e4 ! 10800 = 180(deg) * 60(m)
      maxtimestep=minval(tim,mask=tim>0.);deallocate(tim)
      if(spdp==4)then
        call MPI_ALLREDUCE(maxtimestep,delttm,1,MPI_REAL,MPI_MIN,mpi_comm,ierr)
      else
        call MPI_ALLREDUCE(maxtimestep,delttm,1,MPI_DOUBLE_PRECISION,MPI_MIN,mpi_comm,ierr)
      endif
      maxtimestep=delttm
      if(maxtimestep>1)then
        ii=int(maxtimestep)
        if(mod(60,ii)==0)then
          maxtimestep=ii
        else
          jj=int(60.d0/maxtimestep)+1
          maxtimestep=60.d0/dble(jj)
        endif
      else
        ii=int(maxtimestep*60)  ! in seconds
        if(mod(60,ii)==0)then
          maxtimestep=dble(ii)/60.d0
        else
          jj=int(1.d0/maxtimestep)+1
          maxtimestep=1.d0/dble(jj)
        endif
      endif
      delttm=maxtimestep
      !      iii=max(1,nint(60.e0/maxtimestep))
      !      if(60.e0/iii>maxtimestep)iii=iii+1
      !      delttm=60.e0/iii
      !      ! reduce delttm ???
      !      if(spdp==4)then
      !        call MPI_ALLREDUCE(delttm,prop_time_step,1,MPI_REAL,MPI_MIN,mpi_comm,ierr)
      !      else
      !        call MPI_ALLREDUCE(delttm,prop_time_step,1,MPI_DOUBLE_PRECISION,MPI_MIN,mpi_comm,ierr)
      !      endif
      !      delttm=prop_time_step
    endif
    deltt    = delttm  * 60.  ! yinxq
    !yinxq 20190119: deltt5   = delttm  * 30.  ! yinxq
    iwiofreq = wiofreq * 60. / delttm
!    iciofreq = ciofreq * 60. / delttm
    irstfreq = rstfreq * 60. / delttm
    number = (1-key) * cools_days * 1440. / delttm
    !DBG,'prop_time_step',prop_time_step
    !DBG,'number',number
    !cgro=0.0000091*p*deltts
    if(pid==0)write(*,*)'delttm=',delttm
    do k=1,kl
      !grolim(k)=0.0000091*p*deltt/wk(k)**4
      grolim(k)=0.0000091*p/wk(k)**4
    enddo
  end subroutine reset_time_step
!-------------------------------------------------------------------------------------------------
  subroutine update_ee
    integer,save :: group_ind_ee=0
    integer,allocatable :: gpind(:)
    integer :: ivar,kk,jj
#ifndef SMALLEXG
    if(group_ind_ee==0)then
      ivar=1;group_ind_ee=1;kk=kl;jj=jl
      call irrp_exg_setvar(group_ind_ee,ivar,'ee',ee,kk,jj)
    endif
    call irrp_exg_action(group_ind_ee)
#else
    if(.not.allocated(tempv2))then
      allocate(tempv2(kl,0:np));group_ind_ee=1;ivar=1;kk=kl
      call irrp_exg_setvar(group_ind_ee,ivar,'ee',tempv2,kk)
    endif
    do jj=1,jl
      tempv2(1:kl,0:np)=ee(1:kl,jj,0:np)
      call irrp_exg_action(group_ind_ee)
      ee(1:kl,jj,0:np)=tempv2(1:kl,0:np)
    enddo
#endif
    ee(:,:,0)=small
  end subroutine update_ee
!-------------------------------------------------------------------------------------------------
  subroutine update_e
    integer,save :: group_ind_e=0
    integer :: ivar,kk,jj
#ifndef SMALLEXG
    if(group_ind_e==0)then
      ivar=1;group_ind_e=1;kk=kl;jj=jl
      call irrp_exg_setvar(group_ind_e,ivar,'e',e,kk,jj)
    endif
    call irrp_exg_action(group_ind_e)
#else
    if(.not.allocated(tempv2))then
      allocate(tempv2(kl,0:np));group_ind_e=1;ivar=1;kk=kl
      call irrp_exg_setvar(group_ind_e,ivar,'e',tempv2,kk)
    endif
    do jj=1,jl
      tempv2(1:kl,0:np)=e(1:kl,jj,0:np)
      call irrp_exg_action(group_ind_e)
      e(1:kl,jj,0:np)=tempv2(1:kl,0:np)
    enddo
#endif
    e(:,:,0)=small
  end subroutine update_e
!-------------------------------------------------------------------------------------------------
end module wamint_mod
!-------------------------------------------------------------------------------------------------
  
