#define DBG  print*, __FILE__, __LINE__,pid
#define DBG0 if(pid==0)print*, __FILE__, __LINE__
!!#define DOGFSForecast
!!!!#define USEPNETCDFPNC
!#define OUTWAVEPARS_EXW
#define EXTREMEWAVE
#define SWELL 

module wamfio_mod
  use irrp_smpi_mod;use irrp_package_mod
  use time_mod;use netcdf_mod
  use partctl_mod,only: mpi_comm,pid,root,lon,lat,mask
  use mwmvar_mod
  use mwmcor_mod
  use partctl_mod,only : plist
#ifdef USEPNETCDFPNC
  use pncio_mod
#endif
  implicit none

  public :: pntio_itp_init,pntio_itp_output,pntio_init,pntio_output

  public :: output,inprst,outrst,getrst,getwav
  public :: outwave,outwave_onerecd
  private

  integer*2,parameter :: ivland=nf_fill_int2
  integer*2,allocatable :: iv2(:,:)
  real(spdp),allocatable :: v2(:,:)
!  integer :: wind_init=0
  integer :: irstcunt=0,onedaysteps

  type pntioinf_type
    character(len=20) :: cflag
    real(4) :: dt                   ! time interval in hours.
    integer :: flag                 ! io flag, 0 for one year one file
    integer :: np=0                 ! Number of pnts.
    real(4),pointer :: x(:)=>null()
    real(4),pointer :: y(:)=>null() ! Location list of pnts.
    integer,pointer :: i(:)=>null()
    integer,pointer :: j(:)=>null() ! index list of pnts.
    !-----------------------------------------------------
    integer,pointer :: i4(:,:)=>null()
    integer,pointer :: j4(:,:)=>null()
    real(8),pointer :: w4(:,:)=>null()
    !-----------------------------------------------------
    integer :: nio=0
    integer,pointer :: iolist(:,:)=>null() ! (nio,3) idx,i,j
    integer :: istep,cntstep               ! Temporary value for IO.
    !-----------------------------------------------------
  end type pntioinf_type

  type(pntioinf_type) :: pinf

#ifdef EXTREMEWAVE 
  public :: extreme_wave_out
  !-----------------------------------------------------------------------------------------------
  ! Parameters for predicting extreme waves from spectrum
  ! Method/code provided by Francesco Barbariol from ISMAR-CNR, Venice, Italy
  ! Refference:
  ! Barbariol F, Alves J H G M, Benetazzo A, et al. Numerical modeling of
  ! space-time wave extremes using WAVEWATCH III[J]. Ocean Dynamics, 2017, 67(3-4):1-15.

  integer :: exw_flag                  ! The flag for extreme waves,
                                       ! 0 is for not calculate the extreme waves
  real(spdp) :: exw_x = 100            ! size in space of the domain, in meters
  real(spdp) :: exw_y = 100            ! size in space of the domain, in meters
  real(spdp) :: exw_d = 1800           ! duration in time of the domain, in seconds.
  integer :: exw_freq = 1              ! The output frequence for extreme waves (hour).
  real(spdp),allocatable :: exw_cmax(:)    ! Expected maximum crest height.
  real(spdp),allocatable :: exw_cmaxstd(:) ! STD of expected maximum crest height. 
  real(spdp),allocatable :: exw_hmax(:)    ! Expected maximum crest-to-trough height.
  real(spdp),allocatable :: exw_hmaxstd(:) ! STD of expected maximum crest-to-trough height.

  real(spdp),allocatable :: exw_tm(:)
  real(spdp),allocatable :: exw_lx(:)
  real(spdp),allocatable :: exw_ly(:)
  real(spdp),allocatable :: exw_axy(:)
  real(spdp),allocatable :: exw_axt(:)
  real(spdp),allocatable :: exw_ayt(:)
  real(spdp),allocatable :: exw_ni(:)
  real(spdp),allocatable :: exw_mu(:)

  integer :: exw_init = 0 ! The flag for exw initiated (1) or not (0).
  integer :: exw_nstp = 0 ! The output frequence for extreme waves in steps.
  integer :: exw_icnt = 0 ! The count for output of the extreme waves in steps.
#endif

#ifdef SWELL
  public :: swell_out
  real(spdp),allocatable,private :: swell_hs(:) ! Significant wave height of swell
  real(spdp),allocatable,private :: swell_th(:) ! Mean wave direction of swell
  real(spdp),allocatable,private :: swell_tp(:) ! Spectrum peak wave period of swell
  real(spdp),allocatable,private :: swell_tz(:) ! Zero-crossing wave period of swell

  real(spdp),allocatable,private :: wind_hs(:) ! Significant wave height of windwave. 
  real(spdp),allocatable,private :: wind_th(:) ! Mean wave direction of windwave.
  real(spdp),allocatable,private :: wind_tp(:) ! Spectrum peak wave period of windwave.
  real(spdp),allocatable,private :: wind_tz(:) ! Zero-crossing wave period of windwave.

  type swell_type
    real(spdp) :: aves,asis,apes,awfs,atcs,atss
    real(spdp) :: avew,asiw,apew,awfw,atcw,atsw
  end type swell_type
  type(swell_type),allocatable :: swl(:)
#endif
  !-----------------------------------------------------------------------------------------------
  contains
  !-----------------------------------------------------------------------------------------------
  subroutine output(key,it,itime)
    integer,intent(in) :: key,it,itime(6)
    integer :: maxrst
    maxrst=0
    if(outflag==5)maxrst=1
    if(outflag==6)maxrst=2

    if(key==0)return
#ifdef USEPNETCDFPNC
    call init_iopnc
#endif
    ! --- Output wave parameters.
    call outwave(it)
#ifdef SWELL
    call swell_out(it)
#endif
#ifdef EXTREMEWAVE 
    ! --- Output extreme wave parameters.
    call extreme_wave_out
#endif
    ! --- Output wave spectrum at some points.
    call pntio_itp_output
    ! --- Output restart
#ifndef DOGFSForecast
#ifndef OUTRSTEACHMONTH
    if(irstfreq>0)then
      if(irstcunt==irstfreq)then
        call outrst(trim(outpath)//'restart_'//ctime//'.nc');irstcunt=0
      endif
      irstcunt=irstcunt+1
      if(maxrst>0 .and. it-number>maxrst*irstfreq)irstcunt=0
      return
    elseif(irstfreq==0)then
      if(it/=number .and. itime(3)==1 .and. sum(itime(4:6))==0)then
        DBG0;call outrst(trim(outpath)//'restart_'//ctime//'.nc')
      endif
    elseif(irstfreq<0)then
      if(it/=number .and. itime(2)==1 .and. itime(3)==1 .and. sum(itime(4:6))==0)then
        DBG0;call outrst(trim(outpath)//'restart_'//ctime//'.nc')
      endif
    endif
#else
    if(it/=number .and. itime(3)==1 .and. sum(itime(4:6))==0)then
      DBG0;call outrst(trim(outpath)//'restart_'//ctime//'.nc')
    endif
#endif
#else
    onedaysteps=1440.d0/delttm
    if(it==onedaysteps)call outrst('wave_rest.'//ctime(1:10)//'.nc')
#endif
  end subroutine output
  !-----------------------------------------------------------------------------------------------
#ifdef SWELL  
  subroutine swell_out(it)
    integer,intent(in) :: it
    integer :: idx
    !---------------------------------------------------------------------------------------------
    integer,save :: swell_freq =-1 ! Out frequency of swell in hours. 
                                   ! Default value is -1 for not initialated, 
                                   ! and 0 for no output, >0 for the output frequency by hours.
    integer,save :: swell_nstp = 0 ! The output frequence for swell params in steps.
    integer,save :: swell_icnt = 0 ! The count for output of the swell params in steps.
    ! IO-flags for wave parameters of wind wave and swell.
    integer,save :: ioflag_hss,ioflag_tps,ioflag_ths,ioflag_tzs  ! parameters of wind wave.
    integer,save :: ioflag_hsw,ioflag_tpw,ioflag_thw,ioflag_tzw  ! parameters of swell.
    !---------------------------------------------------------------------------------------------
    namelist/swellnml/swell_freq, &
             ioflag_hss,ioflag_tps,ioflag_ths,ioflag_tzs, &
             ioflag_hsw,ioflag_tpw,ioflag_thw,ioflag_tzw
    !---------------------------------------------------------------------------------------------
    if(swell_freq==0)return
    if(swell_freq<0)call swell_init
    if(swell_freq==0)return
    swell_icnt=swell_icnt+1
    !if(swell_icnt<swell_nstp)return
    if(swell_icnt<swell_nstp .and. it .ne. 0)return !output on first step,xiaob,20190319
    !---------------------------------------------------------------------------------------------
#ifdef USEPNETCDFPNC
    call init_iopnc
#endif
    !---------------------------------------------------------------------------------------------
    do idx=1,npc
      call swell_calculate(wf(:,idx),wx(idx),wy(idx),ee(:,:,idx),                   &
                           swell_hs(idx),swell_th(idx),swell_tp(idx),swell_tz(idx), &
                            wind_hs(idx), wind_th(idx), wind_tp(idx), wind_tz(idx)  )
    enddo
    call out_swell;swell_icnt=0
    !---------------------------------------------------------------------------------------------
    contains
    !---------------------------------------------------------------------------------------------
    subroutine swell_calculate(wf,wx,wy,ee,hss,ths,tps,tzs,hsw,thw,tpw,tzw)
      real(spdp),intent(in) :: wf(:),wx,wy
      real(spdp),intent(in) :: ee(:,:)
      real(spdp),intent(out) :: hss,ths,tps,tzs,hsw,thw,tpw,tzw
      real(spdp) :: aves,asis,apes,awfs,atcs,atss
      real(spdp) :: avew,asiw,apew,awfw,atcw,atsw
      real(spdp) :: dwkk,wfk,wfk1,wkk,wkk1,wsk,wsk1,test
      real(spdp) :: eekj,eekj1,costh,sinth
      integer :: i,j,k1,i1
      real(spdp),parameter :: beta=1.2d0
      real(spdp),parameter :: dttest=0.01d0

      real(spdp) :: wt
      !-------------------------------------------------------------------------------------------
      ! Following Janssen et al. (1989) and Bidlot (2001), the spectral components 
      ! are considered to be subject to local wind forcing when
      !          c / [U cos(θ - φ)] < β,
      ! where c is the phase velocity c = σ/k, φ is the wind direction, U is the 
      ! wind speed at 10m above the sea surface (sometimes approximated by 28*ustar).
      ! β is the constant forcing parameter with the value between [1.0, 2.0]. By 
      ! default, β = 1.2 as in Bidlot (2001). σ is circular frenquence (σ=2πf).
      ! The above formula can be written as 
      !           β*[U cos(θ - φ)]*k > σ=2πf.
      ! -->       (β/2π)*[U cos(θ - φ)]*k > f
      ! Consider the wind components, wx=U*cos(φ) and wy=U*sin(φ), the above formula
      ! can be written as (due to cos（α－β）＝cosαcosβ＋sinαsinβ )
      !          (β/2π)*k*[ wx * cos(θ) + wy * sin(θ) ] > f
      !          β*k*[ ux * cos(θ) + uy * sin(θ) ] - 2πf > 0
      !-------------------------------------------------------------------------------------------
      hss=0;ths=0;tps=0;tzs=0;hsw=0;thw=0;tpw=0;tzw=0
      aves=0.d0;asis=0.d0;apes=0.d0;awfs=0.d0;atss=0.d0;atcs=0.d0;
      avew=0.d0;asiw=0.d0;apew=0.d0;awfw=0.d0;atsw=0.d0;atcw=0.d0;
      do k=1,kl-1
        k1=k+1;i=k-kl+1;i1=i+1
        dwkk=dwk(k)
        wfk=wf(k)  ! yinxq 20190324
        wfk1=wf(k1)
        wsk=zpi*wfk
        wsk1=zpi*wfk1
        wkk=wk(k)
        wkk1=wk(k1)
        do j=1,jl
          if (k.lt.kl) then
            eekj =ee(k,j);eekj1=ee(k1,j)
          else
            eekj =ee(kl,j)*wkh(i);eekj1=ee(kl,j)*wkh(i1)
          endif
          sinth=sin(thet(j));costh=cos(thet(j))

          !test=beta*wkk*(wx*costh+wy*sinth)-wsk
          !wt=0.d0;if(test<=0)wt=1.d0
          test=beta*wkk*(wx*costh+wy*sinth)/wsk-1.d0
          if(test+dttest<0.d0)then     ! test<0.9
            wt=1.d0  ! swell
          elseif(test-dttest>0.d0)then ! test>1.1
            wt=0.d0  ! wind-wave
          else
            wt=(dttest-test)/(dttest*2.d0)
          endif

          aves=aves+wt*dwkk*(eekj+eekj1)
          asis=asis+wt*dwkk*(eekj/(wfk**2)+eekj1/(wfk1**2))
          apes=apes+wt*dwkk*(eekj*wsk**2+eekj1*wsk1**2)
          awfs=awfs+wt*dwkk*(eekj*wfk+eekj1*wfk1)
          atss=atss+wt*dwkk*(eekj+eekj1)*sinth
          atcs=atcs+wt*dwkk*(eekj+eekj1)*costh

          avew=avew+(1.d0-wt)*dwkk*(eekj+eekj1)
          asiw=asiw+(1.d0-wt)*dwkk*(eekj/(wfk**2)+eekj1/(wfk1**2))
          apew=apew+(1.d0-wt)*dwkk*(eekj*wsk**2+eekj1*wsk1**2)
          awfw=awfw+(1.d0-wt)*dwkk*(eekj*wfk+eekj1*wfk1)
          atsw=atsw+(1.d0-wt)*dwkk*(eekj+eekj1)*sinth
          atcw=atcw+(1.d0-wt)*dwkk*(eekj+eekj1)*costh
        enddo
      enddo
      hss=4.d0*sqrt(aves)
      tps=(asis/aves)*(awfs/aves)
      ths=atan2(atss,atcs)*180.d0/pi
      tzs=zpi/sqrt(apes/aves); if(ths<0)ths=360.+ths

      hsw=4.d0*sqrt(avew)
      tpw=(asiw/avew)*(awfw/avew)
      thw=atan2(atsw,atcw)*180.d0/pi
      tzw=zpi/sqrt(apew/avew); if(thw<0)thw=360.+thw
    end subroutine swell_calculate
    !---------------------------------------------------------------------------------------------
    subroutine swell_init
      integer :: root=0,lsize,ierr
      type(mpipacket) :: pk
      swell_freq=0
      if(pid==root)then
        open(11,file='ctlparams',delim='quote')
        read(11,nml=swellnml,iostat=ierr)
        if(ierr/=0)swell_freq=0
        close(11)
        write(*,nml=swellnml)
        call packbcastdata(0,pk,lsize)
      endif
      call packbcastdata(1,pk,lsize)
      if(swell_freq<1)return
      allocate(swell_hs(0:np));swell_hs=0.d0
      allocate(swell_th(0:np));swell_th=0.d0
      allocate(swell_tp(0:np));swell_tp=0.d0
      allocate(swell_tz(0:np));swell_tz=0.d0
      allocate(wind_hs(0:np));wind_hs=0.d0
      allocate(wind_th(0:np));wind_th=0.d0
      allocate(wind_tp(0:np));wind_tp=0.d0
      allocate(wind_tz(0:np));wind_tz=0.d0
      call init_swell_info
      swell_nstp=swell_freq*60.d0/delttm
      !swell_icnt=0
      swell_icnt=swell_nstp
    end subroutine swell_init
    subroutine init_swell_info
      integer :: idx
      if(.not. allocated(swl))allocate(swl(0:np))
      do idx=1,np
        swl(idx)%aves=0.d0
        swl(idx)%asis=0.d0
        swl(idx)%apes=0.d0
        swl(idx)%awfs=0.d0
        swl(idx)%atcs=0.d0
        swl(idx)%atss=0.d0
        swl(idx)%avew=0.d0
        swl(idx)%asiw=0.d0
        swl(idx)%apew=0.d0
        swl(idx)%awfw=0.d0
        swl(idx)%atcw=0.d0
        swl(idx)%atsw=0.d0
      enddo
    end subroutine init_swell_info
    !---------------------------------------------------------------------------------------------
    subroutine packbcastdata(act,pk,lsize)
      integer,intent(in) :: act
      type(mpipacket),intent(inout) :: pk
      integer,intent(inout) :: lsize
      if(act==0)then
        lsize=200
        call InitMpiPacket(pk,lsize)
      else
        call bcast_packet(pk,root,pid,mpi_comm)
      endif
      call irrp_pget_mpipacket(pk,swell_freq,1,mpi_comm,act) 
      call irrp_pget_mpipacket(pk,ioflag_hss,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,ioflag_tps,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,ioflag_ths,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,ioflag_tzs,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,ioflag_hsw,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,ioflag_tpw,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,ioflag_thw,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,ioflag_tzw,1,mpi_comm,act)
      if(act>0)then
        call FinalMpiPacket(pk)
      endif
    end subroutine packbcastdata
    !---------------------------------------------------------------------------------------------
    subroutine out_swell
      character(len=256) :: filename
      integer :: recd,ncid
      logical :: ext
      call set_filename_recd(filename,recd)
      inquire(file=filename,exist=ext)
      if((.not. ext) .or. recd==1)call create_outfile(filename)
      if(pid==0)write(*,*)trim(filename),recd
      if(pid==root)then
        call open_nc(ncid,filename,'w')
        call writenc(ncid,'time',dtime,recd)
        call close_nc(ncid)
      endif
      call outnc_2d_reciv2(filename,'swell_hs',0.01,recd,swell_hs,ioflag_hss)
      call outnc_2d_reciv2(filename,'swell_th',0.1 ,recd,swell_th,ioflag_ths)
      call outnc_2d_reciv2(filename,'swell_tp',0.01,recd,swell_tp,ioflag_tps)
      call outnc_2d_reciv2(filename,'swell_tz',0.01,recd,swell_tz,ioflag_tzs)
      call outnc_2d_reciv2(filename,'wind_hs' ,0.01,recd, wind_hs,ioflag_hsw)
      call outnc_2d_reciv2(filename,'wind_th' ,0.1 ,recd, wind_th,ioflag_thw)
      call outnc_2d_reciv2(filename,'wind_tp' ,0.01,recd, wind_tp,ioflag_tpw)
      call outnc_2d_reciv2(filename,'wind_tz' ,0.01,recd, wind_tz,ioflag_tzw)
    end subroutine out_swell
    !---------------------------------------------------------------------------------------------
    subroutine create_outfile(filename)
#ifdef USEPNETCDFPNC
      use pnetcdf
      character(len=*),intent(in) :: filename
      integer :: ncid,stat,dimids(3),vid,vidlon,vidlat
      integer(KIND=8) :: g_im,g_jm,ulm
  
      g_im=im;g_jm=jm;ulm=NF90_UNLIMITED
      stat=nf90mpi_create(mpi_comm,filename,                 &
                            IOR(NF_CLOBBER,NF_64BIT_OFFSET), &
                            MPI_INFO_NULL,ncid)
      stat=nf90mpi_def_dim(ncid,"lon",g_im,dimids(1))
      stat=nf90mpi_def_var(ncid,"lon",nf90_real,dimids(1),vidlon)
      stat=nf90mpi_put_att(ncid,vidlon,'units','degrees_east')
      stat=nf90mpi_put_att(ncid,vidlon,'modulo','')
  
      stat=nf90mpi_def_dim(ncid,"lat",g_jm,dimids(2))
      stat=nf90mpi_def_var(ncid,"lat",nf90_real,dimids(2),vidlat)
      stat=nf90mpi_put_att(ncid,vidlat,'units','degrees_north')
  
      stat=nf90mpi_def_dim(ncid,"time",ulm,dimids(3))
      stat=nf90mpi_def_var(ncid,"time",nf90_double,dimids(3),vid)
      stat=nf90mpi_put_att(ncid,vid,'units',trim(timeunits))
  
      if(ioflag_hss/=0)then
        stat=nf90mpi_def_var(ncid,'swell_hs',nf90_int2,dimids,vid)
        stat=nf90mpi_put_att(ncid,vid,'scale_factor',0.01)
        stat=nf90mpi_put_att(ncid,vid,'units','m')
        stat=nf90mpi_put_att(ncid,vid,'longname','Significant wave height of swell')
        stat=nf90mpi_put_att(ncid,vid,'missing_value',NF90_FILL_int2)
        stat=nf90mpi_def_var_fill(ncid,vid,0,NF90_FILL_int2)
      endif
  
      if(ioflag_ths/=0)then
        stat=nf90mpi_def_var(ncid,'swell_th',nf90_int2,dimids,vid)
        stat=nf90mpi_put_att(ncid,vid,'scale_factor',0.1)
        stat=nf90mpi_put_att(ncid,vid,'units','degree')
        stat=nf90mpi_put_att(ncid,vid,'longname','Mean wave direction of swell')
        stat=nf90mpi_put_att(ncid,vid,'missing_value',NF90_FILL_int2)
        stat=nf90mpi_def_var_fill(ncid,vid,0,NF90_FILL_int2)
      endif
  
      if(ioflag_tps/=0)then
        stat=nf90mpi_def_var(ncid,'swell_tp',nf90_int2,dimids,vid)
        stat=nf90mpi_put_att(ncid,vid,'scale_factor',0.01)
        stat=nf90mpi_put_att(ncid,vid,'units','second')
        stat=nf90mpi_put_att(ncid,vid,'longname','Spectrum peak wave period of swell')
        stat=nf90mpi_put_att(ncid,vid,'missing_value',NF90_FILL_int2)
        stat=nf90mpi_def_var_fill(ncid,vid,0,NF90_FILL_int2)
      endif
  
      if(ioflag_tzs/=0)then
        stat=nf90mpi_def_var(ncid,'swell_tz',nf90_int2,dimids,vid)
        stat=nf90mpi_put_att(ncid,vid,'scale_factor',0.01)
        stat=nf90mpi_put_att(ncid,vid,'units','second')
        stat=nf90mpi_put_att(ncid,vid,'longname','Zero-crossing wave period of swell')
        stat=nf90mpi_put_att(ncid,vid,'missing_value',NF90_FILL_int2)
        stat=nf90mpi_def_var_fill(ncid,vid,0,NF90_FILL_int2)
      endif
  
      if(ioflag_hsw/=0)then
        stat=nf90mpi_def_var(ncid,'wind_hs',nf90_int2,dimids,vid)
        stat=nf90mpi_put_att(ncid,vid,'scale_factor',0.01)
        stat=nf90mpi_put_att(ncid,vid,'units','m')
        stat=nf90mpi_put_att(ncid,vid,'longname','Significant wave height of windwave')
        stat=nf90mpi_put_att(ncid,vid,'missing_value',NF90_FILL_int2)
        stat=nf90mpi_def_var_fill(ncid,vid,0,NF90_FILL_int2)
      endif
  
      if(ioflag_thw/=0)then
        stat=nf90mpi_def_var(ncid,'wind_th',nf90_int2,dimids,vid)
        stat=nf90mpi_put_att(ncid,vid,'scale_factor',0.1)
        stat=nf90mpi_put_att(ncid,vid,'units','degree')
        stat=nf90mpi_put_att(ncid,vid,'longname','Mean wave direction of windwave')
        stat=nf90mpi_put_att(ncid,vid,'missing_value',NF90_FILL_int2)
        stat=nf90mpi_def_var_fill(ncid,vid,0,NF90_FILL_int2)
      endif
  
      if(ioflag_tpw/=0)then
        stat=nf90mpi_def_var(ncid,'wind_tp',nf90_int2,dimids,vid)
        stat=nf90mpi_put_att(ncid,vid,'scale_factor',0.01)
        stat=nf90mpi_put_att(ncid,vid,'units','second')
        stat=nf90mpi_put_att(ncid,vid,'longname','Spectrum peak wave period of wiondwave')
        stat=nf90mpi_put_att(ncid,vid,'missing_value',NF90_FILL_int2)
        stat=nf90mpi_def_var_fill(ncid,vid,0,NF90_FILL_int2)
      endif
  
      if(ioflag_tzw/=0)then
        stat=nf90mpi_def_var(ncid,'wind_tz',nf90_int2,dimids,vid)
        stat=nf90mpi_put_att(ncid,vid,'scale_factor',0.01)
        stat=nf90mpi_put_att(ncid,vid,'units','second')
        stat=nf90mpi_put_att(ncid,vid,'longname','Zero-crossing wave period of windwave')
        stat=nf90mpi_put_att(ncid,vid,'missing_value',NF90_FILL_int2)
        stat=nf90mpi_def_var_fill(ncid,vid,0,NF90_FILL_int2)
      endif
  
      stat=nf90mpi_enddef(ncid)
      stat=nf90mpi_begin_indep_data(ncid)
      if(pid==root)then
        stat=nf90mpi_put_var(ncid,vidlon,lon)
        stat=nf90mpi_put_var(ncid,vidlat,lat)
      endif
      stat=nf90mpi_end_indep_data(ncid)
      stat=nf90mpi_close(ncid)
#else
      character(len=*),intent(in) :: filename
      integer :: ncid
      integer*2 :: vland
      vland=ivland
      if(pid/=root)return
      call open_nc(ncid,filename,'c')
      call dimension_define(ncid,'lon',im,'lon',nf_real)
      call dimension_define(ncid,'lat',jm,'lat',nf_real)
      call dimension_define(ncid,'time',0,'time',nf_double)
      call set_attribute(ncid,'units','degrees_north','lat')
      call set_attribute(ncid,'units','degrees_east','lon')
      call set_attribute(ncid,'modulo','','lon')
      call set_attribute(ncid,'units',trim(timeunits),'time')
      call set_attribute(ncid,'Start_time',ctime)
  
      if(ioflag_hss/=0)then
        call variable_define(ncid,'swell_hs',nf_int2,['lon ','lat ','time'])
        call set_attribute(ncid,'missing_value',vland,'swell_hs')
        call set_attribute(ncid,'units','m','swell_hs')
        call set_attribute(ncid,'longname','Significant wave height of swell','swell_hs')
        call set_attribute(ncid,'scale_factor',0.01,'swell_hs')
      endif
  
      if(ioflag_ths/=0)then
        call variable_define(ncid,'swell_th',nf_int2,['lon ','lat ','time'])
        call set_attribute(ncid,'missing_value',vland,'swell_th')
        call set_attribute(ncid,'units','degree','swell_th')
        call set_attribute(ncid,'longname','Mean wave direction of swell','swell_th')
        call set_attribute(ncid,'scale_factor',0.1,'swell_th')
      endif
  
      if(ioflag_tps/=0)then
        call variable_define(ncid,'swell_tp',nf_int2,['lon ','lat ','time'])
        call set_attribute(ncid,'missing_value',vland,'swell_tp')
        call set_attribute(ncid,'units','second','swell_tp')
        call set_attribute(ncid,'longname','Spectrum peak wave period of swell','swell_tp')
        call set_attribute(ncid,'scale_factor',0.01,'swell_tp')
      endif
  
      if(ioflag_tzs/=0)then
        call variable_define(ncid,'swell_tz',nf_int2,['lon ','lat ','time'])
        call set_attribute(ncid,'missing_value',vland,'swell_tz')
        call set_attribute(ncid,'units','second','swell_tz')
        call set_attribute(ncid,'longname','Zero-crossing wave period of swell','swell_tz')
        call set_attribute(ncid,'scale_factor',0.01,'swell_tz')
      endif
  
      if(ioflag_hsw/=0)then
        call variable_define(ncid,'wind_hs',nf_int2,['lon ','lat ','time'])
        call set_attribute(ncid,'missing_value',vland,'wind_hs')
        call set_attribute(ncid,'units','m','wind_hs')
        call set_attribute(ncid,'longname','Significant wave height of windwave','wind_hs')
        call set_attribute(ncid,'scale_factor',0.01,'wind_hs')
      endif
  
      if(ioflag_thw/=0)then
        call variable_define(ncid,'wind_th',nf_int2,['lon ','lat ','time'])
        call set_attribute(ncid,'missing_value',vland,'wind_th')
        call set_attribute(ncid,'units','degree','wind_th')
        call set_attribute(ncid,'longname','Mean wave direction of windwave','wind_th')
        call set_attribute(ncid,'scale_factor',0.1,'wind_th')
      endif
  
      if(ioflag_tpw/=0)then
        call variable_define(ncid,'wind_tp',nf_int2,['lon ','lat ','time'])
        call set_attribute(ncid,'missing_value',vland,'wind_tp')
        call set_attribute(ncid,'units','second','wind_tp')
        call set_attribute(ncid,'longname','Spectrum peak wave period of windwave','wind_tp')
        call set_attribute(ncid,'scale_factor',0.01,'wind_tp')
      endif
  
      if(ioflag_tzw/=0)then
        call variable_define(ncid,'wind_tz',nf_int2,['lon ','lat ','time'])
        call set_attribute(ncid,'missing_value',vland,'wind_tz')
        call set_attribute(ncid,'units','second','wind_tz')
        call set_attribute(ncid,'longname','Zero-crossing wave period of windwave','wind_tz')
        call set_attribute(ncid,'scale_factor',0.01,'wind_tz')
      endif
      
      call end_define(ncid)
      if(pid==root)then
        call writenc(ncid,'lon',lon)
        call writenc(ncid,'lat',lat)
      endif
      call close_nc(ncid)
#endif      
    end subroutine create_outfile
    !---------------------------------------------------------------------------------------------
    subroutine set_filename_recd(filename,recd)
      character(len=*),intent(out) :: filename
      integer,intent(out) :: recd
      integer :: itime_tmp(6),ncid,idx
      real(8) :: dtime1
      character(len=14) :: ctime
      !logical :: ext
      !itime=datevec(dtime-swell_freq/48.d0);ctime=datestr(itime)
      itime=datevec(dtime);ctime=datestr(itime)
      if(outflag==1)then     ! --- Output one file by yearly.
        filename=trim(outpath)//trim(title)//'_swl_'//ctime(1:4)//'.nc'
        itime_tmp=itime;itime_tmp(4:6)=0;itime_tmp(2:3)=1
      elseif(outflag==2)then ! --- Output one file by yearly.
        filename=trim(outpath)//trim(title)//'_swl_'//ctime(1:6)//'.nc'
        itime_tmp=itime;itime_tmp(4:6)=0;itime_tmp(3)=1
      elseif(outflag==3)then ! --- Output one file by daily.
        filename=trim(outpath)//trim(title)//'_swl_'//ctime(1:8)//'.nc'
        itime_tmp=itime;itime_tmp(4:6)=0;
      else
        !filename=trim(outpath)//trim(title)//'_swell.nc'
        ctime=datestr(dtime0)
        filename=trim(outpath)//trim(title)//'_swl_'//ctime(1:8)//'.nc'
        itime_tmp=datevec(dtime0)
      endif
      recd=nint(24.*(datenum(itime)-datenum(itime_tmp))/swell_freq)+1
      if(pid==0)write(*,*)datestr(dtime),ctime,recd
    end subroutine set_filename_recd
    !---------------------------------------------------------------------------------------------
  end subroutine swell_out
#endif
  !-----------------------------------------------------------------------------------------------
#ifdef EXTREMEWAVE 
  subroutine extreme_wave_out
    character(len=100) :: filename
    integer :: recd,idx
    !---------------------------------------------------------------------------
    if(exw_init==0)then
      call extreme_wave_init
    endif
    if(exw_flag==0)return
    exw_icnt=exw_icnt+1; if(exw_icnt<exw_nstp)return
#ifdef USEPNETCDFPNC
    call init_iopnc
#endif
    !---------------------------------------------------------------------------
    do idx=1,npc
      call cal_extreme(ee(:,:,idx)      , &
                       wf(:,idx)        , &
                       exw_cmax(idx)    , &
                       exw_cmaxstd(idx) , &
                       exw_hmax(idx)    , &
                       exw_hmaxstd(idx) , &
                       idx                )
    enddo
    !---------------------------------------------------------------------------
    call output_exw;exw_icnt=0
    !---------------------------------------------------------------------------
    contains
    !---------------------------------------------------------------------------
    subroutine output_exw
      character(len=256) :: filename
      integer :: recd,ncid
      logical :: ext
      call set_filename_recd(filename,recd)
      !filename='testexw.nc';recd=1
      inquire(file=filename,exist=ext)
      if((.not. ext) .or. recd==1)call create_exwout(filename)
      if(pid==0)write(*,*)trim(filename),recd
      if(pid==root)then
        call open_nc(ncid,filename,'w')
        call writenc(ncid,'time',dtime,recd)
        call close_nc(ncid)
      endif
      call outnc_2d_reciv2(filename,'cmax   ',0.01,recd,exw_cmax   ,1)
      call outnc_2d_reciv2(filename,'cmaxstd',0.01,recd,exw_cmaxstd,1)
      call outnc_2d_reciv2(filename,'hmax   ',0.01,recd,exw_hmax   ,1)
      call outnc_2d_reciv2(filename,'hmaxstd',0.01,recd,exw_hmaxstd,1)
      !call outnc_2d_recv2_real(filename,'cmax   ',recd,exw_cmax   )
      !call outnc_2d_recv2_real(filename,'cmaxstd',recd,exw_cmaxstd)
      !call outnc_2d_recv2_real(filename,'hmax   ',recd,exw_hmax   )
      !call outnc_2d_recv2_real(filename,'hmaxstd',recd,exw_hmaxstd)
#ifdef OUTWAVEPARS_EXW
      call outnc_2d_reciv2(filename,'windx',0.01,recd,wx  ,1)
      call outnc_2d_reciv2(filename,'windy',0.01,recd,wy  ,1)
      call outnc_2d_reciv2(filename,'hs   ',0.01,recd,h1_3,1)
      call outnc_2d_reciv2(filename,'tp   ',0.01,recd,tpf ,1)
      call outnc_2d_reciv2(filename,'tz   ',0.01,recd,ape ,1)
      call outnc_2d_reciv2(filename,'th   ',0.01,recd,aet ,1)
      !call outnc_2d_recv2_real(filename,'windx',recd,wx  )
      !call outnc_2d_recv2_real(filename,'windy',recd,wy  )
      !call outnc_2d_recv2_real(filename,'hs   ',recd,h1_3)
      !call outnc_2d_recv2_real(filename,'tp   ',recd,tpf )
      !call outnc_2d_recv2_real(filename,'tz   ',recd,ape )
      !call outnc_2d_recv2_real(filename,'th   ',recd,aet )
#endif
#ifdef TESTTEST
      call outnc_2d_recv2_real(filename,'exw_tm ',recd,exw_tm )
      call outnc_2d_recv2_real(filename,'exw_lx ',recd,exw_lx )
      call outnc_2d_recv2_real(filename,'exw_ly ',recd,exw_ly )
      call outnc_2d_recv2_real(filename,'exw_axy',recd,exw_axy)
      call outnc_2d_recv2_real(filename,'exw_axt',recd,exw_axt)
      call outnc_2d_recv2_real(filename,'exw_ayt',recd,exw_ayt)
      call outnc_2d_recv2_real(filename,'exw_ni ',recd,exw_ni )
      call outnc_2d_recv2_real(filename,'exw_mu ',recd,exw_mu )
#endif
    end subroutine output_exw
    !---------------------------------------------------------------------------
    subroutine set_filename_recd(filename,recd)
      character(len=*),intent(out) :: filename
      integer,intent(out) :: recd
      integer :: itime_tmp(6),ncid,idx
      real(8) :: dtime1
      character(len=14) :: ctime
      !logical :: ext
      !itime=datevec(dtime-exw_freq/48.d0);
      itime=datevec(dtime);
      ctime=datestr(itime)
      if(outflag==1)then     ! --- Output one file by yearly.
        filename=trim(outpath)//trim(title)//'_exw_'//ctime(1:4)//'.nc'
        itime_tmp=itime;itime_tmp(4:6)=0;itime_tmp(2:3)=1
      elseif(outflag==2)then ! --- Output one file by yearly.
        filename=trim(outpath)//trim(title)//'_exw_'//ctime(1:6)//'.nc'
        itime_tmp=itime;itime_tmp(4:6)=0;itime_tmp(3)=1
      elseif(outflag==3)then ! --- Output one file by daily.
        filename=trim(outpath)//trim(title)//'_exw_'//ctime(1:8)//'.nc'
        itime_tmp=itime;itime_tmp(4:6)=0;
      else
        ctime=datestr(dtime0)
        filename=trim(outpath)//trim(title)//'_exw_'//ctime(1:8)//'.nc'
        itime_tmp=datevec(dtime0)
      endif
      recd=nint(24.*(datenum(itime)-datenum(itime_tmp))/exw_freq)+1
      if(pid==0)write(*,*)datestr(dtime),ctime,recd
    end subroutine set_filename_recd
    !---------------------------------------------------------------------------
    subroutine create_exwout(filename)
#ifdef USEPNETCDFPNC
      use pnetcdf
      character(len=*),intent(in) :: filename
      integer :: ncid,stat,dimids(3),vid,vidlon,vidlat
      integer(kind=8) :: g_im,g_jm,ulm

      g_im=im;g_jm=jm;ulm=NF90_UNLIMITED
      stat=nf90mpi_create(mpi_comm,filename,                 &
                            IOR(NF_CLOBBER,NF_64BIT_OFFSET), &
                            MPI_INFO_NULL,ncid)
      stat=nf90mpi_def_dim(ncid,"lon",g_im,dimids(1))
      stat=nf90mpi_def_var(ncid,"lon",nf90_real,dimids(1),vidlon)
      stat=nf90mpi_put_att(ncid,vidlon,'units','degrees_east')
      stat=nf90mpi_put_att(ncid,vidlon,'modulo','')

      stat=nf90mpi_def_dim(ncid,"lat",g_jm,dimids(2))
      stat=nf90mpi_def_var(ncid,"lat",nf90_real,dimids(2),vidlat)
      stat=nf90mpi_put_att(ncid,vidlat,'units','degrees_north')

      stat=nf90mpi_def_dim(ncid,"time",ulm,dimids(3))
      stat=nf90mpi_def_var(ncid,"time",nf90_double,dimids(3),vid)
      stat=nf90mpi_put_att(ncid,vid,'units',trim(timeunits))

      stat=nf90mpi_def_var(ncid,'cmax',nf90_int2,dimids,vid)
      stat=nf90mpi_put_att(ncid,vid,'scale_factor' ,0.01)
      stat=nf90mpi_put_att(ncid,vid,'units','m')
      stat=nf90mpi_put_att(ncid,vid,'longname','expected maximum crest height' )
      stat=nf90mpi_put_att(ncid,vid,'missing_value',NF90_FILL_int2)
      stat=nf90mpi_def_var_fill(ncid,vid,0,NF90_FILL_int2)
  
      stat=nf90mpi_def_var(ncid,'cmaxstd',nf90_int2,dimids, vid )
      stat=nf90mpi_put_att(ncid,vid,'scale_factor' ,0.01)
      stat=nf90mpi_put_att(ncid,vid,'units','m/s')
      stat=nf90mpi_put_att(ncid,vid,'longname','STD of expected maximum crest height' )
      stat=nf90mpi_put_att(ncid,vid,'missing_value',NF90_FILL_int2)
      stat=nf90mpi_def_var_fill(ncid,vid,0,NF90_FILL_int2)
  
      stat=nf90mpi_def_var(ncid,'hmax',nf90_int2,dimids, vid )
      stat=nf90mpi_put_att(ncid,vid,'scale_factor' ,0.01)
      stat=nf90mpi_put_att(ncid,vid,'units','m')
      stat=nf90mpi_put_att(ncid,vid,'longname','expected maximum crest-to-trough height' )
      stat=nf90mpi_put_att(ncid,vid,'missing_value',NF90_FILL_int2)
      stat=nf90mpi_def_var_fill(ncid,vid,0,NF90_FILL_int2)
  
      stat=nf90mpi_def_var(ncid,'hmaxstd',nf90_int2,dimids, vid )
      stat=nf90mpi_put_att(ncid,vid,'scale_factor' ,0.01)
      stat=nf90mpi_put_att(ncid,vid,'units','m')
      stat=nf90mpi_put_att(ncid,vid,'longname','STD of expected maximum crest-to-trough height' )
      stat=nf90mpi_put_att(ncid,vid,'missing_value',NF90_FILL_int2)
      stat=nf90mpi_def_var_fill(ncid,vid,0,NF90_FILL_int2)
  
      stat=nf90mpi_enddef(ncid)
      stat=nf90mpi_begin_indep_data(ncid)
      if(pid==root)then
        stat=nf90mpi_put_var(ncid,vidlon,lon)
        stat=nf90mpi_put_var(ncid,vidlat,lat)
      endif
      stat=nf90mpi_end_indep_data(ncid)
      stat=nf90mpi_close(ncid)
#else
      character(len=*),intent(in) :: filename
      integer :: ncid
      integer*2 :: vland
      vland=ivland
      if(pid/=root)return
      call open_nc(ncid,filename,'c')
      call dimension_define(ncid,'lon',im,'lon',nf_real)
      call dimension_define(ncid,'lat',jm,'lat',nf_real)
      call dimension_define(ncid,'time',0,'time',nf_double)
      call set_attribute(ncid,'units','degrees_north','lat')
      call set_attribute(ncid,'units','degrees_east','lon')
      call set_attribute(ncid,'modulo','','lon')
      call set_attribute(ncid,'units',trim(timeunits),'time')
      call set_attribute(ncid,'Start_time',ctime)
  
      call variable_define(ncid,'cmax',nf_int2,['lon ','lat ','time'])
      call set_attribute(ncid,'missing_value',vland,'cmax')
      call set_attribute(ncid,'units','m','cmax')
      call set_attribute(ncid,'longname','expected maximum crest height','cmax')
      call set_attribute(ncid,'scale_factor',0.01,'cmax')

      call variable_define(ncid,'cmaxstd',nf_int2,['lon ','lat ','time'])
      call set_attribute(ncid,'missing_value',vland,'cmaxstd')
      call set_attribute(ncid,'units','m','cmaxstd')
      call set_attribute(ncid,'longname','STD of expected maximum crest height','cmaxstd')
      call set_attribute(ncid,'scale_factor',0.01,'cmaxstd')

      call variable_define(ncid,'hmax',nf_int2,['lon ','lat ','time'])
      call set_attribute(ncid,'missing_value',vland,'hmax')
      call set_attribute(ncid,'units','m','hmax')
      call set_attribute(ncid,'longname','STD of expected maximum crest-to-trough height','hmax')
      call set_attribute(ncid,'scale_factor',0.01,'hmax')

      call variable_define(ncid,'hmaxstd',nf_int2,['lon ','lat ','time'])
      call set_attribute(ncid,'missing_value',vland,'hmaxstd')
      call set_attribute(ncid,'units','m','hmaxstd')
      call set_attribute(ncid,'longname','STD of expected maximum crest-to-trough height','hmaxstd')
      call set_attribute(ncid,'scale_factor',0.01,'hmaxstd')

#ifdef OUTWAVEPARS_EXW
      call variable_define(ncid,'windx',nf_int2,['lon ','lat ','time'])        
      call set_attribute(ncid,'missing_value',vland,'windx')                  
      call set_attribute(ncid,'units','m/s','windx')                           
      call set_attribute(ncid,'longname','Zonal Wind Velocity '     ,'windx')  
      call set_attribute(ncid,'scale_factor',0.01,'windx')

      call variable_define(ncid,'windy',nf_int2,['lon ','lat ','time'])        
      call set_attribute(ncid,'missing_value',vland,'windy')                  
      call set_attribute(ncid,'units','m/s','windy')                           
      call set_attribute(ncid,'longname','Meridional Wind Velocity ','windy')  
      call set_attribute(ncid,'scale_factor',0.01,'windy')

      call variable_define(ncid,'hs',nf_int2,['lon ','lat ','time'])           
      call set_attribute(ncid,'missing_value',vland,'hs')                     
      call set_attribute(ncid,'units','m'  ,'hs')                              
      call set_attribute(ncid,'longname','Significant wave height'  ,'hs')     
      call set_attribute(ncid,'scale_factor',0.01,'hs')

      call variable_define(ncid,'tp',nf_int2,['lon ','lat ','time'])           
      call set_attribute(ncid,'missing_value',vland,'tp')                     
      call set_attribute(ncid,'units','s'  ,'tp')                              
      call set_attribute(ncid,'longname','Spectrum peak wave period','tp')     
      call set_attribute(ncid,'scale_factor',0.01,'tp')

      call variable_define(ncid,'tz',nf_int2,['lon ','lat ','time'])           
      call set_attribute(ncid,'missing_value',vland,'tz')                     
      call set_attribute(ncid,'units','s'  ,'tz')                              
      call set_attribute(ncid,'longname','Zero-crossing wave period','tz')     
      call set_attribute(ncid,'scale_factor',0.01,'tz')

      call variable_define(ncid,'th',nf_int2,['lon ','lat ','time'])           
      call set_attribute(ncid,'missing_value',vland,'th')                     
      call set_attribute(ncid,'units','deg','th')                              
      call set_attribute(ncid,'longname','Mean wave direction'      ,'th')     
      call set_attribute(ncid,'scale_factor',0.1,'th')
#endif
  
#ifdef TESTTEST 
      call variable_define(ncid,'exw_tm ',nf_real,['lon ','lat ','time'])
      call variable_define(ncid,'exw_lx ',nf_real,['lon ','lat ','time'])
      call variable_define(ncid,'exw_ly ',nf_real,['lon ','lat ','time'])
      call variable_define(ncid,'exw_axy',nf_real,['lon ','lat ','time'])
      call variable_define(ncid,'exw_axt',nf_real,['lon ','lat ','time'])
      call variable_define(ncid,'exw_ayt',nf_real,['lon ','lat ','time'])
      call variable_define(ncid,'exw_ni ',nf_real,['lon ','lat ','time'])
      call variable_define(ncid,'exw_mu ',nf_real,['lon ','lat ','time'])
  
      call set_attribute(ncid,'missing_value',vland,'exw_tm ')
      call set_attribute(ncid,'missing_value',vland,'exw_lx ')
      call set_attribute(ncid,'missing_value',vland,'exw_ly ')
      call set_attribute(ncid,'missing_value',vland,'exw_axy')
      call set_attribute(ncid,'missing_value',vland,'exw_axt')
      call set_attribute(ncid,'missing_value',vland,'exw_ayt')
      call set_attribute(ncid,'missing_value',vland,'exw_ni ')
      call set_attribute(ncid,'missing_value',vland,'exw_mu ')
#endif
  
      call end_define(ncid)
      if(pid==root)then
        call writenc(ncid,'lon',lon)
        call writenc(ncid,'lat',lat)
      endif
      call close_nc(ncid)
#endif
    end subroutine create_exwout
    !---------------------------------------------------------------------------
    subroutine cal_extreme(ee,wf,cmaxev,cmaxsd,hmaxev,hmaxsd,idx)
      real(spdp),intent(in) :: ee(:,:),wf(:)
      real(spdp),intent(out) :: cmaxev,cmaxsd,hmaxev,hmaxsd
      integer,intent(in),optional :: idx
  
      integer :: j,k,k1,t
      real(spdp) :: tm,lx,ly,axy,ayt,axt,ni,mu
      real(spdp) :: ae,ae002,ae200,ae020,ae001,ae101,ae011,ae110
      real(spdp) :: dwkk,wkk,wkk1,wsk,wsk1,sinth,costh,eekj,eekj1,h1_3  
      real(spdp) :: phist,axyt,n3,n2,n1,cmode,tlg,eek,eek1
      real(spdp),allocatable :: eeka(:)
      integer,parameter :: tmax=21
      real(spdp) :: acf(tmax)

      real(spdp) :: x,y,d
      
      namelist/testnml/phist,cmaxev,cmaxsd,hmaxev,hmaxsd,eeka,acf
  
      allocate(eeka(kl))
  
      x=exw_x;y=exw_y;d=exw_d
  
      ! initialize spectral moments and parameters
      ae =0.
      ae002 =0.
      ae020 =0.
      ae200 =0.
      ae001 =0.
      ae011 =0.
      ae110 =0.
      ae101 =0.
      h1_3 =0.
      tm =0.
      lx =0.
      ly =0.
      axt =0.
      ayt =0.
      axy =0.
      !if(nsp(idx)==0)return
      ! compute spectral moments
      do k=1,kl-1
        k1=k+1
        dwkk=dwk(k)
        wkk=wk(k)
        wkk1=wk(k1)
        wsk=zpi*wf(k)
        wsk1=zpi*wf(k1)
        do j=1,jl
          sinth=sin(thet(j))
          costh=cos(thet(j))
          ! m000
          eekj =ee(k,j )
          eekj1=ee(k1,j )
          ae =ae +(eekj+eekj1)*dwkk
          ! m002
          eekj =ee(k,j )*wsk**2
          eekj1=ee(k1,j )*wsk1**2
          ae002 =ae002 +(eekj+eekj1)*dwkk
          ! m200
          eekj =ee(k,j )*wkk**2*costh**2
          eekj1=ee(k1,j )*wkk1**2*costh**2
          ae200 =ae200 +(eekj+eekj1)*dwkk
          ! m020
          eekj =ee(k,j )*wkk**2*sinth**2
          eekj1=ee(k1,j )*wkk1**2*sinth**2
          ae020 =ae020 +(eekj+eekj1)*dwkk
          ! m001
          eekj =ee(k,j )*wsk
          eekj1=ee(k1,j )*wsk1
          ae001 =ae001 +(eekj+eekj1)*dwkk
          ! m101
          eekj =ee(k,j )*wsk*wkk*costh
          eekj1=ee(k1,j )*wsk1*wkk1*costh
          ae101 =ae101 +(eekj+eekj1)*dwkk
          ! m110
          eekj =ee(k,j )*wkk**2*sinth*costh
          eekj1=ee(k1,j )*wkk1**2*sinth*costh
          ae110 =ae110 +(eekj+eekj1)*dwkk
          ! m011
          eekj =ee(k,j )*wsk*wkk*sinth
          eekj1=ee(k1,j )*wsk1*wkk1*sinth
          ae011 =ae011 +(eekj+eekj1)*dwkk
        enddo
      enddo
      !^^^^^^^^^^^^^^^^^^^^^^^
      ! compute spectral parameters
      h1_3 =4.*sqrt(ae )
      tm  = zpi   *sqrt(ae /ae002 )
      lx  = zpi   *sqrt(ae /ae200 )
      ly  = zpi   *sqrt(ae /ae020 )
      axy = ae110 /sqrt(ae200 *ae020 )
      axt = ae101 /sqrt(ae200 *ae002 )
      ayt = ae011 /sqrt(ae020 *ae002 )
      ni  = sqrt(ae *ae002 /ae001 **2 - 1)
      mu  = ae001 **2/9.81*ae **(-1.5)*(1-ni +ni **2)
      ! compute autocovariance function
  
      eeka = sum(ee(:,:), dim=2)
      tlg = 0.3*tm
      acf=0
      do t = 1,tmax !21
        do k = 1,kl-1
          k1=k+1
           dwkk=dwk(k)
           wsk=zpi*wf(k)
           wsk1=zpi*wf(k1)
           eek =cos(wsk*tlg)*eeka(k)
           eek1=cos(wsk1*tlg)*eeka(k1)
           acf(t) = acf(t) + (eek+eek1)*dwkk
        enddo
        tlg = tlg + tm/float(tmax-1) !20.
      enddo
      phist = abs(minval(acf))/ae
      ! average numbers of waves
      ! if X=Y=0, N3=N2=0 and N1=D/tm, time extremes
      axyt = axt**2+ayt**2+axy**2-2*axt*ayt*axy
      N3 = zpi*X*Y*D/tm/lx/ly*sqrt(1-axyt)
      N2 = sqrt(zpi)*(X*Y/lx/ly*sqrt(1-axy**2)                        &
                    + Y*D/tm/ly*sqrt(1-ayt**2)                        &
                    + X*D/tm/lx*sqrt(1-axt**2))
      N1 = X/lx + Y/ly + D/tm
  
      ! Mode of the crest height extreme distribution
      ! (only space-time extremes or time extremes allowed, no space extremes)
      if ((x .eq. 0) .and. (y .eq. 0)) then
        cmode = sqrt(2*log(n1))
      else
        cmode = sqrt(2*log(n3)+2*log(2*log(n3)+2*log(2*log(n3))))
      endif
      ! Maximum crest height (expected value and standard deviation)
      cmaxev  = (cmode+0.5*mu*cmode**2+0.5772*(1+mu*cmode) /                   &
                (cmode-(2*N3*cmode+N2)/(N3*cmode**2+N2*cmode+N1)))*sqrt(ae )
      cmaxsd  = (pi*(1+mu*cmode)/sqrt(6.)/(cmode-(2*N3*cmode+N2)/              &
                (N3*cmode**2+N2*cmode+N1)))*sqrt(ae )
      ! Maximum crest-to-trough height (expected value and standard deviation)
      hmaxev  = (cmode+0.5772*(cmode-(2*N3*cmode+N2)/(N3*cmode**2+N2*cmode+N1))**(-1.))   &
                *sqrt(2*(1+phist))*sqrt(ae )
      hmaxsd  = pi/sqrt(6.)*(cmode-(2*N3*cmode+N2)/(N3*cmode**2+N2*cmode+N1))**(-1.)      &
                *sqrt(2*(1+phist))*sqrt(ae )
  
#ifdef TESTTEST 
      !--------------TESTTEST ---------------------
      cmaxev=cmaxev/h1_3
      cmaxsd=cmaxsd/h1_3
      hmaxev=hmaxev/h1_3
      hmaxsd=hmaxsd/h1_3
      if(plist(idx)%i==60 .and. plist(idx)%j==25)then
        write(*,*)'check:h1_3,tm,lx,ly,axy,axt,ayt,ni,mu'
        write(*,*)'check',h1_3,tm,lx,ly,axy,axt,ayt,ni,mu
        write(*,nml=testnml)
      endif
      return
      !--------------TESTTEST ---------------------
#endif      
      deallocate(eeka)
    end subroutine cal_extreme
    !---------------------------------------------------------------------------
    subroutine extreme_wave_init
      integer :: root=0,lsize,ierr
      type(mpipacket) :: pk
      namelist/exwnml/exw_flag,exw_x,exw_y,exw_d,exw_freq
      exw_flag=0
      if(pid==root)then
        open(11,file='ctlparams',delim='quote')
        read(11,nml=exwnml,iostat=ierr)
        close(11)
        if(ierr/=0)exw_flag=0
        call packbcastdata(0,pk,lsize)
      endif
      call packbcastdata(1,pk,lsize)
      if(exw_flag/=0)then
        exw_nstp=exw_freq*60./delttm
        exw_icnt=exw_nstp
        allocate(exw_cmax(0:np)   );exw_cmax   =0.d0
        allocate(exw_cmaxstd(0:np));exw_cmaxstd=0.d0
        allocate(exw_hmax(0:np)   );exw_hmax   =0.d0
        allocate(exw_hmaxstd(0:np));exw_hmaxstd=0.d0
        
        allocate(exw_tm(0:np) );exw_tm =0.0
        allocate(exw_lx(0:np) );exw_lx =0.0
        allocate(exw_ly(0:np) );exw_ly =0.0
        allocate(exw_axy(0:np));exw_axy=0.0
        allocate(exw_axt(0:np));exw_axt=0.0
        allocate(exw_ayt(0:np));exw_ayt=0.0
        allocate(exw_ni(0:np) );exw_ni =0.0
        allocate(exw_mu(0:np) );exw_mu =0.0
      endif
      exw_init=1
    end subroutine extreme_wave_init
    !-----------------------------------------------------------------------------------------------
    subroutine packbcastdata(act,pk,lsize)
      integer,intent(in) :: act
      type(mpipacket),intent(inout) :: pk
      integer,intent(inout) :: lsize
      if(act==0)then
        lsize=200
        call InitMpiPacket(pk,lsize)
      else
        call bcast_packet(pk,root,pid,mpi_comm)
      endif
      call irrp_pget_mpipacket(pk,exw_flag,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,exw_x,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,exw_y,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,exw_d,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,exw_freq,1,mpi_comm,act)
      !----------------------------------------------------------------
      if(act>0)then
        call FinalMpiPacket(pk)
      endif
    end subroutine packbcastdata
    !-----------------------------------------------------------------------------------------------
  end subroutine extreme_wave_out
#endif
  !-----------------------------------------------------------------------------------------------
  subroutine pntio_itp_init
    integer :: i,lsize,recti(4),ii,jj,k,root
    integer,allocatable :: ij2s(:,:)
    type(mpipacket) :: pk
    logical :: ext
    root=0
    if(pid == root)then
      inquire(file='pntinf',exist=ext)
      if(ext)then
        open(11,file='pntinf')
        read(11,'(a)')pinf%cflag
        read(11,*)pinf%dt
        read(11,*)pinf%np
        read(11,*)
        write(*,*)'pntinf:',pinf%cflag,pinf%dt,pinf%np
        allocate(pinf%x(pinf%np),pinf%y(pinf%np),pinf%i(pinf%np),pinf%j(pinf%np))
        allocate(pinf%i4(4,pinf%np),pinf%j4(4,pinf%np),pinf%w4(4,pinf%np))
        do i=1,pinf%np
          read(11,*)pinf%x(i),pinf%y(i),pinf%i(i),pinf%j(i), &
                    pinf%i4(1:4,i),pinf%j4(1:4,i),pinf%w4(1:4,i)
          write(*,*)'w0:',pinf%w4(1:4,i)
        enddo
        close(11)
      else
        pinf%np=0
      endif
      call packbcastdata(0)
    endif
    call packbcastdata(1)
    if(pinf%np==0)return
    pinf%cntstep=pinf%dt*60./delttm
    pinf%istep=pinf%cntstep
    call irrp_getrects(recto=recti)
    !allocate(ij2s(recti(1):recti(3),recti(2):recti(4)));ij2s=0
    allocate(ij2s(im,jm));ij2s=0
    do i=1,np
      !ii=pnb(i)%i
      !if(ii<recti(1))ii=recti(3)
      !if(ii>recti(3))ii=recti(1)
      !ij2s(ii,pnb(i)%j)=i
      ij2s(pnb(i)%i,pnb(i)%j)=i
    enddo
    allocate(pinf%iolist(7,pinf%np))
    pinf%iolist=0;pinf%nio=0
    do i=1,pinf%np
      if(pid==10)write(*,*)'w4:',pinf%w4(1:4,i)
      do k=1,4
        ii=pinf%i4(k,i);jj=pinf%j4(k,i)
        if(ii/=0)exit
      enddo
      if(ii<recti(1) .or. ii>recti(3) .or. jj<recti(2) .or. jj>recti(4))cycle
      if(ij2s(ii,jj)>0 .and. ij2s(ii,jj)<=npc)then
        pinf%nio=pinf%nio+1
        pinf%iolist(1:3,pinf%nio)=[i,pinf%i(i),pinf%j(i)]
        do k=1,4
          ii=pinf%i4(k,i);jj=pinf%j4(k,i)
          if(ii/=0)then
            pinf%iolist(k+3,pinf%nio)=ij2s(ii,jj)
          endif
        enddo
      endif
    enddo
    deallocate(ij2s)
    !------------------------------------------------------------------------------
    contains
    subroutine packbcastdata(act)
      integer,intent(in) :: act
      if(act==0)then
        lsize=(pinf%np*16*10+200)
        call InitMpiPacket(pk,lsize)
      else
        call bcast_packet(pk,root,pid,mpi_comm)
      endif
      call irrp_pget_mpipacket(pk,pinf%cflag,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,pinf%dt,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,pinf%np,1,mpi_comm,act)
      if(pinf%np/=0)then
        if(.not.associated(pinf%j))then
          allocate(pinf%x(pinf%np),pinf%y(pinf%np),pinf%i(pinf%np),pinf%j(pinf%np))
          allocate(pinf%i4(4,pinf%np),pinf%j4(4,pinf%np),pinf%w4(4,pinf%np))
          !allocate(pinf%iolist(7,pinf%np))
        endif
        call irrp_pget_mpipacket(pk,pinf%x,pinf%np,mpi_comm,act)
        call irrp_pget_mpipacket(pk,pinf%y,pinf%np,mpi_comm,act)
        call irrp_pget_mpipacket(pk,pinf%i,pinf%np,mpi_comm,act)
        call irrp_pget_mpipacket(pk,pinf%j,pinf%np,mpi_comm,act)
        call irrp_pget_mpipacket(pk,pinf%i4,pinf%np*4,mpi_comm,act)
        call irrp_pget_mpipacket(pk,pinf%j4,pinf%np*4,mpi_comm,act)
        call irrp_pget_mpipacket(pk,pinf%w4,pinf%np*4,mpi_comm,act)
      endif
      if(act>0)then
        call FinalMpiPacket(pk)
      endif
    end subroutine packbcastdata
  end subroutine pntio_itp_init
  !-----------------------------------------------------------------------------------------------
  subroutine pntio_itp_output
    integer :: i,IAIC_IDX,itime_tmp(6),recd
    character(len=100) :: str,filename
    real(spdp),allocatable :: tmpee(:,:)
    real(8) :: w4(4)
    character(len=14) :: ctime
    !if(pinf%np==0)return
    if(pinf%nio==0)return
    pinf%istep=pinf%istep+1
    if(pinf%istep<pinf%cntstep)return
    allocate(tmpee(kl,jl))
    itime_tmp=itime;itime_tmp(4:6)=0;itime_tmp(2:3)=1;
    ctime=datestr(itime_tmp)
    recd=nint(24.*(dtime-datenum(itime_tmp))/pinf%dt)+1
    !recd=nint(24.*(dtime-datenum(itime_tmp))/pinf%dt)
    do i=1,pinf%nio
      write(str,"('_',i5.5,'_',i5.5,'.nc')")pinf%iolist(2:3,i)
      !filename=trim(pinf%cflag)//trim(str)
      filename='res/Buoy_'//ctime(1:4)//trim(str)
      w4=pinf%w4(:,pinf%iolist(1,i))
      !write(*,"('ww:',4f10.5)")w4
      tmpee=ee(:,:,pinf%iolist(4,i))*w4(1)+ee(:,:,pinf%iolist(5,i))*w4(2) &
           +ee(:,:,pinf%iolist(6,i))*w4(3)+ee(:,:,pinf%iolist(7,i))*w4(4)
      !write(*,"('ee:',6i10)")pinf%iolist(4:7,i),np,npc
      !write(*,"('aa',2i5,2f15.5)")pinf%iolist(1,i),pid,minval(tmpee),maxval(tmpee)
      !write(*,"('bb',2i5,2f15.5)")pinf%iolist(1,i),pid,minval(ee(:,:,1:npc)),maxval(ee(:,:,1:npc))
      call output_pntnc(filename,tmpee,recd)
    enddo
    pinf%istep=0
    deallocate(tmpee)
  end subroutine pntio_itp_output
  !-----------------------------------------------------------------------------------------------
  subroutine pntio_init
    integer :: i,lsize,recti(4)
    integer,allocatable :: nn(:,:)
    real(4) :: x,y
    type(mpipacket) :: pk
    logical :: ext
    if(pid == root)then
      inquire(file='pntinf',exist=ext)
      if(ext)then
        open(11,file='pntinf')
        read(11,'(a)')pinf%cflag
        read(11,*)pinf%dt
        read(11,*)pinf%np
        read(11,*)
        write(*,*)'pntinf:',pinf%cflag,pinf%dt,pinf%np
        allocate(pinf%i(pinf%np),pinf%j(pinf%np))
        do i=1,pinf%np
          read(11,*)x,y,pinf%i(i),pinf%j(i)
        enddo
        close(11)
      else
        pinf%np=0
      endif
      call packbcastdata(0)
    endif
    call packbcastdata(1)
    if(pinf%np==0)return
    pinf%istep=0
    pinf%cntstep=pinf%dt*60./delttm
    call irrp_getrects(recti)
    allocate(nn(recti(1):recti(3),recti(2):recti(4)));nn=0
    do i=1,npc
      nn(pnb(i)%i,pnb(i)%j)=1
    enddo
    allocate(pinf%iolist(pinf%np,3))
    pinf%nio=0
    do i=1,pinf%np
      if(pinf%i(i)<recti(1) .or. pinf%i(i)>recti(3))cycle
      if(pinf%j(i)<recti(2) .or. pinf%j(i)>recti(4))cycle
      if(nn(pinf%i(i),pinf%j(i))==1)then
        pinf%nio=pinf%nio+1
        pinf%iolist(pinf%nio,1:3)=[i,pinf%i(i),pinf%j(i)]
      endif
    enddo
    !------------------------------------------------------------------------------
    contains
    !------------------------------------------------------------------------------
    subroutine packbcastdata(act)
      integer,intent(in) :: act
      if(act==0)then
        lsize=(pinf%np*2*8+200)
        call InitMpiPacket(pk,lsize)
      else
        call bcast_packet(pk,root,pid,mpi_comm)
      endif
      call irrp_pget_mpipacket(pk,pinf%cflag,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,pinf%dt,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,pinf%np,1,mpi_comm,act)
      if(pinf%np/=0)then
        if(.not.associated(pinf%j))allocate(pinf%i(pinf%np),pinf%j(pinf%np))
        call irrp_pget_mpipacket(pk,pinf%i,pinf%np,mpi_comm,act)
        call irrp_pget_mpipacket(pk,pinf%j,pinf%np,mpi_comm,act)
      endif
      if(act>0)then
        call FinalMpiPacket(pk)
      endif
    end subroutine packbcastdata
  end subroutine pntio_init
  !-----------------------------------------------------------------------------------------------
  subroutine pntio_output
    integer :: i,IAIC_IDX,itime_tmp(6),recd
    character(len=100) :: str,filename
    if(pinf%np==0)return
    pinf%istep=pinf%istep+1
    if(pinf%istep/=pinf%cntstep)return
    itime_tmp=itime;itime_tmp(4:6)=0;itime_tmp(2:3)=1;
    !recd=nint(24.*(dtime-datenum(itime_tmp))/pinf%dt)+1
    recd=nint(24.*(dtime-datenum(itime_tmp))/pinf%dt)
    do i=1,pinf%nio
      write(str,"('_',i5.5,'_',i5.5,'.nc')")pinf%iolist(i,2:3)
      !filename=trim(pinf%cflag)//trim(str)
      filename='res/Buoy'//trim(str)
      IAIC_IDX=pinf%iolist(i,1)
      !write(*,*)trim(filename)
      !write(*,*)IAIC_IDX,recd,trim(pinf%cflag)
      call output_pntnc(filename,ee(:,:,IAIC_IDX),recd)
    enddo
    pinf%istep=0
  end subroutine pntio_output
  !-----------------------------------------------------------------------------------------------
  subroutine output_pntnc(filename,ee,recd)
    character(len=*),intent(in) :: filename
    real(spdp),intent(in) :: ee(:,:)
    integer,intent(in) :: recd
    integer :: ncid
    logical :: ext
    inquire(file=filename,exist=ext)
    if(recd==1 .or.(.not.ext))then
    !if(.not. ext)then
      call open_nc(ncid,filename,'c')
      call dimension_define(ncid,'wkwk',kl,'wkwk',nf_real)
      call dimension_define(ncid,'thet',jl,'thet',nf_real)
      call dimension_define(ncid,'time',0,'time',nf_double)
      !call variable_define(ncid,'ee',nf_real,['wkwk','thet','time'])
      call variable_define(ncid,'ee',nf_double,['wkwk','thet','time'])
      call set_attribute(ncid,'longname','Wave number','wkwk')
      call set_attribute(ncid,'longname','Wave direction (rad)','thet')
      call set_attribute(ncid,'longname','Wave spectrum','ee')
      call set_attribute(ncid,'units',trim(timeunits),'time')
      call end_define(ncid)
      call writenc(ncid,'wkwk',wk(1:kl))
      call writenc(ncid,'thet',thet(1:jl))
      call close_nc(ncid)
    endif
    call open_nc(ncid,filename,'w')
    call writenc(ncid,'time',dtime,recd)
    call writenc(ncid,'ee',ee,recd)
    call close_nc(ncid)
  end subroutine output_pntnc
  !-----------------------------------------------------------------------------------------------
  subroutine inprst(filename,key)
    integer,intent(out) :: key
    character(len=*),intent(in) :: filename
    integer :: ncid,j,k,ierr
    logical :: ext
    real(4),allocatable :: gvar(:,:,:,:)
    real(spdp),allocatable :: gvar1(:,:),lvar1(:)
    integer(2) :: itimetmp(6)
!!!#ifdef USEPNETCDFPNC
!!!    call init_iopnc
!!!#endif
    inquire(file=filename,exist=ext)
    !key=1;if(.not. ext)then;key=0;return;endif
    if(ext)then
      key=1
    else
      key=0; return
    endif
#ifdef USEPNETCDFPNC
    call init_iopnc
    !ee(kl,jl,0:np) --> ee(lon,lat,kl,jl)
    call readpnc(mpi_comm,filename,'ee',ee,0,kl,jl)
    ! itimetmp
#else
    root=0
    if(pid==root)then
      call open_nc(ncid,filename,'r')
!yinxq:20221228      call get_attribute(ncid,'ctime',ctime)
    endif
    allocate(gvar(kl,jl,im,jm),gvar1(im,jm),lvar1(0:np))
    if(pid==root)then
      call readnc(ncid,'ee',gvar)
    endif
    do j=1,jl
      do k=1,kl
        if(pid==root)then
          !call readnc(ncid,'ee',gvar,locs=[k,j,1,1])
          gvar1(:,:)=gvar(k,j,:,:)
        endif
        !call irrp_scatter_ext(gvar1,ee,kl,k,jl,j,root)
        call irrp_scatter_ext(gvar1,lvar1,root);ee(k,j,:)=lvar1
      enddo
    enddo
    if(pid==root)then
      call close_nc(ncid)
      !write(6,*)'Restart time is :',ctime
      !read(ctime,'(i4.4,5i2.2)')istime
      itimetmp=istime
    endif
!    call MPI_BCAST(itimetmp,6,MPI_INTEGER2,root,mpi_comm,ierr)
!    istime=itimetmp
    deallocate(gvar,gvar1,lvar1)
#endif    
  end subroutine inprst
  !-----------------------------------------------------------------------------------------------
  subroutine getrst(filename,ee,np,kl,jl)
    character(len=*),intent(in) :: filename
    integer,intent(in) :: np,kl,jl
    real(4),intent(out) :: ee(kl,jl,0:np)

    integer :: ncid,j,k,ierr
    logical :: ext
    real(4),allocatable :: gvar(:,:,:,:)
    real(spdp),allocatable :: gvar1(:,:),lvar1(:)
    integer(2) :: itimetmp(6)

#ifdef USEPNETCDFPNC
    call init_iopnc
    !ee(kl,jl,0:np) --> ee(lon,lat,kl,jl)
    call readpnc(mpi_comm,filename,'ee',ee,0,kl,jl)
    ! itimetmp
#else
    root=0
    if(pid==root)then
      call open_nc(ncid,filename,'r')
!yinxq:20221228      call get_attribute(ncid,'ctime',ctime)
    endif
    allocate(gvar(kl,jl,im,jm),gvar1(im,jm),lvar1(0:np))
    if(pid==root)then
      call readnc(ncid,'ee',gvar)
    endif
    do j=1,jl
      do k=1,kl
        if(pid==root)then
          !call readnc(ncid,'ee',gvar,locs=[k,j,1,1])
          gvar1(:,:)=gvar(k,j,:,:)
        endif
        !call irrp_scatter_ext(gvar1,ee,kl,k,jl,j,root)
        call irrp_scatter_ext(gvar1,lvar1,root);ee(k,j,:)=lvar1
      enddo
    enddo
    if(pid==root)then
      call close_nc(ncid)
      !write(6,*)'Restart time is :',ctime
      !read(ctime,'(i4.4,5i2.2)')istime
      itimetmp=istime
    endif
!    call MPI_BCAST(itimetmp,6,MPI_INTEGER2,root,mpi_comm,ierr)
!    istime=itimetmp
    deallocate(gvar,gvar1,lvar1)
#endif    
  end subroutine getrst

  subroutine getwav(filename,hs,th,tp,tz,np,irec)
    character(len=*),intent(in) :: filename
    integer,intent(in) :: np,irec
    real(4),intent(out) :: hs(0:np)
    real(4),intent(out) :: th(0:np)
    real(4),intent(out) :: tp(0:np)
    real(4),intent(out) :: tz(0:np)

    integer :: ncid,j,k,ierr
    logical :: ext
    real(spdp),allocatable :: gvar1(:,:),lvar1(:)
    integer(2) :: itimetmp(6)
    real(4) :: iv2(0:np)

#ifdef USEPNETCDFPNC
    call init_iopnc
    call readpnc(mpi_comm,filename,'hs',iv2,0,recd=irec);hs=iv2*0.01
    call readpnc(mpi_comm,filename,'th',iv2,0,recd=irec);th=iv2*0.1
    call readpnc(mpi_comm,filename,'tp',iv2,0,recd=irec);tp=iv2*0.01
    call readpnc(mpi_comm,filename,'tz',iv2,0,recd=irec);tz=iv2*0.01
#else
    root=0
    if(pid==root)then
      call open_nc(ncid,filename,'r')
    endif
    allocate(gvar1(im,jm),lvar1(0:np))
    if(pid==root)call readnc(ncid,'hs',gvar1,irec)
    call irrp_scatter_ext(gvar1,lvar1,root);hs(:)=lvar1
    if(pid==root)call readnc(ncid,'th',gvar1,irec)
    call irrp_scatter_ext(gvar1,lvar1,root);th(:)=lvar1
    if(pid==root)call readnc(ncid,'tp',gvar1,irec)
    call irrp_scatter_ext(gvar1,lvar1,root);tp(:)=lvar1
    if(pid==root)call readnc(ncid,'tz',gvar1,irec)
    call irrp_scatter_ext(gvar1,lvar1,root);tz(:)=lvar1
    if(pid==root)then
      call close_nc(ncid)
    endif
    deallocate(gvar1,lvar1)
#endif    
  end subroutine getwav
#ifdef USEPNETCDFPNC
  subroutine outrst(filename)
    use pnetcdf
    character(len=*),intent(in) :: filename
    integer :: kk_dimid,jj_dimid,lon_dimid,lat_dimid
    integer :: dimids(4),stat,i,ncid,cmode,kk_varid,jj_varid,lon_varid,lat_varid,vid
    integer(KIND=8) :: g_im,g_jm,g_kl,g_jl

    call init_iopnc

    if(mpi_comm==MPI_COMM_NULL)return
    g_im=im;g_jm=jm;g_kl=kl;g_jl=jl
    stat=nf90mpi_create(mpi_comm,filename,                 &
                          IOR(NF_CLOBBER,NF_64BIT_OFFSET), &
                          MPI_INFO_NULL,ncid)
    !stat=nf90mpi_create(mpi_comm,filename,cmode,MPI_INFO_NULL,ncid)
    !stat=nf90mpi_def_dim(ncid,"lon",g_im,lon_dimid);dimids(1)=lon_dimid
    !stat=nf90mpi_def_dim(ncid,"lat",g_jm,lat_dimid);dimids(2)=lat_dimid
    !stat=nf90mpi_def_dim(ncid,"kk",g_kl,kk_dimid);dimids(3)=kk_dimid
    !stat=nf90mpi_def_dim(ncid,"jj",g_jl,jj_dimid);dimids(4)=jj_dimid
    stat=nf90mpi_def_dim(ncid,"lon",g_im,lon_dimid);dimids(3)=lon_dimid
    stat=nf90mpi_def_dim(ncid,"lat",g_jm,lat_dimid);dimids(4)=lat_dimid
    stat=nf90mpi_def_dim(ncid,"kk",g_kl,kk_dimid);  dimids(1)=kk_dimid
    stat=nf90mpi_def_dim(ncid,"jj",g_jl,jj_dimid);  dimids(2)=jj_dimid
    
    stat=nf90mpi_def_var(ncid,"kk",nf90_float,kk_dimid,kk_varid)
    stat=nf90mpi_def_var_fill(ncid,kk_varid,0,NF90_FILL_float)

    stat=nf90mpi_def_var(ncid,"jj",nf90_float,jj_dimid,jj_varid)
    stat=nf90mpi_def_var_fill(ncid,jj_varid,0,NF90_FILL_float)

    stat=nf90mpi_def_var(ncid,"lon",nf90_float,lon_dimid,lon_varid)
    stat=nf90mpi_put_att(ncid,lon_varid,'units','degrees_east')
    stat=nf90mpi_put_att(ncid,lon_varid,'modulo','')

    stat=nf90mpi_def_var(ncid,"lat",nf90_float,lat_dimid,lat_varid)
    stat=nf90mpi_put_att(ncid,lat_varid,'units','degrees_north')

    stat=nf90mpi_def_var(ncid,"ee",nf90_double,dimids,vid)
    !stat=nf90mpi_def_var_fill(ncid,vid,0,0.d0)
    stat=nf90mpi_def_var_fill(ncid,vid,0,nf90_fill_double)

    stat=nf90mpi_put_att(ncid,NF90_GLOBAL,'ctime',ctime)
    stat=nf90mpi_enddef(ncid)

    stat=nf90mpi_begin_indep_data(ncid)
    if(pid==root)then
      stat=nf90mpi_put_var(ncid,lon_varid,lon)
      stat=nf90mpi_put_var(ncid,lat_varid,lat)
      stat=nf90mpi_put_var(ncid,kk_varid,wk(1:kl))
      stat=nf90mpi_put_var(ncid,jj_varid,thet(1:jl))
    endif
    stat=nf90mpi_end_indep_data(ncid)
    stat=nf90mpi_close(ncid)

    !ee(kl,jl,0:np) --> ee(lon,lat,kl,jl)
    call writepnc(mpi_comm,filename,'ee',ee,0,kl,jl)
  end subroutine outrst
#else
  subroutine outrst(filename)
    character(len=*),intent(in) :: filename
    integer :: ncid
    real(4),allocatable :: gvar(:,:,:,:)
    real(spdp),allocatable :: gvar1(:,:),lvar1(:)
    !allocate(gvar(1,1,im,jm),gvar1(im,jm),lvar1(0:np))
    allocate(gvar(kl,jl,im,jm),gvar1(im,jm),lvar1(0:np))
    !gvar=0;
    gvar1=0  ! yinxq 20221113
    root=0
    if(pid==root)then
      call open_nc(ncid,filename,'c')
      call dimension_define(ncid,'kk',kl,'kk',nf_real)
      call dimension_define(ncid,'jj',jl,'jj',nf_real)
      call set_attribute(ncid,'longname','Wave number (rad/m)','kk')
      call set_attribute(ncid,'longname','Wave direction (rad)','jj')
      call dimension_define(ncid,'lon',im,'lon',nf_real)
      call dimension_define(ncid,'lat',jm,'lat',nf_real)
      call set_attribute(ncid,'units','degrees_north','lat')
      call set_attribute(ncid,'units','degrees_east','lon')
      call set_attribute(ncid,'modulo','','lon')
      call variable_define(ncid,'ee',nf_real,['kk ','jj ','lon','lat'])
      call set_attribute(ncid,'longname','Wave spectrum','ee')
      call set_attribute(ncid,'ctime',ctime)
      call end_define(ncid)
      call writenc(ncid,'kk',wk(1:kl))
      call writenc(ncid,'jj',thet(1:jl))
      call writenc(ncid,'lon',lon)
      call writenc(ncid,'lat',lat)
      call close_nc(ncid)
    endif
    do j=1,jl
      do k=1,kl
        lvar1=ee(k,j,:);call irrp_gather(lvar1,gvar1,root)
        !call irrp_gather(ee,gvar1,kl,k,jl,j,root)
        if(pid==root)then
          gvar(k,j,:,:)=gvar1(:,:)
          !call writenc(ncid,'ee',gvar,locs=[k,j,1,1])
        endif
      enddo
    enddo
    if(pid==root)then
      call open_nc(ncid,filename,'w')
      call writenc(ncid,'ee',gvar)
      call close_nc(ncid)
    endif
    deallocate(gvar,gvar1,lvar1)
  end subroutine outrst
#endif
  !-----------------------------------------------------------------------------------------------
  !-----------------------------------------------------------------------------------------------
  subroutine outwave(it)
    integer,intent(in) :: it
    character(len=100) :: filename
    integer :: recd
    if(mod(it-number,iwiofreq)/=0)return
    call set_filename(filename,recd)
    call outwave_onerecd(filename,recd)
    contains
    subroutine set_filename(filename,recd)
      character(len=*),intent(out) :: filename
      integer,intent(out) :: recd
      integer :: itime_tmp(6)
      character(len=14) :: ctime1
      itime_tmp=itime;itime_tmp(4:6)=0
#ifdef DOGFSForecast
      if(outflag==1)then     ! --- Output one file by yearly.
        filename=trim(outpath)//'wave.'//ctime(1:4)//'.nc'
        itime_tmp(2:3)=1;recd=nint(24.*(dtime-datenum(itime_tmp))/wiofreq)+1
      elseif(outflag==2)then ! --- Output one file by monthly.
        filename=trim(outpath)//'wave.'//ctime(1:6)//'.nc'
        itime_tmp(3)=1;recd=nint(24.*(dtime-datenum(itime_tmp))/wiofreq)+1
      elseif(outflag==3)then ! --- Output one file by daily.
        filename=trim(outpath)//'wave.'//ctime(1:8)//'.nc'
        recd=nint(24.*(dtime-datenum(itime_tmp))/wiofreq)+1
      else
        filename=trim(outpath)//'wave.nc'
        recd=nint(24.*(dtime-dtime0)/wiofreq)+1
      endif
#else
      if(outflag==1)then     ! --- Output one file by yearly.
        filename=trim(outpath)//trim(title)//'_wav_'//ctime(1:4)//'.nc'
        itime_tmp(2:3)=1;recd=nint(24.*(dtime-datenum(itime_tmp))/wiofreq)+1
      elseif(outflag==2)then ! --- Output one file by monthly.
        filename=trim(outpath)//trim(title)//'_wav_'//ctime(1:6)//'.nc'
        itime_tmp(3)=1;recd=nint(24.*(dtime-datenum(itime_tmp))/wiofreq)+1
      elseif(outflag==3)then ! --- Output one file by daily.
        filename=trim(outpath)//trim(title)//'_wav_'//ctime(1:8)//'.nc'
        recd=nint(24.*(dtime-datenum(itime_tmp))/wiofreq)+1
      elseif(outflag==4)then
        filename=trim(outpath)//trim(title)//'.wave.nc'
        recd=nint(24.*(dtime-dtime0)/wiofreq)+1
      else
        ctime1=datestr(dtime0)
        filename=trim(outpath)//trim(title)//'_wav_'//ctime1(1:8)//'.nc'
        recd=nint(24.*(dtime-dtime0)/wiofreq)+1
      endif
#endif
    end subroutine set_filename
  end subroutine outwave

  !-----------------------------------------------------------------------------------------------
  subroutine outwave_onerecd(filename,recd)
    character(len=*),intent(in) :: filename
    integer,intent(in) :: recd
    integer :: root=0,ncid,idx
#ifdef USEPNETCDFPNC
    call init_iopnc
#endif
    if(recd==1)call create_waveout(filename)
    if(pid==root)then
      call open_nc(ncid,filename,'w')
      call writenc(ncid,'time',dtime,recd)
      call close_nc(ncid)
    endif

!    do idx=0,np
!      h1_3(idx)=plist(idx)%i
!      tpf(idx)=plist(idx)%j
!    enddo
    call outnc_2d_reciv2(filename,'windx',0.01,recd,wx  ,ioflag_wx)
    call outnc_2d_reciv2(filename,'windy',0.01,recd,wy  ,ioflag_wy)
    call outnc_2d_reciv2(filename,'hs'   ,0.01,recd,h1_3,ioflag_hs)
    call outnc_2d_reciv2(filename,'tp'   ,0.01,recd,tpf ,ioflag_tp)
    call outnc_2d_reciv2(filename,'tz'   ,0.01,recd,ape ,ioflag_tz)
    call outnc_2d_reciv2(filename,'th'   ,0.1 ,recd,aet ,ioflag_th)

    !-----------------------------------------------------------------------------------------------
    contains
    !-----------------------------------------------------------------------------------------------
#ifdef USEPNETCDFPNC
    subroutine create_waveout(filename)
      use pnetcdf
      character(len=*),intent(in) :: filename
      integer :: ncid,stat,dimids(3),vid,vidlon,vidlat
      integer(KIND=8) :: g_im,g_jm,ulm
      g_im=im;g_jm=jm;ulm=NF90_UNLIMITED
      stat=nf90mpi_create(mpi_comm,filename,                 &
                            IOR(NF_CLOBBER,NF_64BIT_OFFSET), &
                            MPI_INFO_NULL,ncid)
  
    !stat=nf90mpi_create(mpi_comm,filename,cmode,MPI_INFO_NULL,ncid)
      stat=nf90mpi_def_dim(ncid,"lon",g_im,dimids(1))
      stat=nf90mpi_def_var(ncid,"lon",nf90_real,dimids(1),vidlon)
      stat=nf90mpi_put_att(ncid,vidlon,'units','degrees_east')
      stat=nf90mpi_put_att(ncid,vidlon,'modulo','')
  
      stat=nf90mpi_def_dim(ncid,"lat",g_jm,dimids(2))
      stat=nf90mpi_def_var(ncid,"lat",nf90_real,dimids(2),vidlat)
      stat=nf90mpi_put_att(ncid,vidlat,'units','degrees_north')
  
      stat=nf90mpi_def_dim(ncid,"time",ulm,dimids(3))
      stat=nf90mpi_def_var(ncid,"time",nf90_double,dimids(3),vid)
      stat=nf90mpi_put_att(ncid,vid,'units',trim(timeunits))
  
      if(ioflag_wx/=0)then
        stat=nf90mpi_def_var(ncid,'windx',nf90_int2,dimids,vid)
        stat=nf90mpi_put_att(ncid,vid,'scale_factor',0.01)
        stat=nf90mpi_put_att(ncid,vid,'units','m/s')
        stat=nf90mpi_put_att(ncid,vid,'longname','Zonal Wind Velocity ' )
        stat=nf90mpi_put_att(ncid,vid,'missing_value',NF90_FILL_int2)
        stat=nf90mpi_def_var_fill(ncid,vid,0,NF90_FILL_int2)
      endif
      if(ioflag_wy/=0)then
        stat=nf90mpi_def_var(ncid,'windy',nf90_int2,dimids,vid)
        stat=nf90mpi_put_att(ncid,vid,'scale_factor',0.01)
        stat=nf90mpi_put_att(ncid,vid,'units','m/s')
        stat=nf90mpi_put_att(ncid,vid,'longname','Meridional Wind Velocity ' )
        stat=nf90mpi_put_att(ncid,vid,'missing_value',NF90_FILL_int2)
        stat=nf90mpi_def_var_fill(ncid,vid,0,NF90_FILL_int2)
      endif
      if(ioflag_hs/=0)then
        stat=nf90mpi_def_var(ncid,'hs',nf90_int2,dimids,vid)
        stat=nf90mpi_put_att(ncid,vid,'scale_factor',0.01)
        stat=nf90mpi_put_att(ncid,vid,'units','m')
        stat=nf90mpi_put_att(ncid,vid,'longname','Significant wave height' )
        stat=nf90mpi_put_att(ncid,vid,'missing_value',NF90_FILL_int2)
        stat=nf90mpi_def_var_fill(ncid,vid,0,NF90_FILL_int2)
      endif
      if(ioflag_tp/=0)then
        stat=nf90mpi_def_var(ncid,'tp',nf90_int2,dimids, vid )
        stat=nf90mpi_put_att(ncid,vid,'scale_factor',0.01)
        stat=nf90mpi_put_att(ncid,vid,'units','s')
        stat=nf90mpi_put_att(ncid,vid,'longname','Spectrum peak wave period' )
        stat=nf90mpi_put_att(ncid,vid,'missing_value',NF90_FILL_int2)
        stat=nf90mpi_def_var_fill(ncid,vid,0,NF90_FILL_int2)
      endif
      if(ioflag_tz/=0)then
        stat=nf90mpi_def_var(ncid,'tz',nf90_int2,dimids, vid )
        stat=nf90mpi_put_att(ncid,vid,'scale_factor',0.01)
        stat=nf90mpi_put_att(ncid,vid,'units','s')
        stat=nf90mpi_put_att(ncid,vid,'longname','Zero-crossing wave period' )
        stat=nf90mpi_put_att(ncid,vid,'missing_value',NF90_FILL_int2)
        stat=nf90mpi_def_var_fill(ncid,vid,0,NF90_FILL_int2)
      endif
      if(ioflag_th/=0)then
        stat=nf90mpi_def_var(ncid,'th',nf90_int2,dimids, vid )
        stat=nf90mpi_put_att(ncid,vid,'scale_factor',0.1)
        stat=nf90mpi_put_att(ncid,vid,'units','deg')
        stat=nf90mpi_put_att(ncid,vid,'longname','Mean wave direction' )
        stat=nf90mpi_put_att(ncid,vid,'missing_value',NF90_FILL_int2)
        stat=nf90mpi_def_var_fill(ncid,vid,0,NF90_FILL_int2)
      endif
      stat=nf90mpi_enddef(ncid)
      stat=nf90mpi_begin_indep_data(ncid)
      if(pid==root)then
        stat=nf90mpi_put_var(ncid,vidlon,lon)
        stat=nf90mpi_put_var(ncid,vidlat,lat)
      endif
      stat=nf90mpi_end_indep_data(ncid)
      stat=nf90mpi_close(ncid)
    end subroutine create_waveout
#else
    subroutine create_waveout(filename)
      character(len=*),intent(in) :: filename
      integer :: ncid
      if(pid/=root)return
      call open_nc(ncid,filename,'c')
      call dimension_define(ncid,'lon',im,'lon',nf_real)
      call dimension_define(ncid,'lat',jm,'lat',nf_real)
      call dimension_define(ncid,'time',0,'time',nf_double)
      call set_attribute(ncid,'units','degrees_north','lat')
      call set_attribute(ncid,'units','degrees_east','lon')
      call set_attribute(ncid,'modulo','','lon')
      !call set_attribute(ncid,'units','Days since 1950-01-01 00:00:0.0.','time')
      call set_attribute(ncid,'units',trim(timeunits),'time')
      call set_attribute(ncid,'Start_time',ctime)
      if(ioflag_wx/=0)then
        call variable_define(ncid,'windx',nf_int2,['lon ','lat ','time'])
        call set_attribute(ncid,'missing_value',ivland,'windx')
        call set_attribute(ncid,'scale_factor',0.01,'windx')
        call set_attribute(ncid,'units','m/s','windx')
        call set_attribute(ncid,'longname','Zonal Wind Velocity '     ,'windx')
      endif
      if(ioflag_wy/=0)then
        call variable_define(ncid,'windy',nf_int2,['lon ','lat ','time'])
        call set_attribute(ncid,'missing_value',ivland,'windy')
        call set_attribute(ncid,'scale_factor',0.01,'windy')
        call set_attribute(ncid,'units','m/s','windy')
        call set_attribute(ncid,'longname','Meridional Wind Velocity ','windy')
      endif
      if(ioflag_hs/=0)then
        call variable_define(ncid,'hs',nf_int2,['lon ','lat ','time'])
        call set_attribute(ncid,'missing_value',ivland,'hs')
        call set_attribute(ncid,'scale_factor',0.01,'hs')
        call set_attribute(ncid,'units','m'  ,'hs')
        call set_attribute(ncid,'longname','Significant wave height'  ,'hs')
      endif
      if(ioflag_tp/=0)then
        call variable_define(ncid,'tp',nf_int2,['lon ','lat ','time'])
        call set_attribute(ncid,'missing_value',ivland,'tp')
        call set_attribute(ncid,'scale_factor',0.01,'tp')
        call set_attribute(ncid,'units','s'  ,'tp')
        call set_attribute(ncid,'longname','Spectrum peak wave period','tp')
      endif
      if(ioflag_tz/=0)then
        call variable_define(ncid,'tz',nf_int2,['lon ','lat ','time'])
        call set_attribute(ncid,'missing_value',ivland,'tz')
        call set_attribute(ncid,'scale_factor',0.01,'tz')
        call set_attribute(ncid,'units','s'  ,'tz')
        call set_attribute(ncid,'longname','Zero-crossing wave period','tz')
      endif
      if(ioflag_th/=0)then
        call variable_define(ncid,'th',nf_int2,['lon ','lat ','time'])
        call set_attribute(ncid,'missing_value',ivland,'th')
        call set_attribute(ncid,'scale_factor',0.1,'th')
        call set_attribute(ncid,'units','deg','th')
        call set_attribute(ncid,'longname','Mean wave direction'      ,'th')
      endif
      call end_define(ncid)
      if(pid==root)then
        call writenc(ncid,'lon',lon)
        call writenc(ncid,'lat',lat)
      endif
      call close_nc(ncid)
    end subroutine create_waveout
#endif
  end subroutine outwave_onerecd
  !-----------------------------------------------------------------------------------------------
  subroutine outnc_2d_reciv2(filename,vname,scal,recd,var,flag)
    character(len=*),intent(in) :: filename,vname
    real,intent(in) :: scal
    integer,intent(in) :: recd
    real(spdp),intent(in) :: var(0:np)
    integer,intent(in),optional :: flag
    integer :: ncid,i,j
    real(spdp) :: sc,of
    if(present(flag))then
      if(flag==0)return
    endif
#ifdef USEPNETCDFPNC
    sc=scal;of=0.0
    call writepnc(mpi_comm,filename,vname,var,0,sc,of,recd)
#else    
    if(.not.allocated(v2))allocate(v2(im,jm))
    if(.not.allocated(iv2))allocate(iv2(im,jm))
    call irrp_gather(var,v2,root)
    if(root/=pid)return
    do j=1,jm
      do i=1,im
        if(mask(i,j)==0)then
          iv2(i,j)=ivland
        else
          iv2(i,j)=v2(i,j)/scal
        endif
      enddo
    enddo
    call open_nc(ncid,filename,'w')
    call writenc(ncid,vname,iv2,recd)
    call close_nc(ncid)
#endif
  end subroutine outnc_2d_reciv2
  !-----------------------------------------------------------------------------------------------
  subroutine outnc_2d_recv2_real(filename,vname,recd,var,flag)
    character(len=*),intent(in) :: filename,vname
    integer,intent(in) :: recd
    real(spdp),intent(in) :: var(0:np)
    integer,intent(in),optional :: flag
    integer :: ncid,i,j
    real(4) :: vland
    if(present(flag))then
      if(flag==0)return
    endif
#ifdef USEPNETCDFPNC
    call writepnc(mpi_comm,filename,vname,var,0,recd)
#else    
    if(.not.allocated(v2))allocate(v2(im,jm))
    call irrp_gather(var,v2,root)
    if(root/=pid)return
    vland=ivland
    do j=1,jm
      do i=1,im
        if(mask(i,j)==0)then
          v2(i,j)=vland
        endif
      enddo
    enddo
    call open_nc(ncid,filename,'w')
    call writenc(ncid,vname,v2,recd)
    call close_nc(ncid)
#endif
  end subroutine outnc_2d_recv2_real
  !-----------------------------------------------------------------------------------------------
end module wamfio_mod

