#define DBG  print*, pid ,__FILE__, __LINE__
#define DOGFSForecast
!!#define LGMTEST
!!#define USEPNETCDF
!!#define BCSTFORCE
!-------------------------------------------------------------------------------------------------
  module wamcpl_mod
  use irrp_smpi_mod;use irrp_package_mod
  use time_mod;use netcdf_mod
  use mwmvar_mod
  use wamfio_mod
  use partctl_mod,only: mpi_comm,pid,root,lon,lat,mask
  implicit none
!-------------------------------------------------------------------------------------------------
  public :: set_uv
  public :: set_ice
  public :: set_wind
  public :: outmixingbv
  private
!-------------------------------------------------------------------------------------------------
  real(8) :: dwtime1=-1.d0,dwtime2=-1.d0
  real(spdp),allocatable, dimension(:) :: windx1,windx2,windy1,windy2
  integer :: wflag=0,wind_init=0
  real(4),allocatable :: dlon(:),dlat(:),wu(:,:),wv(:,:),lvar(:)
  integer*2,allocatable :: ivar(:,:)
  real(8),allocatable :: fix(:),fiy(:)
  integer :: imd,jmd,fid_wind=1
!-------------------------------------------------------------------------------------------------
  integer :: wftype,dimtype,wddtype
  character(len=50) :: uhead,utail,vhead,vtail,xname,yname,uname,vname,tname,dtmid
  character(len=200) :: wpath ! --- Path for wind.
  real(8) :: scalfct,offset
  integer :: iwndfreq,iwndcnt
!-------------------------------------------------------------------------------------------------
  integer :: current_month_ice=0
  integer :: ice_flag=0
!-------------------------------------------------------------------------------------------------
#ifdef OLDWINDIN
  integer,parameter :: wndtype_default=0
  integer,parameter :: wndtype_gfs=1
  integer,parameter :: wndtype_qbln=2
  integer,parameter :: wndtype_ncep=3
  integer,parameter :: wndtype_ccmp=4
  integer,parameter :: wndtype_ccmp2=6 !!!!!
  integer,parameter :: wndtype_gfsfcst=5
  integer,parameter :: wndtype_jra=7
  integer,parameter :: wndtype_core2=8
  integer,parameter :: wndtype_cfsr=9
  integer,parameter :: wndtype_cfsrv2=10
  public :: get_wind
#endif
!-------------------------------------------------------------------------------------------------
  real(spdp),allocatable,dimension(:,:) :: taubb11,taubb12,taubb22,taubb33,bv,h3
  real(spdp),allocatable :: zyyz(:),Cs_r(:)
  integer :: kb,iciocount=0
  real(4),allocatable :: gvar(:,:,:),lay(:)
  real(spdp),allocatable :: gvar1(:,:),ulvar(:)
  character(len=200) :: mixpath             ! --- Path for model output.
  real(8) :: ciofreqbyday
  integer :: ciofreq                         ! --- The output frequency for current coef.s (hour).
  integer :: iciofreq=0
!-------------------------------------------------------------------------------------------------
#ifdef BCSTFORCE
  type foreceinf_type
    integer,pointer :: i(:,:)=>null()
    integer,pointer :: j(:,:)=>null()
    real(8),pointer :: w(:,:)=>null()
  end type foreceinf_type
  type(foreceinf_type) :: fi
!!#ifdef BCSTFORCE
#endif
!-------------------------------------------------------------------------------------------------
  contains
#ifndef NOWINDDATA
!-------------------------------------------------------------------------------------------------
  subroutine set_wind
    integer :: root
    character(len=256) :: ufile,vfile
    integer :: ii
    real(8) :: a,b
    if(wind_init<0)return
    call setwndinf
    if(dwtime1 == -1.d0 .and. dwtime2 == -1.d0)then
      ii=wndfreq*int(itime(4)/wndfreq)
      dwtime2=datenum([itime(1),itime(2),itime(3),ii,0,0])
      call readwind(dwtime2,windx2,windy2,wflag,np) ! --- read wind2
      iwndcnt=iwndfreq
    endif
    !if(dtime>=dwtime2 .and. wflag==0)then
    if(iwndcnt==iwndfreq .and. wflag==0)then
      dwtime1=dwtime2;windx1=windx2;windy1=windy2
      ii=wndfreq*int(itime(4)/wndfreq)+wndfreq
      dwtime2=datenum([itime(1),itime(2),itime(3),ii,0,0])
      call readwind(dwtime2,windx2,windy2,wflag,np) ! --- read wind2
      if(wflag/=0)then
        dwtime2=dwtime1;windx2=windx1;windy2=windy1
      endif
      iwndcnt=0
    endif
    !if(pid==0)then
    !  write(*,*)datestr(dwtime1),'-',datestr(dwtime2),' ',datestr(dtime)
    !endif
    b=0;if(wflag==0)b=(dtime-dwtime1)/(dwtime2-dwtime1);iwndcnt=iwndcnt+1
    a=1-b;wx=windx1*a+windx2*b;wy=windy1*a+windy2*b !;w=sqrt(abs(wx*wx+wy*wy))
    !-------------------------------------------------------------------------------------------
    contains
    !-------------------------------------------------------------------------------------------
    subroutine readwind(dwtime,windx,windy,flag,np)
      real(8),intent(in) :: dwtime
      integer,intent(out) :: flag
      integer,intent(in) :: np
      real(spdp),intent(out) :: windx(0:np),windy(0:np)
      real(8) :: startdwtime
      real(8),allocatable :: dvar(:,:)
      real(4),allocatable :: rvar(:,:)
      integer,allocatable :: ivar(:,:)
      integer*1,allocatable :: i1var(:,:)
      integer*2,allocatable :: i2var(:,:)
      logical :: ext
      integer :: ncid,recd
      root=0
      call set_wind_file(dwtime,ufile,vfile,ext,recd)
      flag=0
      if(.not. ext)then
        if(wind_init==0)then
          wx=10.0;wy=0.0
          wind_init=-1
          if(pid==root)write(*,*)'NO WIND data, set wx=10,wy=0'
        endif
        flag=1;return
      endif
      call initreadwind
      if(pid==root)then
        if(wddtype==nf_double)then
          allocate(dvar(imd,jmd))
          call open_nc(ncid,ufile,'r')
          call readnc(ncid,uname,dvar,recd);wu=dvar*scalfct+offset
          call close_nc(ncid)
          call open_nc(ncid,vfile,'r')
          call readnc(ncid,vname,dvar,recd);wv=dvar*scalfct+offset
          call close_nc(ncid)
          deallocate(dvar)
        elseif(wddtype==nf_real)then
          allocate(rvar(imd,jmd))
          call open_nc(ncid,ufile,'r')
          call readnc(ncid,uname,rvar,recd);wu=rvar*scalfct+offset
          call close_nc(ncid)
          call open_nc(ncid,vfile,'r')
          call readnc(ncid,vname,rvar,recd);wv=rvar*scalfct+offset
          call close_nc(ncid)
          deallocate(rvar)
        elseif(wddtype==nf_int)then
          allocate(ivar(imd,jmd))
          call open_nc(ncid,ufile,'r')
          call readnc(ncid,uname,ivar,recd);wu=ivar*scalfct+offset
          call close_nc(ncid)
          call open_nc(ncid,vfile,'r')
          call readnc(ncid,vname,ivar,recd);wv=ivar*scalfct+offset
          call close_nc(ncid)
          deallocate(ivar)
        elseif(wddtype==nf_int2)then
          allocate(i2var(imd,jmd))
          call open_nc(ncid,ufile,'r')
          call readnc(ncid,uname,i2var,recd);wu=i2var*scalfct+offset
          call close_nc(ncid)
          call open_nc(ncid,vfile,'r')
          call readnc(ncid,vname,i2var,recd);wv=i2var*scalfct+offset
          call close_nc(ncid)
          deallocate(i2var)
        elseif(wddtype==nf_int1)then
          allocate(i1var(imd,jmd))
          call open_nc(ncid,ufile,'r')
          call readnc(ncid,uname,i1var,recd);wu=i1var*scalfct+offset
          call close_nc(ncid)
          call open_nc(ncid,vfile,'r')
          call readnc(ncid,vname,i1var,recd);wv=i1var*scalfct+offset
          call close_nc(ncid)
          deallocate(i1var)
        endif
      endif
      if(dimtype==0)then
        call irrp_scatter_ext(wu,lvar,root);windx=lvar
        call irrp_scatter_ext(wv,lvar,root);windy=lvar
      else
#ifdef BCSTFORCE
        call bcst_force(windx,windy,np)
#else
        call irrp_scatter_force(fid_wind,wu,lvar,root);windx=lvar
        call irrp_scatter_force(fid_wind,wv,lvar,root);windy=lvar
#endif
      endif
    end subroutine readwind
    !-------------------------------------------------------------------------------------------
    subroutine initreadwind
      real(4),allocatable :: dlon(:),dlat(:)
      real(4),allocatable :: rlon(:),rlat(:)
      integer,allocatable :: ilon(:),ilat(:)
      integer*2,allocatable :: i2lon(:),i2lat(:)
      integer*1,allocatable :: i1lon(:),i1lat(:)
      real(8),allocatable :: fox(:),foy(:)
      integer :: ncid
      if(wind_init/=0)return
      imd=1;jmd=1
      if(pid==root)then
        !call set_wind_diminfs(filename)
        call open_nc(ncid,ufile,'r')
        imd=get_dimension_len(ncid,xname)
        jmd=get_dimension_len(ncid,yname)
        allocate(fix(imd),fiy(jmd))
        !          ( nf_int1 = 1, nf_char = 2, nf_int2 = 3, nf_int = 4,
        !            nf_real = 5, nf_double = 6 )
        if(dimtype==nf_double)then
          allocate(dlon(imd),dlat(jmd))
          call readnc(ncid,xname,dlon);fix=dlon
          call readnc(ncid,yname,dlat);fiy=dlat
          deallocate(dlon,dlat)
        elseif(dimtype==nf_real)then
          allocate(rlon(imd),rlat(jmd))
          call readnc(ncid,xname,rlon);fix=rlon
          call readnc(ncid,yname,rlat);fiy=rlat
          deallocate(rlon,rlat)
        elseif(dimtype==nf_int)then
          allocate(ilon(imd),ilat(jmd))
          call readnc(ncid,xname,ilon);fix=ilon
          call readnc(ncid,yname,ilat);fiy=ilat
          deallocate(ilon,ilat)
        elseif(dimtype==nf_int2)then
          allocate(i2lon(imd),i2lat(jmd))
          call readnc(ncid,xname,i2lon);fix=i2lon
          call readnc(ncid,yname,i2lat);fiy=i2lat
          deallocate(i2lon,i2lat)
        elseif(dimtype==nf_int1)then
          allocate(i1lon(imd),i1lat(jmd))
          call readnc(ncid,xname,i1lon);fix=i1lon
          call readnc(ncid,yname,i1lat);fiy=i1lat
          deallocate(i1lon,i1lat)
        endif
        call close_nc(ncid)
      endif
#ifdef BCSTFORCE
      call init_bcst_force
#else
      if(dimtype/=0)then
        if(.not.allocated(fix))then
          imd=1;jmd=1;allocate(fix(imd),fiy(jmd))
        endif
        !if(spdp==8)then
        !  call irrp_scatter_force_init(fid_wind,fix,fiy,alon,alat,imd,jmd,imd,jmd,1,360.d0,root)
        !else
        !  allocate(fox(0:np),foy(0:np));fox=alon;foy=alat
        !  call irrp_scatter_force_init(fid_wind,fix,fiy,fox,foy,imd,jmd,imd,jmd,1,360.d0,root)
        !  deallocate(fox,foy)
        !endif
        allocate(fox(0:np),foy(0:np));fox=alon;foy=alat
        call irrp_scatter_force_init(fid_wind,fix,fiy,fox,foy,imd,jmd,imd,jmd,1,360.d0,root)
        deallocate(fox,foy)
      endif
#endif
      allocate(wu(imd,jmd),wv(imd,jmd))
      if(.not.allocated(lvar))allocate(lvar(0:np))
      deallocate(fix,fiy)
      wind_init=1
    end subroutine initreadwind
    !-------------------------------------------------------------------------------------------
    subroutine set_wind_file(dwtime,ufile,vfile,ext,recd)
      real(8),intent(in) :: dwtime
      character(len=*),intent(out) :: ufile,vfile
      logical,intent(out) :: ext
      integer,intent(out) :: recd
      integer :: iwtime(6),ncid,maxrec,i1,i2
      character(len=14) :: cwtime,sdate
      logical :: ext1,ext2
      real(8) :: startdwtime
      character(len=10) :: ystr
      ystr='/'
      iwtime=datevec(dwtime);cwtime=datestr(iwtime);sdate=''
      if(wftype==1)then          ! files in yearly
        sdate=cwtime(1:4)
        startdwtime=datenum([iwtime(1),1,1,0,0,0])
      elseif(wftype==2)then      ! files in monthly
        sdate=cwtime(1:4)//trim(dtmid)//cwtime(5:6)
        startdwtime=datenum([iwtime(1),iwtime(2),1,0,0,0])
      elseif(wftype==3)then      ! files in daily
        sdate=cwtime(1:4)//trim(dtmid)//cwtime(5:6)//trim(dtmid)//cwtime(7:8)
        startdwtime=datenum([iwtime(1),iwtime(2),iwtime(3),0,0,0])
        ystr='/'//cwtime(1:4)//'/'  ! this should be the year of wind data!!! 20211016
      elseif(wftype==4)then      ! one file each run and record since 1948-01-01
        startdwtime=datenum([1948,1,1,0,0,0]) !-getleaps(dwtime,datenum([1948,1,1,0,0,0]))
      elseif(wftype==5)then      ! one file every 10 year and record since 0001-01-01, same calender
        i1=int((iwtime(1)-1)/10)*10+1;i2=i1+10
        write(sdate,"(i4.4,'-',i4.4)")i1,i2
        startdwtime=datenum([i1,1,1,0,0,0])
      elseif(wftype==8)then      ! one file for each run for forecasting by GFS
        startdwtime=dtime0
        cwtime=datestr(startdwtime)
        sdate=cwtime(1:4)//trim(dtmid)//cwtime(5:6)//trim(dtmid)//cwtime(7:8)
        ystr='/'//ctime(1:4)//'/'
      elseif(wftype==9)then      ! one file for each run for forecasting by GFS
        startdwtime=dtime0
        cwtime=datestr(startdwtime)
        sdate=cwtime(1:4)//trim(dtmid)//cwtime(5:6)//trim(dtmid)//cwtime(7:8)
        ystr=''   ! w/o yearly direct
      else                       ! one file for each run.
        startdwtime=dtime0
        cwtime=datestr(startdwtime)
        sdate=cwtime(1:8)
      endif
      recd=(dwtime-startdwtime)*24.0/wndfreq+1
      ufile=trim(wpath)//trim(ystr)//trim(uhead)//trim(sdate)//trim(utail)
      vfile=trim(wpath)//trim(ystr)//trim(vhead)//trim(sdate)//trim(vtail)
      inquire(file=ufile,exist=ext1)
      inquire(file=vfile,exist=ext2)
      ext=ext1 .and. ext2
      if(ext .and. pid==root)then
        call open_nc(ncid,ufile,'r')
        maxrec=get_dimension_len(ncid,tname);if(recd>maxrec)recd=maxrec
        call close_nc(ncid)
      endif
      if(pid==0)then
        write(*,*)trim(ufile),recd
        write(*,*)trim(vfile),recd        
      endif
    end subroutine set_wind_file
    !-------------------------------------------------------------------------------------------
  end subroutine set_wind

  subroutine setwndinf
    type(mpipacket) :: pk
    integer :: lsize
    namelist/wndinf/wpath,uhead,utail,vhead,vtail,dtmid,xname,yname,tname,uname,vname, &
                    wftype,dimtype,wddtype,scalfct,offset,wndfreq
    if(wind_init/=0)return
    if(pid == root)then
      open(11,file='ctlparams',delim='quote');read(11,nml=wndinf);close(11)
      call packbcastdata(0)
    endif
    call packbcastdata(1)
    iwndfreq=wndfreq*60./delttm
    if(.not.allocated(windx1))allocate(windx1(0:np), windx2(0:np), windy1(0:np), windy2(0:np))
    windx1=10;windy1=0;windx2=10;windy2=0;
    contains
    subroutine packbcastdata(act)
      integer,intent(in) :: act
      if(act==0)then
        lsize=(5*8+750)
        call InitMpiPacket(pk,lsize)
      else
        call bcast_packet(pk,root,pid,mpi_comm)
      endif
      call irrp_pget_mpipacket(pk,wpath,200,mpi_comm,act)
      call irrp_pget_mpipacket(pk,uhead,50,mpi_comm,act)
      call irrp_pget_mpipacket(pk,utail,50,mpi_comm,act)
      call irrp_pget_mpipacket(pk,vhead,50,mpi_comm,act)
      call irrp_pget_mpipacket(pk,vtail,50,mpi_comm,act)
      call irrp_pget_mpipacket(pk,xname,50,mpi_comm,act)
      call irrp_pget_mpipacket(pk,yname,50,mpi_comm,act)
      call irrp_pget_mpipacket(pk,tname,50,mpi_comm,act)
      call irrp_pget_mpipacket(pk,uname,50,mpi_comm,act)
      call irrp_pget_mpipacket(pk,vname,50,mpi_comm,act)
      call irrp_pget_mpipacket(pk,dtmid,50,mpi_comm,act)
      call irrp_pget_mpipacket(pk,wftype,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,dimtype,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,wddtype,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,scalfct,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,offset,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,wndfreq,1,mpi_comm,act)
      if(act>0)then
        call FinalMpiPacket(pk)
      endif
    end subroutine packbcastdata
  end subroutine setwndinf

#ifdef BCSTFORCE
  subroutine bcst_force(windx,windy,np)
    integer,intent(in) :: np
    real(spdp),intent(out) :: windx(0:np),windy(0:np)
    type(mpipacket) :: pk
    integer :: lsize,n
    ! bcast (wu,wv), and then interp for (windx,windy).
    if(pid==root)then
      call packbcastdata(0)
    endif
    call packbcastdata(1)
    do n=1,np
      windx(n)=fi%w(1,n)*wu(fi%i(1,n),fi%j(1,n))+fi%w(2,n)*wu(fi%i(2,n),fi%j(2,n)) &
              +fi%w(3,n)*wu(fi%i(3,n),fi%j(3,n))+fi%w(4,n)*wu(fi%i(4,n),fi%j(4,n))
      windy(n)=fi%w(1,n)*wv(fi%i(1,n),fi%j(1,n))+fi%w(2,n)*wv(fi%i(2,n),fi%j(2,n)) &
              +fi%w(3,n)*wv(fi%i(3,n),fi%j(3,n))+fi%w(4,n)*wv(fi%i(4,n),fi%j(4,n))
    enddo
    !------------------------------------------------------------------------------
    contains
    !------------------------------------------------------------------------------
    subroutine packbcastdata(act)
      integer,intent(in) :: act
      if(act==0)then
        lsize=(imd*jmd)*8*2+200
        call InitMpiPacket(pk,lsize)
      else
        call bcast_packet(pk,root,pid,mpi_comm)
      endif
      call irrp_pget_mpipacket(pk,wu,imd*jmd,mpi_comm,act)
      call irrp_pget_mpipacket(pk,wv,imd*jmd,mpi_comm,act)
      if(act>0)then
        call FinalMpiPacket(pk)
      endif
    end subroutine packbcastdata
  end subroutine bcst_force

  subroutine init_bcst_force
    type(mpipacket) :: pk
    integer :: lsize,i1,i2,j1,j2,n
    real(8) :: p,q
    ! need bcast fix,fiy,imd,jmd
    if(pid==root)then
      call packbcastdata(0)
    endif
    call packbcastdata(1)
    ! prepare interp coef. from fix,fiy to fox,foy
    allocate(fi%i(4,np),fi%j(4,np),fi%w(4,np))
    fi%i=0;fi%j=0;fi%w=0
    do n=1,np
      call findi1i2(fix,imd,alon(n),i1,i2,p,360.d0)
      call findi1i2(fiy,jmd,alat(n),j1,j2,q,0.d0)
      fi%i(1,n)=i1; fi%j(1,n)=j1; fi%w(1,n)=(1-p)*(1-q)
      fi%i(2,n)=i2; fi%j(2,n)=j1; fi%w(2,n)=   p *(1-q)
      fi%i(3,n)=i1; fi%j(3,n)=j2; fi%w(3,n)=(1-p)* q
      fi%i(4,n)=i2; fi%j(4,n)=j2; fi%w(4,n)=   p * q
    enddo
    !------------------------------------------------------------------------------
    contains
    !------------------------------------------------------------------------------
    subroutine packbcastdata(act)
      integer,intent(in) :: act
      if(act==0)then
        lsize=(imd+jmd)*8+200
        call InitMpiPacket(pk,lsize)
      else
        call bcast_packet(pk,root,pid,mpi_comm)
      endif
      call irrp_pget_mpipacket(pk,imd,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,jmd,1,mpi_comm,act)
      if(.not. allocated(fix))allocate(fix(imd))
      if(.not. allocated(fiy))allocate(fiy(jmd))
      call irrp_pget_mpipacket(pk,fix,imd,mpi_comm,act)
      call irrp_pget_mpipacket(pk,fiy,jmd,mpi_comm,act)
      if(act>0)then
        call FinalMpiPacket(pk)
      endif
    end subroutine packbcastdata
  end subroutine init_bcst_force

  subroutine findi1i2(fp,n,x,i1,i2,p,fcycle)
    integer,intent(in):: n
    real(8) ,intent(in):: x,fp(n),fcycle
    integer,intent(out):: i1,i2
    real(8) ,intent(out):: p
    integer :: i
    real(8) :: dx,dfcycle
    i1=n
    if(fp(2)>=fp(1))then
      do i=1,n
        if(x<fp(i))then
          i1=i-1;exit
        endif
      enddo
      dfcycle=fcycle
    else
      do i=1,n
        if(x>fp(i))then
          i1=i-1;exit
        endif
      enddo
      dfcycle=-fcycle
    endif
    i2=i1+1
    if(i1==0 .or. i1==n)then
      if(fcycle>1e-5)then
        p=(x-fp(n))/(fp(1)+dfcycle-fp(n))
        if(i1==0)p=(x+dfcycle-fp(n))/(fp(1)+dfcycle-fp(n))
        i1=n;i2=1
      else
        if(i1==0)i1=1
        i2=i1;p=0
      endif
    else
      p=(x-fp(i1))/(fp(i2)-fp(i1))
    endif
  end subroutine findi1i2
#endif
!-------------------------------------------------------------------------------------------------
#ifdef OLDWINDIN
!-------------------------------------------------------------------------------------------------
  subroutine get_wind
    integer :: ii,i,j
    real :: a,b
    if(.not.allocated(windx1))allocate(windx1(0:np), windx2(0:np), windy1(0:np), windy2(0:np))
    if(dwtime1 == -1.d0 .and. dwtime2 == -1.d0)then
      ii=wndfreq*int(itime(4)/wndfreq)
      dwtime2=datenum([itime(1),itime(2),itime(3),ii,0,0])
      call read_wind(dwtime2,windx2,windy2,wflag,np) ! --- read wind2
    endif
    if(dtime>=dwtime2 .and. wflag==0)then
      dwtime1=dwtime2;windx1=windx2;windy1=windy2
      ii=wndfreq*int(itime(4)/wndfreq)+wndfreq
      dwtime2=datenum([itime(1),itime(2),itime(3),ii,0,0])
      call read_wind(dwtime2,windx2,windy2,wflag,np) ! --- read wind2
      if(wflag/=0)then
        dwtime2=dwtime1;windx2=windx1;windy2=windy1
      endif
    endif
    if(wflag /= 0)then
      wx=windx1;wy=windy1;w=sqrt(wx*wx+wy*wy);return
    endif
    b=(dtime-dwtime1)/(dwtime2-dwtime1);a=1-b
    wx=windx1*a+windx2*b;wy=windy1*a+windy2*b;w=sqrt(abs(wx*wx+wy*wy))
  end subroutine get_wind
!-------------------------------------------------------------------------------------------------
  subroutine read_wind(dwtime,windx,windy,flag,np)
    real(8),intent(in) :: dwtime
    integer,intent(out) :: flag
    integer,intent(in) :: np
    real(spdp),intent(out) :: windx(0:np),windy(0:np)
    integer :: fid,nix,niy,idx,rec,iwtime(6),ncid,maxrec
    character(len=100) :: filename,filename1
    logical :: ext
    root=0
    call set_wind_filename(dwtime,filename,filename1,ext)
    !if(pid==root)then
    !  DBG,trim(filename),ext
    !endif
    fid=1;flag=0;if(.not.ext)then;flag=1;return;endif
    if(wind_init==0)then
      if(.not.allocated(lvar))allocate(lvar(0:np))
      if(pid==root)then
        call set_wind_diminfs(filename)
        write(*,*)trim(filename)
        nix=imd;niy=jmd
        allocate(fix(nix),fiy(niy));fix=dlon;fiy=dlat
      else
        nix=1;niy=1;imd=1;jmd=1
        allocate(dlon(imd),dlat(jmd),wu(imd,jmd),wv(imd,jmd))
        allocate(fix(nix),fiy(niy))
      endif
      call irrp_scatter_force_init(fid,fix,fiy,alon,alat,nix,niy,nix,niy,1,360.d0,root)
      deallocate(fix,fiy,dlon,dlat)
      wind_init=1
    endif
    if(pid==root)call set_wind_data(dwtime,filename,filename1)
    call irrp_scatter_force(fid,wu,lvar,root);windx=lvar
    call irrp_scatter_force(fid,wv,lvar,root);windy=lvar
  end subroutine read_wind
!-------------------------------------------------------------------------------------------------
  subroutine set_wind_filename(dwtime,filename,filename1,ext)
    real(8),intent(in) :: dwtime
    character(len=*),intent(out) :: filename,filename1
    logical,intent(out) :: ext
    character(len=14) :: cwtime
    integer :: iwtime(6)
    if(wndtype==wndtype_gfs)then
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_qbln)then
      iwtime=datevec(dwtime);cwtime=datestr(iwtime)
      filename=trim(wpath)//'wind'//cwtime(1:6)//'.nc';filename1=filename
      inquire(file=filename,exist=ext)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_ncep)then
      iwtime=datevec(dwtime);cwtime=datestr(iwtime)
      filename =trim(wpath)//'uwnd.sig995.'//cwtime(1:4)//'.nc'
      filename1=trim(wpath)//'vwnd.sig995.'//cwtime(1:4)//'.nc'
      inquire(file=filename,exist=ext)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_ccmp)then
      iwtime=datevec(dwtime);cwtime=datestr(iwtime)
      filename=trim(wpath)//'analysis_'//cwtime(1:8)//'_v11l30flk.nc'
      inquire(file=filename,exist=ext)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_gfsfcst)then
      iwtime=datevec(dtime0);cwtime=datestr(iwtime)
      filename=trim(wpath)//cwtime(1:8)//'/'//cwtime(1:8)//'_0p25.nc'
      inquire(file=filename,exist=ext)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_jra)then
      iwtime=datevec(dwtime);cwtime=datestr(iwtime)
      ! anl_surf_six_hourly_ugrd10m_195801
      filename=trim(wpath)//'anl_surf_six_hourly_ugrd10m_'//cwtime(1:6)//'.nc'
      filename1=trim(wpath)//'anl_surf_six_hourly_vgrd10m_'//cwtime(1:6)//'.nc'
      inquire(file=filename,exist=ext)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_core2)then
      iwtime=datevec(dwtime);cwtime=datestr(iwtime)
      if(dwtime>=datenum(1948,1,0,0,0,0) .and. dwtime<datenum(2010,1,1,0,0,0))then
        filename=trim(wpath)//'u_10.1948-2009.23OCT2012.nc'
        filename1=trim(wpath)//'v_10.1948-2009.23OCT2012.nc'
        inquire(file=filename,exist=ext)
        !write(*,*)trim(filename)
      else
        ext=.false.
      endif
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_cfsr)then
      iwtime=datevec(dwtime);cwtime=datestr(iwtime)
      filename=trim(wpath)//'wnd10m.'//cwtime(1:6)//'.grb2.nc'
      inquire(file=filename,exist=ext)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_cfsrv2)then
      iwtime=datevec(dwtime);cwtime=datestr(iwtime)
      filename=trim(wpath)//'flxf00.gdas.'//cwtime(1:8)//'.grb2.nc'
      inquire(file=filename,exist=ext)
      !-------------------------------------------------------------------------------------------
    else !if(wndtype==wndtype_default)then
    endif
  end subroutine set_wind_filename
!-------------------------------------------------------------------------------------------------
  subroutine set_wind_diminfs(filename)
    character(len=*),intent(in) :: filename
    integer :: ncid
    real(8),allocatable :: ddlon(:),ddlat(:)
    if(wndtype==wndtype_gfs)then
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_qbln)then
      call open_nc(ncid,filename,'r')
      imd=get_dimension_len(ncid,'lon')
      jmd=get_dimension_len(ncid,'lat')
      allocate(dlon(imd),dlat(jmd),wu(imd,jmd),wv(imd,jmd))
      call readnc(ncid,'lon',dlon)
      call readnc(ncid,'lat',dlat)
      call close_nc(ncid)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_ncep)then
      call open_nc(ncid,filename,'r')
      imd=get_dimension_len(ncid,'lon')
      jmd=get_dimension_len(ncid,'lat')
      allocate(dlon(imd),dlat(jmd),wu(imd,jmd),wv(imd,jmd),ivar(imd,jmd))
      call readnc(ncid,'lon',dlon)
      call readnc(ncid,'lat',dlat)
      call close_nc(ncid)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_ccmp)then
      call open_nc(ncid,filename,'r')
      imd=get_dimension_len(ncid,'lon')
      jmd=get_dimension_len(ncid,'lat')
      allocate(dlon(imd),dlat(jmd),wu(imd,jmd),wv(imd,jmd),ivar(imd,jmd))
      call readnc(ncid,'lon',dlon)
      call readnc(ncid,'lat',dlat)
      call close_nc(ncid)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_gfsfcst)then
      call open_nc(ncid,filename,'r')
      imd=get_dimension_len(ncid,'longitude')
      jmd=get_dimension_len(ncid,'latitude')
      allocate(dlon(imd),dlat(jmd),wu(imd,jmd),wv(imd,jmd))
      call readnc(ncid,'longitude',dlon)
      call readnc(ncid,'latitude',dlat)
      call close_nc(ncid)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_jra)then
      call open_nc(ncid,filename,'r')
      imd=get_dimension_len(ncid,'lon')
      jmd=get_dimension_len(ncid,'lat')
      allocate(dlon(imd),dlat(jmd),wu(imd,jmd),wv(imd,jmd))
      call readnc(ncid,'lon',dlon)
      call readnc(ncid,'lat',dlat)
      call close_nc(ncid)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_core2)then
      call open_nc(ncid,filename,'r')
      imd=get_dimension_len(ncid,'LON')
      jmd=get_dimension_len(ncid,'LAT')
      allocate(dlon(imd),dlat(jmd),wu(imd,jmd),wv(imd,jmd))
      call readnc(ncid,'LON',dlon)
      call readnc(ncid,'LAT',dlat)
      call close_nc(ncid)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_cfsr)then
      call open_nc(ncid,filename,'r')
      imd=get_dimension_len(ncid,'lon')
      jmd=get_dimension_len(ncid,'lat')
      allocate(dlon(imd),dlat(jmd),wu(imd,jmd),wv(imd,jmd))
      call readnc(ncid,'lon',dlon)
      call readnc(ncid,'lat',dlat)
      call close_nc(ncid)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_cfsrv2)then
      call open_nc(ncid,filename,'r')
      imd=get_dimension_len(ncid,'longitude')
      jmd=get_dimension_len(ncid,'latitude')
      allocate(dlon(imd),dlat(jmd),wu(imd,jmd),wv(imd,jmd),ddlon(imd),ddlat(jmd))
      call readnc(ncid,'longitude',ddlon);dlon=ddlon
      call readnc(ncid,'latitude',ddlat);dlat=ddlat
      call close_nc(ncid)
      deallocate(ddlon,ddlat)
      !-------------------------------------------------------------------------------------------
    else !if(wndtype==wndtype_default)then
    endif
  end subroutine set_wind_diminfs
!-------------------------------------------------------------------------------------------------
  subroutine set_wind_data(dwtime,filename,filename1)
    real(8),intent(in) :: dwtime
    character(len=*),intent(in) :: filename,filename1
    integer :: iwtime(6),ncid,maxrec,rec
    iwtime=datevec(dwtime)
    if(wndtype==wndtype_gfs)then
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_qbln)then
      rec=(dwtime-datenum([iwtime(1),iwtime(2),1,0,0,0]))*24.0/wndfreq+1
      if(iwtime(2)==2 .and. iwtime(3)==29)then
        rec=(datenum([iwtime(1),iwtime(2),28,iwtime(4:6)]) &
            -datenum([iwtime(1),iwtime(2),1,0,0,0])      )*24.0/wndfreq+1
      endif
      call open_nc(ncid,filename,'r')
      maxrec=get_dimension_len(ncid,'time')
      if(rec>maxrec)rec=maxrec
      call readnc(ncid,'windu',wu,rec)
      call readnc(ncid,'windv',wv,rec)
      call close_nc(ncid)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_ncep)then
      rec=(dwtime-datenum([iwtime(1),1,1,0,0,0]))*24.0/wndfreq+1
      call open_nc(ncid,filename,'r')
      maxrec=get_dimension_len(ncid,'time')
      if(rec>maxrec)rec=maxrec
      call readnc(ncid,'uwnd',ivar,rec);wu=ivar*0.01+225.45
      call close_nc(ncid)
      rec=(dwtime-datenum([iwtime(1),1,1,0,0,0]))*24.0/wndfreq+1
      call open_nc(ncid,filename1,'r')
      maxrec=get_dimension_len(ncid,'time')
      if(rec>maxrec)rec=maxrec
      call readnc(ncid,'vwnd',ivar,rec);wv=ivar*0.01+225.45
      call close_nc(ncid)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_ccmp)then
      rec=(dwtime-datenum([iwtime(1),iwtime(2),iwtime(3),0,0,0]))*24.0/wndfreq+1
      call open_nc(ncid,filename,'r')
      maxrec=get_dimension_len(ncid,'time')
      if(rec>maxrec)rec=maxrec
      call readnc(ncid,'uwnd',ivar,rec);wu=ivar*0.003051944
      call readnc(ncid,'vwnd',ivar,rec);wv=ivar*0.003051944
      call close_nc(ncid)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_gfsfcst)then
      rec=(dwtime-dtime0)*24.0/wndfreq+1
      call open_nc(ncid,filename,'r')
      maxrec=get_dimension_len(ncid,'time')
      if(rec>maxrec)rec=maxrec
      call readnc(ncid,'UGRD_10maboveground',wu,rec)
      call readnc(ncid,'VGRD_10maboveground',wv,rec)
      call close_nc(ncid)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_jra)then
      !rec=(dwtime-datenum([iwtime(1),1,1,0,0,0]))*24.0/wndfreq+1
      rec=(dwtime-datenum([iwtime(1),iwtime(2),1,0,0,0]))*24.0/wndfreq+1
      write(*,*)trim(filename),rec
      call open_nc(ncid,filename,'r')
      maxrec=get_dimension_len(ncid,'time');if(rec>maxrec)rec=maxrec
      call readnc(ncid,'ugrd10m',wu,rec)
      call close_nc(ncid)
      call open_nc(ncid,filename1,'r')
      call readnc(ncid,'vgrd10m',wv,rec)
      call close_nc(ncid)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_core2)then
      ! TIME:calendar = "NOLEAP" ;
      rec=(dwtime-datenum([1948,1,1,0,0,0])           &
           -getleaps(dwtime,datenum([1948,1,1,0,0,0])))*24.0/wndfreq+1
      write(*,*)trim(filename),rec
      call open_nc(ncid,filename,'r')
      maxrec=get_dimension_len(ncid,'TIME');if(rec>maxrec)rec=maxrec
      call readnc(ncid,'U_10_MOD',wu,rec)
      call close_nc(ncid)
      call open_nc(ncid,filename1,'r')
      call readnc(ncid,'V_10_MOD',wv,rec)
      call close_nc(ncid)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_cfsr)then
      ! TIME:calendar = "NOLEAP" ;
      rec=(dwtime-datenum([iwtime(1),iwtime(2),1,0,0,0]))*24.0/wndfreq+1
      write(*,*)trim(filename),rec
      call open_nc(ncid,filename,'r')
      maxrec=get_dimension_len(ncid,'time');if(rec>maxrec)rec=maxrec
      call readnc(ncid,'U_GRD_L103',wu,rec)
      call readnc(ncid,'V_GRD_L103',wv,rec)
      call close_nc(ncid)
      !-------------------------------------------------------------------------------------------
    elseif(wndtype==wndtype_cfsrv2)then
      rec=(dwtime-datenum([iwtime(1),iwtime(2),iwtime(3),0,0,0]))*24.0/wndfreq+1
      write(*,*)trim(filename),rec
      call open_nc(ncid,filename,'r')
      maxrec=get_dimension_len(ncid,'time');if(rec>maxrec)rec=maxrec
      call readnc(ncid,'UGRD_10maboveground',wu,rec)
      call readnc(ncid,'VGRD_10maboveground',wv,rec)
      call close_nc(ncid)
      !-------------------------------------------------------------------------------------------
    else !if(wndtype==wndtype_default)then
    endif
    contains
    integer function getleaps(dtime1,dtime2)
      real(8),intent(in) :: dtime1,dtime2
      integer :: itime1(6),itime2(6),i,is,ie
      itime1=datevec(dtime1);itime2=datevec(dtime2)
      is=itime1(1);ie=itime2(1)-1;if(itime(2)>2)ie=itime2(1)
      getleaps=0
      do i=is,ie,1
        if((mod(i,4)==0 .and. mod(i,100)/= 0) .or. (mod(i,400)==0))then
          getleaps=getleaps+1
        endif
      enddo
    end function getleaps
  end subroutine set_wind_data
!-------------------------------------------------------------------------------------------------
!  subroutine read_wind_qbln(dwtime,windx,windy,flag,np)
!    real(8),intent(in) :: dwtime
!    integer,intent(out) :: flag
!    integer,intent(in) :: np
!    real(spdp),intent(out) :: windx(0:np),windy(0:np)
!    integer :: fid,nix,niy,idx,rec,iwtime(6),ncid,maxrec
!    character(len=14) :: cwtime
!    character(len=100) :: filename
!    logical :: ext
!    iwtime=datevec(dwtime);cwtime=datestr(iwtime)
!    filename=trim(wpath)//'wind'//cwtime(1:6)//'.nc'
!    inquire(file=filename,exist=ext)
!    flag=0;if(.not.ext)then;flag=1;return;endif
!    fid=1
!    if(wind_init==0)then
!      if(.not.allocated(lvar))allocate(lvar(0:np))
!      if(pid==root)then
!        call open_nc(ncid,filename,'r')
!        imd=get_dimension_len(ncid,'lon')
!        jmd=get_dimension_len(ncid,'lat')
!        allocate(dlon(imd),dlat(jmd),wu(imd,jmd),wv(imd,jmd))
!        call readnc(ncid,'lon',dlon)
!        call readnc(ncid,'lat',dlat)
!        call close_nc(ncid)
!        nix=imd;niy=jmd
!        allocate(fix(nix),fiy(niy));fix=dlon;fiy=dlat
!      else
!        nix=1;niy=1;imd=1;jmd=1
!        allocate(dlon(imd),dlat(jmd),wu(imd,jmd),wv(imd,jmd))
!        allocate(fix(nix),fiy(niy))
!      endif
!      !allocate(fox(0:np),foy(0:np))
!      !do idx=1,np
!      !  fox(idx)=lon(pnb(idx)%i)
!      !  foy(idx)=lat(pnb(idx)%j)
!      !enddo
!      call irrp_scatter_force_init(fid,fix,fiy,fox,foy,nix,niy,nix,niy,1,360.d0,root)
!      deallocate(fix,fiy,dlon,dlat) !fox,foy,
!      wind_init=1
!    endif
!    if(pid==root)then
!      rec=(dwtime-datenum([iwtime(1),iwtime(2),1,0,0,0]))*24.0/wndfreq+1
!      if(iwtime(2)==2 .and. iwtime(3)==29)then
!        rec=(datenum([iwtime(1),iwtime(2),28,iwtime(4:6)]) &
!            -datenum([iwtime(1),iwtime(2),1,0,0,0])      )*24.0/wndfreq+1
!      endif
!      call open_nc(ncid,filename,'r')
!      maxrec=get_dimension_len(ncid,'time')
!      if(rec>maxrec)then
!        write(6,*)'WND: ','maxrec,rec',maxrec,rec
!        rec=maxrec
!      endif
!      call readnc(ncid,'windu',wu,rec)
!      call readnc(ncid,'windv',wv,rec)
!      call close_nc(ncid)
!    endif
!    call irrp_scatter_force(fid,wu,lvar,root);windx=lvar
!    call irrp_scatter_force(fid,wv,lvar,root);windy=lvar
!  end subroutine read_wind_qbln
!-------------------------------------------------------------------------------------------------
!  subroutine read_wind_ncep(dwtime,windx,windy,flag,np)
!    real(8),intent(in) :: dwtime
!    integer,intent(out) :: flag
!    integer,intent(in) :: np
!    real(spdp),intent(out) :: windx(0:np),windy(0:np)
!    integer :: fid,nix,niy,idx,rec,iwtime(6),ncid,maxrec
!    character(len=14) :: cwtime
!    character(len=100) :: filename,filename1
!    logical :: ext
!    iwtime=datevec(dwtime);cwtime=datestr(iwtime)
!    filename =trim(wpath)//'uwnd.sig995.'//cwtime(1:4)//'.nc'
!    filename1=trim(wpath)//'vwnd.sig995.'//cwtime(1:4)//'.nc'
!    inquire(file=filename,exist=ext)
!    flag=0;if(.not.ext)then;flag=1;return;endif
!    fid=1
!    if(wind_init==0)then
!      if(.not.allocated(lvar))allocate(lvar(0:np))
!      if(pid==root)then
!        call open_nc(ncid,filename,'r')
!        imd=get_dimension_len(ncid,'lon')
!        jmd=get_dimension_len(ncid,'lat')
!        allocate(dlon(imd),dlat(jmd),wu(imd,jmd),wv(imd,jmd),ivar(imd,jmd))
!        call readnc(ncid,'lon',dlon)
!        call readnc(ncid,'lat',dlat)
!        call close_nc(ncid)
!        nix=imd;niy=jmd
!        allocate(fix(nix),fiy(niy));fix=dlon;fiy=dlat
!      else
!        nix=1;niy=1;imd=1;jmd=1
!        allocate(dlon(imd),dlat(jmd),wu(imd,jmd),wv(imd,jmd),ivar(imd,jmd))
!        allocate(fix(nix),fiy(niy))
!      endif
!      !allocate(fox(0:np),foy(0:np))
!      !do idx=1,np
!      !  fox(idx)=lon(pnb(idx)%i)
!      !  foy(idx)=lat(pnb(idx)%j)
!      !enddo
!      call irrp_scatter_force_init(fid,fix,fiy,fox,foy,nix,niy,nix,niy,1,360.d0,root)
!      deallocate(fix,fiy,dlon,dlat) !fox,foy,
!      wind_init=1
!    endif
!    if(pid==root)then
!      rec=(dwtime-datenum([iwtime(1),1,1,0,0,0]))*24.0/wndfreq+1
!      call open_nc(ncid,filename,'r')
!      maxrec=get_dimension_len(ncid,'time')
!      if(rec<=maxrec)then
!        call readnc(ncid,'uwnd',ivar,rec)
!        wu=ivar*0.01+225.45
!      else
!        flag=1
!      endif
!      call close_nc(ncid)
!      call open_nc(ncid,filename1,'r')
!      maxrec=get_dimension_len(ncid,'time')
!      if(rec<=maxrec)then
!        call readnc(ncid,'vwnd',ivar,rec)
!        wv=ivar*0.01+225.45
!      else
!        flag=1
!      endif
!      call close_nc(ncid)
!    endif
!    call irrp_scatter_force(fid,wu,lvar,root);windx=lvar
!    call irrp_scatter_force(fid,wv,lvar,root);windy=lvar
!  end subroutine read_wind_ncep
!-------------------------------------------------------------------------------------------------
!  subroutine read_wind_ccmp(dwtime,windx,windy,flag,np)
!    real(8),intent(in) :: dwtime
!    integer,intent(out) :: flag
!    integer,intent(in) :: np
!    real(spdp),intent(out) :: windx(0:np),windy(0:np)
!    integer :: fid,nix,niy,idx,rec,iwtime(6),ncid,maxrec
!    character(len=14) :: cwtime
!    character(len=100) :: filename
!    logical :: ext
!    iwtime=datevec(dwtime);cwtime=datestr(iwtime)
!    filename=trim(wpath)//'analysis_'//cwtime(1:8)//'_v11l30flk.nc'
!    inquire(file=filename,exist=ext)
!    flag=0;if(.not.ext)then;flag=1;return;endif
!    fid=1
!    if(wind_init==0)then
!      if(.not.allocated(lvar))allocate(lvar(0:np))
!      if(pid==root)then
!        call open_nc(ncid,filename,'r')
!        imd=get_dimension_len(ncid,'lon')
!        jmd=get_dimension_len(ncid,'lat')
!        allocate(dlon(imd),dlat(jmd),wu(imd,jmd),wv(imd,jmd))
!        call readnc(ncid,'lon',dlon)
!        call readnc(ncid,'lat',dlat)
!        call close_nc(ncid)
!        nix=imd;niy=jmd;allocate(fix(nix),fiy(niy));fix=dlon;fiy=dlat
!      else
!        nix=1;niy=1;imd=1;jmd=1
!        allocate(dlon(imd),dlat(jmd),wu(imd,jmd),wv(imd,jmd),ivar(imd,jmd),fix(nix),fiy(niy))
!      endif
!      !allocate(fox(0:np),foy(0:np))
!      !do idx=1,np
!      !  fox(idx)=lon(pnb(idx)%i)
!      !  foy(idx)=lat(pnb(idx)%j)
!      !enddo
!      call irrp_scatter_force_init(fid,fix,fiy,fox,foy,nix,niy,nix,niy,1,360.d0,root)
!      deallocate(fix,fiy,dlon,dlat) !fox,foy,
!      wind_init=1
!    endif
!    if(pid==root)then
!      rec=(dwtime-datenum([iwtime(1),iwtime(2),iwtime(3),0,0,0]))*24.0/wndfreq+1
!      call open_nc(ncid,filename,'r')
!      maxrec=get_dimension_len(ncid,'time')
!      if(rec>maxrec)then
!        write(6,*)'WND: ','maxrec,rec',maxrec,rec
!        rec=maxrec
!      endif
!      call readnc(ncid,'uwnd',ivar,rec);wu=ivar*0.003051944
!      call readnc(ncid,'vwnd',ivar,rec);wv=ivar*0.003051944
!      call close_nc(ncid)
!    endif
!    call irrp_scatter_force(fid,wu,lvar,root);windx=lvar
!    call irrp_scatter_force(fid,wv,lvar,root);windy=lvar
!  end subroutine read_wind_ccmp
!!#ifdef OLDWINDIN
#endif
#endif
!  ifndef NOWINDDATA
#ifndef NOICEDATA
!-------------------------------------------------------------------------------------------------
  subroutine set_uv(flag)
    integer,intent(in) :: flag
    if(flag==0)then
      ux=0.0;uy=0.0;uxx=0.0;uyx=0.0;uxy=0.0;uyy=0.0
    else
      ux=0.0;uy=0.0;uxx=0.0;uyx=0.0;uxy=0.0;uyy=0.0
    endif
  end subroutine set_uv
!-------------------------------------------------------------------------------------------------
#ifndef LGMTEST
  subroutine set_ice(flag)
    integer,intent(in) :: flag
    character(len=256) :: path,icefile='sea_ice_mask.nc'
    character(len=14) :: mname
    integer :: icerec,iceflag,idx
    integer,save :: current_ice_rec=0
    logical :: ext
    namelist/icenml/path,mname,iceflag
    if(flag==0)return
    if(ice_flag<0)return
    itime=datevec(dtime);icerec=itime(3)
    if(icerec/=current_ice_rec)then
      current_ice_rec=icerec
      path='/home/yinxq/asim/data/seaice/OSI-409/mask/mask'
      path='/home/yinxq/asim/data/seaice/OSI-409/mask/maskdfsdfs'
      mname='mask';iceflag=0 ! 0 for ice, else /=0 is for ice
      icefile=trim(path)//'/'//ctime(1:8)//'.nc'
      inquire(file=icefile,exist=ext)
      if(pid==0)write(*,*)'ice:',icerec,trim(icefile),ext
      if(ext)then
        call set_icemask
      else
        ice_flag=-1
      endif
    endif
    do idx=1,npc
      if(nsp(idx)==0)then
        ee(:,:,idx)=small;e(:,:,idx)=small
      endif
    enddo
    !-----------------------------------------------------------------
    contains
    !-----------------------------------------------------------------
    subroutine set_icemask
      integer :: ncid,root,i,j
      real(spdp),allocatable :: gvar1(:,:),lvar1(:)
      integer,allocatable :: mask(:,:)
      allocate(lvar1(0:np))
#ifdef USEPNETCDF
      call pnetcdf_read2dt_i2(icefile,mname,lvar1)
#else
      allocate(mask(im,jm),gvar1(im,jm))
      root=0
      if(pid==root)then
        call open_nc(ncid,icefile,'r')
        call readnc(ncid,mname,mask)
        call close_nc(ncid)
        gvar1=mask
      endif
      call irrp_scatter_ext(gvar1,lvar1,root);nsp(1:np)=lvar1(1:np)
      deallocate(mask,gvar1)
#endif
      if(iceflag==0)then
        do idx=1,npc
          if(nsp(idx)<2 .and. lvar1(idx)<=0)nsp(idx)=0
        enddo
      else
        do idx=1,npc
          if(nsp(idx)<2 .and. lvar1(idx)>0 .and. lvar1(idx)<1.e10)nsp(idx)=0
        enddo
      endif
      deallocate(lvar1)
    end subroutine set_icemask
  end subroutine set_ice
!-------------------------------------------------------------------------------------------------
  subroutine set_ice_mc(flag)
    integer,intent(in) :: flag
    character(len=256) :: icefile
    character(len=14) :: xname,yname,mname
    integer :: isize,jsize
    logical :: ext
    icefile='sea_ice_mask.nc'
    xname='lon';yname='lat';mname='mask'
    inquire(file=icefile,exist=ext)
    if(.not.ext)return
    if(flag==0)then
      current_month_ice=1;call set_icemask
    else
      itime=datevec(dtime)
      if(current_month_ice==itime(2))return
      current_month_ice=itime(2);call set_icemask
    endif
    contains
    subroutine set_icemask
      integer :: ncid,root
      integer,allocatable :: gvar1(:,:),lvar1(:)
      real(8),allocatable :: dlon(:),dlat(:),mask(:,:)
!      integer,allocatable :: icemask(:)
!      allocate(icemask(0:np))
      root=0
      if(pid==root)then
        write(*,*)trim(icefile),current_month_ice
        call open_nc(ncid,icefile,'r')
        if(.not.allocated(dlon))then
          isize=get_dimension_len(ncid,xname)
          jsize=get_dimension_len(ncid,yname)
          allocate(dlon(isize),dlat(jsize),mask(isize,jsize))
        endif
        call readnc(ncid,xname,dlon)
        call readnc(ncid,yname,dlat)
        call readnc(ncid,mname,mask,current_month_ice)
        call close_nc(ncid)
      else
        if(.not.allocated(dlon))then
          isize=1;jsize=1
          allocate(dlon(isize),dlat(jsize),mask(isize,jsize))
        endif
      endif
      allocate(gvar1(isize,jsize),lvar1(0:np))
      gvar1=mask
      call irrp_scatter_ext(gvar1,lvar1,root);nsp(1:np)=lvar1(1:np)
      deallocate(dlon,dlat,mask,gvar1,lvar1)
    end subroutine set_icemask
  end subroutine set_ice_mc
!-------------------------------------------------------------------------------------------------
!!#ifndef LGMTEST
#else
  subroutine set_ice(flag)
    integer,intent(in) :: flag
    character(len=256) :: icefile='sea_ice_mask.nc'
    character(len=14) :: mname
    integer :: icerec,idx
    logical :: ext
    if(flag==0)return
    itime=datevec(dtime);icerec=(itime(1)-1)*12+itime(2)
    icerec=mod(icerec,120);if(icerec<1)icerec=1
    if(icerec/=current_month_ice)then
      inquire(file=icefile,exist=ext)
      if(pid==0)then
        write(*,*)'ice:',icerec,current_month_ice,ext
      endif
      mname='aice' !mname='mask'
      if(ext)call set_icemask
    endif
    do idx=1,npc
      if(nsp(idx)==0)then
        ee(:,:,idx)=small;e(:,:,idx)=small
      endif
    enddo
    !-----------------------------------------------------------------
    contains
    !-----------------------------------------------------------------
    subroutine set_icemask
      integer :: ncid,root,i,j
      real(spdp),allocatable :: gvar1(:,:),lvar1(:)
      real(4),allocatable :: mask(:,:)
      current_month_ice=icerec;root=0
      allocate(lvar1(0:np))
#ifdef USEPNETCDF
      call pnetcdf_read2dt_r4(icefile,mname,lvar1,current_month_ice)
#else
      allocate(mask(im,jm),gvar1(im,jm))
      if(pid==root)then
        write(*,*)trim(icefile),current_month_ice
        call open_nc(ncid,icefile,'r')
        call readnc(ncid,mname,mask,current_month_ice);gvar1=mask
        call close_nc(ncid)
      endif
      call irrp_scatter_ext(gvar1,lvar1,root);
      deallocate(mask,gvar1)
#endif
      do idx=1,npc
        if(lvar1(idx)>0 .and. lvar1(idx)<1.e10)nsp(idx)=0
      enddo
      deallocate(lvar1)
    end subroutine set_icemask
  end subroutine set_ice
!-------------------------------------------------------------------------------------------------
!!#ifndef LGMTEST  else
#endif
!  ifndef NOICEDATA
#endif
!-------------------------------------------------------------------------------------------------
  subroutine intact_mixture
    integer :: kh,k,k1,i,i1,j,idx
    real(spdp) :: dwkk,wsk,wkk,theta0,sinth,costh,ekj,ekj1,bv1,bv2,bv3,tmpewzk,t1,t2,t3,t4,dep1
    taubb11=0.e0;taubb12=0.e0;taubb22=0.e0;taubb33=0.e0;bv=0.e0
    do kh=1,kb
      dep1=-abs(zyyz(kh))
      do idx=1,npc
        if(nsp(idx)==0)cycle
        t1=0.e0;t2=0.e0;t3=0.e0;t4=0.e0;bv1=0.e0;bv2=0.e0;bv3=0.e0
        if(abs(dep1)>d(idx))cycle
        do k=1,kld
          k1=k+1;i=k-kl+1;i1=i+1
          dwkk=dwk(k);wsk=zpi*wf(k,idx);wkk=wk(k)
          do j=1,jl
            theta0=thet(j);sinth=sin(theta0);costh=cos(theta0)
            if (k.lt.kl) then
              ekj=ea(k,j,idx);ekj1=ea(k1,j,idx)
            else
              ekj=ea(kl,j,idx)*wkh(i);ekj1=ea(kl,j,idx)*wkh(i1)
            endif
            tmpewzk=(ekj+ekj1)*exp(2*wkk*dep1)*dwkk
            t1=t1-wsk**2*costh**2   *tmpewzk
            t2=t2-wsk**2*sinth*costh*tmpewzk
            t3=t3-wsk**2*sinth**2   *tmpewzk
            t4=t4-wsk**2            *tmpewzk
            bv1=bv1                 +tmpewzk
            bv2=bv2+wsk**2          *tmpewzk
            bv3=bv3+wkk*wsk**2      *tmpewzk
          enddo
        enddo
        taubb11(kh,idx)=t1
        taubb12(kh,idx)=t2
        taubb22(kh,idx)=t3
        taubb33(kh,idx)=t4
        bv(kh,idx)=bv1/sqrt(bv2)*bv3
      enddo
    enddo
  end subroutine intact_mixture
!-------------------------------------------------------------------------------------------------
  subroutine intact_mixture_sigma
    integer :: kh,k,k1,i,i1,j,idx
    real(spdp) :: dwkk,wsk,wkk,theta0,sinth,costh,ekj,ekj1,bv1,bv2,bv3,tmpewzk,t1,t2,t3,t4,dep1
    taubb11=0.e0;taubb12=0.e0;taubb22=0.e0;taubb33=0.e0;bv=0.e0
    do kh=1,kb
      do idx=1,np
        if(nsp(idx)==0)cycle
        dep1=-abs(h3(kh,idx))
        if(abs(dep1)>d(idx))cycle
        t1=0.e0;t2=0.e0;t3=0.e0;t4=0.e0;bv1=0.e0;bv2=0.e0;bv3=0.e0
        do k=1,kld
          k1=k+1;i=k-kl+1;i1=i+1
          dwkk=dwk(k);wsk=zpi*wf(k,idx);wkk=wk(k)
          do j=1,jl
            theta0=thet(j);sinth=sin(theta0);costh=cos(theta0)
            if (k.lt.kl)then
              ekj=ea(k,j,idx);ekj1=ea(k1,j,idx)
            else
              ekj=ea(kl,j,idx)*wkh(i);ekj1=ea(kl,j,idx)*wkh(i1)
            endif
            tmpewzk=(ekj+ekj1)*exp(2*wkk*dep1)*dwkk
#ifndef DOGFSForecast
            t1=t1-wsk**2*costh**2   *tmpewzk
            t2=t2-wsk**2*sinth*costh*tmpewzk
            t3=t3-wsk**2*sinth**2   *tmpewzk
            t4=t4-wsk**2            *tmpewzk
#endif
            bv1=bv1                 +tmpewzk
            bv2=bv2+wsk**2          *tmpewzk
            bv3=bv3+wkk*wsk**2      *tmpewzk
          enddo
        enddo
#ifndef DOGFSForecast
        taubb11(kh,idx)=t1
        taubb12(kh,idx)=t2
        taubb22(kh,idx)=t3
        taubb33(kh,idx)=t4
#endif
        bv(kh,idx)=bv1/sqrt(bv2)*bv3
      enddo
    enddo
  end subroutine intact_mixture_sigma
!-------------------------------------------------------------------------------------------------
  subroutine outmixingbv
    call mixingbv_init
    if(iciofreq<=0)return
    if(iciocount<iciofreq)then
      ea=ea+ee;iciocount=iciocount+1
    endif
    if(iciocount==iciofreq)then
      ea=ea/float(iciofreq)
      call intact_mixture_sigma
      call outputmix
      ea=0.e0;iciocount=0
    endif
  end subroutine outmixingbv
!-------------------------------------------------------------------------------------------------
  subroutine outputmix
    character(len=14) :: ctime
    character(len=300) :: filename
    integer :: ncid,i,j
    root=0
    if(root==pid)then
      ctime=datestr(dtime-ciofreqbyday+delttm/1440.d0)
      !filename=trim(title)//'_mix_'//ctime(1:8)//'.nc'
#ifdef DOGFSForecast
      !filename=trim(mixpath)//trim(title)//'_bv_'//ctime(1:10)//'.nc'
      filename=trim(mixpath)//trim(title)//'.bv.'//ctime(1:10)//'.nc'
      !filename=trim(mixpath)//'bv.'//ctime(1:10)//'.nc'
      write(*,*)trim(filename)
#else
      filename=trim(mixpath)//trim(title)//'_mix_'//ctime(1:10)//'.nc'
#endif
      call open_nc(ncid,filename,'c')
      call dimension_define(ncid,'lon',im,'lon',nf_real)
      call dimension_define(ncid,'lat',jm,'lat',nf_real)
      call dimension_define(ncid,'lay',kb,'lay',nf_real)
      call set_attribute(ncid,'units','degrees_north','lat')
      call set_attribute(ncid,'units','degrees_east','lon')
      call set_attribute(ncid,'modulo','','lon')
      call variable_define(ncid,'bv',nf_real,['lon','lat','lay'])
#ifndef DOGFSForecast
      call variable_define(ncid,'tau11',nf_real,['lon','lat','lay'])
      call variable_define(ncid,'tau12',nf_real,['lon','lat','lay'])
      call variable_define(ncid,'tau22',nf_real,['lon','lat','lay'])
      call variable_define(ncid,'tau33',nf_real,['lon','lat','lay'])
#endif
      call end_define(ncid)
      call writenc(ncid,'lon',lon)
      call writenc(ncid,'lat',lat)
      call writenc(ncid,'lay',lay)
      call close_nc(ncid)
    endif
    do k=1,kb
#ifndef DOGFSForecast
      call irrp_gather(taubb11,gvar1,kb,k,root)
      if(pid==root)then
        gvar(:,:,1)=gvar1(:,:)
        call open_nc(ncid,filename,'w')
        call writenc(ncid,'tau11',gvar,locs=[1,1,k])
        call close_nc(ncid)
      endif
      call irrp_gather(taubb12,gvar1,kb,k,root)
      if(pid==root)then
        gvar(:,:,1)=gvar1(:,:)
        call open_nc(ncid,filename,'w')
        call writenc(ncid,'tau12',gvar,locs=[1,1,k])
        call close_nc(ncid)
      endif
      call irrp_gather(taubb22,gvar1,kb,k,root)
      if(pid==root)then
        gvar(:,:,1)=gvar1(:,:)
        call open_nc(ncid,filename,'w')
        call writenc(ncid,'tau22',gvar,locs=[1,1,k])
        call close_nc(ncid)
      endif
      call irrp_gather(taubb33,gvar1,kb,k,root)
      if(pid==root)then
        gvar(:,:,1)=gvar1(:,:)
        call open_nc(ncid,filename,'w')
        call writenc(ncid,'tau33',gvar,locs=[1,1,k])
        call close_nc(ncid)
      endif
#endif
      ulvar=bv(k,:);call irrp_gather(ulvar,gvar1,root)
      if(pid==root)then
        do j=1,jm
          do i=1,im
            if(mask(i,j)>0)then
              gvar(i,j,k)=gvar1(i,j)
            else
              gvar(i,j,k)=0.e0
            endif
          enddo
        enddo
      endif
    enddo
    if(pid==root)then
      call open_nc(ncid,filename,'w')
      call writenc(ncid,'bv',gvar)
      call close_nc(ncid)
    endif
  end subroutine outputmix

#ifdef USEPNETCDF
  subroutine pnetcdf_write4d(filename,var_in,var_out)
    use pnetcdf
    character(len=*),intent(in) :: var_out
    character(len=*),intent(in) :: filename
    real(spdp), intent(in) :: var_in(kb,0:np)
    integer :: status,vid,i,ncid,llen,rlen,ulen,dlen
    integer :: rect(4),rstart,rend,lstart,lend,ustart,uend,dstart,dend
    real(8), allocatable:: Cvar3d(:,:,:) ,Lvar3d(:,:,:),Rvar3d(:,:,:),Uvar3d(:,:,:),Dvar3d(:,:,:)
    integer(kind=8) :: Cstarts3d(3),Lstarts3d(3),Rstarts3d(3),Ustarts3d(3),Dstarts3d(3)
    integer(kind=8) :: Ccounts3d(3),Lcounts3d(3),Rcounts3d(3),Ucounts3d(3),Dcounts3d(3)
    call irrp_getrects(rect) ! [imin,jmin,imax,jmax]
    rstart=jm;rend=1;lstart=jm;lend=1;ustart=im;uend=1;dstart=im;dend=1
    llen=0;rlen=0;ulen=0;dlen=0
    do i=1,npc
      if(pnb(i)%i==rect(1))then
        lstart=min(lstart,pnb(i)%j);lend=max(lend,pnb(i)%j);llen=llen+1
      endif
      if(pnb(i)%i==rect(3))then
        rstart=min(rstart,pnb(i)%j);rend=max(rend,pnb(i)%j);rlen=rlen+1
      endif
      if(pnb(i)%j==rect(4))then
        ustart=min(ustart,pnb(i)%i);uend=max(uend,pnb(i)%i);ulen=ulen+1
      endif
      if(pnb(i)%j==rect(2))then
        dstart=min(dstart,pnb(i)%i);dend=max(dend,pnb(i)%i);dlen=dlen+1
      endif
    enddo
    Cstarts3d=[rect(1)+1,rect(2)+1,1];Ccounts3d=[rect(3)-rect(1)-1,rect(4)-rect(2)-1,kb]
    Ustarts3d=[ustart,rect(4),1];     Ucounts3d=[ulen,1,kb]
    Dstarts3d=[dstart,rect(2),1];     Dcounts3d=[dlen,1,kb]
    Lstarts3d=[rect(1),lstart,1];     Lcounts3d=[1,llen,kb]
    Rstarts3d=[rect(3),rstart,1];     Rcounts3d=[1,rlen,kb]
    allocate(Cvar3d((rect(1)+1):(rect(3)-1),(rect(2)+1):(rect(4)-1),kb));Cvar3d=NF90_FILL_float
    allocate(Rvar3d(1,rstart:rend,kb));Rvar3d=NF90_FILL_float
    allocate(Lvar3d(1,lstart:lend,kb));Lvar3d=NF90_FILL_float
    allocate(Dvar3d(dstart:dend,1,kb));Dvar3d=NF90_FILL_float
    allocate(Uvar3d(ustart:uend,1,kb));Uvar3d=NF90_FILL_float
    do i=1,npc
      if(pnb(i)%i==rect(1))then
        Lvar3d(1,pnb(i)%j,:)=var_in(:,i)
      elseif(pnb(i)%i==rect(3))then
        Rvar3d(1,pnb(i)%j,:)=var_in(:,i)
      elseif(pnb(i)%j==rect(4))then
        Uvar3d(pnb(i)%i,1,:)=var_in(:,i)
      elseif(pnb(i)%j==rect(2))then
        Dvar3d(pnb(i)%i,1,:)=var_in(:,i)
      else
        Cvar3d(pnb(i)%i,pnb(i)%j,:)=var_in(:,i)
      endif
    enddo
    status=nf90mpi_open(mpi_comm,filename,NF_WRITE,MPI_INFO_NULL,ncid)
    status=nf90mpi_inq_varid(ncid,var_out,vid)
    status=nf90mpi_put_var_all(ncid,vid,Cvar3d,Cstarts3d,Ccounts3d)
    if(Lcounts3d(2)/=0)status=nf90mpi_put_var_all(ncid,vid,Lvar3d,Lstarts3d,Lcounts3d)
    if(Rcounts3d(2)/=0)status=nf90mpi_put_var_all(ncid,vid,Rvar3d,Rstarts3d,Rcounts3d)
    if(Ucounts3d(1)/=0)status=nf90mpi_put_var_all(ncid,vid,Uvar3d,Ustarts3d,Ucounts3d)
    if(Dcounts3d(1)/=0)status=nf90mpi_put_var_all(ncid,vid,Dvar3d,Dstarts3d,Dcounts3d)
    status=nf90mpi_close(ncid)
    if(allocated(Cvar3d))deallocate(Cvar3d)
    if(allocated(Lvar3d))deallocate(Lvar3d)
    if(allocated(Rvar3d))deallocate(Rvar3d)
    if(allocated(Uvar3d))deallocate(Uvar3d)
    if(allocated(Dvar3d))deallocate(Dvar3d)
  end subroutine pnetcdf_write4d
#endif

!-------------------------------------------------------------------------------------------------
  subroutine mixingbv_init
    integer :: ncid,k,lsize,itypezcord=-1,root=0
    type(mpipacket) :: pk
    real(spdp),allocatable :: zyyz(:)
    real(spdp) :: hc
    integer :: Vtransform,idx
    !-------------------------------
    !if(iciofreq<=0)return
    if(iciofreq/=0)return
    if(pid==root)then
      call setzyyz
      call packbcastdata(0)
    endif
    call packbcastdata(1)
    if(kb==0)then
      iciofreq=-1
      return
    endif
    !-------------------------------
    allocate(gvar(im,jm,kb),gvar1(im,jm))
    if(.not.allocated(ulvar))allocate(ulvar(0:np))
    allocate(taubb11(kb,0:np),taubb12(kb,0:np),taubb22(kb,0:np),taubb33(kb,0:np),bv(kb,0:np))
    allocate(h3(kb,0:np),lay(kb),ea(kl,jl,0:np))
    !-------------------------------
    if(itypezcord==0)then     ! Z-Coordernate
      do k=1,kb
        lay(k)=zyyz(k)
        h3(k,:)=zyyz(k)
      enddo
    elseif(itypezcord==1)then ! Sigma-Coordernate
      do k=1,kb
        lay(k)=zyyz(k)
        h3(k,:)=d(:)*zyyz(k)
      enddo
    elseif(itypezcord==2)then ! S-Coordernate
      do idx=1,np
        call s2z(kb,zyyz,Cs_r,hc,d(idx),0.0_spdp,Vtransform,h3(:,idx))
      enddo

      !do k=1,kb
      !  lay(k)=zyyz(k)
      !  h3(k,:)=d(:)*zyyz(k)
      !enddo
    endif
    !-------------------------------
    iciofreq=ciofreq*60./delttm
    ciofreqbyday=ciofreq/24.d0  ! ciofreq in days, used for output.
    ea=0.e0;iciocount=0
    !-------------------------------
    return
    !if(pid==root)call open_nc(ncid,topo_file,'r')
    !do k=1,kb
    !  if(pid==root)then
    !    call readnc(ncid,'h3',gvar,locs=[1,1,k])
    !    gvar1(:,:)=gvar(:,:,1)
    !  endif
    !  call irrp_scatter_ext(gvar1,h3,kb,k,root)
    !  lay(k)=k
    !enddo
    !if(pid==root)call close_nc(ncid)
    !ea=0.e0;iciocount=0
    !ciofreqbyday=ciofreq/48.d0  ! for middle of average.
    !-------------------------------
    !---------------------------------------------------------------------------------------------
    contains
    !---------------------------------------------------------------------------------------------
    subroutine setzyyz
#ifdef TEST2017
      integer,parameter :: kb1=50
#else
      integer,parameter :: kb1=40
#endif
      real(spdp) :: zscal,zt(200)=0.,zt1(200)
      integer :: ierr
      namelist/bvinf/mixpath,ciofreq,kb,itypezcord,zscal,zt,zt1,Vtransform,hc
      kb=kb1;itypezcord=-1;mixpath=''
      !-------------------------------------------------------------------------------------------
      !open(11,file='ctlparams',delim='quote');read(11,nml=bvinf,iostat=ierr);close(11)
      !if(ierr/=0)kb=0
      open(11,file='ctlparams',delim='quote')
      read(11,nml=bvinf,iostat=ierr)
      close(11)
      if(ierr/=0)kb=0
      write(*,nml=bvinf)
      if(kb<1)return
      allocate(zyyz(kb))
      zyyz(1:kb)=zt(1:kb)*zscal
      if(itypezcord==2)then
        allocate(Cs_r(kb))
        ! zyyz:=sc_r
        Cs_r(1:kb)=zt1(1:kb)
      endif
      !-------------------------------------------------------------------------------------------
      !      if(itypezcord<0)then
      !        itypezcord=1;allocate(zyyz(kb))
      !#ifdef TEST2017
      !        ! --- Set for zyyz which is levels for BV.
      !        !zyyz=[1., 3.098493, 5.871948, 9.441639, 14.24002, 20.19016, 27.4915,           &
      !        !      35.82209, 45.14835, 54.95014, 65.04986, 74.95014, 85.04986, 94.95014,    &
      !        !      105.0499, 114.9501, 125.0499, 134.9501, 145.0499, 154.9501, 165.0499,    &
      !        !      174.9501, 185.0499, 194.9501, 205.0499, 214.9501, 225.0499, 235.512,     &
      !        !      250.0959, 269.4701, 297.2818, 334.0331, 383.1529, 444.8752, 522.3149,    &
      !        !      615.3498, 726.701, 855.82, 1004.974, 1173.139, 1362.092, 1570.307,       &
      !        !      1799.058, 2046.32, 2312.874, 2596.219, 2896.685, 3211.343, 3540.129,     &
      !        !      3879.758, 4229.851, 4586.858, 4950.179, 5316.097 ]
      !        !zyyz=[10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200,210,220,  &
      !        !      230.2809,242.804,259.783,283.3759,315.6575,358.593,414.0141,483.5951,568.8323,   &
      !        !      671.0254,791.2605,930.397,1089.057,1267.615,1466.199,1684.683,1922.689,2179.597, &
      !        !      2454.547,2746.452,3054.014,3375.736,3709.943,4054.804,4408.354,4768.518,5133.138,&
      !        !      5500 ]
      !        zyyz=[10.,20.,30.,40.,50.,60.,70.,80.,90.,100.,110.,120.,130.,140.,150.,160.,170.,180.,&
      !             190.,200.,210.,220.,230.2809,242.804,259.783,283.3759,315.6575,358.593,414.0141,  &
      !             483.5951,568.8323,671.0254,791.2605,930.397,1089.057,1267.615,1466.199,1684.683,  &
      !             1922.689,2179.597,2454.547,2746.452,3054.014,3375.736,3709.943,4054.804,4408.354, &
      !             4768.518,5133.138,5500.]
      !#else
      !        ! --- Set for zyyz which is levels for BV.
      !        zyyz=[0.,2.5,5.,7.5,10.,15.,20.,25.,30.,35.,40.,45.,50.,60.,70.,80.,90.,100.,&
      !              110.,120.,130.,140.,150.,160.,170.,180.,190.,200.,225.,250.,275.,300., &
      !              325.,350.,375.,400.,450.,500.,750.,1000.]
      !#endif
      !      endif
      !-------------------------------------------------------------------------------------------
    end subroutine setzyyz
    !---------------------------------------------------------------------------------------------
    subroutine packbcastdata(act)
      integer,intent(in) :: act
      if(act==0)then
        lsize=(kb*8+250)
        call InitMpiPacket(pk,lsize)
      else
        call bcast_packet(pk,root,pid,mpi_comm)
      endif
      call irrp_pget_mpipacket(pk,mixpath,200,mpi_comm,act)
      call irrp_pget_mpipacket(pk,ciofreq,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,itypezcord,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,kb,1,mpi_comm,act)
      if(kb>0)then
        if(.not. allocated(zyyz))allocate(zyyz(kb))
        call irrp_pget_mpipacket(pk,zyyz,kb,mpi_comm,act)
        if(itypezcord==2)then
          if(.not. allocated(Cs_r))allocate(Cs_r(kb))
          call irrp_pget_mpipacket(pk,Cs_r,kb,mpi_comm,act)
          call irrp_pget_mpipacket(pk,Vtransform,1,mpi_comm,act)
          call irrp_pget_mpipacket(pk,hc,1,mpi_comm,act)
        endif
      endif
      if(act>0)call FinalMpiPacket(pk)
    end subroutine packbcastdata
    !---------------------------------------------------------------------------------------------
    subroutine s2z(N,sc_r,Cs_r,hc,h,zeta,Vtransform,z)
      implicit none
      integer,intent(in) :: N            ! Vertical layers
      integer,intent(in) :: Vtransform   ! Form of vertical cood
      real(spdp),intent(in) :: sc_r(N)      ! 
      real(spdp),intent(in) :: Cs_r(N)
      real(spdp),intent(in) :: hc
      real(spdp),intent(in) :: h
      real(spdp),intent(in) :: zeta
      real(spdp),intent(out) :: z(N)
      real(8) :: z0(N)
      if (Vtransform == 1) then
        z0(:)=(sc_r(:)-Cs_r(:))*hc + Cs_r(:)*h
        z(:)=z0(:) + zeta*(1.0 + z0(:)/h)
      endif
      if (Vtransform == 2) then
        z0(:)=(hc*sc_r(:)+Cs_r(:)*h)/(hc+h)
        z(:)=zeta+(zeta+h)*z0(:)
      endif
    end subroutine s2z
  end subroutine mixingbv_init
!-------------------------------------------------------------------------------------------------
  end module wamcpl_mod
!-------------------------------------------------------------------------------------------------

