#define DBG  print*, pid ,__FILE__, __LINE__
!#################################################################################################
!-------------------------------------------------------------------------------------------------
  module partctl_mod
  use irrp_smpi_mod;use irrp_package_mod;use netcdf_mod
  implicit none
!-------------------------------------------------------------------------------------------------
  public :: mpi_comm,root,pid,gnpc,npe,nb8,plist,lon,lat,mask,partctl_init,partctl_final
  public :: im,jm,npc,np
  private
  
  integer :: root=0
  integer :: gnpc,npe,pid,mpi_comm
  type(nb_8pnts_def_type),pointer :: nb8(:)=>null()      ! (0:np)
  type(pi_pos_type      ),pointer :: plist(:)=>null()    ! (0:np)
!-------------------------------------------------------------------------------------------------
  integer :: im,jm,npc,np
  real(4),allocatable :: lon(:),lat(:)
  integer,allocatable :: mask(:,:)
!-------------------------------------------------------------------------------------------------
  contains
!-------------------------------------------------------------------------------------------------
  subroutine partctl_init
    integer :: ierr,root
    type(mpipacket) :: pk
    integer :: lsize,ncid,i,j,globalflag
    logical :: ext,inited
    character(len=200) :: topo_file
    character(len=20) :: xvar,yvar,mvar
    namelist/pctnml/topo_file,xvar,yvar,mvar
    !------------------------------------------------------------------------------
    ! --- Initialize for MPI.
    call MPI_INITIALIZED(inited,ierr)
    if(.not. inited)call MPI_INIT(ierr)
    mpi_comm = MPI_COMM_WORLD
    call MPI_COMM_RANK(mpi_comm,pid,ierr)
    call MPI_COMM_SIZE(mpi_comm,npe,ierr)
    !------------------------------------------------------------------------------
    root=0
    if(pid == root)then
      open(11,file='ctlparams',delim='quote'); read(11,nml=pctnml); close(11)
      inquire(file=topo_file,exist=ext)
      if(.not. ext)call pretopo_interp
      call open_nc(ncid,topo_file,'r')
      im=get_dimension_len(ncid,xvar)
      jm=get_dimension_len(ncid,yvar)
!      kb=get_dimension_len(ncid,'zyyz') yinxq 20180104
!      if(ciofreq>0)kb=get_dimension_len(ncid,'lay')
      allocate(mask(im,jm),lon(im),lat(jm))
      call readnc(ncid,xvar,lon)
      call readnc(ncid,yvar,lat)
      call readnc(ncid,mvar,mask)
      call close_nc(ncid)
      do j=1,jm
        do i=1,im
          if(mask(i,j)>0)mask(i,j)=1
        enddo
      enddo
      !mask(:,jm-5:jm)=0; !mask(:,jm-1)=0
      call packbcastdata(0)
    endif
    call packbcastdata(1)
    !------------------------------------------------------------------------------
    !globalflag=0;if(lon(2)+lon(im)-2*lon(1)-360 >=0)globalflag=1
    globalflag=0
    if(abs(lon(2)+lon(im)-2*lon(1)-360)<=1.e-6)globalflag=1
    if(abs(lon(2)+lon(im)-2*lon(1))<=1.e-6)globalflag=1
    !------------------------------------------------------------------------------
    call irrp_init(0,npe,pid,mpi_comm,mask,1,globalflag)  ! global?
    call irrp_SetPartSerial(gnpc,npc,np,plist,nb8,0)
!    if(pid==0)then
!      do i=npc,np
!        write(*,*)plist(i)%i,plist(nb8(i)%l)%i
!      enddo
!    endif    
    !------------------------------------------------------------------------------
    contains
    !------------------------------------------------------------------------------
    subroutine packbcastdata(act)
      integer,intent(in) :: act
      if(act==0)then
        lsize=(im*jm*8*2+200)
        call InitMpiPacket(pk,lsize)
      else
        call bcast_packet(pk,root,pid,mpi_comm)
      endif
      call irrp_pget_mpipacket(pk,im,1,mpi_comm,act)
      call irrp_pget_mpipacket(pk,jm,1,mpi_comm,act)
      !call irrp_pget_mpipacket(pk,kb,1,mpi_comm,act) yinxq 20180104
      if(.not. allocated(mask))allocate(mask(im,jm),lon(im),lat(jm))
      call irrp_pget_mpipacket(pk,mask,im*jm,mpi_comm,act)
      call irrp_pget_mpipacket(pk,lon,im,mpi_comm,act)
      call irrp_pget_mpipacket(pk,lat,jm,mpi_comm,act)
      if(act>0)then
        call FinalMpiPacket(pk)
      endif
    end subroutine packbcastdata
    !------------------------------------------------------------------------------
  end subroutine partctl_init
!-------------------------------------------------------------------------------------------------
  subroutine partctl_final
    integer :: rc
    if(associated(nb8))then;deallocate(nb8); nullify(nb8);endif
    if(associated(plist))then;deallocate(plist); nullify(plist);endif
    call MPI_FINALIZE(rc)
  end subroutine partctl_final
!-------------------------------------------------------------------------------------------------
  subroutine pretopo_interp
    character(len=100) :: filename
    integer :: im,jm,ncid,i,j,i1,i2,j1,j2,ixs,ixl,iys,iyl,gflag_
    real(4) :: dtlon,dtlat,xx,yy,tlon1,tlat1
    real(4),allocatable :: tlon(:),tlat(:),etopo(:,:)
    integer,allocatable :: iv(:,:)
    integer :: gdxdyflag
    real(4) :: gdx,gdy,lon1,lon2,lat1,lat2
    real(4) :: ax,ay
    real(4),allocatable :: x(:),y(:),d(:,:)
    namelist/toponml/filename,gdxdyflag,gdx,gdy,lon1,lon2,lat1,lat2
    !---------------------------------------------------------------------------
    ! --- Prepare model grids.
    !---------------------------------------------------------------------------
    ! gdxdyflag :=  Dividing method for resulotion, gdxdyflag=0 is default and 
    !               (gdx,gdy) will be used for dividing. Otherwise, (1/gdx,1/gdy) 
    !               will be use for dividing.
    ! gdx,gdy   := Increaments in longitude & latitude.
    ! lon1,lon2 := Boundary of longitude, 0-360 means global.
    ! lat1,lat2 := Boundary of latitude. 
    ! filename  := File name of origional topography.
    !---------------------------------------------------------------------------
    gdxdyflag=0;gdx=1;gdy=1;lon1=0;lon2=360;lat1=-80;lat2=65
    open(11,file='ctlparams',delim='quote');read(11,nml=toponml);close(11);write(*,nml=toponml)
    !---------------------------------------------
    ! --- Readin origional topography.
    call open_nc(ncid,filename,'r')
    im=get_dimension_len(ncid,'lon')
    jm=get_dimension_len(ncid,'lat')
    allocate(tlon(im),tlat(jm),etopo(im,jm),iv(im,jm))
    call readnc(ncid,'lon',tlon)
    call readnc(ncid,'lat',tlat)
    call readnc(ncid,'etop5',iv);etopo=iv
    call close_nc(ncid)
    dtlon=tlon(2)-tlon(1);tlon1=tlon(1);dtlat=tlat(2)-tlat(1);tlat1=tlat(1)
    !---------------------------------------------
    ! --- Calculate parameters.
    if(gdxdyflag/=0)then;gdx=1./gdx;gdy=1./gdy;endif
    ixs=1;ixl=nint((lon2-lon1)/gdx)+1
    iys=1;iyl=nint((lat2-lat1)/gdy)+1
    ! For global case, there is no overlaped grid is used.
    gflag_=0
    if(abs(lon2-lon1-360)<1.e-6)then
      ixl=ixl-1 ;gflag_=1
    endif
!    write(*,*)ixl,iyl
    !---------------------------------------------
    ! --- Readin origional topography.
    allocate(x(ixl),y(iyl),d(ixl,iyl))
    x=(/((lon1+(i-1)*gdx),i=ixs,ixl)/)
    y=(/((lat1+(i-1)*gdy),i=iys,iyl)/)
    do j=iys,iyl
      do i=ixs,ixl
        xx=x(i);yy=y(j)
        i1=int((xx-tlon1)/dtlon)+1
        i2=i1+1;if(i1==im)i2=1
        j1=int((yy-tlat1)/dtlat)+1;if(j1<0)j1=1
        j2=j1+1;if(j1>=jm)j2=jm
        ax=(dtlon-getdist(xx,tlon1,dtlon))/dtlon;
        ay=(dtlat-getdist(yy,tlat1,dtlat))/dtlat
        d(i,j)=etopo(i1,j1)*(  ax)*ay+etopo(i1,j2)*(  ax)*(1-ay) &
              +etopo(i2,j1)*(1-ax)*ay+etopo(i2,j2)*(1-ax)*(1-ay)

        if(abs(yy)>70)d(i,j)=0.0      
      enddo
    enddo
    d=0-d
    call outwamset(ixl,iyl,x,y,d,gflag_)
    deallocate(tlon,tlat,etopo,iv,x,y,d)
    !---------------------------------------------------------------------------------------------
    contains
    !---------------------------------------------------------------------------------------------
    real(4) function getdist(xx,x0,dx)
      real(4),intent(in) :: xx,x0,dx
      getdist=xx-x0-int((xx-x0)/dx)*dx
    end function getdist
   !---------------------------------------------
    subroutine outwamset(ixl,iyl,x,y,d,gflag_)
      integer,intent(in) :: ixl,iyl
      real(4),intent(in) :: x(ixl),y(iyl)
      real(4),intent(inout) :: d(ixl,iyl)
      integer,optional :: gflag_
      real(4) :: nsp(ixl,iyl),a
      integer :: i,j,k,gflag,ncid
      !integer,parameter :: kb=40
      !real(4) :: zyyz(kb)
      real(4),allocatable :: alon(:,:),alat(:,:)
      allocate(alon(ixl,iyl),alat(ixl,iyl))
      nsp=1
      do j=1,iyl
        do i=1,ixl
          if(d(i,j)<=0.1)then
            d(i,j)=0;nsp(i,j)=0
          endif
          alon(i,j)=x(i);alat(i,j)=y(j)
        enddo
      enddo
      ! --- Check for isolated points.
      do k=1,5
        do j=1,iyl
          do i=1,ixl
            if(nsp(i,j)==0)cycle;a=0
            a=0;if(nsp(i,j)==0)cycle
            if(i/=1)a=a+nsp(i-1,j)
            if(i/=ixl)a=a+nsp(i+1,j)
            if(j/=1)a=a+nsp(i,j-1)
            if(j/=1)a=a+nsp(i,j-1)
            if(j/=iyl)a=a+nsp(i,j+1)
            !          if(i/=1 .and. j/=1 .and. i/=ixl .and. j/=iyl)then
            !            a=nsp(i-1,j)+nsp(i+1,j)+nsp(i,j-1)+nsp(i,j+1)
            !          elseif(i==1 .and. j/=1 .and. i/=ixl .and. j/=iyl)then
            !            a=nsp(i+1,j)+nsp(i,j-1)+nsp(i,j+1)
            !          elseif(i/=1 .and. j==1 .and. i/=ixl .and. j/=iyl)then
            !            a=nsp(i-1,j)+nsp(i+1,j)+nsp(i,j+1)
            !          elseif(i/=1 .and. j/=1 .and. i==ixl .and. j/=iyl)then
            !            a=nsp(i-1,j)+nsp(i,j-1)+nsp(i,j+1)
            !          elseif(i/=1 .and. j/=1 .and. i/=ixl .and. j==iyl)then
            !            a=nsp(i-1,j)+nsp(i+1,j)+nsp(i,j-1)
            !          endif
            if(a<=1)then
              nsp(i,j)=0;d(i,j)=0
            endif
          enddo
        enddo
      enddo
      ! --- Check for open boundaries.
      if(present(gflag_))then
        gflag=gflag_
      else
        gflag=0;
        if(abs((x(2)-x(1))-(x(1)+360-x(ixl)))<1.e-6)gflag=1
        if(abs((x(2)-x(1))-(x(2)+360-x(ixl)))<1.e-6)gflag=1
      endif
      if(gflag==0)then
        do j=1,iyl
          i=1;if(nsp(i,j)==1)nsp(i,j)=2
          i=ixl;if(nsp(i,j)==1)nsp(i,j)=2
        enddo
      endif
        do i=1,ixl
          j=1;if(nsp(i,j)==1)nsp(i,j)=2
          j=iyl;if(nsp(i,j)==1)nsp(i,j)=2
        enddo
  !    endif
      ! --- Set for zyyz which is levels for BV.
      !zyyz=[0.,2.5,5.,7.5,10.,15.,20.,25.,30.,35.,40.,45.,50.,60.,70.,80.,90.,100.,&
      !      110.,120.,130.,140.,150.,160.,170.,180.,190.,200.,225.,250.,275.,300., &
      !      325.,350.,375.,400.,450.,500.,750.,1000.]
      ! --- Output model setting.    
      call open_nc(ncid,'wamyyz.nc','c')
      call dimension_define(ncid,'lon',ixl,'lon',nf_real)
      call dimension_define(ncid,'lat',iyl,'lat',nf_real)
      !call dimension_define(ncid,'zyyz',kb,'zyyz',nf_real)
      call variable_define(ncid,'depyyz',nf_real,['lon','lat'])
      call variable_define(ncid,'nspyyz',nf_int,['lon','lat'])
      call set_attribute(ncid,'missing_value',0.0,'depyyz')
      call set_attribute(ncid,'missing_value',0.0,'nspyyz')
      call set_attribute(ncid,'units','degrees_north','lat')
      call set_attribute(ncid,'units','degrees_east','lon')
      call set_attribute(ncid,'modulo','','lon')
      call variable_define(ncid,'alon',nf_real,['lon','lat'])
      call variable_define(ncid,'alat',nf_real,['lon','lat'])
      call end_define(ncid)
      call writenc(ncid,'lon',x)
      call writenc(ncid,'lat',y)
      !call writenc(ncid,'zyyz',zyyz)
      call writenc(ncid,'depyyz',d)
      call writenc(ncid,'nspyyz',nsp)
      call writenc(ncid,'alon',alon)
      call writenc(ncid,'alat',alat)
      call close_nc(ncid)
      deallocate(alon,alat)
    end subroutine outwamset
   !---------------------------------------------
  end subroutine pretopo_interp
!-------------------------------------------------------------------------------------------------
#ifdef IOPNC
  subroutine init_iopnc
    integer :: is,ie,js,je,rsize,rjs,rje,lsize,ljs,lje, &
                           dsize,dis,die,usize,uis,uie

    integer :: rect(4)
    integer :: start_u(2),count_u(2),  &
               start_d(2),count_d(2),  &
               start_l(2),count_l(2),  &
               start_r(2),count_r(2),  &
               start_c(2),count_c(2)


    ! set parameters
    ! set for size
    ! set start, count
    call irrp_getrects(rect) ! [imin,jmin,imax,jmax]

    !is,ie,js,je
    ! For center block, is+1---ie-1, js+1---je-1
    is=rect(1);ie=rect(3);js=rect(2);je=rect(4)
    if(is>ie)then
      ! the block is too small, pnetcdf can't be used'
    endif
    rsize=0;rjs=je;rje=js
    lsize=0;ljs=je;lje=js
    dsize=0;dis=ie;die=is
    usize=0;uis=ie;uie=is
    do i=1,npc
      if(pnb(i)%j==js)then
        dsize=dsize+1
        dis=min(dis,pnb(i)%i)
        die=max(die,pnb(i)%i)
      endif
      if(pnb(i)%j==je)then
        usize=usize+1
        uis=min(uis,pnb(i)%i)
        uie=max(uie,pnb(i)%i)
      endif
      if(pnb(i)%i==is)then
        lsize=lsize+1
        ljs=min(ljs,pnb(i)%j)
        lje=max(lje,pnb(i)%j)
      endif
      if(pnb(i)%i==ie)then
        rsize=rsize+1
        rjs=min(rjs,pnb(i)%j)
        rje=max(rje,pnb(i)%j)
      endif
    enddo

    if(dsize==0)then
      js=js+1;dsize=ie-is+1;dis=is;die=ie
    endif
    if(usize==0)then
      je=je-1;usize=ie-is+1;uis=is;uie=ie
    endif

    ! (ie-1) - (is+1) + 1 = ie-is-1-1+1 = ie-is-1
    start_c=[is+1,js+1];count_c=[ie-is-1,je-js-1]
    start_u=[uis,je]   ;count_u=[usize,1]
    start_d=[dis,js]   ;count_d=[dsize,1]
    start_l=[is,ljs]   ;count_l=[1,lsize]
    start_r=[ie,rjs]   ;count_r=[1,rsize]

!                                  U4
!      (is,je)(is+1,je  )-----------------------(ie-1,je  )(ie,je)
!         |        |                                 |        |
!         |---(is+1,je-1)-----------------------(ie-1,je-1)---|
!         |        |                                 |        |
!         |        |                                 |        |
!         |        |               0                 |        |             
!       L1|        |         is+1 --> ie-1           |        | R2
!         |        |         js+1 --> je-1           |        |
!         |        |               0                 |        |
!         |        |                                 |        |
!         |        |                                 |        |
!         |---(is+1,js+1)-----------------------(ie-1,js+1)---|
!         |        |                                 |        |
!      (is,js)(is+1,js  )-----------------------(ie-1,js  )(ie,js)
!                                  D3

  do idx=1,npc
    i=pnb(idx)%i;j=pnb(idx)%j;flag=check_parts(i,j)
    if(flag==1)then
      Lvar(:,1,j)=var(:,idx)
    elseif(flag==2)then
      Rvar(:,1,j)=var(:,idx)
    elseif(flag==3)then
      Dvar(:,i,1)=var(:,idx)
    elseif(flag==4)then
      Uvar(:,i,1)=var(:,idx)
    elseif(flag==2)then
      Cvar(:,i,j)=var(:,idx)
    endif

    i=pnb(idx)%i;j=pnb(idx)%j;flag=check_parts(i,j)
    if(flag==0)Cvar(:,i,j)=var(:,idx)
    if(flag==1)Lvar(:,1,j)=var(:,idx)
    if(flag==2)Rvar(:,1,j)=var(:,idx)
    if(flag==3)Dvar(:,i,1)=var(:,idx)
    if(flag==4)Uvar(:,i,1)=var(:,idx)
  enddo

  contains
  integer function check_parts(i,j)
    integer,intent(in) :: i,j
    if(i==is)then     ! Left part
      check_oarts=1
    elseif(i==ie)then ! Right part
      check_oarts=2
    elseif(j==js)then ! Down part
      check_oarts=3
    elseif(j==je)then ! Upper part
      check_oarts=4
    else              ! Center part
      check_oarts=0
    endif
    check_oarts=flag
  end function check_parts(i,j)

  end subroutine init_iopnc
#endif
!-------------------------------------------------------------------------------------------------
  end module partctl_mod
!-------------------------------------------------------------------------------------------------
!#################################################################################################
  
