#/bin/bash
#-------------------------------------------------------------------------------------------------
#<DESCRIPTION>
# This is an example for prepare the parameters and required files (grid, topography and ice). 
# One can change the Part I of this script for runing this model. And the Part II is not need to
# change. The path structure will be like in the follows. If you are not sure how to set some 
# parameters, please contact us. To run this script: "bash prepare_wave_example.sh".
# By Xunqiang Yin (yinxq@fio.org.cn), 2017-10-16
#-------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------
# ************ Part I. Set parameters for the MASNUM_WAVE model.                   ***************
#-------------------------------------------------------------------------------------------------

  masnum_home=/WORK/para_gz_fio_ofs/yinxq/wave2.2
  wind_path=$masnum_home/data/wind/
  etopfile=$masnum_home/data/etop5.nc
  depfile=$masnum_home/data/wamyyz_demo.nc
  exefile=$masnum_home/bin/mwave
  work_path=$masnum_home/exp/demo

  HH=12
  startdate=20220806

  argnumb=$#
  if [ $argnumb == 1 ] ; then
    echo $argnumb  $1
    startdate=$1
  fi
  enddate=`date -d "+5 day $startdate" +%Y%m%d`

#-------------------------------------------------------------------------------------------------
  startdate=${startdate}$HH
    enddate=${enddate}$HH
  echo $startdate $enddate
  outpath=$work_path/res/
  mkdir -p $work_path $outpath
  restfile=$outpath/restart_${startdate}0000.nc
#-------------------------------------------------------------------------------------------------
  cd $work_path
  if [ -f $restfile ]; then
    cp $restfile wave_rest.nc 
  fi
  if [ -f $depfile ]; then
    cp  $depfile wamyyz.nc
  fi
  if [ -f $exefile ]; then
    cp $exefile ./
  fi
#-------------------------------------------------------------------------------------------------
cat > ctlparams << EOF
===========================================================================================
  title   --- Symbal for model output.
  istime  --- Integral start time
  ietime  --- Integral end time
  delttm  --- Length of integral time step, in minutes.
           0  The time step will be set by model itself.
  cpflag  --- Flag for setting of compute periods.
  cpdays  --- Days need to integerated of this model.
           0  is default and the period will be given by start & end time.
          else, the cpdays and start time will be used to determinethe compute period.
  GRDFLAG --- Type of grid: 0 for normal grid, 1 for cuvlinear grid.
  TMREF   --- Refference date for the of output time.
  CLDTYPE --- Calendar type: 
           0 for normal calendar; 
           1 for no leap; 
           2 for 30 days for each month
===========================================================================================
&CTLPARAMS
  TITLE       = "demo"    ,
  CISTIME     = "$startdate",
  CIETIME     = "$enddate"  ,
  COOLS_DAYS  = 5           ,
  DELTTM      = 0           ,
  CPDAYS      = 0           ,
  GRDFLAG     = 1           ,
  TMREF       = "199001010000"  ,
  CLDTYPE     = 0           /
===========================================================================================
EOF
#-------------------------------------------------------------------------------------------------
cat >> ctlparams << EOF
===========================================================================================
  The model could use global topography of ETOPO-5 to generate model grids and topography  
  using the following parameters. If the depfile is exist, it will be used for this model.
  depetop   --- Global topography of ETOPO-5
  gdxdyflag --- Flag for grid resolutions. 
                gdxdyflag=0 is default and (gdx,gdy) will  be used for 
                grid dividing. 
                Otherwise, (1/gdx,1/gdy) will be use for dividing. 
  gdx       --- Increaments in longitude.
  gdy       --- Increaments in latitude.
  lon1      --- Start of longitude, 0-360 means global.
  lon2      --- End of longitude, 0-360 means global.
  lat1      --- Start of latitude.
  lat2      --- End of latitude.
===========================================================================================
&TOPONML
  FILENAME  = "$etopfile"  ,
  GDXDYFLAG = 1,
  GDX       = 2,
  GDY       = 2,
  LON1      = 0,
  LON2      = 360,
  LAT1      = -70,
  LAT2      = 70 /
===========================================================================================
EOF
cat >> ctlparams << EOF
&PCTNML
  TOPO_FILE ="wamyyz.nc",
  XVAR      ="lon"      ,
  YVAR      ="lat"      ,
  MVAR      ="nspyyz"   /
===========================================================================================
EOF
#-------------------------------------------------------------------------------------------------
cat >> ctlparams << EOF
===========================================================================================
#  outpath --- Path for output of wave results and restarts.
#  outflag --- output wave variables into file multi-records, 
#           1    : one file every year,
#           2    : one file every month,
#           3    : one file every day,
#          else  : one file every run.
#           5    : restart only output once.
#           6    : restart only output twice.
#  wiofreq --- The output frequence for wave results (hour).
#  rstfreq --- The output frequence for model restart (hour).
#  ioflag_wx --- Output flag for windx, 0 for none output.
#  ioflag_wy --- Output flag for windy, 0 for none output.
#  ioflag_hs --- Output flag for HS (Significant wave height), 0 for none output.
#  ioflag_th --- Output flag for TH (Mean wave direction), 0 for none output.
#  ioflag_tp --- Output flag for TP (Spectrum peak wave period), 0 for none output.
#  ioflag_tz --- Output flag for TZ (Zero-crossing wave period), 0 for none output.
===========================================================================================
&IOFLAGS
  OUTPATH   = "$outpath",
  OUTFLAG   = 5,
  WIOFREQ   = 3,
  RSTFREQ   = 24,
  IOFLAG_WX = 1 ,
  IOFLAG_WY = 1 ,
  IOFLAG_HS = 1 ,
  IOFLAG_TH = 1 ,
  IOFLAG_TP = 1 ,
  IOFLAG_TZ = 1 /
===========================================================================================
EOF
#===========================================================================================
#-------------------------------------------------------------------------------------------------
cat >> ctlparams << EOF
===========================================================================================
  WPATH    --- Wind path
  UHEAD    --- Head chasracters in u-file of wind.
  UTAIL    --- Tail chasracters in u-file of wind.
  VHEAD    --- Head chasracters in v-file of wind.
  VTAIL    --- Tail chasracters in v-file of wind.
  DTMID    --- Middle characters in date strings.
  XNAME    --- Name of x-direction in netcdf file.
  YNAME    --- Name of y-direction in netcdf file.
  TNAME    --- Name of time in netcdf file.
  UNAME    --- Name of wind-u in netcdf file.
  VNAME    --- Name of wind-v in netcdf file.
  WFTYPE   --- Type wind data file: 1 yearly, 2 monthly, 3 daily, 4/5 one file for each run.
               8 is for one file for each run with the dir-year.
               9 is for one file for each run without the dir-year.
  DIMTYPE  --- Type of dimension variables, 0 is for the same grid with model. 
               The other value follows the netcdf, int1=1, int2=3, int=4,real=5, double=6
  WDDTYPE  --- Type of variables for wind data, follows netcdf.
  SCALFCT --- Scale factor for wind data.
  OFFSET  --- Offset of wind data.
  WNDFREQ --- Frequent of wind data, in hours.
===========================================================================================
&WNDINF
  WPATH = '$wind_path',
  UHEAD = '',
  UTAIL = '_0p25.nc',
  VHEAD = '',
  VTAIL = '_0p25.nc',
  DTMID = '',
  XNAME = 'longitude',
  YNAME = 'latitude',
  TNAME = 'time',
  UNAME = 'UGRD_10maboveground',
  VNAME = 'VGRD_10maboveground',
  WFTYPE  = 9,
  DIMTYPE = 6,
  WDDTYPE = 5,
  SCALFCT = 1.0,
  OFFSET  = 0.0,
  WNDFREQ = 3 /
===========================================================================================
EOF
#-------------------------------------------------------------------------------------------------

  mkdir -p log
  cat ctlparams >log/out_$startdate.log
  ln -sf log/out_$startdate.log out.log

  echo "yhrun -n 1200 -p paratera ./mwave &>>log/out_$startdate.log & " > mrun
#  bash mrun 

#-------------------------------------------------------------------------------------------------
# *****************************           THE END         ****************************************
#-------------------------------------------------------------------------------------------------
