#define DBG print*,__LINE__,__FILE__
!-------------------------------------------------------------------------------
 module pncio_mod
  use pnetcdf
  use irrp_smpi_mod,only: MPI_COMM_WORLD,MPI_INFO_NULL
  use irrp_package_mod,only: irrp_SetPartSerial,irrp_getrects,pi_pos_type
  implicit none
!-------------------------------------------------------------------------------
  public :: writepnc
  public :: readpnc
  public :: init_iopnc
  private
!-------------------------------------------------------------------------------
  interface writepnc
    module procedure writepnc_xyt_r8i2,writepnc_xyzt_r8i2,writepnc_xyzzt_r8i2,&
                     writepnc_xyt_r4i2,writepnc_xyzt_r4i2,writepnc_xyzzt_r4i2,&
                     writepnc_xyt_r8r8,writepnc_xyzt_r8r8,writepnc_xyzzt_r8r8,&
                     writepnc_xyt_r4r4,writepnc_xyzt_r4r4,writepnc_xyzzt_r4r4
  end interface writepnc
!-------------------------------------------------------------------------------
  interface readpnc
    module procedure readpnc_xyt_r8i2,readpnc_xyzt_r8i2,readpnc_xyzzt_r8i2,&
                     readpnc_xyt_r4i2,readpnc_xyzt_r4i2,readpnc_xyzzt_r4i2,&
                     readpnc_xyt_r8r8,readpnc_xyzt_r8r8,readpnc_xyzzt_r8r8,&
                     readpnc_xyt_r4r4,readpnc_xyzt_r4r4,readpnc_xyzzt_r4r4
  end interface readpnc
!-------------------------------------------------------------------------------
  integer,private :: is,ie,js,je,rsize,rjs,rje,lsize,ljs,lje, &
                     dsize,dis,die,usize,uis,uie
  integer(8),private :: start_u(2) ,count_u(2) ,&
                        start_d(2) ,count_d(2) ,&
                        start_l(2) ,count_l(2) ,&
                        start_r(2) ,count_r(2) ,&
                        start_c(2) ,count_c(2)
  integer(8),private :: start_ut(6),count_ut(6),&
                        start_dt(6),count_dt(6),&
                        start_lt(6),count_lt(6),&
                        start_rt(6),count_rt(6),&
                        start_ct(6),count_ct(6)
!-------------------------------------------------------------------------------
  integer,private :: npc
  type(pi_pos_type),pointer,private :: plist(:)=>null()
  integer,private :: fioinited=0
!-------------------------------------------------------------------------------
  contains
!-------------------------------------------------------------------------------
  subroutine init_iopnc(npc_,plist_)
    integer,intent(in),optional :: npc_
    type(pi_pos_type),intent(in),optional,pointer :: plist_(:)
    integer :: rect(4)
    integer :: idx,i,j,flag
    !-------------------------------------------------
    if(fioinited/=0)return
    if(present(npc_))npc=npc_
    if(present(plist_))then
      plist=>plist_
    else
      !call irrp_SetPartSerial(npc=npc,plist=plist)
      call irrp_getrects(npc=npc,plist=plist)
    endif
    call irrp_getrects(rect) ! [imin,jmin,imax,jmax]
    !-------------------------------------------------
    !is,ie,js,je
    ! For center block, is+1---ie-1, js+1---je-1
    is=rect(1);ie=rect(3);js=rect(2);je=rect(4)
    rsize=0;rjs=je;rje=js
    lsize=0;ljs=je;lje=js
    dsize=0;dis=ie;die=is
    usize=0;uis=ie;uie=is
    do i=1,npc
      if(plist(i)%i==is)then
        !lsize=lsize+1
        ljs=min(ljs,plist(i)%j)
        lje=max(lje,plist(i)%j)
      elseif(plist(i)%i==ie)then
        !rsize=rsize+1
        rjs=min(rjs,plist(i)%j)
        rje=max(rje,plist(i)%j)
      else
        if(plist(i)%j==js)then
          dis=min(dis,plist(i)%i)
          die=max(die,plist(i)%i)
        elseif(plist(i)%j==je)then
          uis=min(uis,plist(i)%i)
          uie=max(uie,plist(i)%i)
        endif
      endif
    enddo
    if(dis>die)then
      js=js+1;dis=is+1;die=ie-1
    endif
    if(uis>uie)then
      je=je-1;uis=is+1;uie=ie-1
    endif
    !-------------------------------------------------
    lsize=lje-ljs+1;rsize=rje-rjs+1
    dsize=die-dis+1;usize=uie-uis+1
    !-------------------------------------------------
    ! (ie-1) - (is+1) + 1 = ie-is-1-1+1 = ie-is-1
    start_c=[is+1,js+1];count_c=[ie-is-1,je-js-1]
    start_u=[uis,je]   ;count_u=[usize,1]
    start_d=[dis,js]   ;count_d=[dsize,1]
    start_l=[is,ljs]   ;count_l=[1,lsize]
    start_r=[ie,rjs]   ;count_r=[1,rsize]
    !-------------------------------------------------
    start_ct=1;start_ct(1:2)=start_c(1:2)
    start_ut=1;start_ut(1:2)=start_u(1:2)
    start_dt=1;start_dt(1:2)=start_d(1:2)
    start_lt=1;start_lt(1:2)=start_l(1:2)
    start_rt=1;start_rt(1:2)=start_r(1:2)
    count_ct=1;count_ct(1:2)=count_c(1:2)
    count_ut=1;count_ut(1:2)=count_u(1:2)
    count_dt=1;count_dt(1:2)=count_d(1:2)
    count_lt=1;count_lt(1:2)=count_l(1:2)
    count_rt=1;count_rt(1:2)=count_r(1:2)
    !-------------------------------------------------
    !do idx=1,npc
    !  i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
    !  if(flag==0)Cvar(:,i,j)=var(:,idx)
    !  if(flag==1)Lvar(:,1,j)=var(:,idx)
    !  if(flag==2)Rvar(:,1,j)=var(:,idx)
    !  if(flag==3)Dvar(:,i,1)=var(:,idx)
    !  if(flag==4)Uvar(:,i,1)=var(:,idx)
    !enddo
    fioinited=1
  end subroutine init_iopnc
!-------------------------------------------------------------------------------
  integer function check_parts(i,j)
    integer,intent(in) :: i,j
    !-------------------------------------------------------------!
    !                             U4                              !
    ! (is,je)(is+1,je  )-----------------------(ie-1,je  )(ie,je) !
    !    |        |                                 |        |    !
    !    |---(is+1,je-1)-----------------------(ie-1,je-1)---|    !
    !    |        |                                 |        |    !
    !    |        |                                 |        |    !
    !    |        |               0                 |        |    !      
    !  L1|        |         is+1 --> ie-1           |        | R2 !
    !    |        |         js+1 --> je-1           |        |    !
    !    |        |               0                 |        |    !
    !    |        |                                 |        |    !
    !    |        |                                 |        |    !
    !    |---(is+1,js+1)-----------------------(ie-1,js+1)---|    !
    !    |        |                                 |        |    !
    ! (is,js)(is+1,js  )-----------------------(ie-1,js  )(ie,js) !
    !                             D3                              !
    !-------------------------------------------------------------!
    if(i==is)then     ! Left part
      check_parts=1
    elseif(i==ie)then ! Right part
      check_parts=2
    else
      if(j==js)then ! Down part
        check_parts=3
      elseif(j==je)then ! Upper part
        check_parts=4
      else              ! Center part
        check_parts=0
      endif
    endif
  end function check_parts
!-------------------------------------------------------------------------------!
  subroutine check(err,message)
    integer,intent(in) :: err
    character(len=*),intent(in) :: message
    ! It is a good idea to check returned value for possible error
    if(err /= NF90_NOERR)then
      write(6,*)trim(message), trim(nf90mpi_strerror(err))
      call MPI_Abort(MPI_COMM_WORLD, -1, err)
    endif
  end subroutine check
!-------------------------------------------------------------------------------!
!integer function nf90mpi_put_var_all(ncid, varid, values, start, stride, map,  !
!                                     bufcount, buftype)                        !
!-integer,                                            intent(in   ) :: ncid     !
!-integer,                                            intent(in   ) :: varid    !
!-<any valid type, scalar or array of any rank>,      intent(inout) :: values   !
!-integer(kind=MPI_OFFSET_KIND),dimension(:),optional,intent(in   ) :: start    !
!-integer(kind=MPI_OFFSET_KIND),dimension(:),optional,intent(in   ) :: count    !
!-integer(kind=MPI_OFFSET_KIND),dimension(:),optional,intent(in   ) :: stride   !
!-integer(kind=MPI_OFFSET_KIND),dimension(:),optional,intent(in   ) :: map      !
!-integer(kind=MPI_OFFSET_KIND),             optional,intent(in   ) :: bufcount !
!-integer,                                   optional,intent(in   ) :: buftype  !
!-------------------------------------------------------------------------------!
  subroutine writepnc_xyt_r8i2(mpicomm ,&
                               filename,&
                               vname   ,&
                               var     ,&
                               ns      ,&
                               scalfact,&
                               offset  ,&
                               recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(8),intent(in) :: var(:)
    integer,intent(in) :: ns
    real(8),intent(in) :: scalfact,offset
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    integer(2),allocatable :: Lvar(:,:)
    integer(2),allocatable :: Rvar(:,:)
    integer(2),allocatable :: Uvar(:,:)
    integer(2),allocatable :: Dvar(:,:)
    integer(2),allocatable :: Cvar(:,:)
    integer(8) :: irec
    ss=1-ns;ndim=2
    start_ct=1;start_ct(1:2)=start_c(1:2)
    start_ut=1;start_ut(1:2)=start_u(1:2)
    start_dt=1;start_dt(1:2)=start_d(1:2)
    start_lt=1;start_lt(1:2)=start_l(1:2)
    start_rt=1;start_rt(1:2)=start_r(1:2)
    count_ct=1;count_ct(1:2)=count_c(1:2)
    count_ut=1;count_ut(1:2)=count_u(1:2)
    count_dt=1;count_dt(1:2)=count_d(1:2)
    count_lt=1;count_lt(1:2)=count_l(1:2)
    count_rt=1;count_rt(1:2)=count_r(1:2)
    if(present(recd))then
      ndim=ndim+1;irec=recd;start_ct(ndim)=recd
      start_ut(ndim)=recd;  start_dt(ndim)=recd
      start_lt(ndim)=recd;  start_rt(ndim)=recd
    endif
    allocate(Lvar(1,ljs:lje),Rvar(1,rjs:rje),&
             Uvar(uis:uie,1),Dvar(dis:die,1),&
             Cvar(is+1:ie-1,js+1:je-1)       )
    Lvar=nf90_fill_int2
    Rvar=nf90_fill_int2
    Uvar=nf90_fill_int2
    Dvar=nf90_fill_int2
    Cvar=nf90_fill_int2
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)Cvar(i,j)=(var(idx+ss)-offset)/scalfact
      if(flag==1)Lvar(1,j)=(var(idx+ss)-offset)/scalfact
      if(flag==2)Rvar(1,j)=(var(idx+ss)-offset)/scalfact
      if(flag==3)Dvar(i,1)=(var(idx+ss)-offset)/scalfact
      if(flag==4)Uvar(i,1)=(var(idx+ss)-offset)/scalfact
    enddo
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_WRITE     ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    if(present(recd))stat=nf90mpi_fill_var_rec(ncid,vid,irec)
    stat=nf90mpi_put_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine writepnc_xyt_r8i2
!-------------------------------------------------------------------------------
  subroutine writepnc_xyt_r4i2(mpicomm ,&
                               filename,&
                               vname   ,&
                               var     ,&
                               ns      ,&
                               scalfact,&
                               offset  ,&
                               recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(4),intent(in) :: var(:)
    integer,intent(in) :: ns
    real(4),intent(in) :: scalfact,offset
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    integer(2),allocatable :: Lvar(:,:)
    integer(2),allocatable :: Rvar(:,:)
    integer(2),allocatable :: Uvar(:,:)
    integer(2),allocatable :: Dvar(:,:)
    integer(2),allocatable :: Cvar(:,:)
    integer(8) :: irec

    ss=1-ns;ndim=2
    start_ct=1;start_ct(1:2)=start_c(1:2)
    start_ut=1;start_ut(1:2)=start_u(1:2)
    start_dt=1;start_dt(1:2)=start_d(1:2)
    start_lt=1;start_lt(1:2)=start_l(1:2)
    start_rt=1;start_rt(1:2)=start_r(1:2)
    count_ct=1;count_ct(1:2)=count_c(1:2)
    count_ut=1;count_ut(1:2)=count_u(1:2)
    count_dt=1;count_dt(1:2)=count_d(1:2)
    count_lt=1;count_lt(1:2)=count_l(1:2)
    count_rt=1;count_rt(1:2)=count_r(1:2)
    if(present(recd))then
      ndim=ndim+1;irec=recd;start_ct(ndim)=recd
      start_ut(ndim)=recd;  start_dt(ndim)=recd
      start_lt(ndim)=recd;  start_rt(ndim)=recd
    endif
    allocate(Lvar(1,ljs:lje),Rvar(1,rjs:rje),&
             Uvar(uis:uie,1),Dvar(dis:die,1),&
             Cvar(is+1:ie-1,js+1:je-1)       )
    Lvar=nf90_fill_int2
    Rvar=nf90_fill_int2
    Uvar=nf90_fill_int2
    Dvar=nf90_fill_int2
    Cvar=nf90_fill_int2
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)Cvar(i,j)=(var(idx+ss)-offset)/scalfact
      if(flag==1)Lvar(1,j)=(var(idx+ss)-offset)/scalfact
      if(flag==2)Rvar(1,j)=(var(idx+ss)-offset)/scalfact
      if(flag==3)Dvar(i,1)=(var(idx+ss)-offset)/scalfact
      if(flag==4)Uvar(i,1)=(var(idx+ss)-offset)/scalfact
    enddo
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_WRITE     ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    if(present(recd))stat=nf90mpi_fill_var_rec(ncid,vid,irec)
    stat=nf90mpi_put_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine writepnc_xyt_r4i2
!-------------------------------------------------------------------------------
  subroutine writepnc_xyt_r4r4(mpicomm ,&
                               filename,&
                               vname   ,&
                               var     ,&
                               ns      ,&
                               recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(4),intent(in) :: var(:)
    integer,intent(in) :: ns
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    real(4),allocatable :: Lvar(:,:)
    real(4),allocatable :: Rvar(:,:)
    real(4),allocatable :: Uvar(:,:)
    real(4),allocatable :: Dvar(:,:)
    real(4),allocatable :: Cvar(:,:)
    integer(8) :: irec

    ss=1-ns;ndim=2
    start_ct=1;start_ct(1:2)=start_c(1:2)
    start_ut=1;start_ut(1:2)=start_u(1:2)
    start_dt=1;start_dt(1:2)=start_d(1:2)
    start_lt=1;start_lt(1:2)=start_l(1:2)
    start_rt=1;start_rt(1:2)=start_r(1:2)
    count_ct=1;count_ct(1:2)=count_c(1:2)
    count_ut=1;count_ut(1:2)=count_u(1:2)
    count_dt=1;count_dt(1:2)=count_d(1:2)
    count_lt=1;count_lt(1:2)=count_l(1:2)
    count_rt=1;count_rt(1:2)=count_r(1:2)
    if(present(recd))then
      ndim=ndim+1;irec=recd;start_ct(ndim)=recd
      start_ut(ndim)=recd;  start_dt(ndim)=recd
      start_lt(ndim)=recd;  start_rt(ndim)=recd
    endif
    allocate(Lvar(1,ljs:lje),Rvar(1,rjs:rje),&
             Uvar(uis:uie,1),Dvar(dis:die,1),&
             Cvar(is+1:ie-1,js+1:je-1)       )
    Lvar=nf90_fill_real
    Rvar=nf90_fill_real
    Uvar=nf90_fill_real
    Dvar=nf90_fill_real
    Cvar=nf90_fill_real
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)Cvar(i,j)=var(idx+ss)
      if(flag==1)Lvar(1,j)=var(idx+ss)
      if(flag==2)Rvar(1,j)=var(idx+ss)
      if(flag==3)Dvar(i,1)=var(idx+ss)
      if(flag==4)Uvar(i,1)=var(idx+ss)
    enddo
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_WRITE     ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    if(present(recd))stat=nf90mpi_fill_var_rec(ncid,vid,irec)
    stat=nf90mpi_put_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine writepnc_xyt_r4r4
!-------------------------------------------------------------------------------
  subroutine writepnc_xyt_r8r8(mpicomm ,&
                               filename,&
                               vname   ,&
                               var     ,&
                               ns      ,&
                               recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(8),intent(in) :: var(:)
    integer,intent(in) :: ns
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    real(8),allocatable :: Lvar(:,:)
    real(8),allocatable :: Rvar(:,:)
    real(8),allocatable :: Uvar(:,:)
    real(8),allocatable :: Dvar(:,:)
    real(8),allocatable :: Cvar(:,:)
    integer(8) :: irec

    ss=1-ns;ndim=2
    start_ct=1;start_ct(1:2)=start_c(1:2)
    start_ut=1;start_ut(1:2)=start_u(1:2)
    start_dt=1;start_dt(1:2)=start_d(1:2)
    start_lt=1;start_lt(1:2)=start_l(1:2)
    start_rt=1;start_rt(1:2)=start_r(1:2)
    count_ct=1;count_ct(1:2)=count_c(1:2)
    count_ut=1;count_ut(1:2)=count_u(1:2)
    count_dt=1;count_dt(1:2)=count_d(1:2)
    count_lt=1;count_lt(1:2)=count_l(1:2)
    count_rt=1;count_rt(1:2)=count_r(1:2)
    if(present(recd))then
      ndim=ndim+1;irec=recd;start_ct(ndim)=recd
      start_ut(ndim)=recd;  start_dt(ndim)=recd
      start_lt(ndim)=recd;  start_rt(ndim)=recd
    endif
    allocate(Lvar(1,ljs:lje),Rvar(1,rjs:rje),&
             Uvar(uis:uie,1),Dvar(dis:die,1),&
             Cvar(is+1:ie-1,js+1:je-1)       )
    Lvar=nf90_fill_double
    Rvar=nf90_fill_double
    Uvar=nf90_fill_double
    Dvar=nf90_fill_double
    Cvar=nf90_fill_double
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)Cvar(i,j)=var(idx+ss)
      if(flag==1)Lvar(1,j)=var(idx+ss)
      if(flag==2)Rvar(1,j)=var(idx+ss)
      if(flag==3)Dvar(i,1)=var(idx+ss)
      if(flag==4)Uvar(i,1)=var(idx+ss)
    enddo
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_WRITE     ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    if(present(recd))stat=nf90mpi_fill_var_rec(ncid,vid,irec)
    stat=nf90mpi_put_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine writepnc_xyt_r8r8
!-------------------------------------------------------------------------------
  subroutine writepnc_xyzt_r8i2(mpicomm ,&
                               filename,&
                               vname   ,&
                               var     ,&
                               ns      ,&
                               kb      ,&
                               scalfact,&
                               offset  ,&
                               recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(8),intent(in) :: var(:,:)
    integer,intent(in) :: ns
    integer,intent(in) :: kb
    real(8),intent(in) :: scalfact
    real(8),intent(in) :: offset
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    integer(2),allocatable :: Lvar(:,:,:)
    integer(2),allocatable :: Rvar(:,:,:)
    integer(2),allocatable :: Uvar(:,:,:)
    integer(2),allocatable :: Dvar(:,:,:)
    integer(2),allocatable :: Cvar(:,:,:)
    integer(8) :: irec

    ss=1-ns;ndim=3
    start_ct=1;start_ct(1:2)=start_c(1:2)
    start_ut=1;start_ut(1:2)=start_u(1:2)
    start_dt=1;start_dt(1:2)=start_d(1:2)
    start_lt=1;start_lt(1:2)=start_l(1:2)
    start_rt=1;start_rt(1:2)=start_r(1:2)
    count_ct=1;count_ct(1:2)=count_c(1:2);count_ct(3)=kb
    count_ut=1;count_ut(1:2)=count_u(1:2);count_ut(3)=kb
    count_dt=1;count_dt(1:2)=count_d(1:2);count_dt(3)=kb
    count_lt=1;count_lt(1:2)=count_l(1:2);count_lt(3)=kb
    count_rt=1;count_rt(1:2)=count_r(1:2);count_rt(3)=kb
    if(present(recd))then
      ndim=ndim+1;irec=recd
      start_ct(ndim)=recd
      start_ut(ndim)=recd;start_dt(ndim)=recd
      start_lt(ndim)=recd;start_rt(ndim)=recd
    endif
    allocate(Lvar(1,ljs:lje,kb),Rvar(1,rjs:rje,kb),&
             Uvar(uis:uie,1,kb),Dvar(dis:die,1,kb),&
             Cvar(is+1:ie-1,js+1:je-1,kb)          )
    Lvar=nf90_fill_int2
    Rvar=nf90_fill_int2
    Uvar=nf90_fill_int2
    Dvar=nf90_fill_int2
    Cvar=nf90_fill_int2
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)Cvar(i,j,:)=(var(:,idx+ss)-offset)/scalfact
      if(flag==1)Lvar(1,j,:)=(var(:,idx+ss)-offset)/scalfact
      if(flag==2)Rvar(1,j,:)=(var(:,idx+ss)-offset)/scalfact
      if(flag==3)Dvar(i,1,:)=(var(:,idx+ss)-offset)/scalfact
      if(flag==4)Uvar(i,1,:)=(var(:,idx+ss)-offset)/scalfact
    enddo
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_WRITE     ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    if(present(recd))stat=nf90mpi_fill_var_rec(ncid,vid,irec)
    stat=nf90mpi_put_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine writepnc_xyzt_r8i2
!-------------------------------------------------------------------------------
  subroutine writepnc_xyzt_r4i2(mpicomm ,&
                               filename,&
                               vname   ,&
                               var     ,&
                               ns      ,&
                               kb      ,&
                               scalfact,&
                               offset  ,&
                               recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(4),intent(in) :: var(:,:)
    integer,intent(in) :: ns
    integer,intent(in) :: kb
    real(4),intent(in) :: scalfact,offset
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    integer(2),allocatable :: Lvar(:,:,:)
    integer(2),allocatable :: Rvar(:,:,:)
    integer(2),allocatable :: Uvar(:,:,:)
    integer(2),allocatable :: Dvar(:,:,:)
    integer(2),allocatable :: Cvar(:,:,:)
    integer(8) :: irec

    ss=1-ns;ndim=3
    start_ct=1;start_ct(1:2)=start_c(1:2)
    start_ut=1;start_ut(1:2)=start_u(1:2)
    start_dt=1;start_dt(1:2)=start_d(1:2)
    start_lt=1;start_lt(1:2)=start_l(1:2)
    start_rt=1;start_rt(1:2)=start_r(1:2)
    count_ct=1;count_ct(1:2)=count_c(1:2);count_ct(3)=kb
    count_ut=1;count_ut(1:2)=count_u(1:2);count_ut(3)=kb
    count_dt=1;count_dt(1:2)=count_d(1:2);count_dt(3)=kb
    count_lt=1;count_lt(1:2)=count_l(1:2);count_lt(3)=kb
    count_rt=1;count_rt(1:2)=count_r(1:2);count_rt(3)=kb
    if(present(recd))then
      ndim=ndim+1;irec=recd
      start_ct(ndim)=recd
      start_ut(ndim)=recd;start_dt(ndim)=recd
      start_lt(ndim)=recd;start_rt(ndim)=recd
    endif
    allocate(Lvar(1,ljs:lje,kb),Rvar(1,rjs:rje,kb),&
             Uvar(uis:uie,1,kb),Dvar(dis:die,1,kb),&
             Cvar(is+1:ie-1,js+1:je-1,kb)          )
    Lvar=nf90_fill_int2
    Rvar=nf90_fill_int2
    Uvar=nf90_fill_int2
    Dvar=nf90_fill_int2
    Cvar=nf90_fill_int2
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)Cvar(i,j,:)=(var(:,idx+ss)-offset)/scalfact
      if(flag==1)Lvar(1,j,:)=(var(:,idx+ss)-offset)/scalfact
      if(flag==2)Rvar(1,j,:)=(var(:,idx+ss)-offset)/scalfact
      if(flag==3)Dvar(i,1,:)=(var(:,idx+ss)-offset)/scalfact
      if(flag==4)Uvar(i,1,:)=(var(:,idx+ss)-offset)/scalfact
    enddo
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_WRITE     ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    if(present(recd))stat=nf90mpi_fill_var_rec(ncid,vid,irec)
    stat=nf90mpi_put_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine writepnc_xyzt_r4i2
!-------------------------------------------------------------------------------
  subroutine writepnc_xyzt_r4r4(mpicomm ,&
                               filename,&
                               vname   ,&
                               var     ,&
                               ns      ,&
                               kb      ,&
                               recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(4),intent(in) :: var(:,:)
    integer,intent(in) :: ns
    integer,intent(in) :: kb
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    real(4),allocatable :: Lvar(:,:,:)
    real(4),allocatable :: Rvar(:,:,:)
    real(4),allocatable :: Uvar(:,:,:)
    real(4),allocatable :: Dvar(:,:,:)
    real(4),allocatable :: Cvar(:,:,:)
    integer(8) :: irec

    ss=1-ns;ndim=3
    start_ct=1;start_ct(1:2)=start_c(1:2)
    start_ut=1;start_ut(1:2)=start_u(1:2)
    start_dt=1;start_dt(1:2)=start_d(1:2)
    start_lt=1;start_lt(1:2)=start_l(1:2)
    start_rt=1;start_rt(1:2)=start_r(1:2)
    count_ct=1;count_ct(1:2)=count_c(1:2);count_ct(3)=kb
    count_ut=1;count_ut(1:2)=count_u(1:2);count_ut(3)=kb
    count_dt=1;count_dt(1:2)=count_d(1:2);count_dt(3)=kb
    count_lt=1;count_lt(1:2)=count_l(1:2);count_lt(3)=kb
    count_rt=1;count_rt(1:2)=count_r(1:2);count_rt(3)=kb
    if(present(recd))then
      ndim=ndim+1;irec=recd
      start_ct(ndim)=recd
      start_ut(ndim)=recd;start_dt(ndim)=recd
      start_lt(ndim)=recd;start_rt(ndim)=recd
    endif
    allocate(Lvar(1,ljs:lje,kb),Rvar(1,rjs:rje,kb),&
             Uvar(uis:uie,1,kb),Dvar(dis:die,1,kb),&
             Cvar(is+1:ie-1,js+1:je-1,kb)          )
    Lvar=nf90_fill_real
    Rvar=nf90_fill_real
    Uvar=nf90_fill_real
    Dvar=nf90_fill_real
    Cvar=nf90_fill_real
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)Cvar(i,j,:)=var(:,idx+ss)
      if(flag==1)Lvar(1,j,:)=var(:,idx+ss)
      if(flag==2)Rvar(1,j,:)=var(:,idx+ss)
      if(flag==3)Dvar(i,1,:)=var(:,idx+ss)
      if(flag==4)Uvar(i,1,:)=var(:,idx+ss)
    enddo
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_WRITE     ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    if(present(recd))stat=nf90mpi_fill_var_rec(ncid,vid,irec)
    stat=nf90mpi_put_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine writepnc_xyzt_r4r4
!-------------------------------------------------------------------------------
  subroutine writepnc_xyzt_r8r8(mpicomm ,&
                               filename,&
                               vname   ,&
                               var     ,&
                               ns      ,&
                               kb      ,&
                               recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(8),intent(in) :: var(:,:)
    integer,intent(in) :: ns
    integer,intent(in) :: kb
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    real(8),allocatable :: Lvar(:,:,:)
    real(8),allocatable :: Rvar(:,:,:)
    real(8),allocatable :: Uvar(:,:,:)
    real(8),allocatable :: Dvar(:,:,:)
    real(8),allocatable :: Cvar(:,:,:)
    integer(8) :: irec

    ss=1-ns;ndim=3
    start_ct=1;start_ct(1:2)=start_c(1:2)
    start_ut=1;start_ut(1:2)=start_u(1:2)
    start_dt=1;start_dt(1:2)=start_d(1:2)
    start_lt=1;start_lt(1:2)=start_l(1:2)
    start_rt=1;start_rt(1:2)=start_r(1:2)
    count_ct=1;count_ct(1:2)=count_c(1:2);count_ct(3)=kb
    count_ut=1;count_ut(1:2)=count_u(1:2);count_ut(3)=kb
    count_dt=1;count_dt(1:2)=count_d(1:2);count_dt(3)=kb
    count_lt=1;count_lt(1:2)=count_l(1:2);count_lt(3)=kb
    count_rt=1;count_rt(1:2)=count_r(1:2);count_rt(3)=kb
    if(present(recd))then
      ndim=ndim+1;irec=recd
      start_ct(ndim)=recd
      start_ut(ndim)=recd;start_dt(ndim)=recd
      start_lt(ndim)=recd;start_rt(ndim)=recd
    endif
    allocate(Lvar(1,ljs:lje,kb),Rvar(1,rjs:rje,kb),&
             Uvar(uis:uie,1,kb),Dvar(dis:die,1,kb),&
             Cvar(is+1:ie-1,js+1:je-1,kb)         )
    Lvar=nf90_fill_double
    Rvar=nf90_fill_double
    Uvar=nf90_fill_double
    Dvar=nf90_fill_double
    Cvar=nf90_fill_double
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)Cvar(i,j,:)=var(:,idx+ss)
      if(flag==1)Lvar(1,j,:)=var(:,idx+ss)
      if(flag==2)Rvar(1,j,:)=var(:,idx+ss)
      if(flag==3)Dvar(i,1,:)=var(:,idx+ss)
      if(flag==4)Uvar(i,1,:)=var(:,idx+ss)
    enddo
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_WRITE     ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    if(present(recd))stat=nf90mpi_fill_var_rec(ncid,vid,irec)
    stat=nf90mpi_put_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine writepnc_xyzt_r8r8
!-------------------------------------------------------------------------------
  subroutine writepnc_xyzzt_r8i2(mpicomm ,&
                               filename,&
                               vname   ,&
                               var     ,&
                               ns      ,&
                               kb      ,&
                               lm      ,&
                               scalfact,&
                               offset  ,&
                               recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(8),intent(in) :: var(:,:,:)
    integer,intent(in) :: ns
    integer,intent(in) :: kb
    integer,intent(in) :: lm
    real(8),intent(in) :: scalfact
    real(8),intent(in) :: offset
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    integer(2),allocatable :: Lvar(:,:,:,:)
    integer(2),allocatable :: Rvar(:,:,:,:)
    integer(2),allocatable :: Uvar(:,:,:,:)
    integer(2),allocatable :: Dvar(:,:,:,:)
    integer(2),allocatable :: Cvar(:,:,:,:)
    integer(8) :: irec

    ss=1-ns;ndim=4
    start_ct=1;start_ct(3:4)=start_c(1:2)
    start_ut=1;start_ut(3:4)=start_u(1:2)
    start_dt=1;start_dt(3:4)=start_d(1:2)
    start_lt=1;start_lt(3:4)=start_l(1:2)
    start_rt=1;start_rt(3:4)=start_r(1:2)
    count_ct=1;count_ct(3:4)=count_c(1:2);count_ct(1:2)=[kb,lm]
    count_ut=1;count_ut(3:4)=count_u(1:2);count_ut(1:2)=[kb,lm]
    count_dt=1;count_dt(3:4)=count_d(1:2);count_dt(1:2)=[kb,lm]
    count_lt=1;count_lt(3:4)=count_l(1:2);count_lt(1:2)=[kb,lm]
    count_rt=1;count_rt(3:4)=count_r(1:2);count_rt(1:2)=[kb,lm]
    if(present(recd))then
      ndim=ndim+1;irec=recd
      start_ct(ndim)=recd
      start_ut(ndim)=recd;start_dt(ndim)=recd
      start_lt(ndim)=recd;start_rt(ndim)=recd
    endif
    allocate(Lvar(1,ljs:lje,kb,lm),Rvar(1,rjs:rje,kb,lm),&
             Uvar(uis:uie,1,kb,lm),Dvar(dis:die,1,kb,lm),&
             Cvar(is+1:ie-1,js+1:je-1,kb,lm)          )
    Lvar=nf90_fill_int2
    Rvar=nf90_fill_int2
    Uvar=nf90_fill_int2
    Dvar=nf90_fill_int2
    Cvar=nf90_fill_int2
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)Cvar(i,j,:,:)=(var(:,:,idx+ss)-offset)/scalfact
      if(flag==1)Lvar(1,j,:,:)=(var(:,:,idx+ss)-offset)/scalfact
      if(flag==2)Rvar(1,j,:,:)=(var(:,:,idx+ss)-offset)/scalfact
      if(flag==3)Dvar(i,1,:,:)=(var(:,:,idx+ss)-offset)/scalfact
      if(flag==4)Uvar(i,1,:,:)=(var(:,:,idx+ss)-offset)/scalfact
    enddo
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_WRITE     ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    if(present(recd))stat=nf90mpi_fill_var_rec(ncid,vid,irec)
    stat=nf90mpi_put_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine writepnc_xyzzt_r8i2
!-------------------------------------------------------------------------------
  subroutine writepnc_xyzzt_r4i2(mpicomm ,&
                               filename,&
                               vname   ,&
                               var     ,&
                               ns      ,&
                               kb      ,&
                               lm      ,&
                               scalfact,&
                               offset  ,&
                               recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(4),intent(in) :: var(:,:,:)
    integer,intent(in) :: ns
    integer,intent(in) :: kb
    integer,intent(in) :: lm
    real(4),intent(in) :: scalfact,offset
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    integer(2),allocatable :: Lvar(:,:,:,:)
    integer(2),allocatable :: Rvar(:,:,:,:)
    integer(2),allocatable :: Uvar(:,:,:,:)
    integer(2),allocatable :: Dvar(:,:,:,:)
    integer(2),allocatable :: Cvar(:,:,:,:)
    integer(8) :: irec

    ss=1-ns;ndim=4
    start_ct=1;start_ct(3:4)=start_c(1:2)
    start_ut=1;start_ut(3:4)=start_u(1:2)
    start_dt=1;start_dt(3:4)=start_d(1:2)
    start_lt=1;start_lt(3:4)=start_l(1:2)
    start_rt=1;start_rt(3:4)=start_r(1:2)
    if(present(recd))then
      ndim=ndim+1;irec=recd
      start_ct(ndim)=recd
      start_ut(ndim)=recd;start_dt(ndim)=recd
      start_lt(ndim)=recd;start_rt(ndim)=recd
    endif
    count_ct=1;count_ct(3:4)=count_c(1:2);count_ct(1:2)=[kb,lm]
    count_ut=1;count_ut(3:4)=count_u(1:2);count_ut(1:2)=[kb,lm]
    count_dt=1;count_dt(3:4)=count_d(1:2);count_dt(1:2)=[kb,lm]
    count_lt=1;count_lt(3:4)=count_l(1:2);count_lt(1:2)=[kb,lm]
    count_rt=1;count_rt(3:4)=count_r(1:2);count_rt(1:2)=[kb,lm]
    allocate(Lvar(kb,lm,1,ljs:lje),Rvar(kb,lm,1,rjs:rje),&
             Uvar(kb,lm,uis:uie,1),Dvar(kb,lm,dis:die,1),&
             Cvar(kb,lm,is+1:ie-1,js+1:je-1)             )
    !count_ct(3)=kb;count_ct(4)=lm;
    !count_ut(3)=kb;count_ut(4)=lm;
    !count_dt(3)=kb;count_dt(4)=lm;
    !count_lt(3)=kb;count_lt(4)=lm;
    !count_rt(3)=kb;count_rt(4)=lm;
    !allocate(Lvar(1,ljs:lje,kb,lm),Rvar(1,rjs:rje,kb,lm),&
    !         Uvar(uis:uie,1,kb,lm),Dvar(dis:die,1,kb,lm),&
    !         Cvar(is+1:ie-1,js+1:je-1,kb,lm)          )
    Lvar=nf90_fill_int2
    Rvar=nf90_fill_int2
    Uvar=nf90_fill_int2
    Dvar=nf90_fill_int2
    Cvar=nf90_fill_int2
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      !if(flag==0)Cvar(i,j,:,:)=(var(:,:,idx+ss)-offset)/scalfact
      !if(flag==1)Lvar(1,j,:,:)=(var(:,:,idx+ss)-offset)/scalfact
      !if(flag==2)Rvar(1,j,:,:)=(var(:,:,idx+ss)-offset)/scalfact
      !if(flag==3)Dvar(i,1,:,:)=(var(:,:,idx+ss)-offset)/scalfact
      !if(flag==4)Uvar(i,1,:,:)=(var(:,:,idx+ss)-offset)/scalfact
      if(flag==0)Cvar(:,:,i,j)=(var(:,:,idx+ss)-offset)/scalfact
      if(flag==1)Lvar(:,:,1,j)=(var(:,:,idx+ss)-offset)/scalfact
      if(flag==2)Rvar(:,:,1,j)=(var(:,:,idx+ss)-offset)/scalfact
      if(flag==3)Dvar(:,:,i,1)=(var(:,:,idx+ss)-offset)/scalfact
      if(flag==4)Uvar(:,:,i,1)=(var(:,:,idx+ss)-offset)/scalfact
    enddo
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_WRITE     ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    if(present(recd))stat=nf90mpi_fill_var_rec(ncid,vid,irec)
    stat=nf90mpi_put_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine writepnc_xyzzt_r4i2
!-------------------------------------------------------------------------------
  subroutine writepnc_xyzzt_r4r4(mpicomm ,&
                               filename,&
                               vname   ,&
                               var     ,&
                               ns      ,&
                               kb      ,&
                               lm      ,&
                               recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(4),intent(in) :: var(:,:,:)
    integer,intent(in) :: ns
    integer,intent(in) :: kb
    integer,intent(in) :: lm
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    real(4),allocatable :: Lvar(:,:,:,:)
    real(4),allocatable :: Rvar(:,:,:,:)
    real(4),allocatable :: Uvar(:,:,:,:)
    real(4),allocatable :: Dvar(:,:,:,:)
    real(4),allocatable :: Cvar(:,:,:,:)
    integer(8) :: irec

    ss=1-ns;ndim=4
    start_ct=1;start_ct(3:4)=start_c(1:2)
    start_ut=1;start_ut(3:4)=start_u(1:2)
    start_dt=1;start_dt(3:4)=start_d(1:2)
    start_lt=1;start_lt(3:4)=start_l(1:2)
    start_rt=1;start_rt(3:4)=start_r(1:2)
    if(present(recd))then
      ndim=ndim+1;irec=recd
      start_ct(ndim)=recd
      start_ut(ndim)=recd;start_dt(ndim)=recd
      start_lt(ndim)=recd;start_rt(ndim)=recd
    endif
    count_ct=1;count_ct(3:4)=count_c(1:2);count_ct(1:2)=[kb,lm]
    count_ut=1;count_ut(3:4)=count_u(1:2);count_ut(1:2)=[kb,lm]
    count_dt=1;count_dt(3:4)=count_d(1:2);count_dt(1:2)=[kb,lm]
    count_lt=1;count_lt(3:4)=count_l(1:2);count_lt(1:2)=[kb,lm]
    count_rt=1;count_rt(3:4)=count_r(1:2);count_rt(1:2)=[kb,lm]
    allocate(Lvar(kb,lm,1,ljs:lje),Rvar(kb,lm,1,rjs:rje),&
             Uvar(kb,lm,uis:uie,1),Dvar(kb,lm,dis:die,1),&
             Cvar(kb,lm,is+1:ie-1,js+1:je-1)             )
    !count_ct(3)=kb;count_ct(4)=lm;
    !count_ut(3)=kb;count_ut(4)=lm;
    !count_dt(3)=kb;count_dt(4)=lm;
    !count_lt(3)=kb;count_lt(4)=lm;
    !count_rt(3)=kb;count_rt(4)=lm;
    !allocate(Lvar(1,ljs:lje,kb,lm),Rvar(1,rjs:rje,kb,lm),&
    !         Uvar(uis:uie,1,kb,lm),Dvar(dis:die,1,kb,lm),&
    !         Cvar(is+1:ie-1,js+1:je-1,kb,lm)          )
    Lvar=nf90_fill_real
    Rvar=nf90_fill_real
    Uvar=nf90_fill_real
    Dvar=nf90_fill_real
    Cvar=nf90_fill_real
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      !if(flag==0)Cvar(i,j,:,:)=var(:,:,idx+ss)
      !if(flag==1)Lvar(1,j,:,:)=var(:,:,idx+ss)
      !if(flag==2)Rvar(1,j,:,:)=var(:,:,idx+ss)
      !if(flag==3)Dvar(i,1,:,:)=var(:,:,idx+ss)
      !if(flag==4)Uvar(i,1,:,:)=var(:,:,idx+ss)
      if(flag==0)Cvar(:,:,i,j)=var(:,:,idx+ss)
      if(flag==1)Lvar(:,:,1,j)=var(:,:,idx+ss)
      if(flag==2)Rvar(:,:,1,j)=var(:,:,idx+ss)
      if(flag==3)Dvar(:,:,i,1)=var(:,:,idx+ss)
      if(flag==4)Uvar(:,:,i,1)=var(:,:,idx+ss)
    enddo
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_WRITE     ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    if(present(recd))stat=nf90mpi_fill_var_rec(ncid,vid,irec)
    stat=nf90mpi_put_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine writepnc_xyzzt_r4r4
!-------------------------------------------------------------------------------
  subroutine writepnc_xyzzt_r8r8(mpicomm ,&
                               filename,&
                               vname   ,&
                               var     ,&
                               ns      ,&
                               kb      ,&
                               lm      ,&
                               recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(8),intent(in) :: var(:,:,:)
    integer,intent(in) :: ns
    integer,intent(in) :: kb
    integer,intent(in) :: lm
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    real(8),allocatable :: Lvar(:,:,:,:)
    real(8),allocatable :: Rvar(:,:,:,:)
    real(8),allocatable :: Uvar(:,:,:,:)
    real(8),allocatable :: Dvar(:,:,:,:)
    real(8),allocatable :: Cvar(:,:,:,:)
    integer(8) :: irec

    ss=1-ns;ndim=4
    start_ct=1;start_ct(3:4)=start_c(1:2)
    start_ut=1;start_ut(3:4)=start_u(1:2)
    start_dt=1;start_dt(3:4)=start_d(1:2)
    start_lt=1;start_lt(3:4)=start_l(1:2)
    start_rt=1;start_rt(3:4)=start_r(1:2)
    if(present(recd))then
      ndim=ndim+1;irec=recd
      start_ct(ndim)=recd
      start_ut(ndim)=recd;start_dt(ndim)=recd
      start_lt(ndim)=recd;start_rt(ndim)=recd
    endif
    count_ct=1;count_ct(3:4)=count_c(1:2);count_ct(1:2)=[kb,lm]
    count_ut=1;count_ut(3:4)=count_u(1:2);count_ut(1:2)=[kb,lm]
    count_dt=1;count_dt(3:4)=count_d(1:2);count_dt(1:2)=[kb,lm]
    count_lt=1;count_lt(3:4)=count_l(1:2);count_lt(1:2)=[kb,lm]
    count_rt=1;count_rt(3:4)=count_r(1:2);count_rt(1:2)=[kb,lm]
    allocate(Lvar(kb,lm,1,ljs:lje),Rvar(kb,lm,1,rjs:rje),&
             Uvar(kb,lm,uis:uie,1),Dvar(kb,lm,dis:die,1),&
             Cvar(kb,lm,is+1:ie-1,js+1:je-1)             )
    !count_ct(3)=kb;count_ct(4)=lm;
    !count_ut(3)=kb;count_ut(4)=lm;
    !count_dt(3)=kb;count_dt(4)=lm;
    !count_lt(3)=kb;count_lt(4)=lm;
    !count_rt(3)=kb;count_rt(4)=lm;
    !allocate(Lvar(1,ljs:lje,kb,lm),Rvar(1,rjs:rje,kb,lm),&
    !         Uvar(uis:uie,1,kb,lm),Dvar(dis:die,1,kb,lm),&
    !         Cvar(is+1:ie-1,js+1:je-1,kb,lm)         )
    Lvar=nf90_fill_double
    Rvar=nf90_fill_double
    Uvar=nf90_fill_double
    Dvar=nf90_fill_double
    Cvar=nf90_fill_double
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      !if(flag==0)Cvar(i,j,:,:)=var(:,:,idx+ss)
      !if(flag==1)Lvar(1,j,:,:)=var(:,:,idx+ss)
      !if(flag==2)Rvar(1,j,:,:)=var(:,:,idx+ss)
      !if(flag==3)Dvar(i,1,:,:)=var(:,:,idx+ss)
      !if(flag==4)Uvar(i,1,:,:)=var(:,:,idx+ss)
      if(flag==0)Cvar(:,:,i,j)=var(:,:,idx+ss)
      if(flag==1)Lvar(:,:,1,j)=var(:,:,idx+ss)
      if(flag==2)Rvar(:,:,1,j)=var(:,:,idx+ss)
      if(flag==3)Dvar(:,:,i,1)=var(:,:,idx+ss)
      if(flag==4)Uvar(:,:,i,1)=var(:,:,idx+ss)
    enddo
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_WRITE     ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    if(present(recd))stat=nf90mpi_fill_var_rec(ncid,vid,irec)
    stat=nf90mpi_put_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_put_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine writepnc_xyzzt_r8r8
!-------------------------------------------------------------------------------
!-------------------------------------------------------------------------------
!-------------------------------------------------------------------------------
  subroutine readpnc_xyt_r8i2(mpicomm ,&
                              filename,&
                              vname   ,&
                              var     ,&
                              ns      ,&
                              scalfact,&
                              offset  ,&
                              recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(8),intent(out) :: var(:)
    integer,intent(in) :: ns
    real(8),intent(in) :: scalfact,offset
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    integer(2),allocatable :: Lvar(:,:)
    integer(2),allocatable :: Rvar(:,:)
    integer(2),allocatable :: Uvar(:,:)
    integer(2),allocatable :: Dvar(:,:)
    integer(2),allocatable :: Cvar(:,:)

    ss=1-ns;ndim=2
    start_ct=1;start_ct(1:2)=start_c(1:2)
    start_ut=1;start_ut(1:2)=start_u(1:2)
    start_dt=1;start_dt(1:2)=start_d(1:2)
    start_lt=1;start_lt(1:2)=start_l(1:2)
    start_rt=1;start_rt(1:2)=start_r(1:2)
    count_ct=1;count_ct(1:2)=count_c(1:2)
    count_ut=1;count_ut(1:2)=count_u(1:2)
    count_dt=1;count_dt(1:2)=count_d(1:2)
    count_lt=1;count_lt(1:2)=count_l(1:2)
    count_rt=1;count_rt(1:2)=count_r(1:2)
    if(present(recd))then
      ndim=3          ;start_ct(3)=recd
      start_ut(3)=recd;start_dt(3)=recd
      start_lt(3)=recd;start_rt(3)=recd
    endif
    allocate(Lvar(1,ljs:lje),Rvar(1,rjs:rje),&
             Uvar(uis:uie,1),Dvar(dis:die,1),&
             Cvar(is+1:ie-1,js+1:je-1)       )
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_NOWRITE   ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    stat=nf90mpi_get_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)var(idx+ss)=Cvar(i,j)*scalfact+offset
      if(flag==1)var(idx+ss)=Lvar(1,j)*scalfact+offset
      if(flag==2)var(idx+ss)=Rvar(1,j)*scalfact+offset
      if(flag==3)var(idx+ss)=Dvar(i,1)*scalfact+offset
      if(flag==4)var(idx+ss)=Uvar(i,1)*scalfact+offset
    enddo
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine readpnc_xyt_r8i2
!-------------------------------------------------------------------------------
  subroutine readpnc_xyt_r4i2(mpicomm ,&
                              filename,&
                              vname   ,&
                              var     ,&
                              ns      ,&
                              scalfact,&
                              offset  ,&
                              recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(4),intent(out) :: var(:)
    integer,intent(in) :: ns
    real(4),intent(in) :: scalfact,offset
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    integer(2),allocatable :: Lvar(:,:)
    integer(2),allocatable :: Rvar(:,:)
    integer(2),allocatable :: Uvar(:,:)
    integer(2),allocatable :: Dvar(:,:)
    integer(2),allocatable :: Cvar(:,:)

    ss=1-ns;ndim=2
    start_ct=1;start_ct(1:2)=start_c(1:2)
    start_ut=1;start_ut(1:2)=start_u(1:2)
    start_dt=1;start_dt(1:2)=start_d(1:2)
    start_lt=1;start_lt(1:2)=start_l(1:2)
    start_rt=1;start_rt(1:2)=start_r(1:2)
    count_ct=1;count_ct(1:2)=count_c(1:2)
    count_ut=1;count_ut(1:2)=count_u(1:2)
    count_dt=1;count_dt(1:2)=count_d(1:2)
    count_lt=1;count_lt(1:2)=count_l(1:2)
    count_rt=1;count_rt(1:2)=count_r(1:2)
    if(present(recd))then
      ndim=3          ;start_ct(3)=recd
      start_ut(3)=recd;start_dt(3)=recd
      start_lt(3)=recd;start_rt(3)=recd
    endif
    allocate(Lvar(1,ljs:lje),Rvar(1,rjs:rje),&
             Uvar(uis:uie,1),Dvar(dis:die,1),&
             Cvar(is+1:ie-1,js+1:je-1)       )
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_NOWRITE   ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    stat=nf90mpi_get_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)var(idx+ss)=Cvar(i,j)*scalfact+offset
      if(flag==1)var(idx+ss)=Lvar(1,j)*scalfact+offset
      if(flag==2)var(idx+ss)=Rvar(1,j)*scalfact+offset
      if(flag==3)var(idx+ss)=Dvar(i,1)*scalfact+offset
      if(flag==4)var(idx+ss)=Uvar(i,1)*scalfact+offset
    enddo
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine readpnc_xyt_r4i2
!-------------------------------------------------------------------------------
  subroutine readpnc_xyt_r4r4(mpicomm ,&
                              filename,&
                              vname   ,&
                              var     ,&
                              ns      ,&
                              recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(4),intent(out) :: var(:)
    integer,intent(in) :: ns
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    real(4),allocatable :: Lvar(:,:)
    real(4),allocatable :: Rvar(:,:)
    real(4),allocatable :: Uvar(:,:)
    real(4),allocatable :: Dvar(:,:)
    real(4),allocatable :: Cvar(:,:)

    ss=1-ns;ndim=2
    start_ct=1;start_ct(1:2)=start_c(1:2)
    start_ut=1;start_ut(1:2)=start_u(1:2)
    start_dt=1;start_dt(1:2)=start_d(1:2)
    start_lt=1;start_lt(1:2)=start_l(1:2)
    start_rt=1;start_rt(1:2)=start_r(1:2)
    count_ct=1;count_ct(1:2)=count_c(1:2)
    count_ut=1;count_ut(1:2)=count_u(1:2)
    count_dt=1;count_dt(1:2)=count_d(1:2)
    count_lt=1;count_lt(1:2)=count_l(1:2)
    count_rt=1;count_rt(1:2)=count_r(1:2)
    if(present(recd))then
      ndim=3          ;start_ct(3)=recd
      start_ut(3)=recd;start_dt(3)=recd
      start_lt(3)=recd;start_rt(3)=recd
    endif
    allocate(Lvar(1,ljs:lje),Rvar(1,rjs:rje),&
             Uvar(uis:uie,1),Dvar(dis:die,1),&
             Cvar(is+1:ie-1,js+1:je-1)       )
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_NOWRITE   ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    stat=nf90mpi_get_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)var(idx+ss)=Cvar(i,j)
      if(flag==1)var(idx+ss)=Lvar(1,j)
      if(flag==2)var(idx+ss)=Rvar(1,j)
      if(flag==3)var(idx+ss)=Dvar(i,1)
      if(flag==4)var(idx+ss)=Uvar(i,1)
    enddo
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine readpnc_xyt_r4r4
!-------------------------------------------------------------------------------
  subroutine readpnc_xyt_r8r8(mpicomm ,&
                              filename,&
                              vname   ,&
                              var     ,&
                              ns      ,&
                              recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(8),intent(out) :: var(:)
    integer,intent(in) :: ns
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    real(8),allocatable :: Lvar(:,:)
    real(8),allocatable :: Rvar(:,:)
    real(8),allocatable :: Uvar(:,:)
    real(8),allocatable :: Dvar(:,:)
    real(8),allocatable :: Cvar(:,:)

    ss=1-ns;ndim=2
    start_ct=1;start_ct(1:2)=start_c(1:2)
    start_ut=1;start_ut(1:2)=start_u(1:2)
    start_dt=1;start_dt(1:2)=start_d(1:2)
    start_lt=1;start_lt(1:2)=start_l(1:2)
    start_rt=1;start_rt(1:2)=start_r(1:2)
    count_ct=1;count_ct(1:2)=count_c(1:2)
    count_ut=1;count_ut(1:2)=count_u(1:2)
    count_dt=1;count_dt(1:2)=count_d(1:2)
    count_lt=1;count_lt(1:2)=count_l(1:2)
    count_rt=1;count_rt(1:2)=count_r(1:2)
    if(present(recd))then
      ndim=3          ;start_ct(3)=recd
      start_ut(3)=recd;start_dt(3)=recd
      start_lt(3)=recd;start_rt(3)=recd
    endif
    allocate(Lvar(1,ljs:lje),Rvar(1,rjs:rje),&
             Uvar(uis:uie,1),Dvar(dis:die,1),&
             Cvar(is+1:ie-1,js+1:je-1)       )
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_NOWRITE   ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    stat=nf90mpi_get_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)var(idx+ss)=Cvar(i,j)
      if(flag==1)var(idx+ss)=Lvar(1,j)
      if(flag==2)var(idx+ss)=Rvar(1,j)
      if(flag==3)var(idx+ss)=Dvar(i,1)
      if(flag==4)var(idx+ss)=Uvar(i,1)
    enddo
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine readpnc_xyt_r8r8
!-------------------------------------------------------------------------------
  subroutine readpnc_xyzt_r8i2(mpicomm ,&
                              filename,&
                              vname   ,&
                              var     ,&
                              ns      ,&
                              kb      ,&
                              scalfact,&
                              offset  ,&
                              recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(8),intent(out) :: var(:,:)
    integer,intent(in) :: ns
    integer,intent(in) :: kb
    real(8),intent(in) :: scalfact,offset
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    integer(2),allocatable :: Lvar(:,:,:)
    integer(2),allocatable :: Rvar(:,:,:)
    integer(2),allocatable :: Uvar(:,:,:)
    integer(2),allocatable :: Dvar(:,:,:)
    integer(2),allocatable :: Cvar(:,:,:)

    ss=1-ns;ndim=3
    start_ct=1;start_ct(1:2)=start_c(1:2)
    start_ut=1;start_ut(1:2)=start_u(1:2)
    start_dt=1;start_dt(1:2)=start_d(1:2)
    start_lt=1;start_lt(1:2)=start_l(1:2)
    start_rt=1;start_rt(1:2)=start_r(1:2)
    count_ct=1;count_ct(1:2)=count_c(1:2);count_ct(3)=kb
    count_ut=1;count_ut(1:2)=count_u(1:2);count_ut(3)=kb
    count_dt=1;count_dt(1:2)=count_d(1:2);count_dt(3)=kb
    count_lt=1;count_lt(1:2)=count_l(1:2);count_lt(3)=kb
    count_rt=1;count_rt(1:2)=count_r(1:2);count_rt(3)=kb
    if(present(recd))then
      ndim=ndim+1;start_ct(ndim)=recd
      start_ut(ndim)=recd;start_dt(ndim)=recd
      start_lt(ndim)=recd;start_rt(ndim)=recd
    endif
    allocate(Lvar(1,ljs:lje,kb),Rvar(1,rjs:rje,kb),&
             Uvar(uis:uie,1,kb),Dvar(dis:die,1,kb),&
             Cvar(is+1:ie-1,js+1:je-1,kb)          )
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_NOWRITE   ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    stat=nf90mpi_get_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)var(:,idx+ss)=Cvar(i,j,:)*scalfact+offset
      if(flag==1)var(:,idx+ss)=Lvar(1,j,:)*scalfact+offset
      if(flag==2)var(:,idx+ss)=Rvar(1,j,:)*scalfact+offset
      if(flag==3)var(:,idx+ss)=Dvar(i,1,:)*scalfact+offset
      if(flag==4)var(:,idx+ss)=Uvar(i,1,:)*scalfact+offset
    enddo
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine readpnc_xyzt_r8i2
!-------------------------------------------------------------------------------
  subroutine readpnc_xyzt_r4i2(mpicomm ,&
                              filename,&
                              vname   ,&
                              var     ,&
                              ns      ,&
                              kb      ,&
                              scalfact,&
                              offset  ,&
                              recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(4),intent(out) :: var(:,:)
    integer,intent(in) :: ns
    integer,intent(in) :: kb
    real(4),intent(in) :: scalfact,offset
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    integer(2),allocatable :: Lvar(:,:,:)
    integer(2),allocatable :: Rvar(:,:,:)
    integer(2),allocatable :: Uvar(:,:,:)
    integer(2),allocatable :: Dvar(:,:,:)
    integer(2),allocatable :: Cvar(:,:,:)

    ss=1-ns;ndim=3
    start_ct=1;start_ct(1:2)=start_c(1:2)
    start_ut=1;start_ut(1:2)=start_u(1:2)
    start_dt=1;start_dt(1:2)=start_d(1:2)
    start_lt=1;start_lt(1:2)=start_l(1:2)
    start_rt=1;start_rt(1:2)=start_r(1:2)
    count_ct=1;count_ct(1:2)=count_c(1:2);count_ct(3)=kb
    count_ut=1;count_ut(1:2)=count_u(1:2);count_ut(3)=kb
    count_dt=1;count_dt(1:2)=count_d(1:2);count_dt(3)=kb
    count_lt=1;count_lt(1:2)=count_l(1:2);count_lt(3)=kb
    count_rt=1;count_rt(1:2)=count_r(1:2);count_rt(3)=kb
    if(present(recd))then
      ndim=ndim+1;start_ct(ndim)=recd
      start_ut(ndim)=recd;start_dt(ndim)=recd
      start_lt(ndim)=recd;start_rt(ndim)=recd
    endif
    allocate(Lvar(1,ljs:lje,kb),Rvar(1,rjs:rje,kb),&
             Uvar(uis:uie,1,kb),Dvar(dis:die,1,kb),&
             Cvar(is+1:ie-1,js+1:je-1,kb)          )
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_NOWRITE   ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    stat=nf90mpi_get_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)var(:,idx+ss)=Cvar(i,j,:)*scalfact+offset
      if(flag==1)var(:,idx+ss)=Lvar(1,j,:)*scalfact+offset
      if(flag==2)var(:,idx+ss)=Rvar(1,j,:)*scalfact+offset
      if(flag==3)var(:,idx+ss)=Dvar(i,1,:)*scalfact+offset
      if(flag==4)var(:,idx+ss)=Uvar(i,1,:)*scalfact+offset
    enddo
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine readpnc_xyzt_r4i2
!-------------------------------------------------------------------------------
  subroutine readpnc_xyzt_r4r4(mpicomm ,&
                              filename,&
                              vname   ,&
                              var     ,&
                              ns      ,&
                              kb      ,&
                              recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(4),intent(out) :: var(:,:)
    integer,intent(in) :: ns
    integer,intent(in) :: kb
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    real(4),allocatable :: Lvar(:,:,:)
    real(4),allocatable :: Rvar(:,:,:)
    real(4),allocatable :: Uvar(:,:,:)
    real(4),allocatable :: Dvar(:,:,:)
    real(4),allocatable :: Cvar(:,:,:)

    ss=1-ns;ndim=3
    start_ct=1;start_ct(1:2)=start_c(1:2)
    start_ut=1;start_ut(1:2)=start_u(1:2)
    start_dt=1;start_dt(1:2)=start_d(1:2)
    start_lt=1;start_lt(1:2)=start_l(1:2)
    start_rt=1;start_rt(1:2)=start_r(1:2)
    count_ct=1;count_ct(1:2)=count_c(1:2);count_ct(3)=kb
    count_ut=1;count_ut(1:2)=count_u(1:2);count_ut(3)=kb
    count_dt=1;count_dt(1:2)=count_d(1:2);count_dt(3)=kb
    count_lt=1;count_lt(1:2)=count_l(1:2);count_lt(3)=kb
    count_rt=1;count_rt(1:2)=count_r(1:2);count_rt(3)=kb
    if(present(recd))then
      ndim=ndim+1;start_ct(ndim)=recd
      start_ut(ndim)=recd;start_dt(ndim)=recd
      start_lt(ndim)=recd;start_rt(ndim)=recd
    endif
    allocate(Lvar(1,ljs:lje,kb),Rvar(1,rjs:rje,kb),&
             Uvar(uis:uie,1,kb),Dvar(dis:die,1,kb),&
             Cvar(is+1:ie-1,js+1:je-1,kb)          )
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_NOWRITE   ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    stat=nf90mpi_get_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)var(:,idx+ss)=Cvar(i,j,:)
      if(flag==1)var(:,idx+ss)=Lvar(1,j,:)
      if(flag==2)var(:,idx+ss)=Rvar(1,j,:)
      if(flag==3)var(:,idx+ss)=Dvar(i,1,:)
      if(flag==4)var(:,idx+ss)=Uvar(i,1,:)
    enddo
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine readpnc_xyzt_r4r4
!-------------------------------------------------------------------------------
  subroutine readpnc_xyzt_r8r8(mpicomm ,&
                              filename,&
                              vname   ,&
                              var     ,&
                              ns      ,&
                              kb      ,&
                              recd     )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(8),intent(out) :: var(:,:)
    integer,intent(in) :: ns
    integer,intent(in) :: kb
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    real(8),allocatable :: Lvar(:,:,:)
    real(8),allocatable :: Rvar(:,:,:)
    real(8),allocatable :: Uvar(:,:,:)
    real(8),allocatable :: Dvar(:,:,:)
    real(8),allocatable :: Cvar(:,:,:)

    ss=1-ns;ndim=3
    start_ct=1;start_ct(1:2)=start_c(1:2)
    start_ut=1;start_ut(1:2)=start_u(1:2)
    start_dt=1;start_dt(1:2)=start_d(1:2)
    start_lt=1;start_lt(1:2)=start_l(1:2)
    start_rt=1;start_rt(1:2)=start_r(1:2)
    count_ct=1;count_ct(1:2)=count_c(1:2);count_ct(3)=kb
    count_ut=1;count_ut(1:2)=count_u(1:2);count_ut(3)=kb
    count_dt=1;count_dt(1:2)=count_d(1:2);count_dt(3)=kb
    count_lt=1;count_lt(1:2)=count_l(1:2);count_lt(3)=kb
    count_rt=1;count_rt(1:2)=count_r(1:2);count_rt(3)=kb
    if(present(recd))then
      ndim=ndim+1;start_ct(ndim)=recd
      start_ut(ndim)=recd;start_dt(ndim)=recd
      start_lt(ndim)=recd;start_rt(ndim)=recd
    endif
    allocate(Lvar(1,ljs:lje,kb),Rvar(1,rjs:rje,kb),&
             Uvar(uis:uie,1,kb),Dvar(dis:die,1,kb),&
             Cvar(is+1:ie-1,js+1:je-1,kb)          )
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_NOWRITE   ,&
                     MPI_INFO_NULL,&
                     ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    stat=nf90mpi_get_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)var(:,idx+ss)=Cvar(i,j,:)
      if(flag==1)var(:,idx+ss)=Lvar(1,j,:)
      if(flag==2)var(:,idx+ss)=Rvar(1,j,:)
      if(flag==3)var(:,idx+ss)=Dvar(i,1,:)
      if(flag==4)var(:,idx+ss)=Uvar(i,1,:)
    enddo
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine readpnc_xyzt_r8r8
!-------------------------------------------------------------------------------
  subroutine readpnc_xyzzt_r8i2(mpicomm,&
                              filename ,&
                              vname    ,&
                              var      ,&
                              ns       ,&
                              kb       ,&
                              lm       ,&
                              scalfact ,&
                              offset   ,&
                              recd      )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(8),intent(out) :: var(:,:,:)
    integer,intent(in) :: ns
    integer,intent(in) :: kb
    integer,intent(in) :: lm
    real(8),intent(in) :: scalfact,offset
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    integer(2),allocatable :: Lvar(:,:,:,:)
    integer(2),allocatable :: Rvar(:,:,:,:)
    integer(2),allocatable :: Uvar(:,:,:,:)
    integer(2),allocatable :: Dvar(:,:,:,:)
    integer(2),allocatable :: Cvar(:,:,:,:)

    ss=1-ns;ndim=4
    start_ct=1;start_ct(3:4)=start_c(1:2)
    start_ut=1;start_ut(3:4)=start_u(1:2)
    start_dt=1;start_dt(3:4)=start_d(1:2)
    start_lt=1;start_lt(3:4)=start_l(1:2)
    start_rt=1;start_rt(3:4)=start_r(1:2)
    if(present(recd))then
      ndim=ndim+1;start_ct(ndim)=recd
      start_ut(ndim)=recd;start_dt(ndim)=recd
      start_lt(ndim)=recd;start_rt(ndim)=recd
    endif
    count_ct=1;count_ct(3:4)=count_c(1:2);count_ct(1:2)=[kb,lm]
    count_ut=1;count_ut(3:4)=count_u(1:2);count_ut(1:2)=[kb,lm]
    count_dt=1;count_dt(3:4)=count_d(1:2);count_dt(1:2)=[kb,lm]
    count_lt=1;count_lt(3:4)=count_l(1:2);count_lt(1:2)=[kb,lm]
    count_rt=1;count_rt(3:4)=count_r(1:2);count_rt(1:2)=[kb,lm]
    allocate(Lvar(kb,lm,1,ljs:lje),Rvar(kb,lm,1,rjs:rje),&
             Uvar(kb,lm,uis:uie,1),Dvar(kb,lm,dis:die,1),&
             Cvar(kb,lm,is+1:ie-1,js+1:je-1)             )
    !count_ct(3)=kb;count_ct(4)=lm;
    !count_ut(3)=kb;count_ut(4)=lm;
    !count_dt(3)=kb;count_dt(4)=lm;
    !count_lt(3)=kb;count_lt(4)=lm;
    !count_rt(3)=kb;count_rt(4)=lm;
    !allocate(Lvar(1,ljs:lje,kb,lm),Rvar(1,rjs:rje,kb,lm),&
    !         Uvar(uis:uie,1,kb,lm),Dvar(dis:die,1,kb,lm),&
    !         Cvar(is+1:ie-1,js+1:je-1,kb,lm)          )
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_NOCLOBBER ,&
                     MPI_INFO_NULL,&
                     ncid          )
    !stat=nf90mpi_open(mpicomm     ,&
    !                 filename     ,&
    !                 NF_NOWRITE   ,&
    !                 MPI_INFO_NULL,&
    !                 ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    stat=nf90mpi_get_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)var(:,:,idx+ss)=Cvar(:,:,i,j)*scalfact+offset
      if(flag==1)var(:,:,idx+ss)=Lvar(:,:,1,j)*scalfact+offset
      if(flag==2)var(:,:,idx+ss)=Rvar(:,:,1,j)*scalfact+offset
      if(flag==3)var(:,:,idx+ss)=Dvar(:,:,i,1)*scalfact+offset
      if(flag==4)var(:,:,idx+ss)=Uvar(:,:,i,1)*scalfact+offset
      !if(flag==0)var(:,:,idx+ss)=Cvar(i,j,:,:)*scalfact+offset
      !if(flag==1)var(:,:,idx+ss)=Lvar(1,j,:,:)*scalfact+offset
      !if(flag==2)var(:,:,idx+ss)=Rvar(1,j,:,:)*scalfact+offset
      !if(flag==3)var(:,:,idx+ss)=Dvar(i,1,:,:)*scalfact+offset
      !if(flag==4)var(:,:,idx+ss)=Uvar(i,1,:,:)*scalfact+offset
    enddo
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine readpnc_xyzzt_r8i2
!-------------------------------------------------------------------------------
  subroutine readpnc_xyzzt_r4i2(mpicomm,&
                              filename ,&
                              vname    ,&
                              var      ,&
                              ns       ,&
                              kb       ,&
                              lm       ,&
                              scalfact ,&
                              offset   ,&
                              recd      )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(4),intent(out) :: var(:,:,:)
    integer,intent(in) :: ns
    integer,intent(in) :: kb
    integer,intent(in) :: lm
    real(4),intent(in) :: scalfact,offset
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    integer(2),allocatable :: Lvar(:,:,:,:)
    integer(2),allocatable :: Rvar(:,:,:,:)
    integer(2),allocatable :: Uvar(:,:,:,:)
    integer(2),allocatable :: Dvar(:,:,:,:)
    integer(2),allocatable :: Cvar(:,:,:,:)

    ss=1-ns;ndim=4
    start_ct=1;start_ct(3:4)=start_c(1:2)
    start_ut=1;start_ut(3:4)=start_u(1:2)
    start_dt=1;start_dt(3:4)=start_d(1:2)
    start_lt=1;start_lt(3:4)=start_l(1:2)
    start_rt=1;start_rt(3:4)=start_r(1:2)
    if(present(recd))then
      ndim=ndim+1;start_ct(ndim)=recd
      start_ut(ndim)=recd;start_dt(ndim)=recd
      start_lt(ndim)=recd;start_rt(ndim)=recd
    endif
    count_ct=1;count_ct(3:4)=count_c(1:2);count_ct(1:2)=[kb,lm]
    count_ut=1;count_ut(3:4)=count_u(1:2);count_ut(1:2)=[kb,lm]
    count_dt=1;count_dt(3:4)=count_d(1:2);count_dt(1:2)=[kb,lm]
    count_lt=1;count_lt(3:4)=count_l(1:2);count_lt(1:2)=[kb,lm]
    count_rt=1;count_rt(3:4)=count_r(1:2);count_rt(1:2)=[kb,lm]
    allocate(Lvar(kb,lm,1,ljs:lje),Rvar(kb,lm,1,rjs:rje),&
             Uvar(kb,lm,uis:uie,1),Dvar(kb,lm,dis:die,1),&
             Cvar(kb,lm,is+1:ie-1,js+1:je-1)             )
    !count_ct(3)=kb;count_ct(4)=lm;
    !count_ut(3)=kb;count_ut(4)=lm;
    !count_dt(3)=kb;count_dt(4)=lm;
    !count_lt(3)=kb;count_lt(4)=lm;
    !count_rt(3)=kb;count_rt(4)=lm;
    !allocate(Lvar(1,ljs:lje,kb,lm),Rvar(1,rjs:rje,kb,lm),&
    !         Uvar(uis:uie,1,kb,lm),Dvar(dis:die,1,kb,lm),&
    !         Cvar(is+1:ie-1,js+1:je-1,kb,lm)          )
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_NOCLOBBER ,&
                     MPI_INFO_NULL,&
                     ncid          )
    !stat=nf90mpi_open(mpicomm     ,&
    !                 filename     ,&
    !                 NF_NOWRITE   ,&
    !                 MPI_INFO_NULL,&
    !                 ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    stat=nf90mpi_get_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      if(flag==0)var(:,:,idx+ss)=Cvar(:,:,i,j)*scalfact+offset
      if(flag==1)var(:,:,idx+ss)=Lvar(:,:,1,j)*scalfact+offset
      if(flag==2)var(:,:,idx+ss)=Rvar(:,:,1,j)*scalfact+offset
      if(flag==3)var(:,:,idx+ss)=Dvar(:,:,i,1)*scalfact+offset
      if(flag==4)var(:,:,idx+ss)=Uvar(:,:,i,1)*scalfact+offset
      !if(flag==0)var(:,:,idx+ss)=Cvar(i,j,:,:)*scalfact+offset
      !if(flag==1)var(:,:,idx+ss)=Lvar(1,j,:,:)*scalfact+offset
      !if(flag==2)var(:,:,idx+ss)=Rvar(1,j,:,:)*scalfact+offset
      !if(flag==3)var(:,:,idx+ss)=Dvar(i,1,:,:)*scalfact+offset
      !if(flag==4)var(:,:,idx+ss)=Uvar(i,1,:,:)*scalfact+offset
    enddo
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine readpnc_xyzzt_r4i2
!-------------------------------------------------------------------------------
  subroutine readpnc_xyzzt_r4r4(mpicomm,&
                              filename ,&
                              vname    ,&
                              var      ,&
                              ns       ,&
                              kb       ,&
                              lm       ,&
                              recd      )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(4),intent(out) :: var(:,:,:)
    integer,intent(in) :: ns
    integer,intent(in) :: kb
    integer,intent(in) :: lm
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    real(4),allocatable :: Lvar(:,:,:,:)
    real(4),allocatable :: Rvar(:,:,:,:)
    real(4),allocatable :: Uvar(:,:,:,:)
    real(4),allocatable :: Dvar(:,:,:,:)
    real(4),allocatable :: Cvar(:,:,:,:)

    ss=1-ns;ndim=4
    start_ct=1;start_ct(3:4)=start_c(1:2)
    start_ut=1;start_ut(3:4)=start_u(1:2)
    start_dt=1;start_dt(3:4)=start_d(1:2)
    start_lt=1;start_lt(3:4)=start_l(1:2)
    start_rt=1;start_rt(3:4)=start_r(1:2)
    if(present(recd))then
      ndim=ndim+1;start_ct(ndim)=recd
      start_ut(ndim)=recd;start_dt(ndim)=recd
      start_lt(ndim)=recd;start_rt(ndim)=recd
    endif
    count_ct=1;count_ct(3:4)=count_c(1:2);count_ct(1:2)=[kb,lm]
    count_ut=1;count_ut(3:4)=count_u(1:2);count_ut(1:2)=[kb,lm]
    count_dt=1;count_dt(3:4)=count_d(1:2);count_dt(1:2)=[kb,lm]
    count_lt=1;count_lt(3:4)=count_l(1:2);count_lt(1:2)=[kb,lm]
    count_rt=1;count_rt(3:4)=count_r(1:2);count_rt(1:2)=[kb,lm]
    allocate(Lvar(kb,lm,1,ljs:lje),Rvar(kb,lm,1,rjs:rje),&
             Uvar(kb,lm,uis:uie,1),Dvar(kb,lm,dis:die,1),&
             Cvar(kb,lm,is+1:ie-1,js+1:je-1)             )
    !count_ct(3)=kb;count_ct(4)=lm;
    !count_ut(3)=kb;count_ut(4)=lm;
    !count_dt(3)=kb;count_dt(4)=lm;
    !count_lt(3)=kb;count_lt(4)=lm;
    !count_rt(3)=kb;count_rt(4)=lm;
    !allocate(Lvar(1,ljs:lje,kb,lm),Rvar(1,rjs:rje,kb,lm),&
    !         Uvar(uis:uie,1,kb,lm),Dvar(dis:die,1,kb,lm),&
    !         Cvar(is+1:ie-1,js+1:je-1,kb,lm)          )
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_NOCLOBBER ,&
                     MPI_INFO_NULL,&
                     ncid          )
    !stat=nf90mpi_open(mpicomm     ,&
    !                 filename     ,&
    !                 NF_NOWRITE   ,&
    !                 MPI_INFO_NULL,&
    !                 ncid          )
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    stat=nf90mpi_get_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      !if(flag==0)var(:,:,idx+ss)=Cvar(i,j,:,:)
      !if(flag==1)var(:,:,idx+ss)=Lvar(1,j,:,:)
      !if(flag==2)var(:,:,idx+ss)=Rvar(1,j,:,:)
      !if(flag==3)var(:,:,idx+ss)=Dvar(i,1,:,:)
      !if(flag==4)var(:,:,idx+ss)=Uvar(i,1,:,:)
      if(flag==0)var(:,:,idx+ss)=Cvar(:,:,i,j)
      if(flag==1)var(:,:,idx+ss)=Lvar(:,:,1,j)
      if(flag==2)var(:,:,idx+ss)=Rvar(:,:,1,j)
      if(flag==3)var(:,:,idx+ss)=Dvar(:,:,i,1)
      if(flag==4)var(:,:,idx+ss)=Uvar(:,:,i,1)
    enddo
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine readpnc_xyzzt_r4r4
!-------------------------------------------------------------------------------
  subroutine readpnc_xyzzt_r8r8(mpicomm,&
                              filename ,&
                              vname    ,&
                              var      ,&
                              ns       ,&
                              kb       ,&
                              lm       ,&
                              recd      )
    integer,intent(in) :: mpicomm
    character(len=*),intent(in) :: filename,vname
    real(8),intent(out) :: var(:,:,:)
    integer,intent(in) :: ns
    integer,intent(in) :: kb
    integer,intent(in) :: lm
    integer,intent(in),optional :: recd

    integer :: stat,ncid,vid,flag,i,j,idx,ndim,ss
    real(8),allocatable :: Lvar(:,:,:,:)
    real(8),allocatable :: Rvar(:,:,:,:)
    real(8),allocatable :: Uvar(:,:,:,:)
    real(8),allocatable :: Dvar(:,:,:,:)
    real(8),allocatable :: Cvar(:,:,:,:)

    ss=1-ns;ndim=4
    start_ct=1;start_ct(3:4)=start_c(1:2)
    start_ut=1;start_ut(3:4)=start_u(1:2)
    start_dt=1;start_dt(3:4)=start_d(1:2)
    start_lt=1;start_lt(3:4)=start_l(1:2)
    start_rt=1;start_rt(3:4)=start_r(1:2)
    if(present(recd))then
      ndim=ndim+1;start_ct(ndim)=recd
      start_ut(ndim)=recd;start_dt(ndim)=recd
      start_lt(ndim)=recd;start_rt(ndim)=recd
    endif
    count_ct=1;count_ct(3:4)=count_c(1:2);count_ct(1:2)=[kb,lm]
    count_ut=1;count_ut(3:4)=count_u(1:2);count_ut(1:2)=[kb,lm]
    count_dt=1;count_dt(3:4)=count_d(1:2);count_dt(1:2)=[kb,lm]
    count_lt=1;count_lt(3:4)=count_l(1:2);count_lt(1:2)=[kb,lm]
    count_rt=1;count_rt(3:4)=count_r(1:2);count_rt(1:2)=[kb,lm]
    allocate(Lvar(kb,lm,1,ljs:lje),Rvar(kb,lm,1,rjs:rje),&
             Uvar(kb,lm,uis:uie,1),Dvar(kb,lm,dis:die,1),&
             Cvar(kb,lm,is+1:ie-1,js+1:je-1)             )
    !count_ct(3)=kb;count_ct(4)=lm;
    !count_ut(3)=kb;count_ut(4)=lm;
    !count_dt(3)=kb;count_dt(4)=lm;
    !count_lt(3)=kb;count_lt(4)=lm;
    !count_rt(3)=kb;count_rt(4)=lm;
    !allocate(Lvar(1,ljs:lje,kb,lm),Rvar(1,rjs:rje,kb,lm),&
    !         Uvar(uis:uie,1,kb,lm),Dvar(dis:die,1,kb,lm),&
    !         Cvar(is+1:ie-1,js+1:je-1,kb,lm)          )
    stat=nf90mpi_open(mpicomm     ,&
                     filename     ,&
                     NF_NOCLOBBER ,&
                     MPI_INFO_NULL,&
                     ncid          )
    !stat=nf90mpi_open(mpicomm     ,&
    !                 filename     ,&
    !                 NF_NOWRITE   ,&
    !                 MPI_INFO_NULL,&
    !                 ncid          )
    call check(stat,'readpnc_xyzzt_r8r8')
    stat=nf90mpi_inq_varid(ncid,vname,vid)
    stat=nf90mpi_get_var_all(ncid,vid,Cvar,start_Ct(1:ndim),count_Ct(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Lvar,start_Lt(1:ndim),count_Lt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Rvar,start_Rt(1:ndim),count_Rt(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Uvar,start_Ut(1:ndim),count_Ut(1:ndim))
    stat=nf90mpi_get_var_all(ncid,vid,Dvar,start_Dt(1:ndim),count_Dt(1:ndim))
    stat=nf90mpi_close(ncid)
    call check(stat,'readpnc_xyzzt_r8r8')
    var=0
    do idx=1,npc
      i=plist(idx)%i;j=plist(idx)%j;flag=check_parts(i,j)
      !if(flag==0)var(:,:,idx+ss)=Cvar(i,j,:,:)
      !if(flag==1)var(:,:,idx+ss)=Lvar(1,j,:,:)
      !if(flag==2)var(:,:,idx+ss)=Rvar(1,j,:,:)
      !if(flag==3)var(:,:,idx+ss)=Dvar(i,1,:,:)
      !if(flag==4)var(:,:,idx+ss)=Uvar(i,1,:,:)
      if(flag==0)var(:,:,idx+ss)=Cvar(:,:,i,j)
      if(flag==1)var(:,:,idx+ss)=Lvar(:,:,1,j)
      if(flag==2)var(:,:,idx+ss)=Rvar(:,:,1,j)
      if(flag==3)var(:,:,idx+ss)=Dvar(:,:,i,1)
      if(flag==4)var(:,:,idx+ss)=Uvar(:,:,i,1)
      !if(maxval(abs(var(:,:,idx+ss)))>1000)then
      !   write(*,*)'check',idx+ss,i,j,flag
      !endif
    enddo
    deallocate(Lvar,Rvar,Uvar,Dvar,Cvar)
  end subroutine readpnc_xyzzt_r8r8
!-------------------------------------------------------------------------------
!integer function nf90mpi_get_var_all(ncid, varid, values, start, stride, map, bufcount, buftype)
!    integer,                                                intent( in) :: ncid
!    integer,                                                intent( in) :: varid
!    <any valid type, scalar or array of any rank>,          intent(out) :: values
!    integer (kind=MPI_OFFSET_KIND), dimension(:), optional, intent( in) :: start
!    integer (kind=MPI_OFFSET_KIND), dimension(:), optional, intent( in) :: count
!    integer (kind=MPI_OFFSET_KIND), dimension(:), optional, intent( in) :: stride
!    integer (kind=MPI_OFFSET_KIND), dimension(:), optional, intent( in) :: map
!    integer (kind=MPI_OFFSET_KIND),               optional, intent( in) :: bufcount
!    integer,                                      optional, intent( in) :: buftype
!-------------------------------------------------------------------------------
 end module pncio_mod
!-------------------------------------------------------------------------------

