#define DBG  print*,__FILE__,__LINE__
module climdata_mod
  use netcdf_mod
  implicit none
  
  public :: itpinf_type
  public :: clim_interp
  public :: prepare_monthly_clmdata,climdata_mod_init,climdata_mod_final
  public :: check_sctdata,check_sctdata_prf
  private
  
  integer :: climdata_mod_initialized=0
  character(len=100) :: clmpath
  character(len=10) :: xname,yname,zname
  real(4),allocatable,target :: temp(:,:,:)
  real(4),allocatable,target :: salt(:,:,:)
  real(4),allocatable,target :: sstd(:,:,:)
  real(4),allocatable,target :: tstd(:,:,:)
  real(8),allocatable,target :: topo(:,:),lon(:),lat(:),dep(:)
  integer,allocatable,target :: mask(:,:)
  real(8) :: x0,dx,y0,dy
  integer :: im,jm,km
  integer :: moncurrent=0
  
  real(4),parameter :: small=1.e-7
  real(4),parameter :: missvalue=-9999.9 !missvalue=-1.e20   !------Modified by zhaoyd
  
  type itpinf_type
    integer :: i(8),j(8),k(8)
    real(8) :: wgt(8)
    !------------------------------------------------------!
    !          (2)--------(4)                              !
    !          /|         /|        z direction            !
    !         / |        / |        |                      !
    !  k    (1)--------(3) |        |   y direction        !
    !        |  |       |  |        |  /                   !
    !        | (6)------|-(8)  j1   | /                    !
    !        | /        | /         |/                     !
    !        |/         |/          +-------> x direction. !
    ! k1    (5)--------(7)   j                             !
    !        i          i1                                 !
    !------------------------------------------------------!
  end type itpinf_type
  
  type(itpinf_type) :: widx
  
  contains
  
  ! given (x,y,z) return the interp needed grid-index and weight.
  ! given (x,y,z) return the value and std in clim, the variable ID is also needed.
  ! call clim_interp(x,y,z,t=tclim,td=tdclim)
  subroutine clim_interp(x,y,z,widx,t,td,s,sd)
    real(8),intent(in) :: x,y,z
    type(itpinf_type),intent(out),optional,target :: widx
    real(4),intent(out),optional :: t,s,td,sd
    integer :: i,j,k,i1,j1,k1
    type(itpinf_type) :: widxp
    real(8) :: a,b,w
    i=int((x-x0)/dx)+1
    i1=i+1;if(i1>im)i1=1
    a=(x-lon(i))/dx
    j=int((y-y0)/dy)+1
    if(j<0)then
      j=1;j1=1             ! y is less than lat(1)
    else
      j1=j+1;if(j1>jm)j=jm ! y is greater than lat(jm)
    endif
    b=(y-lat(j))/dy
    k=0
    do k1=2,km
      if(dep(k1)>z)then
        k=k1-1;exit
      endif
    enddo
    ! set value for w, 20200904
    if(k>0)then
      w=(z-dep(k))/(dep(k1)-dep(k))
    else
      k=1;k1=1;w=1.0
    endif
!    DBG,i,i1,lon(i),lon(i1),x
!    DBG,j,j1,lat(j),lat(j1),y
!    DBG,k,k1,dep(k),dep(k1),z
    !------------------------------------------------------!
    !          (2)--------(4)                              !
    !          /|         /|        z direction            !
    !         / |        / |        |                      !
    !  k    (1)--------(3) |        |   y direction        !
    !        |  |       |  |        |  /                   !
    !        | (6)------|-(8)  j1   | /                    !
    !        | /        | /         |/                     !
    !        |/         |/          +-------> x direction. !
    ! k1    (5)--------(7)   j                             !
    !        i          i1                                 !
    !------------------------------------------------------!
    widxp%wgt=0;widxp%k=1  ! in case for land
    if(k>0)then
      if(dep(k)+topo(i,j)<=0)then
        if(mask(i ,j )/=0)then
          widxp%i(1)=i; widxp%j(1)=j; widxp%k(1)=k;widxp%wgt(1)=(1-a)*(1-b)*w;
        endif
        if(mask(i ,j1)/=0)then
          widxp%i(2)=i; widxp%j(2)=j1;widxp%k(2)=k;widxp%wgt(2)=(1-a)*(  b)*w
        endif
        if(mask(i1,j )/=0)then
          widxp%i(3)=i1;widxp%j(3)=j; widxp%k(3)=k;widxp%wgt(3)=(  a)*(1-b)*w
        endif
        if(mask(i1,j1)/=0)then
          widxp%i(4)=i1;widxp%j(4)=j1;widxp%k(4)=k;widxp%wgt(4)=(  a)*(  b)*w
        endif
      endif
      if(dep(k1)+topo(i,j)<=0)then
        if(mask(i ,j )/=0)then
          widxp%i(5)=i; widxp%j(5)=j; widxp%k(5)=k1;widxp%wgt(5)=(1-a)*(1-b)*(1-w)
        endif
        if(mask(i ,j1)/=0)then
          widxp%i(6)=i; widxp%j(6)=j1;widxp%k(6)=k1;widxp%wgt(6)=(1-a)*(  b)*(1-w)
        endif
        if(mask(i1,j )/=0)then
          widxp%i(7)=i1;widxp%j(7)=j; widxp%k(7)=k1;widxp%wgt(7)=(  a)*(1-b)*(1-w)
        endif
        if(mask(i1,j1)/=0)then
          widxp%i(8)=i1;widxp%j(8)=j1;widxp%k(8)=k1;widxp%wgt(8)=(  a)*(  b)*(1-w)
        endif
      endif
    endif
!    DBG,mask(i,j)  ,topo(i,j)  
!    DBG,mask(i1,j) ,topo(i1,j) 
!    DBG,mask(i,j1) ,topo(i,j1) 
!    DBG,mask(i1,j1),topo(i1,j1)
!    DBG,widxp%i
!    DBG,widxp%j
!    DBG,widxp%k
!    DBG,widxp%wgt
    if(sum(widxp%wgt)>small)widxp%wgt=widxp%wgt/sum(widxp%wgt)
    if(present(t))call getinterpclim(widxp,1,t)
    if(present(s))call getinterpclim(widxp,2,s)
    if(present(td))call getinterpclim(widxp,3,td)
    if(present(sd))call getinterpclim(widxp,4,sd)
    if(present(widx))widx=widxp
    
!    stop
    
  end subroutine clim_interp
  
  subroutine getinterpclim(widxp,vid,val)
    type(itpinf_type),intent(in) :: widxp
    integer,intent(in) :: vid
    real(4),intent(out) :: val
    real(4),pointer :: var(:,:,:)
    integer :: ii
    if(vid==1)then
      var=>temp
    elseif(vid==2)then
      var=>salt
    elseif(vid==3)then
      var=>tstd
    elseif(vid==4)then
      var=>sstd
    endif
    if(widxp%k(1)==0)then
      val=missvalue
    else
      val=0.e0
      do ii=1,8
        !write(*,*)widxp%i(ii),widxp%j(ii),widxp%k(ii)
        val=val+var(widxp%i(ii),widxp%j(ii),widxp%k(ii))*widxp%wgt(ii)
      enddo
    endif
    nullify(var)
  end subroutine getinterpclim
  
  subroutine prepare_monthly_clmdata(mon)
    integer,intent(in) :: mon
    character(len=2) :: cmon
    integer :: ncid
    if(mon==moncurrent)return
    write(cmon,'(i2.2)')mon
    call open_nc(ncid,trim(clmpath)//'/tgdemv3s'//cmon//'.nc','r')
    call readnc(ncid,'water_temp',temp)
    call close_nc(ncid)
    call open_nc(ncid,trim(clmpath)//'/tstdgdemv3s'//cmon//'.nc','r')
    call readnc(ncid,'water_temp_stdev',tstd)
    call close_nc(ncid)
    call open_nc(ncid,trim(clmpath)//'/sgdemv3s'//cmon//'.nc','r')
    call readnc(ncid,'salinity',salt)
    call close_nc(ncid)
    call open_nc(ncid,trim(clmpath)//'/sstdgdemv3s'//cmon//'.nc','r')
    call readnc(ncid,'salinity_stdev',sstd)
    call close_nc(ncid)
    moncurrent=mon
  end subroutine prepare_monthly_clmdata
  
  subroutine climdata_mod_init(clmpath_)
    character(len=*),intent(in),optional :: clmpath_
    integer :: i,j,ncid
    if(present(clmpath_))then
      clmpath=clmpath_
    else
      clmpath='/WORK/para_gz_fio_ofs/data/GDEM3'
    endif
    xname='lon';yname='lat';zname='depth'
    call open_nc(ncid,trim(clmpath)//'/sgdemv3s01.nc','r')
    im=get_dimension_len(ncid,xname)
    jm=get_dimension_len(ncid,yname)
    km=get_dimension_len(ncid,zname)
    allocate(topo(im,jm),lon(im),lat(jm),dep(km))
    allocate(temp(im,jm,km))
    allocate(salt(im,jm,km))
    allocate(sstd(im,jm,km))
    allocate(tstd(im,jm,km))
    allocate(mask(im,jm))
    call readnc(ncid,xname,lon)
    call readnc(ncid,yname,lat)
    call readnc(ncid,zname,dep)
    call close_nc(ncid)
    call open_nc(ncid,trim(clmpath)//'/dbdbvgdemv3s.nc','r')
    call readnc(ncid,'botdep',topo)
    call close_nc(ncid)
    do j=1,jm
      do i=1,im
        if(topo(i,j)>0)then
          mask(i,j)=0
        else
          mask(i,j)=1
        endif
      enddo
    enddo
    x0=lon(1);dx=lon(2)-lon(1);y0=lat(1);dy=lat(2)-lat(1)
    climdata_mod_initialized=1
  end subroutine climdata_mod_init

  subroutine climdata_mod_final
    if(allocated(temp))deallocate(temp)
    if(allocated(salt))deallocate(salt)
    if(allocated(sstd))deallocate(sstd)
    if(allocated(tstd))deallocate(tstd)
    if(allocated(topo))deallocate(topo)
    if(allocated(mask))deallocate(mask)
    if(allocated(lon ))deallocate(lon )
    if(allocated(lat ))deallocate(lat )
    if(allocated(dep ))deallocate(dep )
    climdata_mod_initialized=1
  end subroutine climdata_mod_final
  
  subroutine check_sctdata_prf(n_obs,lon,lat,zlvl,tclm,tstd,sclm,sstd)
    integer,intent(in) :: n_obs
    real(4),intent(inout) :: lon,lat,zlvl(:)
    real(4),intent(out),optional :: tclm(:),tstd(:),sclm(:),sstd(:)
    integer :: i
    real(8) :: x,y,z
    if(lon<0)lon=lon+360
    x=lon;y=lat
    do i=1,n_obs
    	z=zlvl(i)
      if(present(tclm) .and. present(sclm))then
        call clim_interp(x,y,z,t=tclm(i),td=tstd(i),s=sclm(i),sd=sstd(i))
      elseif(present(tclm))then
        call clim_interp(x,y,z,t=tclm(i),td=tstd(i))
      endif
    enddo
  end subroutine check_sctdata_prf
  
!-------------------------------------------------------------------------------------------------

  subroutine check_sctdata(n_obs,lon,lat,tclm,tstd,sclm,sstd)
    integer,intent(in) :: n_obs
    real(4),intent(inout) :: lon(:),lat(:)
    real(4),intent(out),optional :: tclm(:),tstd(:),sclm(:),sstd(:)
    integer :: i
    real(8) :: x,y,z
    !real(4) :: tclim,tstd
    do i=1,n_obs
      if(lon(i)<0)lon(i)=lon(i)+360
      x=lon(i);y=lat(i);z=0.d0
      if(present(tclm) .and. present(sclm))then
        call clim_interp(x,y,z,t=tclm(i),td=tstd(i),s=sclm(i),sd=sstd(i))
      elseif(present(tclm))then
        call clim_interp(x,y,z,t=tclm(i),td=tstd(i))
      endif
    enddo
  end subroutine check_sctdata
  
end module climdata_mod
