#define DBG  print*, __FILE__, __LINE__
!-------------------------------------------------------------------------------------------------
  module mwmvar_mod
  implicit none
!-------------------------------------------------------------------------------------------------
  public wamvar_mod_init,wamvar_mod_final
  public
!-------------------------------------------------------------------------------------------------
  !integer,parameter :: spdp=4
  integer,parameter :: spdp=8
!-------------------------------------------------------------------------------------------------
  type pntinf_type
    integer :: i =0  ! Index of the first dimension
    integer :: j =0  ! Index of the second dimension
    integer :: k =0  ! Index of the third dimension
    integer :: r =0  ! Right neighbor point.
    integer :: ur=0  ! Up-right neighbor point.
    integer :: u =0  ! Up neighbor point.
    integer :: ul=0  ! Up-left neighbor point.
    integer :: l =0  ! Left neighbor point.
    integer :: dl=0  ! Down-left neighbor point.
    integer :: d =0  ! Down neighbor point.
    integer :: dr=0  ! Down-right neighbor point.
  end type pntinf_type
  type(pntinf_type),allocatable :: pnb(:)
!-------------------------------------------------------------------------------------------------
  type cnb_type
    integer :: n                  ! number of neighbor points.
    integer,pointer :: nbs(:)     ! (n)
    real(spdp),pointer :: rot(:)  ! (n)
    real(spdp),pointer :: dst(:)  ! (n)
    integer,pointer :: nbsc(:)    ! (n)
    real(spdp),pointer :: rotc(:) ! (n)
    real(spdp),pointer :: dstc(:) ! (n)
    real(spdp),pointer :: xm(:)   ! (n)
    real(spdp),pointer :: ym(:)   ! (n)
    real(spdp),pointer :: xmc(:)  ! (n)
    real(spdp),pointer :: ymc(:)  ! (n)
    real(spdp) :: dddx,dddy
    real(spdp) :: deltx,delty,angle
    real(spdp) :: tanlatrs,rslat
  end type cnb_type
  type(cnb_type),allocatable :: cnb(:)
!-------------------------------------------------------------------------------------------------
  !integer,parameter :: kl    = 25
  !integer,parameter :: kld   = 30
  !integer,parameter :: klp1  = kl+1
  !integer,parameter :: kldp1 = kld+1
  !integer,parameter :: jl    = 24
  !integer,parameter :: jlp1  = jl+1
  integer :: kl    = 25
  integer :: kld   = 30
  integer :: jl    = 24
  integer :: jlp1  != jl+1
  integer :: klp1  != kl+1
  integer :: kldp1 != kld+1
  integer :: np
  integer :: npc
  integer :: im
  integer :: jm
!-------------------------------------------------------------------------------------------------
  real(spdp),parameter :: acu   = 0.          ! - Theoretical coefficient for wave-current interaction
  !real(spdp),parameter :: beta0 = 1.12       ! - Coefficient for wind input.
  real(spdp),parameter :: beta0 = 1.0         ! - Coefficient for wind input.
  real(spdp),parameter :: beta10= beta0*0.25*1.25*0.001
  real(spdp),parameter :: rs    = 6367451.637 ! - The global (Earth) radius. 6372799.0?
  real(spdp),parameter :: pi    = 3.1415926   ! - Pi.
  real(spdp),parameter :: pi2   = pi/2.0      ! - Pi/2.
  real(spdp),parameter :: zpi   = 2.0*pi      ! - 2*Pi.
  real(spdp),parameter :: pid180= pi/180.     ! - Pi/180.
  real(spdp),parameter :: deg2rad=3.1415926535897932385/180.0
  real(spdp),parameter :: g     = 9.81        ! - Acceleration of gravity.
  real(spdp),parameter :: gc2   = g*0.877**2  ! - Acceleration of gravity.
  real(spdp),parameter :: gg    = g*g         ! - Acceleration of gravity.
  real(spdp),parameter :: tztz  = 1.099314    ! - Coefficient for zero-crossing wave period.
  real(spdp),parameter :: d1    = 0.000132    ! - Coefficient in wave-breaking dissipation formula
  real(spdp),parameter :: d2    = 2.61        ! - Coefficient in wave-breaking dissipation formula
  !real(spdp),parameter :: pwk   = 1.21        ! - The constant for discretion of wave-number
  !real(spdp),parameter :: wkmin = 0.0071      ! - Minimum of wave-number amplitude
  !real(spdp),parameter :: wkmax = 0.6894      ! - Maximum of wave-umber amplitude
  !real(spdp),parameter :: wfmax = 0.413       ! - Maximum of wave frequency
  !real(spdp),parameter :: wfmin = 0.042       ! - Minimum of wave frequency
  real(spdp),parameter :: ads   = 1.0         ! - Theoretical coefficient for wave-breaking dissipation
  real(spdp),parameter :: abo   = 1.0         ! - Theoretical coefficient for bottom dissipation
  real(spdp),parameter :: p     = 0.025       ! - Coefficient for growth spectrum limiter
  real(spdp),parameter :: cksp  = 14.0        ! - Coefficient for estimation of wave-number range
  real(spdp),parameter :: cksa  = 4.5         ! - Coefficient for estimation of wave-number range
  real(spdp),parameter :: small = 0.000001    ! - Small value.
  !real(spdp),parameter :: alog10pwk = alog10(pwk)   ! - alog10(pwk)
  real(spdp) :: pwk   = 1.21        ! - The constant for discretion of wave-number
  real(spdp) :: wkmin = 0.0071      ! - Minimum of wave-number amplitude
  real(spdp) :: wkmax = 0.6894      ! - Maximum of wave-umber amplitude
  real(spdp) :: alog10pwk                     ! --- alog10(pwk)
  character(len=12),parameter :: rstfile = 'wave_rest.nc'
!-------------------------------------------------------------------------------------------------!
  character(len=200) :: outpath    ! - Path for model output.                                     !
  character(len=14) :: title       ! - Symbal for model output.                                   !
!-------------------------------------------------------------------------------------------------!
  real(spdp) :: delttm             ! - Length of integral time step,in minutes.                   !
  integer :: istime(6)             ! - Integral start time                                        !
  integer :: ietime(6)             ! - Integral end time                                          !
  integer :: cools_days            ! - The time (days) for cool start.                            !
  integer :: wndfreq               ! - The frequency of wind data,in hours.                       !
  integer :: wndtype               ! - Wind type: 0 for same grid with model                      !
                                   !              1 for GFS wind data,no interp.                  !
  integer :: outflag               ! - The method of output.                                      !
                                   !   0,only wave output;                                        !
                                   !   1 wave & mix together;                                     !
                                   !   2 for wave & mix seperately.                               !
                                   !   3 Only output wave variables into file                     !
                                   !     multi-records,everyday 1 file.                           !
                                   !   4 Only output wave variables into file                     !
                                   !     multi-records,one run 1 file                             !
  integer :: wiofreq               ! - The output frequency for wave results (hour).              !
  integer :: rstfreq               ! - The output frequency for model restart (hour).             !
!-------------------------------------------------------------------------------------------------!
  integer :: grdflag               ! 0 for normal grid, 1 for curv-grid,2 for roted grid.         !
                                   ! 3 triangle-grid, 4 for any rect-grid 0 and 1 are ready.      !
  integer :: glbflag               ! --- global flag,0 for global model,1 for regional.           !
  integer :: cpdays=0              ! - Days need to integerated of this model.                    !
                                   !   Flag for setting of compute periods.                       !
                                   ! 0 is default and the period will be given by start           !
                                   !   time and end time.                                         !
                                   ! Other value, the cpdays and start time will be used          !
                                   !   to determine the compute period.                           !
!-------------------------------------------------------------------------------------------------!
  integer :: ioflag_wx=0,ioflag_wy=0,ioflag_tp=0,ioflag_tz=0,ioflag_hs=0,ioflag_th=0
  integer :: opt_cd=0,opt_swl=0,opt_imp=0
  real(4) :: windzone=15.
!-------------------------------------------------------------------------------------------------
! --- For variables about time.
  integer :: itime(6)
  double precision :: dtime,dtime0,dtimeend
  character(len=14) :: ctime,cistime,cietime
! --- ia for x-direction,ic for y-direction,it for time steps,itend for
!     number of all steps,iprint for print interval.
  integer :: iwiofreq,irstfreq !,iciofreq
  integer :: it,itend,ia,ic,j,k,key,number
  real(spdp) :: cong,al11,al21,al31,al12,al22,al13,al23
  real(spdp) :: deltt,deltth
  character(len=100) :: timeunits
!-------------------------------------------------------------------------------------------------
!  real(spdp),allocatable :: dddx(:)
!  real(spdp),allocatable :: dddy(:)
!  real(spdp),allocatable :: rslat(:)
!  real(spdp),allocatable :: deltx(:)
!  real(spdp),allocatable :: delty(:)
  ! --- settopo
  integer,allocatable :: nsp(:)
  real(spdp),allocatable :: alon(:)
  real(spdp),allocatable :: alat(:)
  real(spdp),allocatable :: d(:)
  ! --- setwave
  real(spdp),allocatable :: thet(:)
  real(spdp),allocatable :: wkh(:)
  real(spdp),allocatable :: wk(:)
  real(spdp),allocatable :: dwk(:)
  real(spdp),allocatable :: wf(:,:)
  real(spdp),allocatable :: dwf(:,:)
  real(spdp),allocatable :: ccg(:,:)
  real(spdp),allocatable :: grolim(:)
!-------------------------------------------------------------------------------------------------
  integer,allocatable :: jp1(:,:)     ! - Discrete-interaction configurations of nonlinear wave-wave transfer
  integer,allocatable :: jp2(:,:)     ! - Discrete-interaction configurations of nonlinear wave-wave transfer
  integer,allocatable :: jm1(:,:)     ! - Discrete-interaction configurations of nonlinear wave-wave transfer
  integer,allocatable :: jm2(:,:)     ! - Discrete-interaction configurations of nonlinear wave-wave transfer
                                      ! - angular discrete-interaction configurations of nonlinear wave-wave transfer
  integer,allocatable :: ikp(:)       ! - wave-number discrete-interaction configurations of nonlinear wave-wave transfer
  integer,allocatable :: ikp1(:)      ! - wave-number discrete-interaction configurations of nonlinear wave-wave transfer
  integer,allocatable :: ikm(:)       ! - wave-number discrete-interaction configurations of nonlinear wave-wave transfer
  integer,allocatable :: ikm1(:)      ! - wave-number discrete-interaction configurations of nonlinear wave-wave transfer

  real(spdp),allocatable :: wx(:)     ! - The wind along longitude
  real(spdp),allocatable :: wy(:)     ! - The wind along latitude
  real(spdp),allocatable :: ux(:)
  real(spdp),allocatable :: uy(:)
  real(spdp),allocatable :: uxx(:)
  real(spdp),allocatable :: uyx(:)
  real(spdp),allocatable :: uxy(:)
  real(spdp),allocatable :: uyy(:)

  real(spdp),allocatable :: wp(:,:,:) ! - weighting factor of K+ for decomposing wave-wave transfer
  real(spdp),allocatable :: wm(:,:,:) ! - weighting factor of K- for decomposing wave-wave transfer
  real(spdp),allocatable :: wks17(:)  ! - 17/2 exponential of wave-number,that is K**(17/2)
  real(spdp),allocatable :: h1_3(:)   ! - hs: significant wave height (m)
  real(spdp),allocatable :: aet(:)    ! - th: mean wave direction (Deg)
  real(spdp),allocatable :: tpf(:)    ! - tp: spectrum peak wave period (s)
  real(spdp),allocatable :: ape(:)    ! - tz: zero-crossing wave period (s)
!... added by BaoYing, 20190103
  real(spdp),allocatable :: ustokes(:)! - us: ! stokes velocity, zonal (m/s)
  real(spdp),allocatable :: vstokes(:)! - vs: ! stokes velocity, meridional (m/s)
!... end add  

  real(spdp),allocatable :: e(:,:,:)  ! - Wave spectrum, before the influence of source function & propagation.
  real(spdp),allocatable :: ee(:,:,:) ! - Wave spectrum, after the influence of source function & propagation.
  real(spdp),allocatable :: ea(:,:,:) ! - Time averaged ee.
  real(spdp),allocatable :: ae(:)     ! - The zero-order moment of the spectrum
  real(spdp),allocatable :: awf(:)    ! - The frequency first-order moment of the spectrum
  real(spdp),allocatable :: asi(:)    ! - The frequency negative first-order moment of the spectrum
  real(spdp),allocatable :: awk(:)    ! - The frequency negative second-order moment of the spectrum
  real(spdp),allocatable :: ark(:)    ! - spectral mean of wave-number
  real(spdp),allocatable :: hb(:)     ! - The Hs limiter through wave breaking
  real(spdp),allocatable :: hbb(:)    ! - The Hs limiter through wave breaking
  real(spdp),allocatable :: fconst0(:)! - computing mask for threshold of wave-number
  real(spdp),allocatable :: se(:,:)   ! - Increment of spectrum (m4/s)
  real(spdp),allocatable :: dse(:,:)  ! - Deferential of se with respect to spectrum (s-1)
!-------------------------------------------------------------------------------------------------
  contains
!-------------------------------------------------------------------------------------------------
  subroutine wamvar_mod_init(npin,npcin,imin,jmin,klin,jlin,wkmin_in,wkmax_in)
    integer,intent(in) :: npin,npcin
    integer,intent(in),optional :: imin,jmin
    integer,intent(in),optional :: klin,jlin
    real(spdp),intent(in),optional :: wkmax_in,wkmin_in
    !----------------------------------------
    np=npin;npc=npcin;
    im=npin;if(present(imin))im=imin
    jm=npin;if(present(jmin))jm=jmin
    if(present(klin))then;kl=klin;else;kl=25;endif
    if(present(jlin))then;jl=jlin;else;jl=24;endif
    kld       = kl+5 !30
    klp1      = kl+1
    kldp1     = kld+1
    jlp1      = jl+1
    !----------------------------------------
    pwk   = 1.21        ! - The constant for discretion of wave-number
    wkmin = 0.0071      ! - Minimum of wave-number amplitude
    wkmax = 0.688822359872592
    if(present(wkmax_in))then
      wkmin=wkmin_in
      wkmax=wkmax_in
    endif
    pwk=10**(log10(wkmax/wkmin)/dble(kl-1))
    alog10pwk = log10(pwk)
    !----------------------------------------
!    allocate(rslat(0:np))     ;rslat=0.d0
!    allocate(deltx(0:np))     ;deltx=0.d0
!    allocate(delty(0:np))     ;delty=0.d0
!    allocate(dddx(0:np))      ;dddx =0.d0
!    allocate(dddy(0:np))      ;dddy =0.d0
    allocate(d(0:np))         ;d    =0.d0
    allocate(nsp(0:np))       ;nsp  =0
    allocate(e(kl,jl,0:np))   ;e    =0.d0
    allocate(ee(kl,jl,0:np))  ;ee   =0.d0
    ! --- For wind data.
    allocate(wx(0:np))        ;wx =0.d0 ! --- For wind data.
    allocate(wy(0:np))        ;wy =0.d0 ! --- For wind data.
    allocate(wf(kldp1,0:np))  ;wf =0.d0
    allocate(ccg(kldp1,0:np)) ;ccg=0.d0
    allocate(dwf(kldp1,0:np)) ;dwf=0.d0
    allocate(ae(0:np))        ;ae =0.d0
    allocate(awf(0:np))       ;awf=0.d0
    allocate(asi(0:np))       ;asi=0.d0
    allocate(awk(0:np))       ;awk=0.d0
    allocate(ark(0:np))       ;ark=0.d0
    allocate(hb(0:np))        ;hb =0.d0
    allocate(hbb(0:np))       ;hbb=0.d0

    allocate(grolim(kl))      ;grolim =0.d0
    allocate(thet(jlp1))      ;thet   =0.d0
    allocate(wk(kldp1))       ;wk     =0.d0
    allocate(wkh(kldp1))      ;wkh    =0.d0
    allocate(dwk(kldp1))      ;dwk    =0.d0
    allocate(wp(kl,2,2))      ;wp     =0.d0
    allocate(wm(kl,2,2))      ;wm     =0.d0
    allocate(wks17(kl))       ;wks17  =0.d0
    allocate(se(klp1,jl))     ;se     =0.d0
    allocate(dse(klp1,jl))    ;dse    =0.d0
    allocate(fconst0(kl))     ;fconst0=0.d0
    allocate(jp1(2,jl))       ;jp1    =0
    allocate(jp2(2,jl))       ;jp2    =0
    allocate(jm1(2,jl))       ;jm1    =0
    allocate(jm2(2,jl))       ;jm2    =0
    allocate(ikp(kl))         ;ikp    =0
    allocate(ikp1(kl))        ;ikp1   =0
    allocate(ikm(kl))         ;ikm    =0
    allocate(ikm1(kl))        ;ikm1   =0

    allocate(h1_3(0:np))      ;h1_3=0.d0
    allocate( aet(0:np))      ;aet =0.d0
    allocate( tpf(0:np))      ;tpf =0.d0
    allocate( ape(0:np))      ;ape =0.d0
    allocate(  ux(0:np))      ;ux  =0.d0
    allocate(  uy(0:np))      ;uy  =0.d0
    allocate( uxx(0:np))      ;uxx =0.d0
    allocate( uyx(0:np))      ;uyx =0.d0
    allocate( uxy(0:np))      ;uxy =0.d0
    allocate( uyy(0:np))      ;uyy =0.d0
!... added by BaoYing, 20190103
    allocate(ustokes(0:np))   ;ustokes=0.d0
    allocate(vstokes(0:np))   ;vstokes=0.d0
!... end add 

    if(.not. allocated(alon))allocate(alon(0:np))
    if(.not. allocated(alon))allocate(alat(0:np))

  end subroutine wamvar_mod_init
!-------------------------------------------------------------------------------------------------
  subroutine wamvar_mod_final
    integer :: idx
    !    deallocate(rslat)
    !    deallocate(deltx)
    !    deallocate(delty)
    !    deallocate(dddx)
    !    deallocate(dddy)
    if(allocated(d)      )deallocate(d)
    if(allocated(nsp)    )deallocate(nsp)
    if(allocated(e)      )deallocate(e)
    if(allocated(ee)     )deallocate(ee)
    if(allocated(wx)     )deallocate(wx)
    if(allocated(wy)     )deallocate(wy)
    if(allocated(grolim) )deallocate(grolim)
    if(allocated(thet)   )deallocate(thet)
    if(allocated(wk)     )deallocate(wk)
    if(allocated(wkh)    )deallocate(wkh)
    if(allocated(dwk)    )deallocate(dwk)
    if(allocated(wp)     )deallocate(wp)
    if(allocated(wm)     )deallocate(wm)
    if(allocated(wks17)  )deallocate(wks17)
    if(allocated(se)     )deallocate(se)
    if(allocated(dse)    )deallocate(dse)
    if(allocated(ae)     )deallocate(ae)
    if(allocated(awf)    )deallocate(awf)
    if(allocated(asi)    )deallocate(asi)
    if(allocated(awk)    )deallocate(awk)
    if(allocated(ark)    )deallocate(ark)
    if(allocated(hb)     )deallocate(hb)
    if(allocated(hbb)    )deallocate(hbb)
    if(allocated(fconst0))deallocate(fconst0)
    if(allocated(wf)     )deallocate(wf)
    if(allocated(ccg)    )deallocate(ccg)
    if(allocated(dwf)    )deallocate(dwf)
    if(allocated(jp1)    )deallocate(jp1)
    if(allocated(jp2)    )deallocate(jp2)
    if(allocated(jm1)    )deallocate(jm1)
    if(allocated(jm2)    )deallocate(jm2)
    if(allocated(ikp)    )deallocate(ikp)
    if(allocated(ikp1)   )deallocate(ikp1)
    if(allocated(ikm)    )deallocate(ikm)
    if(allocated(ikm1)   )deallocate(ikm1)
    if(allocated(h1_3)   )deallocate(h1_3)
    if(allocated(aet)    )deallocate(aet)
    if(allocated(tpf)    )deallocate(tpf)
    if(allocated(ape)    )deallocate(ape)
    if(allocated(ux)     )deallocate(ux)
    if(allocated(uy)     )deallocate(uy)
    if(allocated(uxx)    )deallocate(uxx)
    if(allocated(uyx)    )deallocate(uyx)
    if(allocated(uxy)    )deallocate(uxy)
    if(allocated(uyy)    )deallocate(uyy)
!... added by BaoYing, 20190103
    if(allocated(ustokes))deallocate(ustokes)
    if(allocated(vstokes))deallocate(vstokes)
!... end add

    if(allocated(pnb)    )deallocate(pnb)
    if(allocated(alon)   )deallocate(alon)
    if(allocated(alat)   )deallocate(alat)

    if(allocated(cnb))then
    if(size(cnb)>0)then
      do idx=0,size(cnb)
        !if(associated(cnb(idx)%nbs ))then;deallocate(cnb(idx)%nbs );nullify(cnb(idx)%nbs );endif
        !if(associated(cnb(idx)%rot ))then;deallocate(cnb(idx)%rot );nullify(cnb(idx)%rot );endif
        !if(associated(cnb(idx)%dst ))then;deallocate(cnb(idx)%dst );nullify(cnb(idx)%dst );endif
        !if(associated(cnb(idx)%nbsc))then;deallocate(cnb(idx)%nbsc);nullify(cnb(idx)%nbsc);endif
        !if(associated(cnb(idx)%rotc))then;deallocate(cnb(idx)%rotc);nullify(cnb(idx)%rotc);endif
        !if(associated(cnb(idx)%dstc))then;deallocate(cnb(idx)%dstc);nullify(cnb(idx)%dstc);endif
        !if(associated(cnb(idx)%xm  ))then;deallocate(cnb(idx)%xm  );nullify(cnb(idx)%xm  );endif
        !if(associated(cnb(idx)%ym  ))then;deallocate(cnb(idx)%ym  );nullify(cnb(idx)%ym  );endif
        !if(associated(cnb(idx)%xmc ))then;deallocate(cnb(idx)%xmc );nullify(cnb(idx)%xmc );endif
        !if(associated(cnb(idx)%ymc ))then;deallocate(cnb(idx)%ymc );nullify(cnb(idx)%ymc );endif
      enddo
      deallocate(cnb)
    endif
    endif
  end subroutine wamvar_mod_final
!-------------------------------------------------------------------------------------------------
  end module mwmvar_mod
!-------------------------------------------------------------------------------------------------

