#define DBG  print*,__FILE__, __LINE__
!-------------------------------------------------------------------------------------------------
  module mwmpgt_mod
  use mwmvar_mod
  implicit none
!-------------------------------------------------------------------------------------------------
  public :: init_propagat
  public :: final_propagat
  public :: cal_geo_distangl
  public :: propagat
  public :: smoth_ee,smoth_ee_dir
  public :: setgeoinf
  private
!-------------------------------------------------------------------------------------------------
  type pgtinfo_type
    integer            :: np    = 4      ! - Number of grid pnts for interp.
    integer   ,pointer :: ids(:)=>null() ! - Index of grid pnts for interp. (np)
    real(spdp),pointer :: wts(:)=>null() ! - Weight for grid pnts during interp. (np)
    integer            :: iwk   = 0      ! - First index in direction of wave number.
    integer            :: iwk1  = 0      ! - Second index in dimension of wave number.
    integer            :: jth   = 0      ! - First index in dimension of wave direction.
    integer            :: jth1  = 0      ! - Second index in dimension of wave direction.
    real(spdp)         :: wtp(4)= 0      ! - Weights for interp. in dimension of wave number
                                         !   and direction. Grid points are in physical space.
  end type pgtinfo_type                  !   1(iwk,jth),2(iwk1,jth),3(iwk,jth1),4(iwk1,jth1)
  type(pgtinfo_type),allocatable :: pgtinf(:,:,:)  ! - Information for propagation.(kl,jl,0:np)
!-------------------------------------------------------------------------------------------------
  contains
!-------------------------------------------------------------------------------------------------
  subroutine init_propagat
    integer :: idx,k,j,n
    if(.not. allocated(pgtinf))allocate(pgtinf(kl,jl,0:np))
    n=4;if(grdflag==3)n=3
    do idx=1,np
      do j=1,jl
        do k=1,kl
          pgtinf(k,j,idx)%np=n
          allocate(pgtinf(k,j,idx)%ids(n))
          allocate(pgtinf(k,j,idx)%wts(n))
        enddo
      enddo
    enddo
    do idx=1,npc
      call propagat_preinf(idx)
    enddo
    !call out_pgt_info
  end subroutine init_propagat
!-------------------------------------------------------------------------------------------------
  subroutine final_propagat
    integer :: idx,k,j
    if(allocated(pgtinf))then
      do idx=1,np
        do j=1,jl
          do k=1,kl
            pgtinf(k,j,idx)%np=0
            if(associated(pgtinf(k,j,idx)%ids))then
              deallocate(pgtinf(k,j,idx)%ids);nullify(pgtinf(k,j,idx)%ids)
            endif
            if(associated(pgtinf(k,j,idx)%wts))then
              deallocate(pgtinf(k,j,idx)%wts);nullify(pgtinf(k,j,idx)%wts)
            endif
          enddo
        enddo
      enddo
      deallocate(pgtinf)
    endif
  end subroutine final_propagat
!-------------------------------------------------------------------------------------------------
  subroutine propagat_preinf(idx)
    integer,intent(in) :: idx
    integer :: j,k,i,iyyz,ixx,jyy,ixx1,jyy1,iwk,iwk1,i1,jth,jth1
    real(spdp) :: d0,dddx0,dddy0,duxdx0,duxdy0,duydy0,duydx0,th0,tanlatrs
    real(spdp) :: sinth,costh,wk0,ws0,dk0,cg,cgx,cgy
    real(spdp) :: wk1,wk2  !  No value for some case, previous value will be used.
    if(nsp(idx)/=1)return
    tanlatrs=cnb(idx)%tanlatrs
    dddx0 = cnb(idx)%dddx !dddx(idx)
    dddy0 = cnb(idx)%dddy !dddy(idx)
    d0=d(idx)
    duxdx0=uxx(idx)
    duxdy0=uxy(idx)
    duydx0=uyx(idx)
    duydy0=uyy(idx)
    do j=1,jl
      th0=thet(j);sinth=sin(th0);costh=cos(th0)
      do k=1,kl
        wk0=wk(k);ws0=zpi*wf(k,idx);dk0=d0*wk0
        cg=ccg(k,idx);cgx=cg*costh;cgy=cg*sinth
        !-----------------------------------------------------------------------------
        !******  1.  "the calculation of wave engery-current spreading"
        if(grdflag==0)then
          call wave_engery_current_spreading_normgrd
        elseif(grdflag==1)then
          call wave_engery_current_spreading_cuvgrd
        endif
        !-----------------------------------------------------------------------------
        !******  2.  "the effect of refraction caused by topography and current"
        call effect_of_topography_current
      enddo
    enddo
    !-----------------------------------------------------------------------------------------
    contains
    !-----------------------------------------------------------------------------------------
    subroutine wave_engery_current_spreading_cuvgrd
      real(spdp) :: dx,dy,dst,ang,xm(4),ym(4),wtm(4),maxang
      integer :: idx1,ids(4),nn,nnn,nnna,n,nmaxang
      real(spdp) :: xx,yy,x1,x2,y1,y2
      real(spdp) :: ta,tb
#ifdef TESTDISTver1     
      !xx=alon(idx)-deltt*(cgx+ux(idx))/rslat(idx)*180./pi
      !yy=alat(idx)-deltt*(cgy+uy(idx))/rs*180./pi
      !call cal_geo_distangl(alon(idx),alat(idx),xx,yy,dst,ang)
      !xx=dst*cos(ang*pi/180.d0);yy=dst*sin(ang*pi/180.d0)
      xx=-deltt*(cgx+ux(idx))
      yy=-deltt*(cgy+uy(idx))
      ang=atan2(yy,xx)*180/pi
      if(ang<0)ang=ang+360        
      xm(1)=0.d0;ym(1)=0.d0;ids(1)=idx
      nmaxang=4;maxang=cnb(idx)%rot(nmaxang)
      do nn=1,cnb(idx)%n
        if(maxang<cnb(idx)%rot(nn))then
          nmaxang=nn;maxang=cnb(idx)%rot(nmaxang)
        endif
      enddo
      nnna=nmaxang
      do nn=1,cnb(idx)%n
        nnn=mod(nn+nmaxang,cnb(idx)%n);if(nnn==0)nnn=cnb(idx)%n
        if(ang>cnb(idx)%rot(nnn))nnna=nnn
      enddo
      nn=nnna;nnn=nn+1;if(nnn>cnb(idx)%n)nnn=1
      xm(2)=cnb(idx)%dst(nnn)*cos(cnb(idx)%rot(nnn)*pi/180.d0)
      ym(2)=cnb(idx)%dst(nnn)*sin(cnb(idx)%rot(nnn)*pi/180.d0)
      ids(2)=cnb(idx)%nbs(nnn)
      xm(3)=cnb(idx)%dstc(nn)*cos(cnb(idx)%rotc(nn)*pi/180.d0)
      ym(3)=cnb(idx)%dstc(nn)*sin(cnb(idx)%rotc(nn)*pi/180.d0)
      ids(3)=cnb(idx)%nbsc(nn)
      xm(4)=cnb(idx)%dst(nn)*cos(cnb(idx)%rot(nn)*pi/180.d0)
      ym(4)=cnb(idx)%dst(nn)*sin(cnb(idx)%rot(nn)*pi/180.d0)
      ids(4)=cnb(idx)%nbs(nn)
      !  c2----n2----c1   
      !  |      |     |   
      !  n3-----o----n1   N1-4: right,up,left,down
      !  |      |     |   C1-4: ur,ul,dl,dr
      !  c3----n4----c4
      !do nn=1,cnb(idx)%n
      ! if(ang>cnb(idx)%rot(nn))exit
      !enddo
      !write(*,*)'ang',ang,cnb(idx)%rot
      !nnn=nn+1;if(nnn>cnb(idx)%n)nnn=1
      !xm(2)=cnb(idx)%dst(nnn)*cos(cnb(idx)%rot(nnn)*pi/180.d0)
      !xm(3)=cnb(idx)%dstc(nn)*cos(cnb(idx)%rotc(nn)*pi/180.d0)
      !xm(4)=cnb(idx)%dst(nn)*cos(cnb(idx)%rot(nn)*pi/180.d0)
      !ym(2)=cnb(idx)%dst(nnn)*sin(cnb(idx)%rot(nnn)*pi/180.d0)
      !ym(3)=cnb(idx)%dstc(nn)*sin(cnb(idx)%rotc(nn)*pi/180.d0)
      !ym(4)=cnb(idx)%dst(nn)*sin(cnb(idx)%rot(nn)*pi/180.d0)
      !ids(2)=cnb(idx)%nbs(nnn)
      !ids(3)=cnb(idx)%nbsc(nn)
      !ids(4)=cnb(idx)%nbs(nn)
      !if(pid==0)write(*,*)'bbb',pid,idx,ids
      call bilinear_4pm(xx,yy,xm,ym,wtm)

      ta=abs(xm(1)*wtm(1)+xm(2)*wtm(2)+xm(3)*wtm(3)+xm(4)*wtm(4)-xx)
      tb=abs(ym(1)*wtm(1)+ym(2)*wtm(2)+ym(3)*wtm(3)+ym(4)*wtm(4)-yy)
      if(ta>1.e-5 .or. tb>1.e-5)write(*,*)'aaa',ta,tb
      xx=alon(idx)-deltt*(cgx+ux(idx))/rslat(idx)*180./pi
      yy=alat(idx)-deltt*(cgy+uy(idx))/rs*180./pi
      ta=abs(alon(ids(1))*wtm(1)+alon(ids(2))*wtm(2)+alon(ids(3))*wtm(3)+alon(ids(4))*wtm(4)-xx)
      tb=abs(alat(ids(1))*wtm(1)+alat(ids(2))*wtm(2)+alat(ids(3))*wtm(3)+alat(ids(4))*wtm(4)-yy)
      if(ta>1.e-5 .or. tb>1.e-5)write(*,*)'bbb',ta,tb
      !if(pid==0 .and. minval(wtm)<0)then
      if(minval(wtm)<0)then
        write(*,*)'wtm',xm,xx
        write(*,*)'wtm',ym,yy
        write(*,*)'wtm',wtm,nnn,nn
        write(*,*)'wtm',cnb(idx)%rot,ang
        write(*,*)'wtm',ids,-deltt*(cgx+ux(idx)),-deltt*(cgy+uy(idx))
        write(*,*)'wtm',deltt,minval(cnb(idx)%dst)/maxval(ccg(:,idx)),minval(cnb(idx)%dst),maxval(ccg(:,idx))
        do n=1,4
          write(*,*)alon(idx),alat(idx),alon(cnb(idx)%nbs(n)),alat(cnb(idx)%nbs(n))
        enddo
      endif
      !if(alat(idx)>87)then
      !  wtm=0.5; write(*,*)'pole'
      !endif
      !if(minval(wtm)<0 .and. minval(abs(wtm))>1.5)then
      !!if(minval(wtm)<0)then
      !  write(*,*)'wtm',xm,xx
      !  write(*,*)'wtm',ym,yy
      !  write(*,*)'wtm',wtm,nnn,nn
      !  write(*,*)'wtm',cnb(idx)%rot,ang
      !  do n=1,4
      !    write(*,*)alon(idx),alat(idx),alon(cnb(idx)%nbs(n)),alat(cnb(idx)%nbs(n))
      !  enddo
      !endif
      !----------------------------
      ! Points for interp.
      !  (2,2) ---- (3,3)
      !    |           |
      !    |      X    |
      !    |           |
      !  (1,1) ------(4,4)
      !----------------------------
#endif
#ifdef TESTDISTver2     
      xx=-deltt*(cgx+ux(idx))/rslat(idx)*180./pi
      yy=-deltt*(cgy+uy(idx))/rs*180./pi
!      xx=alon(idx)-deltt*(cgx+ux(idx))/rslat(idx)*180./pi
!      yy=alat(idx)-deltt*(cgy+uy(idx))/rs*180./pi
      !xm(1)=alon(idx);ym(1)=alat(idx)
      xm(1)=0.d0;ym(1)=0.d0;ids(1)=idx
      do nn=2,4
        if(ids(nn)==0)then
          ym(nn)=alat(ids(nn))-alat(idx)
          xm(nn)=alon(ids(nn))-alon(idx)
          if(xm(nn)>90.d0)xm(nn)=xm(nn)-360.d0
          if(xm(nn)<-90.d0)xm(nn)=xm(nn)+360.d0
        else
          xm(nn)=0
          ym(nn)=0
        endif
      enddo
      !xm(2)=alon(ids(2))-alon(idx);if(xm(2)>90.d0)xm(2)=xm(2)-360.d0;if(xm(2)<-90.d0)xm(2)=xm(2)+360.d0
      !xm(3)=alon(ids(3))-alon(idx);if(xm(3)>90.d0)xm(3)=xm(3)-360.d0;if(xm(3)<-90.d0)xm(3)=xm(3)+360.d0
      !xm(4)=alon(ids(4))-alon(idx);if(xm(4)>90.d0)xm(4)=xm(4)-360.d0;if(xm(4)<-90.d0)xm(4)=xm(4)+360.d0
      !ym(2)=alat(ids(2))-alat(idx)
      !ym(3)=alat(ids(3))-alat(idx)
      !ym(4)=alat(ids(4))-alat(idx)
#endif
#ifndef TESTDISTver3      
      !xx=-deltt*(cgx+ux(idx))/rslat(idx)*180./pi
      xx=-deltt*(cgx+ux(idx))/cnb(idx)%rslat*180./pi
      yy=-deltt*(cgy+uy(idx))/rs*180./pi
      call cal_geo_distangl(alon(idx),alat(idx),alon(idx)+xx,alat(idx)+yy,dst,ang)
      xm(1)=0.d0;ym(1)=0.d0;ids(1)=idx
      nmaxang=4;maxang=cnb(idx)%rot(nmaxang)
      do nn=1,cnb(idx)%n
        if(maxang<cnb(idx)%rot(nn))then
          nmaxang=nn;maxang=cnb(idx)%rot(nmaxang)
        endif
      enddo
      nnna=nmaxang
      do nn=1,cnb(idx)%n
        nnn=mod(nn+nmaxang,cnb(idx)%n);if(nnn==0)nnn=cnb(idx)%n
        !if(ang>cnb(idx)%rot(nnn))nnna=nnn
        if(ang>cnb(idx)%rot(nnn))nnna=nnn
      enddo
      nn=nnna;nnn=nn+1;if(nnn>cnb(idx)%n)nnn=1
      xm(2)=cnb(idx)%xm(nnn);ym(2)=cnb(idx)%ym(nnn);ids(2)=cnb(idx)%nbs(nnn)
      xm(3)=cnb(idx)%xmc(nn);ym(3)=cnb(idx)%ymc(nn);ids(3)=cnb(idx)%nbsc(nn)
      xm(4)=cnb(idx)%xm(nn); ym(4)=cnb(idx)%ym(nn); ids(4)=cnb(idx)%nbs(nn)
      !  c2----n2----c1   
      !  |      |     |   
      !  n3-----o----n1   N1-4: right,up,left,down
      !  |      |     |   C1-4: ur,ul,dl,dr
      !  c3----n4----c4
      call bilinear_4pm(xx,yy,xm,ym,wtm)
#ifdef CHECKBILN
      ta=abs(xm(1)*wtm(1)+xm(2)*wtm(2)+xm(3)*wtm(3)+xm(4)*wtm(4)-xx)
      tb=abs(ym(1)*wtm(1)+ym(2)*wtm(2)+ym(3)*wtm(3)+ym(4)*wtm(4)-yy)
      if(ta>1.e-5 .or. tb>1.e-5)then
        write(*,*)'ccc',ta,tb
        write(*,*)'cc0x',xm(1:4),xx
        write(*,*)'cc0y',ym(1:4),yy
        write(*,*)'cc1',alon(ids(1)),alon(ids(2)),alon(ids(3)),alon(ids(4)),alon(idx)+xx
        write(*,*)'cc2',alat(ids(1)),alat(ids(2)),alat(ids(3)),alat(ids(4)),alat(idx)+yy
        write(*,*)'cc3',wtm
      endif
      xx=alon(idx)-deltt*(cgx+ux(idx))/cnb(idx)%rslat*180./pi
      yy=alat(idx)-deltt*(cgy+uy(idx))/rs*180./pi
      ta=abs(alon(ids(1))*wtm(1)+alon(ids(2))*wtm(2)+alon(ids(3))*wtm(3)+alon(ids(4))*wtm(4)-xx)
      tb=abs(alat(ids(1))*wtm(1)+alat(ids(2))*wtm(2)+alat(ids(3))*wtm(3)+alat(ids(4))*wtm(4)-yy)
      if(ta>1.e-5 .or. tb>1.e-5)then
        write(*,*)'ddd',ta,tb
        write(*,*)'dddx',alon(ids(1)),alon(ids(2)),alon(ids(3)),alon(ids(4)),xx
        write(*,*)'dddy',alat(ids(1)),alat(ids(2)),alat(ids(3)),alat(ids(4)),yy
        write(*,*)'ids',ids,pnb(ids(1))%i,pnb(ids(1))%j,alon(idx),alat(idx)
        write(*,*)'wtm',wtm
        write(*,*)'xm',xm
        write(*,*)'ym',ym
      endif
#endif      
#endif
      pgtinf(k,j,idx)%ids=ids
      pgtinf(k,j,idx)%wts=wtm
    end subroutine wave_engery_current_spreading_cuvgrd
    !-----------------------------------------------------------------------------------------
    subroutine wave_engery_current_spreading_normgrd
      real(spdp) :: dx,dy,wt4(4),xx,yy,x1,x2,y1,y2
      integer :: idx1,ids(4)
      !******  1.  "the calculation of wave engery-current spreading"
      !----------------------------
      ! Points for interp.
      !  (0,dy) ---- (dx,dy)
      !    |            |
      !    |      X     |
      !    |            |
      !  (0,0) ------(dx,0)
      !----------------------------
      !xx=-deltt*(cgx+ux(idx))/rslat(idx)*180./pi
      xx=-deltt*(cgx+ux(idx))/cnb(idx)%rslat*180./pi
      yy=-deltt*(cgy+uy(idx))/rs*180./pi
      if(xx>=0)then
        !cnb(idx)%nbs(:)=[pnb(idx)%r,pnb(idx)%u,pnb(idx)%l,pnb(idx)%d]
        !cnb(idx)%nbsc(:)=[pnb(idx)%ur,pnb(idx)%ul,pnb(idx)%dl,pnb(idx)%dr]
        if(yy>=0)then  ! Part 1
          !ids(3)=pnb(idx)%u;ids(4)=pnb(idx)%ur;ids(1)=idx;ids(2)=pnb(idx)%r
          ids(3)=cnb(idx)%nbs(2)  ! Up
          ids(4)=cnb(idx)%nbsc(1) ! Up-Right
          ids(1)=idx;             ! Current
          ids(2)=cnb(idx)%nbs(1)  ! Right
        else           ! Part 4
          !ids(3)=idx;ids(4)=pnb(idx)%r;ids(1)=pnb(idx)%d;ids(2)=pnb(idx)%dr
          ids(3)=idx;ids(4)=cnb(idx)%nbs(1);ids(1)=cnb(idx)%nbs(4);ids(2)=cnb(idx)%nbsc(4)
          !yy=delty(idx)+yy
          yy=cnb(idx)%delty+yy
        endif
      else
        if(yy>=0)then  ! Part 2
          !ids(3)=pnb(idx)%ul;ids(4)=pnb(idx)%u;ids(1)=pnb(idx)%l;ids(2)=idx
          ids(3)=cnb(idx)%nbsc(2);ids(4)=cnb(idx)%nbs(2);ids(1)=cnb(idx)%nbs(3);ids(2)=idx
          !xx=deltx(idx)+xx
          xx=cnb(idx)%deltx+xx
        else            ! Part 3
          !ids(3)=pnb(idx)%l;ids(4)=idx;ids(1)=pnb(idx)%dl;ids(2)=pnb(idx)%d
          ids(3)=cnb(idx)%nbs(3);ids(4)=idx;ids(1)=cnb(idx)%nbsc(3);ids(2)=cnb(idx)%nbs(4)
          !xx=deltx(idx)+xx;yy=delty(idx)+yy
          xx=cnb(idx)%deltx+xx;yy=cnb(idx)%delty+yy
        endif
      endif
      !dx=deltx(idx);dy=delty(idx)
      dx=cnb(idx)%deltx;dy=cnb(idx)%delty
      !----------------------------
      call inter_wt(0._spdp,dx,0._spdp,dy,xx,yy,wt4)  ! record: idx1,wt4
      pgtinf(k,j,idx)%ids=ids
      pgtinf(k,j,idx)%wts=wt4
    end subroutine wave_engery_current_spreading_normgrd
    !-----------------------------------------------------------------------------------------
    subroutine effect_of_topography_current
      real(spdp) :: th1,th2,ssr1,ssr2,ssrwk,ssrth,wks,fien,fien1,wt4(4)
      real(spdp) :: dtth0,ths,dsidd
      !real(spdp) :: wk1,wk2
      !******  2.  "the effect of refraction caused by topography and current"
      if (dk0.lt.40.) then
        dsidd=0.5*g/cosh(dk0)*wk0**2/ws0/cosh(dk0)
      else
        dsidd=0.
      endif
      !dddx0 and dddy0 is m/m, changed in wamini, 2018-3-5 9:38:14
      ssr1=(dsidd*dddx0+wk0*costh*duxdx0+wk0*sinth*duydx0) !*(180.d0/pi)/rslat(idx)
      ssr2=(dsidd*dddy0+wk0*costh*duxdy0+wk0*sinth*duydy0) !*(180.d0/pi)/rs
      ssrwk=-(ssr1*costh+ssr2*sinth)
      ssrth=(ssr1*sinth-ssr2*costh)/wk0
      !yinxq:20220716:ssrth=(ssr1*sinth-ssr2*costh)/wk0
      !yinxq:20220716:ssrth=(ssr1*sinth-ssr2*costh)/wk0
      !-ssrwk=-(ssr1*costh/cnb(idx)%rslat+ssr2*sinth/rs)    !jiangxj:pgt
      !-ssrth=(ssr1*sinth/cnb(idx)%rslat-ssr2*costh/rs)/wk0 !jiangxj:pgt
      !ssrth=ssrth-cg*costh*tan(lat(pnb(idx)%j)*pi/180.d0)/rs !! yinxq 2017-10-16 13:19:52
      ssrth=ssrth-cg*costh*tanlatrs !tan(alat(idx)*pi/180.d0)/rs !! yinxq 2017-10-16 13:19:52
      wks=wk0-deltt*ssrwk
      if (wks.lt.0.) wks=0.
      if (wks.le.wkmin) then
        iwk=1
        iwk1=1
        fien=0.
        fien1=1.
        wk1=0.
        wk2=wk(iwk1)
      else
        if (wks.lt.wk(kld)) then
          !======= THE FOLLOWING BELONGS TO THE LAGFD-WAM WAVE MODEL
          !            iwk=int(log(wks/wkmin)/log(pwk))+1
          !==========================================================
          !            if (wks.lt.wk(iwk)) iwk=iwk-1
          !            if (wks.gt.wk(iwk+1)) iwk=iwk+1
          !========   The following is modified by Yang Yongzeng =====c
          do iyyz=1,kld
            if(wks>=wk(iyyz) .and. wks<wk(iyyz+1))iwk=iyyz
          enddo
          iwk1=iwk+1
          !=====================================================================c
          wk1=wk(iwk)
          wk2=wk(iwk+1)
          if (iwk.lt.kl) then
            iwk1=iwk+1
            fien=1.
            fien1=1.
          else
            i=iwk-kl+1
            i1=i+1
            fien=wkh(i)
            fien1=wkh(i1)
            iwk=kl
            iwk1=kl
          endif
        else
          wks=wk(kld)
          iwk=kl
          iwk1=kl
          i=kld-kl+1
          i1=i+1
          fien=wkh(i)
          fien1=wkh(i1)
        endif
      endif
      dtth0=deltt*ssrth
      ths=th0-dtth0
      if (ths<-1.0*zpi .or. ths>=2.0*zpi) ths=th0
      if (ths.ge.zpi) ths=ths-zpi
      if (ths.lt. 0.) ths=ths+zpi
      jth=int(ths/deltth)+1;jth1=jth+1
      if(jth.eq.jlp1)then
        jth=jl;jth1=1
      endif
      if (jth1.eq.jlp1) jth1=1
      th1=thet(jth);
      th2=thet(jth+1)
      !-----------------------------------------------------------------------------------------
      pgtinf(k,j,idx)%iwk=iwk
      pgtinf(k,j,idx)%iwk1=iwk1
      pgtinf(k,j,idx)%jth=jth
      pgtinf(k,j,idx)%jth1=jth1
      call inter_wt(wk1,wk2,th1,th2,wks,ths,wt4) ! record: iwk,iwk1,jth,jth1,wt4
      wt4(1)=wt4(1)*fien;wt4(2)=wt4(2)*fien1;wt4(3)=wt4(3)*fien;wt4(4)=wt4(4)*fien1
      pgtinf(k,j,idx)%wtp=wt4        !1(iwk,jth),2(iwk1,jth),3(iwk,jth1),4(iwk1,jth1)
    end subroutine effect_of_topography_current
    !-----------------------------------------------------------------------------------------
#ifndef NEWITP
    subroutine inter_wt(u1,u2,v1,v2,xt,yt,wt4)
      real(spdp), intent(in) :: u1,u2,v1,v2,xt,yt
      real(spdp), intent(out) :: wt4(4)
      real(spdp) :: dox,doy,r,q
      dox=u2-u1;doy=v2-v1
      q=0.5;if(doy/=0.0)q=(xt-u1)/dox
      r=0.5;if(dox/=0.0)r=(yt-v1)/doy
      wt4(1)=(1-q)*(1-r)
      wt4(2)=q*(1-r)
      wt4(3)=(1-q)*r
      wt4(4)=q*r
    end subroutine inter_wt
#else
  subroutine inter_wt(u1,u2,v1,v2,xt,yt,wt4)
    real(spdp), intent(in) :: u1,u2,v1,v2,xt,yt
    real(spdp), intent(out) :: wt4(4)
    real(spdp) :: dox, doy, r, q, phia, phib, phic, phid
    dox=u2-u1
    doy=v2-v1
    if(dox.eq.0.0.and.doy.eq.0.0)then
      !yvalue=(aa+bb+cc+dd)/4.0
      wt4=1.d0/4.d0
    endif
    if(dox.eq.0.0.and.doy.ne.0.0)then
      r=(yt-v1)/doy
      !yvalue=r*(cc+dd)/2.0+(1-r)*(aa+bb)/2.0
      wt4(3:4)=r/2.d0;wt4(1:2)=(1.d0-r)/2.d0
    endif
    if(dox.ne.0.0.and.doy.eq.0.0)then
      q=(xt-u1)/dox
      !yvalue=q*(bb+dd)/2.0+(1-q)*(aa+cc)/2.0
      wt4(2)=q/2.d0;wt4(4)=q/2.d0
      wt4(1)=(1.d0-q)/2.d0;wt4(3)=(1.d0-q)/2.d0
    endif
    if(dox.ne.0.0.and.doy.ne.0.0)then
      q=(xt-u1)/dox
      r=(yt-v1)/doy
      phia=(1-q)*(1-r)
      phib=q*(1-r)
      phic=(1-q)*r
      phid=q*r
      !yvalue=aa*phia
      !yvalue=yvalue+bb*phib
      !yvalue=yvalue+cc*phic
      !yvalue=yvalue+dd*phid
      wt4(1)=phia
      wt4(2)=phib
      wt4(3)=phic
      wt4(4)=phid
    endif
  end subroutine inter_wt
#endif
    !-----------------------------------------------------------------------------------------
    subroutine bilinear_4pm(x,y,xm,ym,wm,fm,f)
      real(spdp),intent(in) :: xm(4),ym(4),x,y
      real(spdp),intent(out) :: wm(4)
      real(spdp),optional,intent(in)  :: fm(4)
      real(spdp),optional,intent(out) :: f
      real(8) :: a1,a2,a3,a4,b1,b2,b3,b4,A,B,C,t,s
      a1=xm(1)-xm(2)+xm(3)-xm(4);a2=-xm(1)+xm(4);a3=-xm(1)+xm(2);a4=xm(1)-x
      b1=ym(1)-ym(2)+ym(3)-ym(4);b2=-ym(1)+ym(4);b3=-ym(1)+ym(2);b4=ym(1)-y
      a=a3*b1-a1*b3;b=b2*a3+b1*a4-a1*b4-a2*b3;c=-a2*b4+a4*b2
      if(abs(a*c)>0.002*b**2) then
        t=(-b-sqrt(b*b-4.*a*c))/(2.*a)
      else
        t=c/abs(b)
      endif
      a=a2*b1-a1*b2;b=b3*a2+b1*a4-a1*b4-a3*b2;c=-a3*b4+a4*b3
      if(abs(a*c)>0.002*b**2) then
        s=(-b+sqrt(b*b-4.*a*c))/(2.*a)
      else
        s=-c/abs(b)
      endif
      wm(1)=(1.-t)*(1.-s)
      wm(2)=t*(1.-s)
      wm(3)=s*t
      wm(4)=(1.-t)*s
      if(abs(wm(1))<1.e-5)wm(1)=0
      if(abs(wm(2))<1.e-5)wm(2)=0
      if(abs(wm(3))<1.e-5)wm(3)=0
      if(abs(wm(4))<1.e-5)wm(4)=0
      wm=wm/sum(wm)
      if(present(f))then
        f=fm(1)*wm(1)+fm(2)*wm(2)+fm(3)*wm(3)+fm(4)*wm(4)
      endif
    end subroutine bilinear_4pm
    !-----------------------------------------------------------------------------------------
  end subroutine propagat_preinf
!-------------------------------------------------------------------------------------------------
  subroutine propagat(idx)
    integer,intent(in) :: idx
    integer :: idx1,iwk,iwk1,jth,jth1,idx0,n
    real(spdp) :: exxyy
    real(spdp) :: wtp(4),wts(4)
    do j=1,jl
      do k=1,kl
        iwk =pgtinf(k,j,idx)%iwk;iwk1=pgtinf(k,j,idx)%iwk1
        jth =pgtinf(k,j,idx)%jth;jth1=pgtinf(k,j,idx)%jth1
        wtp=pgtinf(k,j,idx)%wtp;wts=pgtinf(k,j,idx)%wts
        exxyy=0.d0
        do n=1,pgtinf(k,j,idx)%np
          idx1=pgtinf(k,j,idx)%ids(n)
          exxyy=exxyy+ee(iwk ,jth ,idx1)*wtp(1)*wts(n)+ee(iwk1,jth ,idx1)*wtp(2)*wts(n) &
                     +ee(iwk ,jth1,idx1)*wtp(3)*wts(n)+ee(iwk1,jth1,idx1)*wtp(4)*wts(n)
        enddo
        e(k,j,idx)=max(exxyy,small)
      enddo
    enddo
  end subroutine propagat
!-------------------------------------------------------------------------------------------------
  subroutine smoth_ee_dir
    real(spdp),parameter :: a=24.0
    real(spdp) :: weight
    integer :: idx,j,j1
    real(spdp),allocatable :: em(:,:)
    allocate(em(kl,jl))
    weight=a+2.d0
    do idx=1,npc
      em=ee(:,:,idx)*a
      do j=1,jl
        j1=j-1;if(j1<1)j1=jl
        em(:,j)=em(:,j)+ee(:,j1,idx)
        j1=j+1;if(j1>jl)j1=1
        em(:,j)=em(:,j)+ee(:,j1,idx)
      enddo
      ee(:,:,idx)=em/weight
    enddo
    deallocate(em)
  end subroutine smoth_ee_dir
!-------------------------------------------------------------------------------------------------
  subroutine smoth_ee
    real(spdp),parameter :: a=24.0
    real(spdp) :: weight
    integer :: idx,n
    real(spdp),allocatable :: em(:,:,:)
    allocate(em(kl,jl,0:np));em=0.0
    do idx=1,npc
      if(nsp(idx)/=1)cycle  ! 2018-10-18 7:56:49
      !em(:,:,idx)=2.d0*a*ee(:,:,idx);weight=2.d0*a
      em(:,:,idx)=a*ee(:,:,idx);weight=a
      do n=1,cnb(idx)%n
        if(cnb(idx)%nbs(n)/=0)then
          em(:,:,idx)=em(:,:,idx)+ee(:,:,cnb(idx)%nbs(n));weight=weight+1
        endif
        !if(cnb(idx)%nbsc(n)/=0)then
        !  em(:,:,idx)=em(:,:,idx)+ee(:,:,cnb(idx)%nbsc(n));weight=weight+1
        !endif
      enddo
      em(:,:,idx)=max(small,em(:,:,idx)/weight)
    enddo
    ee=em
    deallocate(em)
  end subroutine smoth_ee
!-------------------------------------------------------------------------------------------------
  real(spdp) function geodist(lon1,lat1,lon2,lat2)
    implicit none
    real(spdp) :: lon1,lat1,lon2,lat2
    real(8) :: cosdlon,coslata,coslatb,sinlata,sinlatb,temp
    real(8),parameter :: earthradius=rs !6372799.0
    cosdlon=cos(abs((deg2rad*lon1-deg2rad*lon2)))
    coslata=cos(deg2rad*lat1)
    coslatb=cos(deg2rad*lat2)
    sinlata=sin(deg2rad*lat1)
    sinlatb=sin(deg2rad*lat2)
    temp=((cosdlon*coslata*coslatb)+(sinlata*sinlatb))
    geodist=acos(temp)*earthradius
  end function geodist
!-------------------------------------------------------------------------------------------------
  real(spdp) function geoangl(lona,lata,lonc,latc)
    implicit none
    real(spdp) :: lona,lata,lonc,latc
    real(8) :: a,b,c,sina
    real(8), parameter :: eps=0.00001
    integer :: signofresult
    !----------------------------------------------------------------------------
    ! Calculate angle A in degrees between vector b and true east c on earth
    ! given points in longitude degrees East and latitudes in degrees N/S (+/-).
    ! First (lonA, latA) pair is the common origin of the two vectors.
    ! Second pair (lonC, latC) is the end point of vector b.  The end point
    ! (lonB, latB) of vector c is taken as (lonC, latA) to form a right spherical
    ! triangle where B is the 90-degree angle.
    !
    !                            C
    !                           /|
    !                         /  |
    !                       /    |
    !                    b/      |a
    !                   /        |
    !                 /          |
    !               /            |
    !             A-------------->B
    !                      c
    !----------------------------------------------------------------------------
    signofresult=1;if(latc<lata)signofresult=-1
    ! Special treatment at true north pole
    if (((90.0-latc)/90.0)<=eps)lonc=lona
    if (((90.0-lata)/90.0)<=eps)lona=lonc
    !lona = mod(lona, 360.0)
    !lonc = mod(lonc, 360.0)
    ! No matter what the grid, c lies along the east reference direction,
    ! a line of true latitude.  We want the angle between it and the
    ! arbitrary b vector.  Even though b lies along a grid line in
    ! the transformed grid system, inside this routine it is merely
    ! an ordinary vector whose true coordinates are known.  Since we
    ! choose b's end point to lie on the same true meridan as c's end
    ! point, the a vector lies along that true meridian.
    c=abs(lonc-lona)*cos(lata)
    a=abs(latc-lata)
    b=sqrt(a*a+c*c) ! Approximate
    ! However, we don't have a right spherical triangle because c does
    ! not lie along a great circle.  So the following formula is slightly
    ! off.
    sina=sin(deg2rad*a)/sin(deg2rad*b) ! sinb = 1
    geoangl=signofresult*abs(asin(sina))/deg2rad
  end function geoangl
!-------------------------------------------------------------------------------------------------
  subroutine cal_geo_distangl(lon1,lat1,lon2,lat2,geodist,geoangl)
    real(spdp),intent(in) :: lon1,lat1,lon2,lat2
    real(spdp),intent(out) :: geodist,geoangl
    real(8),parameter :: eps=0.00001
    real(8),parameter :: earthradius=rs !6372799.0
    real(8) :: cosdlon,coslata,coslatb,sinlata,sinlatb,temp
    real(8) :: a,b,c,sina
    integer :: signofresult,signlon
    real(8) :: lona,lata,lonc,latc,dlon
    !-------------------------------------------------------------------
    cosdlon=cos(abs((deg2rad*lon1-deg2rad*lon2)))
    coslata=cos(deg2rad*lat1)
    coslatb=cos(deg2rad*lat2)
    sinlata=sin(deg2rad*lat1)
    sinlatb=sin(deg2rad*lat2)
    temp=((cosdlon*coslata*coslatb)+(sinlata*sinlatb))
    geodist=acos(temp)*earthradius
    !-------------------------------------------------------------------
    lona=lon1;lata=lat1;lonc=lon2;latc=lat2
    ! Special treatment at true north pole
    if (((90.0-latc)/90.0)<=eps)lonc=lona
    if (((90.0-lata)/90.0)<=eps)lona=lonc
    signofresult=1;if(latc<lata)signofresult=-1
    if(abs(latc-lata)<1.d-6)signofresult=1  ! new add: yinxq 20190111
    dlon=abs(lonc-lona);signlon=0
    if(dlon>180 .and. lona<lonc)signlon=180
    if(dlon<180 .and. lona>lonc)signlon=180
    !c=abs(lonc-lona)*cos(lata)
    !c=abs(lonc-lona)*cos(lata*deg2rad)
    if(dlon>180)dlon=360-dlon
    c=dlon*cos(lata*deg2rad)
    a=abs(latc-lata)
    b=sqrt(a*a+c*c)
    !sina=sin(deg2rad*a)/sin(deg2rad*b) ! sinb = 1
    sina=a/b
    geoangl=abs(signlon-abs(asin(sina))/deg2rad)
    if(signofresult<0)geoangl=360.d0-geoangl
    !if(geoangl<1.d-6)geoangl=0.d0  ! new add: yinxq 20190111
    if(geoangl<1.d-5)geoangl=0.d0  ! new add: yinxq 20190114
    !write(*,*)'ttt',a,b,c,geoangl,sina
  end subroutine cal_geo_distangl
!-------------------------------------------------------------------------------------------------
  subroutine setgeoinf(mlon,mlat,npend,nsp_)
    real(spdp),intent(in) :: mlon(:,:),mlat(:,:)
    integer,intent(in),optional :: npend,nsp_(:)
    integer :: idx
    real(spdp) :: ang,grdx,grdy
    integer :: n,nn,nnn,i,j,i0,j0,nps0,nps1
    integer,allocatable :: pointernsp(:)
    !------------------------------------------
    if(.not. allocated(cnb))allocate(cnb(0:np))
    nps0=1;nps1=npc;if(present(npend))nps1=npend
    allocate(pointernsp(np))
    if(present(nsp_))then
      pointernsp(1:np)=nsp_(1:np)
    else
      pointernsp(1:np)=nsp(1:np)
    endif
    do idx=nps0,nps1
      
      if(pointernsp(idx)/=1)cycle
      
      ! --- allocate variables
      cnb(idx)%n=4
      allocate(cnb(idx)%nbs(cnb(idx)%n))
      allocate(cnb(idx)%rot(cnb(idx)%n))
      allocate(cnb(idx)%dst(cnb(idx)%n))
      cnb(idx)%nbs(:)=[pnb(idx)%r,pnb(idx)%u,pnb(idx)%l,pnb(idx)%d]
      allocate(cnb(idx)%nbsc(cnb(idx)%n))
      !yinxq-20220716:allocate(cnb(idx)%rotc(cnb(idx)%n))
      !yinxq-20220716:allocate(cnb(idx)%dstc(cnb(idx)%n))
      cnb(idx)%nbsc(:)=[pnb(idx)%ur,pnb(idx)%ul,pnb(idx)%dl,pnb(idx)%dr]
      !yinxq-20220716:allocate(cnb(idx)%xm(cnb(idx)%n))
      !yinxq-20220716:allocate(cnb(idx)%ym(cnb(idx)%n))
      !yinxq-20220716:allocate(cnb(idx)%xmc(cnb(idx)%n))
      !yinxq-20220716:allocate(cnb(idx)%ymc(cnb(idx)%n))
      allocate(cnb(idx)%rotc(cnb(idx)%n)) ;cnb(idx)%rotc=0.d0
      allocate(cnb(idx)%dstc(cnb(idx)%n)) ;cnb(idx)%dstc=0.d0
      allocate(cnb(idx)%xm(cnb(idx)%n))   ;cnb(idx)%xm=0.d0
      allocate(cnb(idx)%ym(cnb(idx)%n))   ;cnb(idx)%ym=0.d0
      allocate(cnb(idx)%xmc(cnb(idx)%n))  ;cnb(idx)%xmc=0.d0
      allocate(cnb(idx)%ymc(cnb(idx)%n))  ;cnb(idx)%ymc=0.d0
      i0=pnb(idx)%i;j0=pnb(idx)%j
      do n=1,4
        if(n==1)then
          nn=pnb(idx)%r;i=i0+1;j=j0
        elseif(n==2)then
          nn=pnb(idx)%u;i=i0;j=j0+1
        elseif(n==3)then
          nn=pnb(idx)%l;i=i0-1;j=j0
        elseif(n==4)then
          nn=pnb(idx)%d;i=i0;j=j0-1
        endif
        !if(nn/=0)then
        ! i=pnb(nn)%i;j=pnb(nn)%j
        ! cnb(idx)%xm(n)=mlon(i,j)-mlon(i0,j0)
        ! cnb(idx)%ym(n)=mlat(i,j)-mlat(i0,j0)
        !endif
        !if(i>0 .and. i<=im .and. j>0 .and. j<=jm)then
        ! cnb(idx)%xm(n)=mlon(i,j)-mlon(i0,j0)
        ! cnb(idx)%ym(n)=mlat(i,j)-mlat(i0,j0)
        !endif
        if(nn/=0)then
          cnb(idx)%xm(n)=alon(nn)-alon(idx)
          cnb(idx)%ym(n)=alat(nn)-alat(idx)
        else
          if(j<1)j=1
          if(j>jm)j=jm
          if(i>im)then
            cnb(idx)%xm(n)=mlon(i0,j0)-mlon(im-1,j)
            !cnb(idx)%ym(n)=mlat(i0,j0)-mlat(im-1,j)
            cnb(idx)%ym(n)=-(mlat(i0,j0)-mlat(im-1,j))
          elseif(i<1)then
            cnb(idx)%xm(n)=mlon(i0,j0)-mlon(2,j)
            !cnb(idx)%ym(n)=mlat(i0,j0)-mlat(2,j)
            cnb(idx)%ym(n)=-(mlat(i0,j0)-mlat(2,j))
          else
            cnb(idx)%xm(n)=mlon(i,j)-mlon(i0,j0)
            cnb(idx)%ym(n)=mlat(i,j)-mlat(i0,j0)
          endif
        endif
        if(cnb(idx)%xm(n)>90.d0)cnb(idx)%xm(n)=cnb(idx)%xm(n)-360.d0
        if(cnb(idx)%xm(n)<-90.d0)cnb(idx)%xm(n)=cnb(idx)%xm(n)+360.d0
        
        if(n==1)then
          nn=pnb(idx)%ur;i=i0+1;j=j0+1
        elseif(n==2)then
          nn=pnb(idx)%ul;i=i0-1;j=j0+1
        elseif(n==3)then
          nn=pnb(idx)%dl;i=i0-1;j=j0-1
        elseif(n==4)then
          nn=pnb(idx)%dr;i=i0+1;j=j0-1
        endif
        if(j<1)j=1
        if(j>jm)j=jm
        if(nn/=0)then
          cnb(idx)%xmc(n)=alon(nn)-alon(idx)
          cnb(idx)%ymc(n)=alat(nn)-alat(idx)
        else
          if(i>im)then
            cnb(idx)%xmc(n)=alon(idx)-mlon(im-1,j)
            cnb(idx)%ymc(n)=-(alat(idx)-mlat(im-1,j))
          elseif(i<1)then
            cnb(idx)%xmc(n)=alon(idx)-mlon(2,j)
            cnb(idx)%ymc(n)=-(alat(idx)-mlat(2,j))
          else
            cnb(idx)%xmc(n)=mlon(i,j)-alon(idx)
            cnb(idx)%ymc(n)=mlat(i,j)-alat(idx)
          endif
        endif
        if(cnb(idx)%xmc(n)>90.d0)cnb(idx)%xmc(n)=cnb(idx)%xmc(n)-360.d0
        if(cnb(idx)%xmc(n)<-90.d0)cnb(idx)%xmc(n)=cnb(idx)%xmc(n)+360.d0
      enddo
      !  c2----n2----c1   
      !  |      |     |   
      !  n3-----o----n1   N1-4: right,up,left,down
      !  |      |     |   C1-4: ur,ul,dl,dr
      !  c3----n4----c4
!      do n=1,cnb(idx)%n
!        if(cnb(idx)%nbs(n)/=0)call cal_geo_distangl(alon(idx),alat(idx),                         &
!                                                    alon(cnb(idx)%nbs(n)),alat(cnb(idx)%nbs(n)), &
!                                                   cnb(idx)%dst(n),cnb(idx)%rot(n))
!        if(cnb(idx)%nbsc(n)/=0)call cal_geo_distangl(alon(idx),alat(idx),                          &
!                                                     alon(cnb(idx)%nbsc(n)),alat(cnb(idx)%nbsc(n)),&
!                                                    cnb(idx)%dstc(n),cnb(idx)%rotc(n))
!      enddo
!      do n=1,cnb(idx)%n
!        if(cnb(idx)%nbs(n)==0)then
!          do nn=1,cnb(idx)%n-1
!            nnn=n+nn;if(nnn>cnb(idx)%n)nnn=nnn-cnb(idx)%n
!            if(cnb(idx)%nbs(nnn)/=0)then
!              cnb(idx)%dst(n)=cnb(idx)%dst(nnn)
!              cnb(idx)%rot(n)=cnb(idx)%rot(nnn)-nn*90.d0
!              if(cnb(idx)%rot(n)<0)cnb(idx)%rot(n)=cnb(idx)%rot(n)+360.d0
!              exit
!            endif
!          enddo
!        endif
!        if(cnb(idx)%nbsc(n)==0)then
!          do nn=1,cnb(idx)%n-1
!            nnn=n+nn;if(nnn>cnb(idx)%n)nnn=nnn-cnb(idx)%n
!            if(cnb(idx)%nbsc(nnn)/=0)then
!              cnb(idx)%dstc(n)=cnb(idx)%dstc(nnn)
!              cnb(idx)%rotc(n)=cnb(idx)%rotc(nnn)-nn*90.d0
!              if(cnb(idx)%rotc(n)<0)cnb(idx)%rotc(n)=cnb(idx)%rotc(n)+360.d0
!              exit
!            endif
!          enddo
!        endif
!      enddo
      do n=1,cnb(idx)%n
        call cal_geo_distangl(alon(idx),                &
                              alat(idx),                &
                              alon(idx)+cnb(idx)%xm(n), &
                              alat(idx)+cnb(idx)%ym(n), &
                              cnb(idx)%dst(n),          &
                              cnb(idx)%rot(n)           )
        call cal_geo_distangl(alon(idx),                 &
                              alat(idx),                 &
                              alon(idx)+cnb(idx)%xmc(n), &
                              alat(idx)+cnb(idx)%ymc(n), &
                              cnb(idx)%dstc(n),          &
                              cnb(idx)%rotc(n)           )
      enddo
!if(cnb(idx)%dst(3)>99978)then    
! write(*,*)'----------',alon(idx),alat(idx),pnb(idx)%i,pnb(idx)%j,cnb(idx)%dst(3)
! write(*,*)'x',alon(cnb(idx)%nbs(1)),alon(cnb(idx)%nbs(2)),alon(cnb(idx)%nbs(3)),alon(cnb(idx)%nbs(4))
! write(*,*)'y',alat(cnb(idx)%nbs(1)),alat(cnb(idx)%nbs(2)),alat(cnb(idx)%nbs(3)),alat(cnb(idx)%nbs(4))
! write(*,*)'dst',cnb(idx)%dst
! write(*,*)'dst',cnb(idx)%nbs
!endif            

      !-------------------------------------------------------------------------------------------
      ! --- Calculate ang, the gridient of topography (dddx, dddy) based on (grdx, grdy)
      !-------------------------------------------------------------------------------------------
      if(pnb(idx)%r/=0 .and. pnb(idx)%l/=0)then
        grdx=0.5d0*((d(pnb(idx)%r)-d(idx))/cnb(idx)%dst(1) &
                   +(d(idx)-d(pnb(idx)%l))/cnb(idx)%dst(3) )
        !yinxq,20190112: ang=deg2rad*(cnb(idx)%rot(1)+cnb(idx)%rot(3)-180.d0)/2.d0
      elseif(pnb(idx)%r/=0)then
        grdx=(d(pnb(idx)%r)-d(idx))/cnb(idx)%dst(1)
        !yinxq,20190112: ang=deg2rad*cnb(idx)%rot(1)
      elseif(pnb(idx)%l/=0)then
        grdx=(d(idx)-d(pnb(idx)%l))/cnb(idx)%dst(3)
        !yinxq,20190112: ang=deg2rad*(cnb(idx)%rot(3)-180.d0)
      else
        grdx=0.d0
        !yinxq,20190112: ang=deg2rad*cnb(idx)%rot(1)
      endif
      ang=deg2rad*cnb(idx)%rot(1)  ! new add: yinxq 20190111
      
      !if(ang>0)then
      ! write(*,*)'------------------------------------------------------------------'
      ! write(*,*)pnb(idx)%r, pnb(idx)%l, idx,cnb(idx)%rot(1),cnb(idx)%rot(3),ang/deg2rad
      ! write(*,*)pnb(idx)%r, pnb(idx)%l, idx,deg2rad*cnb(idx)%rot(1),deg2rad*cnb(idx)%rot(3),ang
      !endif
      
      if(pnb(idx)%u/=0 .and. pnb(idx)%d/=0)then
        grdy=0.5d0*((d(pnb(idx)%u)-d(idx))/cnb(idx)%dst(2)+(d(idx)-d(pnb(idx)%d))/cnb(idx)%dst(4))
      elseif(pnb(idx)%u/=0)then
        grdy=(d(pnb(idx)%u)-d(idx))/cnb(idx)%dst(2)
      elseif(pnb(idx)%d/=0)then
        grdy=(d(idx)-d(pnb(idx)%d))/cnb(idx)%dst(4)
      else
        grdy=0.d0
      endif
      
      cnb(idx)%dddx=grdx*cos(ang)-grdy*sin(ang)
      cnb(idx)%dddy=grdy*cos(ang)+grdx*sin(ang)
      cnb(idx)%tanlatrs=tan(alat(idx)*pi/180.d0)/rs
      cnb(idx)%rslat=rs*cos(alat(idx)*pi/180.d0) !rslat !(idx)      
      cnb(idx)%angle=ang      
    enddo
    deallocate(pointernsp)
  end subroutine setgeoinf
!-------------------------------------------------------------------------------------------------
  end module mwmpgt_mod
!-------------------------------------------------------------------------------------------------
! log: 20190111
!    use the rot(1) as the angle of each grid;
!      ang=deg2rad*cnb(idx)%rot(1)  ! new add: yinxq 20190111
!    When two float value is very close, compare its value will obtain a wrong sign.
!      if(abs(latc-lata)<1.d-6)signofresult=1  ! new add: yinxq 20190111
!    If the calculated angle is very small, set it equal zero.
!     if(geoangl<1.d-6)geoangl=0.d0  ! new add: yinxq 20190111
!    Move this line to the end of this function. yinxq: 20190112
!-------------------------------------------------------------------------------------------------
! log: 20190112
!    Since the difference of the lon/lat from grid location to all the adjacent points have been 
!    calculated already, it can be used to calculate the distance and angle by adding the difference
!    to the center location. So we change the following lines into a new version.
!    Old code:
!      do n=1,cnb(idx)%n
!        if(cnb(idx)%nbs(n)/=0)call cal_geo_distangl(alon(idx),alat(idx),                         &
!                                                    alon(cnb(idx)%nbs(n)),alat(cnb(idx)%nbs(n)), &
!                                                   cnb(idx)%dst(n),cnb(idx)%rot(n))
!        if(cnb(idx)%nbsc(n)/=0)call cal_geo_distangl(alon(idx),alat(idx),                          &
!                                                     alon(cnb(idx)%nbsc(n)),alat(cnb(idx)%nbsc(n)),&
!                                                    cnb(idx)%dstc(n),cnb(idx)%rotc(n))
!      enddo
!      do n=1,cnb(idx)%n
!        if(cnb(idx)%nbs(n)==0)then
!          do nn=1,cnb(idx)%n-1
!            nnn=n+nn;if(nnn>cnb(idx)%n)nnn=nnn-cnb(idx)%n
!            if(cnb(idx)%nbs(nnn)/=0)then
!              cnb(idx)%dst(n)=cnb(idx)%dst(nnn)
!              cnb(idx)%rot(n)=cnb(idx)%rot(nnn)-nn*90.d0
!              if(cnb(idx)%rot(n)<0)cnb(idx)%rot(n)=cnb(idx)%rot(n)+360.d0
!              exit
!            endif
!          enddo
!        endif
!        if(cnb(idx)%nbsc(n)==0)then
!          do nn=1,cnb(idx)%n-1
!            nnn=n+nn;if(nnn>cnb(idx)%n)nnn=nnn-cnb(idx)%n
!            if(cnb(idx)%nbsc(nnn)/=0)then
!              cnb(idx)%dstc(n)=cnb(idx)%dstc(nnn)
!              cnb(idx)%rotc(n)=cnb(idx)%rotc(nnn)-nn*90.d0
!              if(cnb(idx)%rotc(n)<0)cnb(idx)%rotc(n)=cnb(idx)%rotc(n)+360.d0
!              exit
!            endif
!          enddo
!        endif
!      enddo
!    New code:
!      do n=1,cnb(idx)%n
!        call cal_geo_distangl(alon(idx),                &
!                              alat(idx),                &
!                              alon(idx)+cnb(idx)%xm(n), &
!                              alat(idx)+cnb(idx)%ym(n), &
!                              cnb(idx)%dst(n),          &
!                              cnb(idx)%rot(n)           )
!        call cal_geo_distangl(alon(idx),                 &
!                              alat(idx),                 &
!                              alon(idx)+cnb(idx)%xmc(n), &
!                              alat(idx)+cnb(idx)%ymc(n), &
!                              cnb(idx)%dstc(n),          &
!                              cnb(idx)%rotc(n)           )
!      enddo
!-------------------------------------------------------------------------------------------------
! log: 20190112
!   The treatment for averaged angle for one grid point is not right. 
!   For example, rot(1)=350,rot(3)=170, we hope the averaged angle for this point equal to 350 or -10.
!   But using this formula, the results will be 170, and the direction is opposite. 
!   So the rot(1) is used directly for the angle of current point.
!        !yinxq,20190112: ang=deg2rad*(cnb(idx)%rot(1)+cnb(idx)%rot(3)-180.d0)/2.d0
!-------------------------------------------------------------------------------------------------

! log: 20190114
!   last version
!     if(geoangl<1.d-6)geoangl=0.d0  ! new add: yinxq 20190111
!   new version
!     if(geoangl<1.d-5)geoangl=0.d0  ! new add: yinxq 20190114
