#define DBG  print*, __FILE__, __LINE__
#define ST6_SWL
#define PREVCD
!###############################################################################
!-------------------------------------------------------------------------------
!                                                                              !
!              Modular version of MASNUM Wave Model (MWM)                      !
!                                                                              !
!------------------------------------------------------------------------------!
!------------------------------------------------------------------------------!
#define IAIC_IDX idx
  module mwmcor_mod
  use mwmvar_mod
#ifdef TESTINTEG
  use partctl_mod,only : plist
#endif
#ifdef ST6_SWL
  use uomst6_mod, only:st6swl
#endif
  implicit none
  !-------------------------------------------------------------------------------
  public :: setspec,implsch,mean1,setwave,nlweight
  public :: implsch_old
  public :: intact_mixture_bv,check_timestep
  private
  !-------------------------------------------------------------------------------
  contains
  !-------------------------------------------------------------------------------
!-------------------------------------------------------------------------------
  subroutine implsch(IAIC_IDX)
    integer,intent(in) :: IAIC_IDX
    real(spdp) :: ww,cd
    integer :: ks
#ifdef ST6_SWL
    real(spdp) :: s6sig(kl),s6betaswl(kl,jl),seswl(kl,jl)
    integer :: k,j
#endif
!    ee(:,:,idx)=1
!    if(nsp(idx)/=1)then
!      ee(:,:,idx)=0
!      return
!    endif
!    ee(:,:,idx)=1;return
    if(nsp(idx)==0)return
    call mean2(IAIC_IDX)
    !if(nsp(idx)/=0)then
      call setksfconst0(wx(IAIC_IDX),wy(IAIC_IDX),awk(IAIC_IDX),ks)
      call sourcefct_snonlin (IAIC_IDX)                 !d(IAIC_IDX),awk(IAIC_IDX),e(:,:,IAIC_IDX))
!ee(:,:,IAIC_IDX)=se+dse;      return
      call sourcefct_sinput  (IAIC_IDX,ks,cd,ww)        !wf(:,IAIC_IDX),e(:,:,IAIC_IDX),ww)
      call sourcefct_sdissip (IAIC_IDX,ks)              !wf(:,IAIC_IDX),e(:,:,IAIC_IDX),awfss,asiss,arkss,aess)
#ifdef ST6_SWL
      if(opt_swl==1)then
        s6sig(1:ks) = zpi*wf(1:ks,IAIC_IDX)
        call ST6SWL(ks,jl,wk(1:ks),s6sig(1:ks),ccg(1:ks,IAIC_IDX), &
                    e(1:ks,1:jl,IAIC_IDX),seswl(1:ks,1:jl),        &
                    s6betaswl(1:ks,1:jl))
        do k=1,ks
          do j=1,jl
            se(k,j)=se(k,j)+seswl(k,j)
            dse(k,j)=dse(k,j)+s6betaswl(k,j)
          enddo
        enddo
      endif
#endif
      call sourcefct_sbottom (IAIC_IDX,ks)              !d(IAIC_IDX),e(:,:,IAIC_IDX))
      call sourcefct_scurrent(IAIC_IDX,ks)              !duxdx0,duxdy0,duydx0,duydy0,wf(:,IAIC_IDX),e(:,:,IAIC_IDX),ccg(:,IAIC_IDX))
      call forward_implsch   (IAIC_IDX,ks,cd,ww)        !e(:,:,IAIC_IDX),ee(:,:,IAIC_IDX))
    !endif
    call setspec(2,IAIC_IDX) ! set water boundary
    call mean1(IAIC_IDX)     ! To compute the characters of wave
  end subroutine implsch

  subroutine setksfconst0(vx,vy,awk0,ks)
    real(spdp),intent(in) :: vx,vy,awk0
    integer,intent(out) :: ks
    real(spdp) :: ww
    integer :: kpmt,kakt
    !ww=vx**2+vy**2;if(ww==0.)ww=0.05
    !kpmt=log10((cksp*gc2/ww)/wk(1))/alog10pwk+1
    !kakt=log10(cksa*awk(IAIC_IDX)/wk(1))/alog10pwk+1
    !ks=min0(max0(kpmt,kakt),kl)  !;ks0=ks
    !fconst0=1.d0;fconst0((ks+1):kl)=0
    ww=vx**2+vy**2;if(ww==0.)ww=0.05
    kpmt=log10((cksp*gc2/ww)/wk(1))/alog10pwk+1
    !kakt=log10(cksa*awk(IAIC_IDX)/wk(1))/alog10pwk+1
    kakt=log10(cksa*awk0/wk(1))/alog10pwk+1
    ks=min0(max0(kpmt,kakt),kl)  !;ks0=ks
    fconst0=1.d0;fconst0((ks+1):kl)=0
    se=0.d0;dse=0.d0
  end subroutine setksfconst0

  subroutine forward_implsch(idx,ks,cd,ww) !,esigpnt,eesigpnt)
    integer,intent(in) :: idx
    integer,intent(in) :: ks
    real(spdp),intent(in) :: ww
    real(spdp),intent(in) :: cd
    !real(spdp),intent(in) :: esigpnt(:,:)
    !real(spdp),intent(out) :: eesigpnt(:,:)

    real(spdp) :: wstar,deltee,gadiag,eef,eefab,sig
    integer :: i

    !ks=ks0
    wstar=ww*sqrt(cd)
    do j=1,jl
      do k=1,ks
        !deltee=wstar*grolim(k)
        deltee=wstar*grolim(k)*deltt
        !gadiag=1.-deltt5*dse(k,j)
        gadiag=1.d0-0.5d0*deltt*dse(k,j)
        !gadiag=amax1(gadiag,1.)
        gadiag=max(gadiag,1.)
        eef=deltt*se(k,j)/gadiag
        eefab=abs(eef)
        !eefab=amax1(eefab,0.1e-19)  ! yinxq 2015-8-1 0:19:15
        eefab=max(eefab,0.1e-19)
        sig=eef/eefab
        !eefab=amin1(eefab,deltee)  ! yinxq 2015-8-1 0:15:50
        eefab=min(eefab,deltee)
        eef=e(k,j,IAIC_IDX)+sig*eefab
        !eef=esigpnt(k,j)+sig*eefab
        !yinxq:      ee(k,j,IAIC_IDX)=amax1(eef,0.)
        !ee(k,j,IAIC_IDX)=max(small,amax1(eef,0.)) ! yinxq 2015-8-1 0:15:24
        ee(k,j,IAIC_IDX)=max(small,max(eef,0.))
        !eesigpnt(k,j)=max(small,max(eef,0.))
      enddo
      do k=ks+1,kl
        i=k-ks+1
        !yinxq:      ee(k,j,IAIC_IDX)=ee(ks,j,IAIC_IDX)*wkh(i)
        ee(k,j,IAIC_IDX)=max(small,ee(ks,j,IAIC_IDX)*wkh(i))
        !eesigpnt(k,j)=max(small,eesigpnt(k,j)*wkh(i))
      enddo
    enddo
  end subroutine forward_implsch

  subroutine sourcefct_snonlin(idx)         !depth,awk0,esigpnt)
    integer,intent(in) :: idx
    !real(spdp),intent(in) :: depth,awk0,esigpnt(:,:)

    real(spdp) :: deladm,deladp,xx,wp11,wp12,wp21,wp22,wm11,wm12,wm21,wm22
    real(spdp) :: wp112,wp122,wp212,wp222,wm112,wm122,wm212,wm222,ffacp,ffacp1
    real(spdp) :: cwks17,eij,ea1,ea2,ea3,ea4,ea5,ea6,ea7,ea8,up,up1,enh
    real(spdp) :: um,um1,sap,sam,eij2,zua,ead1,ead2,fcen,ad,adp,adm,delad
    integer :: ks,k,j,kh,ip,ip1,im1
    integer :: kp,kp1,kp2,kp3,mr,js,j11,j12,j21,j22,i,im
    real(spdp) :: depth,awk0
    depth=d(IAIC_IDX);awk0=awk(IAIC_IDX) !,,e(:,:,IAIC_IDX)
    !d(IAIC_IDX),awk(IAIC_IDX),e(:,:,IAIC_IDX)

    !*************************************
    !      call snonlin(e)
    !*************************************
    !         x=0.75*d(IAIC_IDX)*akmean(IAIC_IDX)
    !xx=0.75*d(IAIC_IDX)*awk(IAIC_IDX)
    xx=0.75*depth*awk0
    if(xx.lt.0.5)xx=0.5
    enh=1.+(5.5/xx)*(1.-0.833*xx)*exp(-1.25*xx)
    kh=0
    do k=1,kl
      ks=k
      wp11=wp(k,1,1)
      wp12=wp(k,1,2)
      wp21=wp(k,2,1)
      wp22=wp(k,2,2)
      wm11=wm(k,1,1)
      wm12=wm(k,1,2)
      wm21=wm(k,2,1)
      wm22=wm(k,2,2)
      wp112=wp11**2
      wp122=wp12**2
      wp212=wp21**2
      wp222=wp22**2
      wm112=wm11**2
      wm122=wm12**2
      wm212=wm21**2
      wm222=wm22**2
      ffacp=1.
      ffacp1=1.
      ip=ikp(k)
      ip1=ikp1(k)
      im=ikm(k)
      im1=ikm1(k)
      cwks17=cong*wks17(k)
      kp=ip
      kp1=ip1
      kp2=kp
      kp3=kp1
      if(kp >= kl)then
        kh=kh+1
        kp2=kl+1
        if(kp.eq.kl)kp2=kl
        kp=kl
        kp1=kl
        kp3=kl+1
        ffacp=wkh(kh)
        ffacp1=wkh(kh+1)
      endif
      do mr=1,2
        !*      1.2 angular loop
        do j=1,jl
          js=j
          j11=jp1(mr,j)
          j12=jp2(mr,j)
          j21=jm1(mr,j)
          j22=jm2(mr,j)
          !****************************************************************
          eij=e(ks,js,IAIC_IDX)
          !eij=esigpnt(ks,js)
          if (eij.lt.1.e-20) cycle
          ea1=e(kp ,j11,IAIC_IDX)
          ea2=e(kp ,j12,IAIC_IDX)
          ea3=e(kp1,j11,IAIC_IDX)
          ea4=e(kp1,j12,IAIC_IDX)
          ea5=e(im ,j21,IAIC_IDX)
          ea6=e(im ,j22,IAIC_IDX)
          ea7=e(im1,j21,IAIC_IDX)
          ea8=e(im1,j22,IAIC_IDX)

          !ea1=esigpnt(kp ,j11)
          !ea2=esigpnt(kp ,j12)
          !ea3=esigpnt(kp1,j11)
          !ea4=esigpnt(kp1,j12)
          !ea5=esigpnt(im ,j21)
          !ea6=esigpnt(im ,j22)
          !ea7=esigpnt(im1,j21)
          !ea8=esigpnt(im1,j22)

          up =(wp11*ea1+wp12*ea2)*ffacp
          up1=(wp21*ea3+wp22*ea4)*ffacp1
          um =wm11*ea5+wm12*ea6
          um1=wm21*ea7+wm22*ea8
          sap=up+up1
          sam=um+um1
          eij2=eij**2
          zua=2.*eij/al31
          ead1=sap/al11+sam/al21
          ead2=-2.*sap*sam/al31
          !      fcen=fcnss(k,IAIC_IDX)*enh(IAIC_IDX)
          fcen=fconst0(k)*enh
          ad=cwks17*(eij2*ead1+ead2*eij)*fcen
          adp=ad/al13
          adm=ad/al23
          delad =cwks17*(eij*2.*ead1+ead2) *fcen
          deladp=cwks17*(eij2/al11-zua*sam)*fcen/al13
          deladm=cwks17*(eij2/al21-zua*sap)*fcen/al23
          !*      nonlinear transfer
          se(ks ,js )= se(ks ,js )-2.0*ad
          se(kp2,j11)= se(kp2,j11)+adp*wp11
          se(kp2,j12)= se(kp2,j12)+adp*wp12
          se(kp3,j11)= se(kp3,j11)+adp*wp21
          se(kp3,j12)= se(kp3,j12)+adp*wp22
          se(im ,j21)= se(im ,j21)+adm*wm11
          se(im ,j22)= se(im ,j22)+adm*wm12
          se(im1,j21)= se(im1,j21)+adm*wm21
          se(im1,j22)= se(im1,j22)+adm*wm22
          dse(ks ,js )=dse(ks ,js )-2.0*delad
          dse(kp2,j11)=dse(kp2,j11)+deladp*wp112
          dse(kp2,j12)=dse(kp2,j12)+deladp*wp122
          dse(kp3,j11)=dse(kp3,j11)+deladp*wp212
          dse(kp3,j12)=dse(kp3,j12)+deladp*wp222
          dse(im ,j21)=dse(im ,j21)+deladm*wm112
          dse(im ,j22)=dse(im ,j22)+deladm*wm122
          dse(im1,j21)=dse(im1,j21)+deladm*wm212
          dse(im1,j22)=dse(im1,j22)+deladm*wm222
        enddo
      enddo
    enddo
  end subroutine sourcefct_snonlin

  subroutine sourcefct_sinput(idx,ks,cd,ww) !,vx,vy,wfsg,esigpnt)
    integer,intent(in) :: idx
    integer,intent(in) :: ks
    real(spdp),intent(out) :: cd,ww
    !real(spdp),intent(in) :: vx,vy
    !real(spdp),intent(in) :: wfsg(:),esigpnt(:,:)
    real(spdp) :: theta0,costh,sinth,wf0,wlstar,ws0,bett,wk0,wl,beta, vx,vy

    !*************************************
    !      call sinput(e)
    !*************************************
    !ks=ks0 !(IAIC_IDX)
    vx=wx(IAIC_IDX)
    vy=wy(IAIC_IDX)
    ww=sqrt(vx**2+vy**2)
    if (ww.eq.0.) ww=0.05  !!(add)wfw/2022/11/6
!#ifdef PREVCD
    if(opt_cd==0)then
      cd=(0.80+0.065*ww)*0.001
!#else
    elseif(opt_cd==1)then
      if(ww<=11)then
        cd=1.2
      elseif(ww>11 .and. ww <=19)then
        cd=0.49+0.065*ww
      elseif(ww>19)then
        !cd=1.364+0.0234*ww+0.00023158*ww*ww
        cd=1.364+0.0234*ww-0.00023158*ww*ww
      endif
      cd=cd*0.001
    endif
!#endif
    do j=1,jl
      theta0=thet(j)
      costh=cos(theta0)
      sinth=sin(theta0)
      wl=vx*costh+vy*sinth
      wlstar=wl*sqrt(cd)
      do k=1,ks
        wk0=wk(k)
        wf0=wf(k,IAIC_IDX)
        ws0=zpi*wf0
        !yinxq:      bett=beta10*(1.+beta1*winc(IAIC_IDX))
        bett=beta10
        !beta=amax1(0.,bett*(wk0*28.*wlstar-ws0)) ! yinxq 2015-8-1 0:18:21
        beta=max(0.,bett*(wk0*28.*wlstar-ws0))
        !sein(k,j) = beta*e(k,j,IAIC_IDX) ! yinxq: 2011.05.06
        se(k,j)= se(k,j)+beta*e(k,j,IAIC_IDX)
        dse(k,j)=dse(k,j)+beta
      enddo
    enddo
    !      write(*,*)'endcall sinp'
  end subroutine sourcefct_sinput

  subroutine sourcefct_sdissip(idx,ks)      !wfsg,esigpnt,awfss,asiss,arkss,aess)
    integer,intent(in) :: ks
    integer,intent(in) :: idx
    !real(spdp),intent(in) :: wfsg(:),esigpnt(:,:)
    !real(spdp),intent(in) :: awfss,asiss,arkss,aess
    real(spdp) :: eks,ekspm,sds,ssds,wk0,awfss,asiss,arkss,aess
    !***************************************************
    !      goto 3009
    !      if (logsdiss.eq.1) goto 3009
    !      call sdissip(e)--old
    !***************************************************
    !      call sdissip(e)--new
    !***************************************************
    !ks=ks0 !(IAIC_IDX)
    awfss=awf(IAIC_IDX)
    asiss=asi(IAIC_IDX)
    arkss=ark(IAIC_IDX)
    aess = ae(IAIC_IDX)

    eks=aess*arkss*arkss
    ekspm=eks/0.0030162
    !      sds=2.36e-5*asiss*arkss**3*aess**2/alpm2
    !      2.36e-5/alpm2=2.587605807
    !      sds=2.60*(zpi*awfss)*arkss**3*aess**2
    sds=d1*asiss/arkss*sqrt(ekspm)*exp(-d2*0.64/ekspm)
    do k=1,ks
      wk0=wk(k)
      do j=1,jl
        ssds=-ads*sds*wk0
        !seds(k,j)=ssds*e(k,j,IAIC_IDX) ! yinxq: 2011.05.06
        se(k,j)=se(k,j)+ssds*e(k,j,IAIC_IDX)
        dse(k,j)=dse(k,j)+ssds
      enddo
    enddo
  end subroutine sourcefct_sdissip

  subroutine sourcefct_scurrent(idx,ks)     !,duxdx0,duxdy0,duydx0,duydy0,wfsg,esigpnt,ccg1)
    integer,intent(in) :: idx
    integer,intent(in) :: ks
    !real(spdp),intent(in) :: duxdx0,duxdy0,duydx0,duydy0
    !real(spdp),intent(in) :: wfsg(:),esigpnt(:,:),ccg1(:)
    real(spdp) :: th0,sinth,costh,wk0,ws0,cg,cp,cgdc,cu1,cu2,cu3,cost2,sint2,sscu
    real(spdp) :: duxdx0,duxdy0,duydx0,duydy0
    !*************************************
    !      call scurrent(e)
    !*************************************
    duxdx0=uxx(IAIC_IDX)
    duxdy0=uxy(IAIC_IDX)
    duydx0=uyx(IAIC_IDX)
    duydy0=uyy(IAIC_IDX)
    !ks=ks0 !(IAIC_IDX)
    do j=1,jl
      th0=thet(j)
      sinth=sin(th0)
      costh=cos(th0)
      cost2=costh*costh
      sint2=sinth*sinth
      do k=1,ks
        wk0=wk(k)
        ws0=zpi*wf(k,IAIC_IDX)
        cg=ccg(k,IAIC_IDX)
        cp=ws0/wk0
        cgdc=cg/cp
        cu1=(cgdc*(1.+cost2)-0.5)*duxdx0
        cu2= cgdc*sinth*costh*(duxdy0+duydx0)
        cu3=(cgdc*(1.+sint2)-0.5)*duydy0
        sscu=-acu*(cu1+cu2+cu3)
        se(k,j)= se(k,j)+sscu*e(k,j,IAIC_IDX)
        dse(k,j)=dse(k,j)+sscu
      enddo
    enddo
  end subroutine sourcefct_scurrent

  subroutine sourcefct_sbottom(idx,ks)      !,depth,esigpnt)
    integer,intent(in) :: idx
    integer,intent(in) :: ks
    !real(spdp),intent(in) :: depth,esigpnt(:,:)
    real(spdp) :: sbo,wk0,dk,ssbo, depth
    !*************************************
    !      call sbottom(e)
    !*************************************
    sbo=0.038*2./g
    !ks=ks0 !(IAIC_IDX)
    depth=d(IAIC_IDX)
    do k=1,ks
      wk0=wk(k)
      dk=depth*wk0
      do j=1,jl
        if (dk.ge.30.)then
          ssbo=0.
        else
          ssbo=-abo*sbo*wk0/sinh(2.*dk)
        endif
        !ssbo=0.d0;if(dk<30)ssbo=-abo*sbo*wk0/sinh(2.d0*dk)
        !sebo(k,j)=ssbo*e(k,j,IAIC_IDX) ! yinxq: 2011.05.06
        se(k,j)=se(k,j)+ssbo*e(k,j,IAIC_IDX)
        dse(k,j)=dse(k,j)+ssbo
      enddo
    enddo
  end subroutine sourcefct_sbottom

 !-------------------------------------------------------------------------------------------------
  subroutine setwave
    integer :: j,k
    real(spdp) :: wh,di,wkk,dk,tanhdk,wfk,wsk,deltts
    integer :: idx
    deltth=zpi/float(jl)
    do j=1,jlp1
      thet(j)=(j-1)*deltth
    enddo
    wh=sqrt((1./pwk)**7)
    wkh(1)=1.
    do k=1,kldp1
      wk(k)=wkmin*(pwk**(k-1)) !discretion of wave number
      if (k.le.kld) dwk(k)=(pwk-1.)*(wk(k)**2)*deltth/2
      if (k.ge.2) wkh(k)=wkh(k-1)*wh
    enddo
    do idx=1,np
      di=d(IAIC_IDX)
      do k=1,kldp1
        wkk=wk(k)
        dk=di*wkk
        tanhdk=1.
        if (dk.lt.4.) tanhdk=tanh(dk)
        wfk=sqrt(g*wkk*tanhdk)/zpi
        wsk=wfk*zpi
        wf(k,IAIC_IDX)=wfk
        if (dk.gt.4.) then
          ccg(k,IAIC_IDX)=0.5*wsk/wkk
        else
          if (dk.lt.0.14) then
            ccg(k,IAIC_IDX)=sqrt(g*di)
          else
            ccg(k,IAIC_IDX)=0.5*wsk*(1.+2.*dk/sinh(2.*dk))/wkk
          endif
        endif
      enddo
      do k=1,kld
        dwf(k,IAIC_IDX)=(wf(k+1,IAIC_IDX)-wf(k,IAIC_IDX))*deltth/2
      enddo
    enddo
    !    deltts=delttm*60.  ! yinxq: 2015-7-21 5:43:47
    !    cgro=0.0000091*p*deltts
    !    do k=1,kl
    !      grolim(k)=cgro/wk(k)**4
    !    enddo
  end subroutine setwave
!-------------------------------------------------------------------------------------------------
  subroutine nlweight
    integer :: mr,j,js,j1,j2,is1,icl1,icl2,k,ikn
    real(spdp) :: alamd,con,deltha,delphi,delphi2,cl1,cl2,ch,acl1,acl2
    real(spdp) :: cl11,cl21,wkk
    real(spdp) :: wklp,wklm,wkp,wkp1,wklap,wklap1,wklam,wklam1,wkm,wkm1
    !---------------------------------
    !*      1. setting initial value
    !---------------------------------
    alamd=0.25
    con=7.862532087
    cong=con*sqrt(g)
    deltha=deltth*180/pi
    delphi=-11.48
    delphi2=33.56
    !---------------------------------
    !*      2.      computation of weights f angular grid
    !---------------------------------
    cl1=delphi/deltha
    cl2=delphi2/deltha
    ic=1
    do mr=1,2
      do j=1,jl
        js=j
        ch=ic*cl1
        j1=jafu(ch,js,jlp1)
        is1=1
        if (ch.lt.0) is1=-1
        j2=j1+is1
        if (j2.gt.jl) j2=1
        if (j2.lt.1) j2=jl
        jp1(mr,j)=j1
        jp2(mr,j)=j2
        js=j
        ch=ic*cl2
        j1=jafu(ch,js,jlp1)
        is1=1
        if (ch.lt.0) is1=-1
        j2=j1+is1
        if (j2.gt.jl) j2=1
        if (j2.lt.1) j2=jl
        jm1(mr,j)=j1
        jm2(mr,j)=j2
      enddo
      ic=-1
    enddo
    icl1=cl1
    cl1=cl1-icl1
    icl2=cl2
    cl2=cl2-icl2
    acl1=abs(cl1)
    acl2=abs(cl2)
    cl11=1.-acl1
    cl21=1.-acl2
    al11=1.+alamd
    al21=1.-alamd
    al31=al11*al21
    al12=al11**2
    al22=al21**2
    al13=al11**3
    al23=al21**3
    !---------------------------------
    !*      indices and weights f frquency grid
    !---------------------------------
    do k=1,kl
      wkk=wk(k)
      wks17(k)=sqrt(wkk**17)
      wklp=wkk*al12
      wklm=wkk*al22
      !ikn=alog10(al12)/alog10pwk
      ikn=log10(al12)/alog10pwk
      ikn=k+ikn
      ikp(k)=ikn
      wkp=wk(ikp(k))
      ikp1(k)=ikp(k)+1
      wkp1=wk(ikp1(k))
      wklap=(wklp-wkp)/(wkp1-wkp)
      wklap1=1.-wklap
      if(ikp(k)>kl)then
        ikp(k)=klp1
        ikp1(k)=klp1
      endif
      wp(k,1,1)=wklap1*cl11
      wp(k,1,2)=wklap1*acl1
      wp(k,2,1)=wklap*cl11
      wp(k,2,2)=wklap*acl1
      if(wk(1)>=wklm)then
        ikm(k)=1
        ikm1(k)=1
        wklam=0.
        wklam1=0.
      else
        !ikn=alog10(al22)/alog10pwk
        ikn=log10(al22)/alog10pwk
        ikn=k+ikn-1
        if(ikn.lt.1) ikn=1
        ikm(k)=ikn
        wkm=wk(ikm(k))
        ikm1(k)=ikm(k)+1
        wkm1=wk(ikm1(k))
        wklam=(wklm-wkm)/(wkm1-wkm)
        wklam1=1.-wklam
      endif
      wm(k,1,1)=wklam1*cl21
      wm(k,1,2)=wklam1*acl2
      wm(k,2,1)=wklam*cl21
      wm(k,2,2)=wklam*acl2
    enddo
    contains
    integer function jafu(cl,j,ian)
      real(spdp),intent(in) :: cl
      integer,intent(in) :: j,ian
      integer :: idph,ja
      idph=cl
      ja=j+idph
      if(ja.le.0)ja=ian+ja-1
      if(ja.ge.ian)ja=ja-ian+1
      jafu=ja
    end function jafu
  end subroutine nlweight
!-------------------------------------------------------------------------------------------------
  subroutine intact_mixture_bv(kb,np,h3,bv)
    integer,intent(in) :: kb,np
    real(spdp),intent(in) :: h3(kb,0:np)
    real(spdp),intent(out) :: bv(kb,0:np)
    integer :: kh,k,k1,i,i1,j,idx
    real(spdp) :: dwkk,wsk,wkk,theta0,sinth,costh,ekj,ekj1,bv1,bv2,bv3,tmpewzk,dep1
    real(spdp),parameter :: bvlimt=1.d-12,zero=0.d0
    bv=zero
    do kh=1,kb
      do idx=1,np
        if(nsp(idx)==0)cycle
        dep1=-abs(h3(kh,idx))
        if(abs(dep1)>d(idx))cycle
        bv1=zero;bv2=zero;bv3=zero
        do k=1,kld
          k1=k+1;i=k-kl+1;i1=i+1
          dwkk=dwk(k);wsk=zpi*wf(k,idx);wkk=wk(k)
          do j=1,jl
            theta0=thet(j);sinth=sin(theta0);costh=cos(theta0)
            if(k.lt.kl)then
              ekj=ea(k,j,idx);ekj1=ea(k1,j,idx)
            else
              ekj=ea(kl,j,idx)*wkh(i);ekj1=ea(kl,j,idx)*wkh(i1)
            endif
            tmpewzk=(ekj+ekj1)*exp(2*wkk*dep1)*dwkk
            bv1=bv1+tmpewzk
            bv2=bv2+tmpewzk*wsk*wsk
            bv3=bv3+tmpewzk*wsk*wsk*wkk
          enddo
        enddo
        bv(kh,idx)=max(bvlimt,bv1/sqrt(bv2)*bv3)
      enddo
    enddo
  end subroutine intact_mixture_bv
!-------------------------------------------------------------------------------
!*DeckYinxq: mean1 --- To compute the characters of wave for output.
  subroutine mean1(IAIC_IDX)
    integer,intent(in) :: IAIC_IDX
    integer :: i,j,k,k1,i1
    real(spdp) :: aets,aetc,dwkk,dwfk
   !wfw: real(spdp) :: thmax,akmax,eemax,eformax,eef0
    real(spdp) :: wfk,wfk1,wsk,wsk1,wkk,wkk1,eekj,eekj1 !,eekjth
    real(spdp) :: sinth,costh,aett,chbh
    real(spdp) :: hmax,iahm,ichm
    ae(IAIC_IDX)=0.
    asi(IAIC_IDX)=0.
    awf(IAIC_IDX)=0.
    awk(IAIC_IDX)=0.
    ark(IAIC_IDX)=0.
    ape(IAIC_IDX)=0.
    aet(IAIC_IDX)=0.
    hb(IAIC_IDX)=0.
    hbb(IAIC_IDX)=0.
    h1_3(IAIC_IDX)=0.
!... added by BaoYing, 20190103
    ustokes(IAIC_IDX)=0.
    vstokes(IAIC_IDX)=0.
!... end add  
    if(nsp(idx)==0)return
    aets=0.0
    aetc=0.0
    !wfw:thmax=0.0
    !wfw:akmax=0.0
    !wfw:eemax=-999
    !wfw:eformax=-999
    do k=1,kl
    !do k=1,kl
      k1=k+1
      i=k-kl+1
      i1=i+1
      dwkk=dwk(k)
      dwfk=dwf(k,IAIC_IDX)
      wfk=wf(k,IAIC_IDX)
      wfk1=wf(k1,IAIC_IDX)
      !      wfk=fr(k)
      !      wfk1=fr(k1)
      wsk=zpi*wfk
      wsk1=zpi*wfk1
      wkk=wk(k)
      wkk1=wk(k1)
      !wfw:eef0=0.0
      do j=1,jl
        if (k.lt.kl) then
          eekj =ee(k,j,IAIC_IDX)
          eekj1=ee(k1,j,IAIC_IDX)
        else
          eekj =ee(kl,j,IAIC_IDX)*wkh(i)
          eekj1=ee(kl,j,IAIC_IDX)*wkh(i1)
        endif

        !eekjth=eekj*deltth
       !wfw: eef0=eef0+eekjth
        sinth=sin(thet(j))
        costh=cos(thet(j))
        !      atfs=atfs+sinth*eekjth
        !      atfc=atfs+costh*eekjth
        ae(IAIC_IDX)=ae(IAIC_IDX)+(eekj+eekj1)*dwkk
        asi(IAIC_IDX)=asi(IAIC_IDX)+(eekj/wfk**2+eekj1/wfk1**2)*dwkk
        ape(IAIC_IDX)=ape(IAIC_IDX)+(eekj*wsk**2+eekj1*wsk1**2)*dwkk
        awf(IAIC_IDX)=awf(IAIC_IDX)+(eekj*wfk+eekj1*wfk1)*dwkk
        awk(IAIC_IDX)=awk(IAIC_IDX)+(eekj*wkk+eekj1*wkk1)*dwkk
        !      ark(IAIC_IDX)=ark(IAIC_IDX)+(eekj/sqrt(wkk)+eekj1/sqrt(wkk1))*dwkk
        !aets=aets+(eekj+eekj1)*wk(k)*sinth*dwkk
        !aetc=aetc+(eekj+eekj1)*wk(k)*costh*dwkk
        aets=aets+(eekj+eekj1)*sinth*dwkk  ! wk should not here? 2018-10-17 10:53:13
        aetc=aetc+(eekj+eekj1)*costh*dwkk
!... added by BaoYing, 20190103
      ustokes(IAIC_IDX) = ustokes(IAIC_IDX) + 2.0/g * (eekj*wsk**3 + eekj1*wsk1**3) *costh*dwkk
      vstokes(IAIC_IDX) = vstokes(IAIC_IDX) + 2.0/g * (eekj*wsk**3 + eekj1*wsk1**3) *sinth*dwkk
!... end add  

      enddo
      !      ef(k,IAIC_IDX)=zpi*wkk/ccg(k,IAIC_IDX)*eef0
    enddo
    !^^^^^^^^^^^^^^^^^^^^^^^
    !ape(IAIC_IDX)=tztz*zpi/sqrt(ape(IAIC_IDX)/ae(IAIC_IDX))  why tztz 2018-10-17 10:52:41
    ape(IAIC_IDX)=zpi/sqrt(ape(IAIC_IDX)/ae(IAIC_IDX))
    tpf(IAIC_IDX)=(asi(IAIC_IDX)/ae(IAIC_IDX))*(awf(IAIC_IDX)/ae(IAIC_IDX))
    !        tpf(IAIC_IDX)=asi(IAIC_IDX)*awf(IAIC_IDX)/ae(IAIC_IDX)**2
    if(abs(aetc).lt.0.000001)aetc=0.00001
    !aett=atan2d(aets,aetc) ! yinxq 2017-10-16 13:19:52
    aett=atan2(aets,aetc)*180.d0/pi
    if (aett.lt.0.) aett=360.+aett
    aet(IAIC_IDX)=aett
    awk(IAIC_IDX)=awk(IAIC_IDX)/ae(IAIC_IDX)
    h1_3(IAIC_IDX)=4.*sqrt(ae(IAIC_IDX))

#ifdef TESTINTEG
    if(plist(idx)%i==60 .and. plist(idx)%j==25)then
      write(*,*)'test',aets,aetc,aet(IAIC_IDX)
      write(*,*)'hs',h1_3(IAIC_IDX),tpf(IAIC_IDX),aet(IAIC_IDX)
      write(*,*)'aets,aetc',aets,aetc,atan2(aets,aetc)*180.d0/pi
      write(*,*)'testdwk',dwk(1:kl)
    endif
#endif

    !^^^^^^^^^^^^^^^^^^^^^^^
    !        hb(IAIC_IDX)=zpi/awk(IAIC_IDX)*0.12*
    !     &          tanh(d(IAIC_IDX)*awk(IAIC_IDX))/1.6726
    !^^^^^^^^^^^^^^^^^^^^^^^
    hb(IAIC_IDX)=zpi/awk(IAIC_IDX)*0.142*                                   &
    &            tanh(d(IAIC_IDX)*awk(IAIC_IDX))
    hbb(IAIC_IDX)=0.78125*d(IAIC_IDX)/1.6726
    !      hbb(IAIC_IDX)=0.78125*d(IAIC_IDX)/1.5864792
    if(hb(IAIC_IDX).gt.hbb(IAIC_IDX)) hb(IAIC_IDX)=hbb(IAIC_IDX)
    if(h1_3(IAIC_IDX).gt.hb(IAIC_IDX)) then
      chbh=(hb(IAIC_IDX)/h1_3(IAIC_IDX))**2
      do j=1,jl
        do k=1,kl
          ee(k,j,IAIC_IDX)=chbh*ee(k,j,IAIC_IDX)
        enddo
      enddo
      h1_3(IAIC_IDX)=hb(IAIC_IDX)
    endif
    ! --- This constrain is from Hua F. et al,2004. Advances in marine science
    !tpf(IAIC_IDX) = min(1.41*ape(IAIC_IDX),tpf(IAIC_IDX))
    ! It will be cut for tpf, change only for tpf is very big.
    if(tpf(IAIC_IDX)>100)tpf(IAIC_IDX) = min(1.41*ape(IAIC_IDX),tpf(IAIC_IDX))
    
!!!!    if(h1_3(IAIC_IDX).le.0.05)h1_3(IAIC_IDX)=0.05
  end subroutine mean1
!-------------------------------------------------------------------------------
!*DeckYinxq: mean2
  subroutine mean2(IAIC_IDX)
    integer,intent(in) :: IAIC_IDX
    integer :: k,k1,i,i1,j
    real(spdp) :: dwkk,wfk,wfk1,wsk,wsk1,wkk,wkk1,ekj,ekj1
    ae(IAIC_IDX)=0.
    asi(IAIC_IDX)=0.
    awf(IAIC_IDX)=0.
    awk(IAIC_IDX)=0.
    ark(IAIC_IDX)=0.
    if(nsp(idx)==0)return
    do k=1,kld
      k1=k+1
      i=k-kl+1
      i1=i+1
      dwkk=dwk(k)
      wfk=wf(k,IAIC_IDX)
      wfk1=wf(k1,IAIC_IDX)
      !      wfk=fr(k)
      !      wfk1=fr(k1)
      wsk=zpi*wfk
      wsk1=zpi*wfk1
      wkk=wk(k)
      wkk1=wk(k1)
      do j=1,jl
        if (k.lt.kl) then
          ekj=e(k,j,IAIC_IDX)
          ekj1=e(k1,j,IAIC_IDX)
        else
          ekj=e(kl,j,IAIC_IDX)*wkh(i)
          ekj1=e(kl,j,IAIC_IDX)*wkh(i1)
        endif
        ae(IAIC_IDX)=ae(IAIC_IDX)+(ekj+ekj1)*dwkk
        awf(IAIC_IDX)=awf(IAIC_IDX)+(ekj*wfk+ekj1*wfk1)*dwkk
        asi(IAIC_IDX)=asi(IAIC_IDX)+(ekj/wsk+ekj1/wsk1)*dwkk
        awk(IAIC_IDX)=awk(IAIC_IDX)+(ekj*wkk+ekj1*wkk1)*dwkk
        ark(IAIC_IDX)=ark(IAIC_IDX)+(ekj/sqrt(wkk)+ekj1/sqrt(wkk1))*dwkk
      enddo
    enddo
    asi(IAIC_IDX)=ae(IAIC_IDX)/asi(IAIC_IDX)
    awf(IAIC_IDX)=awf(IAIC_IDX)/ae(IAIC_IDX)
    awk(IAIC_IDX)=awk(IAIC_IDX)/ae(IAIC_IDX)
    ark(IAIC_IDX)=(ae(IAIC_IDX)/ark(IAIC_IDX))**2
  end subroutine mean2
!-------------------------------------------------------------------------------
!*DeckYinxq: setspec
! --- Usage: if n = 1,this subroutine will prepare for initial conditions
!            if n = 2,this subroutine will prepare for OBC.
  subroutine setspec(n,IAIC_IDX)
    integer,intent(in) :: n
    integer,intent(in) :: IAIC_IDX
    real(spdp) :: vx,vy,ww,xj,xj0,arlfa,wsj,wkj
    real(spdp) :: theta0,sinth,costh,wk0,wf0,ws0,wl,sigma,alpha
    integer :: j,k
    !  real,parameter :: gama=3.3,sq3=3.0**0.5
    real(spdp),parameter :: gama=3.3
    real(spdp) :: sq3
    if(nsp(IAIC_IDX)<n)return
    sq3=3.0**0.5
    vx=wx(IAIC_IDX);vy=wy(IAIC_IDX);ww=sqrt(vx**2+vy**2)
    if(ww.le.0.)ww=0.9
    !      xj0=0.5*ro(IAIC_IDX)
    !      if (xj0.lt.25000.) xj0=25000.
    !xj0=200.*1000.
    !wfw:xj0=15.*1000.
    !xj0=200.*1000.
    xj0=windzone*1000.
    xj=g*xj0/(ww**2)
    arlfa=(0.076*(xj**(-0.4)))/pi
    wsj=22.*(xj**(-0.33))*g/ww
    wkj=wsj**2/g
    do j=1,jl
      theta0=thet(j);costh=cos(theta0);sinth=sin(theta0)
      do k=1,kl
        wk0=wk(k);wf0=wf(k,IAIC_IDX);ws0=zpi*wf0
        wl=vx*costh+vy*sinth
        if(wl>0)then
          !if(ws0<=wsj)then
          !  sigma=0.07
          !else
          !  sigma=0.09
          !endif
          sigma=0.07;if(ws0>wsj)sigma=0.09
          alpha=arlfa/wk0**4*exp(-1.25*(wkj/wk0)**2)                   &
                            *gama**(exp(-0.5*((1.-ws0/wsj)/sigma)**2)) &
                            *(wl/ww)**2
        else
          alpha=0.0
        endif
        ee(k,j,IAIC_IDX)=max(alpha,small)
      enddo
    enddo
  end subroutine setspec
!-------------------------------------------------------------------------------
  subroutine check_timestep(flag)
    integer,intent(out),optional :: flag
    real(spdp),allocatable :: tim(:)
    real(spdp) :: maxtimestep,prop_time_step,tmpt
    integer :: idx,ierr,ii,jj,secday
    allocate(tim(np));tim=1.e10
    do idx=1,npc
      if(nsp(idx)/=1)cycle
      !tim(idx)=minval(cnb(idx)%dst)/max(ccg(1,idx)+ux(idx),ccg(1,idx)+uy(idx))
      tim(idx)=minval(cnb(idx)%dst)/maxval(ccg(:,idx)) !+ux(idx),ccg(1,idx)+uy(idx))
    enddo
    !tim=tim /60.d0 ! in minus
    maxtimestep=minval(tim,mask=tim>0.);deallocate(tim)
    deltt = delttm*60.d0 ! in seconds
    if(present(flag))then
      flag=1;if(deltt>maxtimestep)flag=0
    endif
    if(deltt>maxtimestep)then
      secday=86400
      ii=int(dble(secday)/dble(maxtimestep))
      jj=int(dble(secday)/dble(ii))
      if(jj>maxtimestep)then
        do while(.true.)
          ii=ii+1;jj=int(dble(secday)/dble(ii))
          if(jj==ceiling(dble(secday)/dble(ii)))exit
        enddo
      endif
      deltt=int(dble(secday)/dble(ii))
    endif
    delttm = deltt/60.d0
    iwiofreq = wiofreq*60.d0/delttm
    irstfreq = rstfreq*60.d0/delttm
    number   = (1-key)*cools_days*1440.d0/delttm
    do k=1,kl
      !grolim(k)=0.0000091*p*deltt/wk(k)**4
      grolim(k)=0.0000091*p/wk(k)**4
    enddo
    write(*,*)'maxtimestep,deltt,delttm',maxtimestep,deltt,delttm
    return
    write(*,*)'maxtimestep,deltt,delttm',maxtimestep,deltt,delttm
    if(delttm>maxtimestep)then
      maxtimestep=delttm
      if(maxtimestep>1)then
        ii=int(maxtimestep)
        if(mod(60,ii)==0)then
          maxtimestep=ii
        else
          jj=int(60.d0/maxtimestep)+1
          maxtimestep=60.d0/dble(jj)
        endif
      else
        ii=int(maxtimestep*60)  ! in seconds
        if(mod(60,ii)==0)then
          maxtimestep=dble(ii)/60.d0
        else
          jj=int(1.d0/maxtimestep)+1
          maxtimestep=1.d0/dble(jj)
        endif
      endif
      delttm=maxtimestep !;flag=0
      return
    endif
    !flag=1
    deltt    = delttm *60.
    iwiofreq = wiofreq*60./delttm
    irstfreq = rstfreq*60./delttm
    number   = (1-key)*cools_days*1440./delttm
    do k=1,kl
      !grolim(k)=0.0000091*p*deltt/wk(k)**4
      grolim(k)=0.0000091*p/wk(k)**4
    enddo
  end subroutine check_timestep

  subroutine implsch_old(IAIC_IDX)
    integer,intent(in) :: IAIC_IDX
    real(spdp) :: awkss,vx,vy,ww,wkpm,wkpmt,wakt,beta
    real(spdp) :: xx,wp11,wp12,wp21,wp22,wm11,wm12,wm21,wm22
    real(spdp) :: wp112,wp122,wp212,wp222,wm112,wm122,wm212,wm222,ffacp,ffacp1
    real(spdp) :: cwks17,rij,eij,ea1,ea2,ea3,ea4,ea5,ea6,ea7,ea8,up,up1
    real(spdp) :: um,um1,sap,sam,eij2,zua,ead1,ead2,fcen,ad,adp,adm,delad
    real(spdp) :: deladm,cd,theta0,costh,sinth,wl,wlstar,wk0,wf0,ws0,bett
    real(spdp) :: awfss,arkss,aess,eks,ekspm,sds,asiss,ssds,d0,dk,ssbo,duxdx0
    real(spdp) :: duydx0,duydy0,th0,cost2,sint2,cg,cp,cgdc,cu1,cu2,cu3,sscu
    real(spdp) :: wstar,deltee,eef,gadiag,eefab,sig,deladp,duxdy0,sbo
    integer :: kpmt,kakt,ks1,ks,ksp1,k,j,kh,ip,ip1,im,im1
    integer :: kp,kp1,kp2,kp3,mr,js,j11,j12,j21,j22,i
    real(spdp),allocatable :: w(:),fconst0(:,:),enh(:)
    integer,allocatable :: ks0(:),kpmt0(:),kakt0(:)
    real(spdp) :: deltt5
    deltt5=delttm*30.
    allocate(w(0:np))
    allocate(enh(0:np))
    allocate(ks0(0:np))
    allocate(kpmt0(0:np))
    allocate(kakt0(0:np))
    allocate(fconst0(kl,0:np))
!!    if(nsp(IAIC_IDX).ne.1)return
!    ee(:,:,idx)=1
!    if(nsp(idx)/=1)then
!      ee(:,:,idx)=0
!      return
!    endif
!    ee(:,:,idx)=1;return
    if(nsp(idx)==0)return
    call mean2(IAIC_IDX)

    awkss=awk(IAIC_IDX)
    vx=wx(IAIC_IDX)
    vy=wy(IAIC_IDX)
    ww=vx**2+vy**2
    w(IAIC_IDX)=sqrt(vx**2+vy**2)
    if(opt_cd==0)then
      cd=(0.80+0.065*w(IAIC_IDX))*0.001
    elseif(opt_cd==1)then
      if(w(IAIC_IDX)<=11)then
        cd=1.2
      elseif(w(IAIC_IDX)>11 .and. w(IAIC_IDX) <=19)then
        cd=0.49+0.065*w(IAIC_IDX)
      elseif(w(IAIC_IDX)>19)then
        cd=1.364+0.0234*w(IAIC_IDX)-0.00023158*w(IAIC_IDX)*w(IAIC_IDX)
      endif
      cd=cd*0.001
    endif

    wstar=w(IAIC_IDX)*sqrt(cd)
    if (ww.eq.0.) ww=0.05
    wkpm=gc2/ww
    wkpmt=cksp*wkpm
    !kpmt=alog10(wkpmt/wk(1))/alog10pwk+1 ! yinxq 2015-8-1 0:25:48
    kpmt=log10(wkpmt/wk(1))/alog10pwk+1
    wakt=cksa*awkss
    !kakt=alog10(wakt/wk(1))/alog10pwk+1 ! yinxq 2015-8-1 0:25:48
    kakt=log10(wakt/wk(1))/alog10pwk+1
    ks1=max0(kpmt,kakt)
    ks=min0(ks1,kl)
    ksp1=ks+1
    ks0(IAIC_IDX)=ks
    kpmt0(IAIC_IDX)=kpmt
    kakt0(IAIC_IDX)=kakt
    do k=1,ks
      fconst0(k,IAIC_IDX)=1.0
    enddo
    do k=ksp1,kl
      fconst0(k,IAIC_IDX)=0.0
    enddo
    !-----------------------------------------------------------------------------
    do j=1,jl
      do k=1,klp1
        se(k,j)=0.
        dse(k,j)=0.
      enddo
    enddo
    !*************************************
    !      call snonlin(e)
    !*************************************
    !         x=0.75*d(IAIC_IDX)*akmean(IAIC_IDX)
    xx=0.75*d(IAIC_IDX)*awk(IAIC_IDX)
    if (xx.lt.0.5) xx=0.5
    enh(IAIC_IDX)=1.+(5.5/xx)*(1.-0.833*xx)*exp(-1.25*xx)
    kh=0
    do k=1,kl
      !zyd!ks=k
      wp11=wp(k,1,1)
      wp12=wp(k,1,2)
      wp21=wp(k,2,1)
      wp22=wp(k,2,2)
      wm11=wm(k,1,1)
      wm12=wm(k,1,2)
      wm21=wm(k,2,1)
      wm22=wm(k,2,2)
      wp112=wp11**2
      wp122=wp12**2
      wp212=wp21**2
      wp222=wp22**2
      wm112=wm11**2
      wm122=wm12**2
      wm212=wm21**2
      wm222=wm22**2
      ffacp=1.
      ffacp1=1.
      ip=ikp(k)
      ip1=ikp1(k)
      im=ikm(k)
      im1=ikm1(k)
      cwks17=cong*wks17(k)
      kp=ip
      kp1=ip1
      kp2=kp
      kp3=kp1
      if(kp >= kl)then
        kh=kh+1
        kp2=kl+1
        if(kp.eq.kl)kp2=kl
        kp=kl
        kp1=kl
        kp3=kl+1
        ffacp=wkh(kh)
        ffacp1=wkh(kh+1)
      endif
      do mr=1,2
        !*      1.2 angular loop
        do j=1,jl
          js=j
          j11=jp1(mr,j)
          j12=jp2(mr,j)
          j21=jm1(mr,j)
          j22=jm2(mr,j)
          !****************************************************************
          eij=e(k,js,IAIC_IDX)
          !zyd!eij=e(ks,js,IAIC_IDX)
          if (eij.lt.1.e-20) cycle
          ea1=e(kp ,j11,IAIC_IDX)
          ea2=e(kp ,j12,IAIC_IDX)
          ea3=e(kp1,j11,IAIC_IDX)
          ea4=e(kp1,j12,IAIC_IDX)
          ea5=e(im ,j21,IAIC_IDX)
          ea6=e(im ,j22,IAIC_IDX)
          ea7=e(im1,j21,IAIC_IDX)
          ea8=e(im1,j22,IAIC_IDX)
          up =(wp11*ea1+wp12*ea2)*ffacp
          up1=(wp21*ea3+wp22*ea4)*ffacp1
          um =wm11*ea5+wm12*ea6
          um1=wm21*ea7+wm22*ea8
          sap=up+up1
          sam=um+um1
          eij2=eij**2
          zua=2.*eij/al31
          ead1=sap/al11+sam/al21
          ead2=-2.*sap*sam/al31
          !      fcen=fcnss(k,IAIC_IDX)*enh(IAIC_IDX)
          fcen=fconst0(k,IAIC_IDX)*enh(IAIC_IDX)
          ad=cwks17*(eij2*ead1+ead2*eij)*fcen
          adp=ad/al13
          adm=ad/al23
          delad =cwks17*(eij*2.*ead1+ead2) *fcen
          deladp=cwks17*(eij2/al11-zua*sam)*fcen/al13
          deladm=cwks17*(eij2/al21-zua*sap)*fcen/al23
          !*      nonlinear transfer
          se(k ,js )= se(k ,js )-2.0*ad
          !zyd!se(ks ,js )= se(ks ,js )-2.0*ad
          se(kp2,j11)= se(kp2,j11)+adp*wp11
          se(kp2,j12)= se(kp2,j12)+adp*wp12
          se(kp3,j11)= se(kp3,j11)+adp*wp21
          se(kp3,j12)= se(kp3,j12)+adp*wp22
          se(im ,j21)= se(im ,j21)+adm*wm11
          se(im ,j22)= se(im ,j22)+adm*wm12
          se(im1,j21)= se(im1,j21)+adm*wm21
          se(im1,j22)= se(im1,j22)+adm*wm22
          dse(k ,js )=dse(k ,js )-2.0*delad
          !zyd!dse(ks ,js )=dse(ks ,js )-2.0*delad
          dse(kp2,j11)=dse(kp2,j11)+deladp*wp112
          dse(kp2,j12)=dse(kp2,j12)+deladp*wp122
          dse(kp3,j11)=dse(kp3,j11)+deladp*wp212
          dse(kp3,j12)=dse(kp3,j12)+deladp*wp222
          dse(im ,j21)=dse(im ,j21)+deladm*wm112
          dse(im ,j22)=dse(im ,j22)+deladm*wm122
          dse(im1,j21)=dse(im1,j21)+deladm*wm212
          dse(im1,j22)=dse(im1,j22)+deladm*wm222
        enddo
      enddo
    enddo
    !      write(*,*)'endcall snon'
!ee(:,:,IAIC_IDX)=se+dse;    return
    !*************************************
    !      call sinput(e)
    !*************************************
    !zyd!ks=ks0(IAIC_IDX)
    !zyd!vx=wx(IAIC_IDX)
    !zyd!vy=wy(IAIC_IDX)
    !zyd!ww=vx**2+vy**2
    !zyd!w(IAIC_IDX)=sqrt(vx**2+vy**2)
    !zyd!cd=(0.80+0.065*w(IAIC_IDX))*0.001
    do j=1,jl
      !-----costh=cos_thet(j) !zyd
      !-----sinth=sin_thet(j) !zyd
      theta0=thet(j)
      costh=cos(theta0)
      sinth=sin(theta0)
      !zyd!theta0=thet(j)
      !zyd!costh=cos(theta0)
      !zyd!sinth=sin(theta0)
      wl=vx*costh+vy*sinth
      wlstar=wl*sqrt(cd)
      do k=1,ks
        wk0=wk(k)
        wf0=wf(k,IAIC_IDX)
        ws0=zpi*wf0
        !yinxq:      bett=beta10*(1.+beta1*winc(IAIC_IDX))
        bett=beta10
        !beta=amax1(0.,bett*(wk0*28.*wlstar-ws0)) ! yinxq 2015-8-1 0:18:21
        beta=max(0.,bett*(wk0*28.*wlstar-ws0))
        !zyd!sein(k,j) = beta * e(k,j,IAIC_IDX) ! yinxq: 2011.05.06
        se(k,j)= se(k,j)+beta*e(k,j,IAIC_IDX)
        dse(k,j)=dse(k,j)+beta
      enddo
    enddo
    !      write(*,*)'endcall sinp'
    !***************************************************
    !      goto 3009
    !      if (logsdiss.eq.1) goto 3009
    !      call sdissip(e)--old
    !***************************************************
    !      call sdissip(e)--new
    !***************************************************
    !zyd!ks=ks0(IAIC_IDX)
    awfss=awf(IAIC_IDX)
    asiss=asi(IAIC_IDX)
    arkss=ark(IAIC_IDX)
    aess = ae(IAIC_IDX)
    eks=aess*arkss*arkss
    ekspm=eks/0.0030162
    !      sds=2.36e-5*asiss*arkss**3*aess**2/alpm2
    !      2.36e-5/alpm2=2.587605807
    !      sds=2.60*(zpi*awfss)*arkss**3*aess**2
    sds=d1*asiss/arkss*sqrt(ekspm)*exp(-d2*0.64/ekspm)
    do k=1,ks
      wk0=wk(k)
      do j=1,jl
        ssds=-ads*sds*wk0
        !zyd!seds(k,j) = ssds * e(k,j,IAIC_IDX) ! yinxq: 2011.05.06
        se(k,j)= se(k,j)+ssds*e(k,j,IAIC_IDX)
        dse(k,j)=dse(k,j)+ssds
      enddo
    enddo
    !*************************************
    !      call sbottom(e)
    !*************************************
    sbo=0.038*2./g
    !zyd!ks=ks0(IAIC_IDX)
    d0=d(IAIC_IDX)
    do k=1,ks
      wk0=wk(k)
      dk=d0*wk0
      do j=1,jl
        if (dk.ge.30.)then
          ssbo=0.
        else
          ssbo=-abo*sbo*wk0/sinh(2.*dk)
        endif
    	  !zyd!sebo(k,j) = ssbo * e(k,j,IAIC_IDX) ! yinxq: 2011.05.06
        se(k,j)= se(k,j)+ssbo*e(k,j,IAIC_IDX)
        dse(k,j)=dse(k,j)+ssbo
      enddo
    enddo
    !*************************************
    !      call scurrent(e)
    !*************************************
    duxdx0=uxx(IAIC_IDX)
    duxdy0=uxy(IAIC_IDX)
    duydx0=uyx(IAIC_IDX)
    duydy0=uyy(IAIC_IDX)
    !zyd!ks=ks0(IAIC_IDX)
    do j=1,jl
      !------sinth=sin_thet(j) !zyd
      !------costh=cos_thet(j) !zyd
      th0=thet(j)
      sinth=sin(th0)
      costh=cos(th0)
      !zyd!th0=thet(j)
      !zyd!sinth=sin(th0)
      !zyd!costh=cos(th0)
      cost2=costh*costh
      sint2=sinth*sinth
      do k=1,ks
        wk0=wk(k)
        ws0=zpi*wf(k,IAIC_IDX)
        cg=ccg(k,IAIC_IDX)
        cp=ws0/wk0
        cgdc=cg/cp
        cu1=(cgdc*(1.+cost2)-0.5)*duxdx0
        cu2= cgdc*sinth*costh*(duxdy0+duydx0)
        cu3=(cgdc*(1.+sint2)-0.5)*duydy0
        sscu=-acu*(cu1+cu2+cu3)
        se(k,j)= se(k,j)+sscu*e(k,j,IAIC_IDX)
        dse(k,j)=dse(k,j)+sscu
      enddo
    enddo
    !*************************************
    !      call source terms end
    !*************************************
    !      write(*,*)'endcall source terms'
    !zyd!ks=ks0(IAIC_IDX)
    !zyd!vx=wx(IAIC_IDX)
    !zyd!vy=wy(IAIC_IDX)
    !zyd!ww=vx**2+vy**2
    !zyd!w(IAIC_IDX)=sqrt(vx**2+vy**2)
    !zyd!cd=(0.80+0.065*w(IAIC_IDX))*0.001
    !zyd!wstar=w(IAIC_IDX)*sqrt(cd)
    do j=1,jl
      do k=1,ks
        deltee=wstar*grolim(k)*deltt
        gadiag=1.-deltt5*dse(k,j)
        !gadiag=amax1(gadiag,1.)
        gadiag=max(gadiag,1.)
        eef=deltt*se(k,j)/gadiag
        eefab=abs(eef)
        !eefab=amax1(eefab,0.1e-19)  ! yinxq 2015-8-1 0:19:15
        eefab=max(eefab,0.1e-19)
        sig=eef/eefab
        !eefab=amin1(eefab,deltee)  ! yinxq 2015-8-1 0:15:50
        eefab=min(eefab,deltee)
        eef=e(k,j,IAIC_IDX)+sig*eefab
        !yinxq:      ee(k,j,IAIC_IDX)=amax1(eef,0.)
        !ee(k,j,IAIC_IDX)=max(small,amax1(eef,0.)) ! yinxq 2015-8-1 0:15:24
        ee(k,j,IAIC_IDX)=max(small,max(eef,0.))
      enddo
      do k=ks+1,kl
        i=k-ks+1
        !yinxq:      ee(k,j,IAIC_IDX)=ee(ks,j,IAIC_IDX)*wkh(i)
        ee(k,j,IAIC_IDX)=max(small,ee(ks,j,IAIC_IDX)*wkh(i))
      enddo
    enddo
    !zyd!
    !zyd!! yinxq: 2011.05.06
	  !zyd!pein(IAIC_IDX) = 0.0
	  !zyd!peds(IAIC_IDX) = 0.0
	  !zyd!pebo(IAIC_IDX) = 0.0
	  !zyd!do k=1,kl
	  !zyd!do j=1,jl
		!zyd!  pein(IAIC_IDX)=pein(IAIC_IDX)+sein(k,j)*2.0*dwk(k)
		!zyd!  pebo(IAIC_IDX)=pebo(IAIC_IDX)+sebo(k,j)*2.0*dwk(k)
		!zyd!  peds(IAIC_IDX)=peds(IAIC_IDX)+seds(k,j)*2.0*dwk(k)
	  !zyd!enddo !	  
	  !zyd!enddo !	  
    !********************************
    !      set water boundary
    !********************************
!    call setspec(2,IAIC_IDX)
!DBG    
    !      write(*,*)'endcall water boundary'
    call setspec(2,IAIC_IDX)
    call mean1(IAIC_IDX)
    deallocate(w,fconst0,enh,ks0,kpmt0,kakt0)
  end subroutine implsch_old
!-------------------------------------------------------------------------------
  end module mwmcor_mod
!-------------------------------------------------------------------------------
!###############################################################################
